/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.bukkit.listener;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.BukkitWorldConfiguration;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.bukkit.util.Entities;
import com.sk89q.worldguard.config.ConfigurationManager;
import com.sk89q.worldguard.config.WorldConfiguration;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.association.RegionAssociable;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.Flags;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedCuboidRegion;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.RegionQuery;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.Wither;
import org.bukkit.entity.WitherSkull;
import org.bukkit.entity.Wolf;
import org.bukkit.entity.minecart.ExplosiveMinecart;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.CreeperPowerEvent;
import org.bukkit.event.entity.EntityBreakDoorEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityDamageByBlockEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityInteractEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;
import org.bukkit.event.entity.PigZapEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.world.PortalCreateEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;

public class WorldGuardEntityListener
implements Listener {
    private WorldGuardPlugin plugin;

    public WorldGuardEntityListener(WorldGuardPlugin plugin) {
        this.plugin = plugin;
    }

    public void registerEvents() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntityInteract(EntityInteractEvent event) {
        Entity entity = event.getEntity();
        Block block = event.getBlock();
        ConfigurationManager cfg = WorldGuard.getInstance().getPlatform().getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(BukkitAdapter.adapt((org.bukkit.World)entity.getWorld()));
        if (block.getType() == Material.FARMLAND && wcfg.disableCreatureCropTrampling) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onEntityDeath(EntityDeathEvent event) {
        WorldConfiguration wcfg = WorldGuard.getInstance().getPlatform().getGlobalStateManager().get(BukkitAdapter.adapt((org.bukkit.World)event.getEntity().getWorld()));
        if (event instanceof PlayerDeathEvent && wcfg.disableDeathMessages) {
            ((PlayerDeathEvent)event).setDeathMessage("");
        }
    }

    private void onEntityDamageByBlock(EntityDamageByBlockEvent event) {
        Entity defender = event.getEntity();
        EntityDamageEvent.DamageCause type = event.getCause();
        ConfigurationManager cfg = WorldGuard.getInstance().getPlatform().getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(BukkitAdapter.adapt((org.bukkit.World)defender.getWorld()));
        if (defender instanceof Wolf && ((Wolf)defender).isTamed()) {
            if (wcfg.antiWolfDumbness && type != EntityDamageEvent.DamageCause.VOID) {
                event.setCancelled(true);
                return;
            }
        } else if (defender instanceof Player) {
            Player player = (Player)defender;
            LocalPlayer localPlayer = WorldGuardPlugin.inst().wrapPlayer(player);
            if (wcfg.disableLavaDamage && type == EntityDamageEvent.DamageCause.LAVA) {
                event.setCancelled(true);
                player.setFireTicks(0);
                return;
            }
            if (wcfg.disableContactDamage && type == EntityDamageEvent.DamageCause.CONTACT) {
                event.setCancelled(true);
                return;
            }
            if (wcfg.teleportOnVoid && type == EntityDamageEvent.DamageCause.VOID) {
                localPlayer.findFreePosition();
                event.setCancelled(true);
                return;
            }
            if (wcfg.disableVoidDamage && type == EntityDamageEvent.DamageCause.VOID) {
                event.setCancelled(true);
                return;
            }
            if (type == EntityDamageEvent.DamageCause.BLOCK_EXPLOSION && (wcfg.disableExplosionDamage || wcfg.blockOtherExplosions || wcfg.explosionFlagCancellation && !StateFlag.test((StateFlag.State[])new StateFlag.State[]{WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery().queryState(localPlayer.getLocation(), (RegionAssociable)null, new StateFlag[]{Flags.OTHER_EXPLOSION})}))) {
                event.setCancelled(true);
                return;
            }
        } else if (type == EntityDamageEvent.DamageCause.BLOCK_EXPLOSION && (wcfg.blockOtherExplosions || wcfg.explosionFlagCancellation && !StateFlag.test((StateFlag.State[])new StateFlag.State[]{WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery().queryState(BukkitAdapter.adapt((Location)defender.getLocation()), (RegionAssociable)null, new StateFlag[]{Flags.OTHER_EXPLOSION})}))) {
            event.setCancelled(true);
            return;
        }
    }

    private void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        if (event.getDamager() instanceof Projectile) {
            this.onEntityDamageByProjectile(event);
            return;
        }
        Entity attacker = event.getDamager();
        Entity defender = event.getEntity();
        WorldConfiguration wcfg = WorldGuard.getInstance().getPlatform().getGlobalStateManager().get(BukkitAdapter.adapt((org.bukkit.World)defender.getWorld()));
        if (defender instanceof ItemFrame) {
            if (this.checkItemFrameProtection(attacker, (ItemFrame)defender)) {
                event.setCancelled(true);
                return;
            }
        } else if (defender instanceof ArmorStand && !(attacker instanceof Player) && wcfg.blockEntityArmorStandDestroy) {
            event.setCancelled(true);
            return;
        }
        if (attacker instanceof EnderCrystal && wcfg.useRegions && wcfg.explosionFlagCancellation && !WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery().getApplicableRegions(BukkitAdapter.adapt((Location)defender.getLocation())).testState(null, new StateFlag[]{Flags.OTHER_EXPLOSION})) {
            event.setCancelled(true);
            return;
        }
        if (defender instanceof Player) {
            Player player = (Player)defender;
            LocalPlayer localPlayer = this.plugin.wrapPlayer(player);
            if (wcfg.disableLightningDamage && event.getCause() == EntityDamageEvent.DamageCause.LIGHTNING) {
                event.setCancelled(true);
                return;
            }
            if (wcfg.disableExplosionDamage) {
                switch (event.getCause()) {
                    case BLOCK_EXPLOSION: 
                    case ENTITY_EXPLOSION: {
                        event.setCancelled(true);
                        return;
                    }
                }
            }
            if (attacker != null) {
                if ((attacker instanceof TNTPrimed || attacker instanceof ExplosiveMinecart) && wcfg.blockTNTExplosions) {
                    event.setCancelled(true);
                    return;
                }
                if (attacker instanceof LivingEntity && !(attacker instanceof Player)) {
                    if (attacker instanceof Creeper && wcfg.blockCreeperExplosions) {
                        event.setCancelled(true);
                        return;
                    }
                    if (wcfg.disableMobDamage) {
                        event.setCancelled(true);
                        return;
                    }
                    if (wcfg.useRegions) {
                        ApplicableRegionSet set = WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery().getApplicableRegions(localPlayer.getLocation());
                        if (!set.testState((RegionAssociable)localPlayer, new StateFlag[]{Flags.MOB_DAMAGE}) && !(attacker instanceof Tameable)) {
                            event.setCancelled(true);
                            return;
                        }
                        if (attacker instanceof Creeper && !set.testState((RegionAssociable)localPlayer, new StateFlag[]{Flags.CREEPER_EXPLOSION}) && wcfg.explosionFlagCancellation) {
                            event.setCancelled(true);
                            return;
                        }
                    }
                }
            }
        }
    }

    private void onEntityDamageByProjectile(EntityDamageByEntityEvent event) {
        Entity defender = event.getEntity();
        ProjectileSource source = ((Projectile)event.getDamager()).getShooter();
        if (!(source instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacker = (LivingEntity)source;
        ConfigurationManager cfg = WorldGuard.getInstance().getPlatform().getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(BukkitAdapter.adapt((org.bukkit.World)defender.getWorld()));
        if (defender instanceof Player) {
            Player player = (Player)defender;
            LocalPlayer localPlayer = this.plugin.wrapPlayer(player);
            if (!(attacker instanceof Player)) {
                if (wcfg.disableMobDamage) {
                    event.setCancelled(true);
                    return;
                }
                if (wcfg.useRegions && !WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery().getApplicableRegions(localPlayer.getLocation()).testState((RegionAssociable)localPlayer, new StateFlag[]{Flags.MOB_DAMAGE})) {
                    event.setCancelled(true);
                    return;
                }
                if (event.getDamager() instanceof Fireball) {
                    RegionQuery query;
                    Fireball fireball = (Fireball)event.getDamager();
                    if (fireball instanceof WitherSkull) {
                        if (wcfg.blockWitherSkullExplosions) {
                            event.setCancelled(true);
                            return;
                        }
                    } else if (wcfg.blockFireballExplosions) {
                        event.setCancelled(true);
                        return;
                    }
                    if (wcfg.useRegions && !(query = WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery()).testState(localPlayer.getLocation(), localPlayer, new StateFlag[]{Flags.GHAST_FIREBALL}) && wcfg.explosionFlagCancellation) {
                        event.setCancelled(true);
                        return;
                    }
                }
            }
        } else if (defender instanceof ItemFrame) {
            if (this.checkItemFrameProtection((Entity)attacker, (ItemFrame)defender)) {
                event.setCancelled(true);
                return;
            }
        } else if (defender instanceof ArmorStand && Entities.isNonPlayerCreature((Entity)attacker) && wcfg.blockEntityArmorStandDestroy) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntityDamage(EntityDamageEvent event) {
        if (event instanceof EntityDamageByEntityEvent) {
            this.onEntityDamageByEntity((EntityDamageByEntityEvent)event);
            return;
        }
        if (event instanceof EntityDamageByBlockEvent) {
            this.onEntityDamageByBlock((EntityDamageByBlockEvent)event);
            return;
        }
        Entity defender = event.getEntity();
        EntityDamageEvent.DamageCause type = event.getCause();
        ConfigurationManager cfg = WorldGuard.getInstance().getPlatform().getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(BukkitAdapter.adapt((org.bukkit.World)defender.getWorld()));
        if (defender instanceof Wolf && ((Wolf)defender).isTamed()) {
            if (wcfg.antiWolfDumbness) {
                event.setCancelled(true);
                return;
            }
        } else if (defender instanceof Player) {
            Player player = (Player)defender;
            LocalPlayer localPlayer = WorldGuardPlugin.inst().wrapPlayer(player);
            if (type == EntityDamageEvent.DamageCause.WITHER) {
                ApplicableRegionSet set;
                if (wcfg.disableMobDamage) {
                    event.setCancelled(true);
                    return;
                }
                if (wcfg.useRegions && !(set = WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery().getApplicableRegions(localPlayer.getLocation())).testState((RegionAssociable)this.plugin.wrapPlayer(player), new StateFlag[]{Flags.MOB_DAMAGE})) {
                    event.setCancelled(true);
                    return;
                }
            }
            if (type == EntityDamageEvent.DamageCause.DROWNING && cfg.hasAmphibiousMode(localPlayer)) {
                player.setRemainingAir(player.getMaximumAir());
                event.setCancelled(true);
                return;
            }
            ItemStack helmet = player.getInventory().getHelmet();
            if (type == EntityDamageEvent.DamageCause.DROWNING && wcfg.pumpkinScuba && helmet != null && (helmet.getType() == Material.CARVED_PUMPKIN || helmet.getType() == Material.JACK_O_LANTERN)) {
                player.setRemainingAir(player.getMaximumAir());
                event.setCancelled(true);
                return;
            }
            if (wcfg.disableFallDamage && type == EntityDamageEvent.DamageCause.FALL) {
                event.setCancelled(true);
                return;
            }
            if (wcfg.disableFireDamage && (type == EntityDamageEvent.DamageCause.FIRE || type == EntityDamageEvent.DamageCause.FIRE_TICK)) {
                event.setCancelled(true);
                return;
            }
            if (wcfg.disableDrowningDamage && type == EntityDamageEvent.DamageCause.DROWNING) {
                player.setRemainingAir(player.getMaximumAir());
                event.setCancelled(true);
                return;
            }
            if (wcfg.teleportOnSuffocation && type == EntityDamageEvent.DamageCause.SUFFOCATION) {
                localPlayer.findFreePosition();
                event.setCancelled(true);
                return;
            }
            if (wcfg.disableSuffocationDamage && type == EntityDamageEvent.DamageCause.SUFFOCATION) {
                event.setCancelled(true);
                return;
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntityExplode(EntityExplodeEvent event) {
        ConfigurationManager cfg = WorldGuard.getInstance().getPlatform().getGlobalStateManager();
        Location l = event.getLocation();
        org.bukkit.World world = l.getWorld();
        BukkitWorldConfiguration wcfg = (BukkitWorldConfiguration)cfg.get(BukkitAdapter.adapt((org.bukkit.World)world));
        Entity ent = event.getEntity();
        if (cfg.activityHaltToggle) {
            ent.remove();
            event.setCancelled(true);
            return;
        }
        if (ent instanceof Creeper) {
            if (wcfg.blockCreeperExplosions) {
                event.setCancelled(true);
                return;
            }
            if (wcfg.blockCreeperBlockDamage) {
                event.blockList().clear();
                return;
            }
        } else if (ent instanceof EnderDragon) {
            if (wcfg.blockEnderDragonBlockDamage) {
                event.blockList().clear();
                return;
            }
        } else if (ent instanceof TNTPrimed || ent instanceof ExplosiveMinecart) {
            if (wcfg.blockTNTExplosions) {
                event.setCancelled(true);
                return;
            }
            if (wcfg.blockTNTBlockDamage) {
                event.blockList().clear();
                return;
            }
        } else if (ent instanceof Fireball) {
            if (ent instanceof WitherSkull) {
                if (wcfg.blockWitherSkullExplosions) {
                    event.setCancelled(true);
                    return;
                }
                if (wcfg.blockWitherSkullBlockDamage) {
                    event.blockList().clear();
                    return;
                }
            } else {
                if (wcfg.blockFireballExplosions) {
                    event.setCancelled(true);
                    return;
                }
                if (wcfg.blockFireballBlockDamage) {
                    event.blockList().clear();
                    return;
                }
            }
            if (wcfg.useRegions) {
                for (Block block : event.blockList()) {
                    if (WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery().getApplicableRegions(BukkitAdapter.adapt((Location)block.getLocation())).testState(null, new StateFlag[]{Flags.GHAST_FIREBALL})) continue;
                    event.blockList().clear();
                    if (wcfg.explosionFlagCancellation) {
                        event.setCancelled(true);
                    }
                    return;
                }
            }
        } else if (ent instanceof Wither) {
            if (wcfg.blockWitherExplosions) {
                event.setCancelled(true);
                return;
            }
            if (wcfg.blockWitherBlockDamage) {
                event.blockList().clear();
                return;
            }
            if (wcfg.useRegions) {
                for (Block block : event.blockList()) {
                    if (StateFlag.test((StateFlag.State[])new StateFlag.State[]{WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery().queryState(BukkitAdapter.adapt((Location)block.getLocation()), (RegionAssociable)null, new StateFlag[]{Flags.WITHER_DAMAGE})})) continue;
                    event.blockList().clear();
                    event.setCancelled(true);
                    return;
                }
            }
        } else {
            if (wcfg.blockOtherExplosions) {
                event.setCancelled(true);
                return;
            }
            if (wcfg.useRegions) {
                for (Block block : event.blockList()) {
                    if (WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery().getApplicableRegions(BukkitAdapter.adapt((Location)block.getLocation())).testState(null, new StateFlag[]{Flags.OTHER_EXPLOSION})) continue;
                    event.blockList().clear();
                    if (wcfg.explosionFlagCancellation) {
                        event.setCancelled(true);
                    }
                    return;
                }
            }
        }
        if (wcfg.signChestProtection) {
            for (Block block : event.blockList()) {
                if (!wcfg.isChestProtected(BukkitAdapter.adapt((Location)block.getLocation()))) continue;
                event.blockList().clear();
                return;
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onExplosionPrime(ExplosionPrimeEvent event) {
        ConfigurationManager cfg = WorldGuard.getInstance().getPlatform().getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(BukkitAdapter.adapt((org.bukkit.World)event.getEntity().getWorld()));
        Entity ent = event.getEntity();
        if (cfg.activityHaltToggle) {
            ent.remove();
            event.setCancelled(true);
            return;
        }
        if (event.getEntityType() == EntityType.WITHER) {
            if (wcfg.blockWitherExplosions) {
                event.setCancelled(true);
                return;
            }
        } else if (event.getEntityType() == EntityType.WITHER_SKULL) {
            if (wcfg.blockWitherSkullExplosions) {
                event.setCancelled(true);
                return;
            }
        } else if (event.getEntityType() == EntityType.FIREBALL) {
            if (wcfg.blockFireballExplosions) {
                event.setCancelled(true);
                return;
            }
        } else if (event.getEntityType() == EntityType.CREEPER) {
            if (wcfg.blockCreeperExplosions) {
                event.setCancelled(true);
                return;
            }
        } else if ((event.getEntityType() == EntityType.PRIMED_TNT || event.getEntityType() == EntityType.MINECART_TNT) && wcfg.blockTNTExplosions) {
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onCreatureSpawn(CreatureSpawnEvent event) {
        ConfigurationManager cfg = WorldGuard.getInstance().getPlatform().getGlobalStateManager();
        if (cfg.activityHaltToggle) {
            event.setCancelled(true);
            return;
        }
        WorldConfiguration wcfg = cfg.get(BukkitAdapter.adapt((org.bukkit.World)event.getEntity().getWorld()));
        if (!wcfg.blockPluginSpawning && event.getSpawnReason() == CreatureSpawnEvent.SpawnReason.CUSTOM) {
            return;
        }
        if (Entities.isConsideredBuildingIfUsed((Entity)event.getEntity())) {
            return;
        }
        if (wcfg.allowTamedSpawns && event.getEntity() instanceof Tameable && ((Tameable)event.getEntity()).isTamed()) {
            return;
        }
        EntityType entityType = event.getEntityType();
        com.sk89q.worldedit.world.entity.EntityType weEntityType = BukkitAdapter.adapt((EntityType)entityType);
        if (weEntityType != null && wcfg.blockCreatureSpawn.contains(weEntityType)) {
            event.setCancelled(true);
            return;
        }
        Location eventLoc = event.getLocation();
        if (wcfg.useRegions && cfg.useRegionsCreatureSpawnEvent) {
            ApplicableRegionSet set = WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery().getApplicableRegions(BukkitAdapter.adapt((Location)eventLoc));
            if (!set.testState(null, new StateFlag[]{Flags.MOB_SPAWNING})) {
                event.setCancelled(true);
                return;
            }
            Set entityTypes = (Set)set.queryValue(null, (Flag)Flags.DENY_SPAWN);
            if (entityTypes != null && weEntityType != null && entityTypes.contains(weEntityType)) {
                event.setCancelled(true);
                return;
            }
        }
        if (wcfg.blockGroundSlimes && entityType == EntityType.SLIME && eventLoc.getY() >= 60.0 && event.getSpawnReason() == CreatureSpawnEvent.SpawnReason.NATURAL) {
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onCreatePortal(PortalCreateEvent event) {
        ConfigurationManager cfg = WorldGuard.getInstance().getPlatform().getGlobalStateManager();
        World world = BukkitAdapter.adapt((org.bukkit.World)event.getWorld());
        WorldConfiguration wcfg = cfg.get(world);
        if (wcfg.regionNetherPortalProtection && event.getReason() == PortalCreateEvent.CreateReason.NETHER_PAIR && !event.getBlocks().isEmpty()) {
            RegionManager regionManager = WorldGuard.getInstance().getPlatform().getRegionContainer().get(world);
            if (regionManager == null) {
                return;
            }
            LocalPlayer associable = null;
            if (event.getEntity() instanceof Player) {
                associable = this.plugin.wrapPlayer((Player)event.getEntity());
            }
            if (WorldGuard.getInstance().getPlatform().getSessionManager().hasBypass(associable, world)) {
                return;
            }
            BlockVector3 min = null;
            BlockVector3 max = null;
            for (BlockState block : event.getBlocks()) {
                BlockVector3 loc = BlockVector3.at((int)block.getX(), (int)block.getY(), (int)block.getZ());
                min = min == null ? loc : loc.getMinimum(min);
                max = max == null ? loc : loc.getMaximum(max);
            }
            ProtectedCuboidRegion target = new ProtectedCuboidRegion("__portal_check", true, min, max);
            ApplicableRegionSet regions = regionManager.getApplicableRegions((ProtectedRegion)target);
            if (!regions.testState((RegionAssociable)associable, new StateFlag[]{Flags.BUILD, Flags.BLOCK_PLACE})) {
                if (associable != null) {
                    associable.print("Destination is an a protected area.");
                }
                event.setCancelled(true);
            }
        }
        if (event.getEntity() instanceof EnderDragon && wcfg.blockEnderDragonPortalCreation) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPigZap(PigZapEvent event) {
        ConfigurationManager cfg = WorldGuard.getInstance().getPlatform().getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(BukkitAdapter.adapt((org.bukkit.World)event.getEntity().getWorld()));
        if (wcfg.disablePigZap) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onCreeperPower(CreeperPowerEvent event) {
        ConfigurationManager cfg = WorldGuard.getInstance().getPlatform().getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(BukkitAdapter.adapt((org.bukkit.World)event.getEntity().getWorld()));
        if (wcfg.disableCreeperPower) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntityRegainHealth(EntityRegainHealthEvent event) {
        Entity ent = event.getEntity();
        org.bukkit.World world = ent.getWorld();
        ConfigurationManager cfg = WorldGuard.getInstance().getPlatform().getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(BukkitAdapter.adapt((org.bukkit.World)world));
        if (wcfg.disableHealthRegain) {
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntityChangeBlock(EntityChangeBlockEvent event) {
        Entity ent = event.getEntity();
        Block block = event.getBlock();
        Location location = block.getLocation();
        ConfigurationManager cfg = WorldGuard.getInstance().getPlatform().getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(BukkitAdapter.adapt((org.bukkit.World)ent.getWorld()));
        if (ent instanceof Enderman) {
            if (wcfg.disableEndermanGriefing) {
                event.setCancelled(true);
                return;
            }
        } else if (ent.getType() == EntityType.WITHER) {
            if (wcfg.blockWitherBlockDamage || wcfg.blockWitherExplosions) {
                event.setCancelled(true);
                return;
            }
            if (wcfg.useRegions && !StateFlag.test((StateFlag.State[])new StateFlag.State[]{WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery().queryState(BukkitAdapter.adapt((Location)location), (RegionAssociable)null, new StateFlag[]{Flags.WITHER_DAMAGE})})) {
                event.setCancelled(true);
                return;
            }
        } else if (event instanceof EntityBreakDoorEvent && wcfg.blockZombieDoorDestruction) {
            event.setCancelled(true);
            return;
        }
    }

    private boolean checkItemFrameProtection(Entity attacker, ItemFrame defender) {
        org.bukkit.World world = attacker.getWorld();
        ConfigurationManager cfg = WorldGuard.getInstance().getPlatform().getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(BukkitAdapter.adapt((org.bukkit.World)world));
        if (wcfg.useRegions && !(attacker instanceof Player) && !StateFlag.test((StateFlag.State[])new StateFlag.State[]{WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery().queryState(BukkitAdapter.adapt((Location)defender.getLocation()), (RegionAssociable)null, new StateFlag[]{Flags.ENTITY_ITEM_FRAME_DESTROY})})) {
            return true;
        }
        return wcfg.blockEntityItemFrameDestroy && !(attacker instanceof Player);
    }
}

