/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.sk89q.worldedit.NotABlockException;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.blocks.BaseItemStack;
import com.sk89q.worldedit.bukkit.BukkitEntity;
import com.sk89q.worldedit.bukkit.BukkitPlayer;
import com.sk89q.worldedit.bukkit.BukkitWorld;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extension.input.InputParseException;
import com.sk89q.worldedit.extension.input.ParserContext;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.biome.BiomeTypes;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import com.sk89q.worldedit.world.entity.EntityTypes;
import com.sk89q.worldedit.world.gamemode.GameMode;
import com.sk89q.worldedit.world.gamemode.GameModes;
import com.sk89q.worldedit.world.item.ItemType;
import com.sk89q.worldedit.world.item.ItemTypes;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;

public class BukkitAdapter {
    private static final ParserContext TO_BLOCK_CONTEXT = new ParserContext();
    private static Map<String, BlockState> blockStateCache;
    private static Map<String, BlockData> blockDataCache;

    private BukkitAdapter() {
    }

    public static boolean equals(BlockType blockType, Material type) {
        return Objects.equals(blockType.getId(), type.getKey().toString());
    }

    public static BukkitWorld asBukkitWorld(World world) {
        if (world instanceof BukkitWorld) {
            return (BukkitWorld)world;
        }
        BukkitWorld bukkitWorld = WorldEditPlugin.getInstance().getInternalPlatform().matchWorld(world);
        if (bukkitWorld == null) {
            throw new RuntimeException("World '" + world.getName() + "' has no matching version in Bukkit");
        }
        return bukkitWorld;
    }

    public static World adapt(org.bukkit.World world) {
        Preconditions.checkNotNull((Object)world);
        return new BukkitWorld(world);
    }

    public static BukkitPlayer adapt(org.bukkit.entity.Player player) {
        return WorldEditPlugin.getInstance().wrapPlayer(player);
    }

    public static org.bukkit.entity.Player adapt(Player player) {
        return ((BukkitPlayer)player).getPlayer();
    }

    public static org.bukkit.World adapt(World world) {
        Preconditions.checkNotNull((Object)world);
        if (world instanceof BukkitWorld) {
            return ((BukkitWorld)world).getWorld();
        }
        org.bukkit.World match = Bukkit.getServer().getWorld(world.getName());
        if (match != null) {
            return match;
        }
        throw new IllegalArgumentException("Can't find a Bukkit world for " + world.getName());
    }

    public static com.sk89q.worldedit.util.Location adapt(Location location) {
        Preconditions.checkNotNull((Object)location);
        Vector3 position = BukkitAdapter.asVector(location);
        return new com.sk89q.worldedit.util.Location((Extent)BukkitAdapter.adapt(location.getWorld()), position, location.getYaw(), location.getPitch());
    }

    public static Location adapt(com.sk89q.worldedit.util.Location location) {
        Preconditions.checkNotNull((Object)location);
        Vector3 position = location.toVector();
        return new Location(BukkitAdapter.adapt((World)location.getExtent()), position.getX(), position.getY(), position.getZ(), location.getYaw(), location.getPitch());
    }

    public static Location adapt(org.bukkit.World world, Vector3 position) {
        Preconditions.checkNotNull((Object)world);
        Preconditions.checkNotNull((Object)position);
        return new Location(world, position.getX(), position.getY(), position.getZ());
    }

    public static Location adapt(org.bukkit.World world, BlockVector3 position) {
        Preconditions.checkNotNull((Object)world);
        Preconditions.checkNotNull((Object)position);
        return new Location(world, (double)position.getX(), (double)position.getY(), (double)position.getZ());
    }

    public static Location adapt(org.bukkit.World world, com.sk89q.worldedit.util.Location location) {
        Preconditions.checkNotNull((Object)world);
        Preconditions.checkNotNull((Object)location);
        return new Location(world, location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
    }

    public static Vector3 asVector(Location location) {
        Preconditions.checkNotNull((Object)location);
        return Vector3.at((double)location.getX(), (double)location.getY(), (double)location.getZ());
    }

    public static BlockVector3 asBlockVector(Location location) {
        Preconditions.checkNotNull((Object)location);
        return BlockVector3.at((double)location.getX(), (double)location.getY(), (double)location.getZ());
    }

    public static Entity adapt(org.bukkit.entity.Entity entity) {
        Preconditions.checkNotNull((Object)entity);
        return new BukkitEntity(entity);
    }

    public static Material adapt(ItemType itemType) {
        Preconditions.checkNotNull((Object)itemType);
        if (!itemType.getId().startsWith("minecraft:")) {
            throw new IllegalArgumentException("Bukkit only supports Minecraft items");
        }
        return Material.getMaterial((String)itemType.getId().substring(10).toUpperCase(Locale.ROOT));
    }

    public static Material adapt(BlockType blockType) {
        Preconditions.checkNotNull((Object)blockType);
        if (!blockType.getId().startsWith("minecraft:")) {
            throw new IllegalArgumentException("Bukkit only supports Minecraft blocks");
        }
        return Material.getMaterial((String)blockType.getId().substring(10).toUpperCase(Locale.ROOT));
    }

    public static GameMode adapt(org.bukkit.GameMode gameMode) {
        Preconditions.checkNotNull((Object)gameMode);
        return GameModes.get((String)gameMode.name().toLowerCase(Locale.ROOT));
    }

    public static BiomeType adapt(Biome biome) {
        return BiomeTypes.get((String)biome.name().toLowerCase(Locale.ROOT));
    }

    public static Biome adapt(BiomeType biomeType) {
        if (!biomeType.getId().startsWith("minecraft:")) {
            throw new IllegalArgumentException("Bukkit only supports vanilla biomes");
        }
        try {
            return Biome.valueOf((String)biomeType.getId().substring(10).toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static com.sk89q.worldedit.world.entity.EntityType adapt(EntityType entityType) {
        return EntityTypes.get((String)entityType.getName().toLowerCase(Locale.ROOT));
    }

    public static EntityType adapt(com.sk89q.worldedit.world.entity.EntityType entityType) {
        if (!entityType.getId().startsWith("minecraft:")) {
            throw new IllegalArgumentException("Bukkit only supports vanilla entities");
        }
        return EntityType.fromName((String)entityType.getId().substring(10));
    }

    public static BlockType asBlockType(Material material) {
        Preconditions.checkNotNull((Object)material);
        if (!material.isBlock()) {
            throw new IllegalArgumentException(material.getKey().toString() + " is not a block!");
        }
        return BlockTypes.get((String)material.getKey().toString());
    }

    public static ItemType asItemType(Material material) {
        Preconditions.checkNotNull((Object)material);
        if (!material.isItem()) {
            throw new IllegalArgumentException(material.getKey().toString() + " is not an item!");
        }
        return ItemTypes.get((String)material.getKey().toString());
    }

    public static BlockState adapt(BlockData blockData) {
        Preconditions.checkNotNull((Object)blockData);
        return blockStateCache.computeIfAbsent(blockData.getAsString(), (java.util.function.Function<String, BlockState>)new Function<String, BlockState>(){

            @Nullable
            public BlockState apply(@Nullable String input) {
                try {
                    return ((BaseBlock)WorldEdit.getInstance().getBlockFactory().parseFromInput(input, TO_BLOCK_CONTEXT)).toImmutableState();
                }
                catch (InputParseException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        });
    }

    public static <B extends BlockStateHolder<B>> BlockData adapt(final B block) {
        Preconditions.checkNotNull(block);
        return blockDataCache.computeIfAbsent(block.getAsString(), (java.util.function.Function<String, BlockData>)new Function<String, BlockData>(){

            @Nullable
            public BlockData apply(@Nullable String input) {
                return Bukkit.createBlockData((String)block.getAsString());
            }
        }).clone();
    }

    public static BlockState asBlockState(ItemStack itemStack) throws WorldEditException {
        Preconditions.checkNotNull((Object)itemStack);
        if (itemStack.getType().isBlock()) {
            return BukkitAdapter.adapt(itemStack.getType().createBlockData());
        }
        throw new NotABlockException();
    }

    public static BaseItemStack adapt(ItemStack itemStack) {
        Preconditions.checkNotNull((Object)itemStack);
        if (WorldEditPlugin.getInstance().getBukkitImplAdapter() != null) {
            return WorldEditPlugin.getInstance().getBukkitImplAdapter().adapt(itemStack);
        }
        return new BaseItemStack(ItemTypes.get((String)itemStack.getType().getKey().toString()), itemStack.getAmount());
    }

    public static ItemStack adapt(BaseItemStack item) {
        Preconditions.checkNotNull((Object)item);
        if (WorldEditPlugin.getInstance().getBukkitImplAdapter() != null) {
            return WorldEditPlugin.getInstance().getBukkitImplAdapter().adapt(item);
        }
        return new ItemStack(BukkitAdapter.adapt(item.getType()), item.getAmount());
    }

    static {
        TO_BLOCK_CONTEXT.setRestricted(false);
        blockStateCache = new HashMap<String, BlockState>();
        blockDataCache = new HashMap<String, BlockData>();
    }
}

