/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.util;

import com.plotsquared.core.util.MathMan;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class TimeUtil {
    private TimeUtil() {
    }

    public static @NonNull String secToTime(@NonNegative long time) {
        StringBuilder toReturn = new StringBuilder();
        if (time >= 33868800L) {
            int years = (int)(time / 33868800L);
            time -= (long)(years * 33868800);
            toReturn.append(years).append("y ");
        }
        if (time >= 604800L) {
            int weeks = (int)(time / 604800L);
            time -= (long)(weeks * 604800);
            toReturn.append(weeks).append("w ");
        }
        if (time >= 86400L) {
            int days = (int)(time / 86400L);
            time -= (long)(days * 86400);
            toReturn.append(days).append("d ");
        }
        if (time >= 3600L) {
            int hours = (int)(time / 3600L);
            time -= (long)(hours * 3600);
            toReturn.append(hours).append("h ");
        }
        if (time >= 60L) {
            int minutes = (int)(time / 60L);
            time -= (long)(minutes * 60);
            toReturn.append(minutes).append("m ");
        }
        if (toReturn.length() == 0 || time > 0L) {
            toReturn.append(time).append("s ");
        }
        return toReturn.toString().trim();
    }

    public static @NonNegative long timeToSec(@NonNull String string) {
        if (MathMan.isInteger(string)) {
            return Long.parseLong(string);
        }
        if ((string = string.toLowerCase().trim().toLowerCase()).equalsIgnoreCase("false")) {
            return 0L;
        }
        String[] split = string.split(" ");
        long time = 0L;
        for (String value : split) {
            String letters;
            int numbers = Integer.parseInt(value.replaceAll("[^\\d]", ""));
            switch (letters = value.replaceAll("[^a-z]", "")) {
                case "week": 
                case "weeks": 
                case "wks": 
                case "w": {
                    time += (long)(604800 * numbers);
                }
                case "days": 
                case "day": 
                case "d": {
                    time += (long)(86400 * numbers);
                }
                case "hour": 
                case "hr": 
                case "hrs": 
                case "hours": 
                case "h": {
                    time += (long)(3600 * numbers);
                }
                case "minutes": 
                case "minute": 
                case "mins": 
                case "min": 
                case "m": {
                    time += (long)(60 * numbers);
                }
                case "seconds": 
                case "second": 
                case "secs": 
                case "sec": 
                case "s": {
                    time += (long)numbers;
                }
            }
        }
        return time;
    }
}

