/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.queue;

import com.plotsquared.core.location.Location;
import com.plotsquared.core.queue.DelegateQueueCoordinator;
import com.plotsquared.core.queue.QueueCoordinator;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ScopedQueueCoordinator
extends DelegateQueueCoordinator {
    private final int minX;
    private final int minY;
    private final int minZ;
    private final int maxX;
    private final int maxY;
    private final int maxZ;
    private final int dx;
    private final int dy;
    private final int dz;

    public ScopedQueueCoordinator(@Nullable QueueCoordinator parent, @NonNull Location min, @NonNull Location max) {
        super(parent);
        this.minX = min.getX();
        this.minY = min.getY();
        this.minZ = min.getZ();
        this.maxX = max.getX();
        this.maxY = max.getY();
        this.maxZ = max.getZ();
        this.dx = this.maxX - this.minX;
        this.dy = this.maxY - this.minY;
        this.dz = this.maxZ - this.minZ;
    }

    @Override
    public boolean setBiome(int x, int z, @NonNull BiomeType biome) {
        return x >= 0 && x <= this.dx && z >= 0 && z <= this.dz && super.setBiome(x + this.minX, z + this.minZ, biome);
    }

    @Override
    public boolean setBiome(int x, int y, int z, @NonNull BiomeType biome) {
        return x >= 0 && x <= this.dx && y >= 0 && y <= this.dy && z >= 0 && z <= this.dz && super.setBiome(x + this.minX, y + this.minY, z + this.minZ, biome);
    }

    public void fillBiome(BiomeType biome) {
        for (int y = 0; y <= this.dy; ++y) {
            for (int x = 0; x <= this.dx; ++x) {
                for (int z = 0; z < this.dz; ++z) {
                    this.setBiome(x, y, z, biome);
                }
            }
        }
    }

    @Override
    public boolean setBlock(int x, int y, int z, @NonNull BaseBlock id) {
        return x >= 0 && x <= this.dx && y >= 0 && y <= this.dy && z >= 0 && z <= this.dz && super.setBlock(x + this.minX, y + this.minY, z + this.minZ, id);
    }

    @Override
    public boolean setBlock(int x, int y, int z, @NonNull BlockState id) {
        return x >= 0 && x <= this.dx && y >= 0 && y <= this.dy && z >= 0 && z <= this.dz && super.setBlock(x + this.minX, y + this.minY, z + this.minZ, id);
    }

    @Override
    public boolean setBlock(int x, int y, int z, @NonNull Pattern pattern) {
        return x >= 0 && x <= this.dx && y >= 0 && y <= this.dy && z >= 0 && z <= this.dz && super.setBlock(x + this.minX, y + this.minY, z + this.minZ, pattern);
    }

    @Override
    public boolean setTile(int x, int y, int z, @NonNull CompoundTag tag) {
        return x >= 0 && x <= this.dx && y >= 0 && y <= this.dy && z >= 0 && z <= this.dz && super.setTile(x + this.minX, y + this.minY, z + this.minZ, tag);
    }

    public @NonNull Location getMin() {
        return Location.at(this.getWorld().getName(), this.minX, this.minY, this.minZ);
    }

    public @NonNull Location getMax() {
        return Location.at(this.getWorld().getName(), this.maxX, this.maxY, this.maxZ);
    }
}

