/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.queue;

import com.plotsquared.core.queue.QueueCoordinator;
import com.plotsquared.core.util.ChunkUtil;
import com.plotsquared.core.util.MathMan;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BaseBlock;
import java.util.HashMap;
import org.checkerframework.checker.nullness.qual.NonNull;

public class LocalChunk {
    private final QueueCoordinator parent;
    private final int x;
    private final int z;
    private final BaseBlock[][] baseblocks;
    private final BiomeType[][] biomes;
    private final HashMap<BlockVector3, CompoundTag> tiles = new HashMap();
    private final HashMap<Location, BaseEntity> entities = new HashMap();

    public LocalChunk(@NonNull QueueCoordinator parent, int x, int z) {
        this.parent = parent;
        this.x = x;
        this.z = z;
        this.baseblocks = new BaseBlock[16][];
        this.biomes = new BiomeType[16][];
    }

    public @NonNull QueueCoordinator getParent() {
        return this.parent;
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public @NonNull BaseBlock[][] getBaseblocks() {
        return this.baseblocks;
    }

    public @NonNull BiomeType[][] getBiomes() {
        return this.biomes;
    }

    public @NonNull HashMap<BlockVector3, CompoundTag> getTiles() {
        return this.tiles;
    }

    public void setBiome(int x, int y, int z, @NonNull BiomeType biomeType) {
        int i = y >> 4;
        int j = ChunkUtil.getJ(x, y, z);
        BiomeType[] array = this.biomes[i];
        if (array == null) {
            this.biomes[i] = new BiomeType[4096];
            array = this.biomes[i];
        }
        array[j] = biomeType;
    }

    public int hashCode() {
        return MathMan.pair((short)this.x, (short)this.z);
    }

    public void setBlock(int x, int y, int z, @NonNull BaseBlock baseBlock) {
        int i = y >> 4;
        int j = ChunkUtil.getJ(x, y, z);
        BaseBlock[] array = this.baseblocks[i];
        if (array == null) {
            this.baseblocks[i] = new BaseBlock[4096];
            array = this.baseblocks[i];
        }
        array[j] = baseBlock;
    }

    public void setTile(int x, int y, int z, @NonNull CompoundTag tag) {
        this.tiles.put(BlockVector3.at((int)x, (int)y, (int)z), tag);
    }

    public void setEntity(@NonNull Location location, @NonNull BaseEntity entity) {
        this.entities.put(location, entity);
    }

    public @NonNull HashMap<Location, BaseEntity> getEntities() {
        return this.entities;
    }
}

