/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.plot.world;

import com.plotsquared.core.location.Location;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotAreaType;
import com.plotsquared.core.util.StringMan;
import com.sk89q.worldedit.regions.CuboidRegion;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface PlotAreaManager {
    public @Nullable PlotArea getApplicablePlotArea(@Nullable Location var1);

    public @Nullable PlotArea getPlotArea(@NonNull Location var1);

    public @Nullable PlotArea getPlotArea(@NonNull String var1, @Nullable String var2);

    public @NonNull PlotArea[] getPlotAreas(@NonNull String var1, @Nullable CuboidRegion var2);

    public @NonNull PlotArea[] getAllPlotAreas();

    public @NonNull String[] getAllWorlds();

    public void addPlotArea(@NonNull PlotArea var1);

    public void removePlotArea(@NonNull PlotArea var1);

    public void addWorld(@NonNull String var1);

    public void removeWorld(@NonNull String var1);

    default public @NonNull Set<@NonNull PlotArea> getPlotAreasSet(@NonNull String world, @Nullable CuboidRegion region) {
        PlotArea[] areas = this.getPlotAreas(world, region);
        HashSet set = new HashSet();
        Collections.addAll(set, areas);
        return Collections.unmodifiableSet(set);
    }

    default public @NonNull Set<@NonNull PlotArea> getPlotAreasSet(@NonNull String world) {
        HashSet<PlotArea> set = new HashSet<PlotArea>();
        Collections.addAll(set, this.getPlotAreas(world, null));
        return set;
    }

    default public @Nullable PlotArea getPlotAreaByString(@NonNull String search) {
        String[] split = search.split("[;,]");
        PlotArea[] areas = this.getPlotAreas(split[0], null);
        if (areas == null) {
            for (PlotArea area : this.getAllPlotAreas()) {
                if (!area.getWorldName().equalsIgnoreCase(split[0]) || area.getId() != null && (split.length != 2 || !area.getId().equalsIgnoreCase(split[1]))) continue;
                return area;
            }
            return null;
        }
        if (areas.length == 1) {
            return areas[0];
        }
        if (split.length == 1) {
            return null;
        }
        for (PlotArea area : areas) {
            if (!StringMan.isEqual(split[1], area.getId())) continue;
            return area;
        }
        return null;
    }

    default public boolean hasPlotArea(@NonNull String world) {
        return this.getPlotAreas(world, null).length != 0;
    }

    default public boolean isAugmented(@NonNull String world) {
        PlotArea[] areas = this.getPlotAreas(world, null);
        return areas != null && (areas.length > 1 || areas[0].getType() != PlotAreaType.NORMAL);
    }

    default public void forEachPlotArea(@NonNull Consumer<? super PlotArea> action) {
        for (PlotArea area : this.getAllPlotAreas()) {
            action.accept(area);
        }
    }
}

