/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SetCommand;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.location.BlockLoc;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import net.kyori.adventure.text.minimessage.Template;

@CommandDeclaration(command="sethome", permission="plots.set.home", usage="/plot sethome [none]", aliases={"sh", "seth"}, category=CommandCategory.SETTINGS, requiredType=RequiredType.PLAYER)
public class SetHome
extends SetCommand {
    @Override
    public boolean set(PlotPlayer<?> player, Plot plot, String value) {
        if (!plot.hasOwner()) {
            player.sendMessage(TranslatableCaption.of("info.plot_unowned"), new Template[0]);
            return false;
        }
        switch (value.toLowerCase()) {
            case "unset": 
            case "reset": 
            case "remove": 
            case "none": {
                Plot base = plot.getBasePlot(false);
                base.setHome(null);
                player.sendMessage(TranslatableCaption.of("position.position_unset"), new Template[0]);
                return true;
            }
            case "": {
                Plot base = plot.getBasePlot(false);
                Location bottom = base.getBottomAbs();
                Location location = player.getLocationFull();
                BlockLoc rel = new BlockLoc(location.getX() - bottom.getX(), location.getY(), location.getZ() - bottom.getZ(), location.getYaw(), location.getPitch());
                base.setHome(rel);
                player.sendMessage(TranslatableCaption.of("position.position_set"), new Template[0]);
                return true;
            }
        }
        player.sendMessage(TranslatableCaption.of("commandconfig.command_syntax"), Template.of((String)"value", (String)"Use /plot set home [none]"));
        return false;
    }
}

