/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.google.inject.Inject;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.command.Argument;
import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.database.DBFunc;
import com.plotsquared.core.events.TeleportCause;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.permissions.PermissionHolder;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.util.EventDispatcher;
import com.plotsquared.core.util.Permissions;
import com.plotsquared.core.util.PlayerManager;
import com.plotsquared.core.util.TabCompletions;
import com.plotsquared.core.util.WorldUtil;
import com.sk89q.worldedit.world.gamemode.GameModes;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import net.kyori.adventure.text.minimessage.Template;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(command="deny", aliases={"d", "ban"}, usage="/plot deny <player>", category=CommandCategory.SETTINGS, requiredType=RequiredType.PLAYER)
public class Deny
extends SubCommand {
    private final PlotAreaManager plotAreaManager;
    private final EventDispatcher eventDispatcher;
    private final WorldUtil worldUtil;

    @Inject
    public Deny(@NonNull PlotAreaManager plotAreaManager, @NonNull EventDispatcher eventDispatcher, @NonNull WorldUtil worldUtil) {
        super(Argument.PlayerName);
        this.plotAreaManager = plotAreaManager;
        this.eventDispatcher = eventDispatcher;
        this.worldUtil = worldUtil;
    }

    @Override
    public boolean onCommand(PlotPlayer<?> player, String[] args) {
        Location location = player.getLocation();
        Plot plot = location.getPlotAbs();
        if (plot == null) {
            player.sendMessage(TranslatableCaption.of("errors.not_in_plot"), new Template[0]);
            return false;
        }
        if (!plot.hasOwner()) {
            player.sendMessage(TranslatableCaption.of("info.plot_unowned"), new Template[0]);
            return false;
        }
        if (!plot.isOwner(player.getUUID()) && !Permissions.hasPermission(player, Permission.PERMISSION_ADMIN_COMMAND_DENY)) {
            player.sendMessage(TranslatableCaption.of("permission.no_plot_perms"), new Template[0]);
            return true;
        }
        int maxDenySize = Permissions.hasPermissionRange(player, Permission.PERMISSION_DENY, Settings.Limit.MAX_PLOTS);
        int size = plot.getDenied().size();
        if (size >= maxDenySize) {
            player.sendMessage(TranslatableCaption.of("members.plot_max_members_denied"), Template.of((String)"amount", (String)String.valueOf(size)));
            return false;
        }
        PlayerManager.getUUIDsFromString(args[0], (uuids, throwable) -> {
            if (throwable instanceof TimeoutException) {
                player.sendMessage(TranslatableCaption.of("players.fetching_players_timeout"), new Template[0]);
            } else if (throwable != null || uuids.isEmpty()) {
                player.sendMessage(TranslatableCaption.of("errors.invalid_player"), Template.of((String)"value", (String)args[0]));
            } else {
                for (UUID uuid : uuids) {
                    if (uuid == DBFunc.EVERYONE && !Permissions.hasPermission((PermissionHolder)player, Permission.PERMISSION_DENY_EVERYONE) && !Permissions.hasPermission((PermissionHolder)player, Permission.PERMISSION_ADMIN_COMMAND_DENY)) {
                        player.sendMessage(TranslatableCaption.of("errors.invalid_player"), Template.of((String)"value", (String)args[0]));
                        continue;
                    }
                    if (plot.isOwner(uuid)) {
                        player.sendMessage(TranslatableCaption.of("deny.cant_remove_owner"), new Template[0]);
                        return;
                    }
                    if (plot.getDenied().contains(uuid)) {
                        player.sendMessage(TranslatableCaption.of("member.already_added"), Template.of((String)"player", (String)PlayerManager.resolveName(uuid).getComponent(player)));
                        return;
                    }
                    if (uuid != DBFunc.EVERYONE) {
                        plot.removeMember(uuid);
                        plot.removeTrusted(uuid);
                    }
                    plot.addDenied(uuid);
                    this.eventDispatcher.callDenied(player, plot, uuid, true);
                    if (!uuid.equals(DBFunc.EVERYONE)) {
                        this.handleKick(PlotSquared.platform().playerManager().getPlayerIfExists(uuid), plot);
                        continue;
                    }
                    for (PlotPlayer<?> plotPlayer : plot.getPlayersInPlot()) {
                        if (plot.isAdded(plotPlayer.getUUID())) continue;
                        this.handleKick(plotPlayer, plot);
                    }
                }
                player.sendMessage(TranslatableCaption.of("deny.denied_added"), new Template[0]);
            }
        });
        return true;
    }

    @Override
    public Collection<Command> tab(PlotPlayer<?> player, String[] args, boolean space) {
        return TabCompletions.completePlayers(player, String.join((CharSequence)",", args).trim(), Collections.emptyList());
    }

    private void handleKick(PlotPlayer<?> player, Plot plot) {
        if (player == null) {
            return;
        }
        if (!plot.equals(player.getCurrentPlot())) {
            return;
        }
        if (player.hasPermission("plots.admin.entry.denied")) {
            return;
        }
        if (player.getGameMode() == GameModes.SPECTATOR) {
            player.stopSpectating();
        }
        Location location = player.getLocation();
        Location spawn = this.worldUtil.getSpawn(location.getWorldName());
        player.sendMessage(TranslatableCaption.of("deny.you_got_denied"), new Template[0]);
        if (plot.equals(spawn.getPlot())) {
            Location newSpawn = this.worldUtil.getSpawn(this.plotAreaManager.getAllWorlds()[0]);
            if (plot.equals(newSpawn.getPlot())) {
                player.kick("You got kicked from the plot! This server did not set up a loaded spawn, so you got kicked from the server.");
            } else {
                player.teleport(newSpawn, TeleportCause.DENIED);
            }
        } else {
            player.teleport(spawn, TeleportCause.DENIED);
        }
    }
}

