/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.spring;

import com.j256.ormlite.dao.BaseDaoImpl;
import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.table.DatabaseTableConfig;
import com.j256.ormlite.table.TableUtils;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TableCreator {
    public static final String AUTO_CREATE_TABLES = "ormlite.auto.create.tables";
    public static final String AUTO_DROP_TABLES = "ormlite.auto.drop.tables";
    private ConnectionSource connectionSource;
    private List<Dao<?, ?>> configuredDaos;
    private Set<DatabaseTableConfig<?>> createdClasses = new HashSet();

    public TableCreator() {
    }

    public TableCreator(ConnectionSource connectionSource, List<Dao<?, ?>> configuredDaos) {
        this.connectionSource = connectionSource;
        this.configuredDaos = configuredDaos;
    }

    public void maybeCreateTables() throws SQLException {
        this.initialize();
    }

    public void initialize() throws SQLException {
        if (!Boolean.parseBoolean(System.getProperty(AUTO_CREATE_TABLES))) {
            return;
        }
        if (this.configuredDaos == null) {
            throw new SQLException("configuredDaos was not set in " + this.getClass().getSimpleName());
        }
        for (Dao<?, ?> dao : this.configuredDaos) {
            Class clazz = dao.getDataClass();
            try {
                DatabaseTableConfig tableConfig = null;
                if (dao instanceof BaseDaoImpl) {
                    tableConfig = ((BaseDaoImpl)dao).getTableConfig();
                }
                if (tableConfig == null) {
                    tableConfig = DatabaseTableConfig.fromClass((ConnectionSource)this.connectionSource, (Class)clazz);
                }
                TableUtils.createTable((ConnectionSource)this.connectionSource, (DatabaseTableConfig)tableConfig);
                this.createdClasses.add(tableConfig);
            }
            catch (Exception e) {
                System.err.println("Was unable to auto-create table for " + clazz);
                e.printStackTrace();
            }
        }
    }

    public void maybeDropTables() {
        this.destroy();
    }

    public void destroy() {
        if (!Boolean.parseBoolean(System.getProperty(AUTO_DROP_TABLES))) {
            return;
        }
        for (DatabaseTableConfig<?> tableConfig : this.createdClasses) {
            try {
                TableUtils.dropTable((ConnectionSource)this.connectionSource, tableConfig, (boolean)false);
            }
            catch (Exception e) {
                System.err.println("Was unable to auto-drop table for " + tableConfig.getDataClass());
                e.printStackTrace();
            }
        }
        this.createdClasses.clear();
    }

    public void setConnectionSource(ConnectionSource dataSource) {
        this.connectionSource = dataSource;
    }

    public void setConfiguredDaos(List<Dao<?, ?>> configuredDaos) {
        this.configuredDaos = configuredDaos;
    }
}

