/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.pubsub.handlers;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.twitch4j.common.events.TwitchEvent;
import com.github.twitch4j.common.events.domain.EventUser;
import com.github.twitch4j.common.events.user.PrivateMessageEvent;
import com.github.twitch4j.common.util.TwitchUtils;
import com.github.twitch4j.common.util.TypeConvert;
import com.github.twitch4j.pubsub.domain.WhisperThread;
import com.github.twitch4j.pubsub.events.WhisperThreadUpdateEvent;
import com.github.twitch4j.pubsub.handlers.TopicHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

class WhispersHandler
implements TopicHandler {
    WhispersHandler() {
    }

    @Override
    public String topicName() {
        return "whispers";
    }

    @Override
    public TwitchEvent apply(TopicHandler.Args args) {
        JsonNode msgDataParsed = (JsonNode)TypeConvert.jsonToObject((String)args.getData().asText(), JsonNode.class);
        String type = args.getType();
        if ("whisper_sent".equals(type) || "whisper_received".equals(type)) {
            Map tags = (Map)TypeConvert.convertValue((Object)msgDataParsed.path("tags"), (TypeReference)new TypeReference<Map<String, Object>>(){});
            String fromId = msgDataParsed.get("from_id").asText();
            String displayName = (String)tags.get("display_name");
            EventUser eventUser = new EventUser(fromId, displayName);
            String body = msgDataParsed.get("body").asText();
            Set permissions = TwitchUtils.getPermissionsFromTags((Map)tags, new HashMap(), (String)fromId, args.getBotOwnerIds());
            return new PrivateMessageEvent(eventUser, body, permissions);
        }
        if ("thread".equals(type)) {
            WhisperThread thread = (WhisperThread)TypeConvert.convertValue((Object)msgDataParsed, WhisperThread.class);
            return new WhisperThreadUpdateEvent(args.getLastTopicPart(), thread);
        }
        return null;
    }
}

