/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.helix.webhooks.topics;

import com.github.twitch4j.helix.webhooks.domain.WebhookNotification;
import com.github.twitch4j.helix.webhooks.topics.ChannelBanTopic;
import com.github.twitch4j.helix.webhooks.topics.ChannelSubscriptionTopic;
import com.github.twitch4j.helix.webhooks.topics.ExtensionTransactionsTopic;
import com.github.twitch4j.helix.webhooks.topics.FollowsTopic;
import com.github.twitch4j.helix.webhooks.topics.HypeTrainTopic;
import com.github.twitch4j.helix.webhooks.topics.ModeratorChangeTopic;
import com.github.twitch4j.helix.webhooks.topics.StreamsTopic;
import com.github.twitch4j.helix.webhooks.topics.UsersTopic;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import lombok.Generated;
import org.jetbrains.annotations.ApiStatus;

@Deprecated
@ApiStatus.ScheduledForRemoval(inVersion="2.0.0")
public abstract class TwitchWebhookTopic<T> {
    private static final String BASE_URL = "https://api.twitch.tv/helix";
    private final String url;
    private Class<T> type;

    public TwitchWebhookTopic(String path, Class<T> type, SortedMap<String, Object> queryParameters) {
        this(BASE_URL, path, type, queryParameters);
    }

    public TwitchWebhookTopic(String baseUrl, String path, Class<T> type, SortedMap<String, Object> queryParameters) {
        this.type = type;
        this.url = baseUrl + path + this.buildQuery(queryParameters.entrySet());
    }

    public TwitchWebhookTopic(String url, Class<T> type) {
        this.url = url;
        this.type = type;
    }

    private String buildQuery(Iterable<Map.Entry<String, Object>> params) {
        StringBuilder urlBuilder = new StringBuilder();
        if (params != null) {
            boolean first = true;
            for (Map.Entry<String, Object> param : params) {
                if (param.getValue() == null) continue;
                urlBuilder.append(first ? "?" : "&").append(param.getKey()).append("=").append(param.getValue().toString());
                first = false;
            }
        }
        return urlBuilder.toString();
    }

    public String toString() {
        return this.url;
    }

    public static TwitchWebhookTopic<?> fromUrl(String url) throws URISyntaxException {
        if (url.startsWith(BASE_URL)) {
            URI uri = new URI(url);
            String[] splitQuery = uri.getRawQuery().split("&");
            TreeMap<String, String> params = new TreeMap<String, String>();
            for (String s : splitQuery) {
                String[] splitParam = s.split("=");
                params.put(splitParam[0], splitParam[1]);
            }
            switch (uri.getPath().replaceFirst("/helix", "")) {
                case "/moderation/banned/events": {
                    String broadcasterId = (String)params.get("broadcaster_id");
                    String userId = (String)params.get("user_id");
                    return new ChannelBanTopic(broadcasterId, userId);
                }
                case "/subscriptions/events": {
                    String broadcasterId = (String)params.get("broadcaster_id");
                    String userId = (String)params.get("user_id");
                    return new ChannelSubscriptionTopic(broadcasterId, userId);
                }
                case "/extensions/transactions": {
                    String extensionId = (String)params.get("extension_id");
                    return new ExtensionTransactionsTopic(extensionId);
                }
                case "/users/follows": {
                    String fromId = (String)params.get("from_id");
                    String toId = (String)params.get("to_id");
                    return new FollowsTopic(fromId, toId);
                }
                case "/hypetrain/events": {
                    String broadcasterId = (String)params.get("broadcaster_id");
                    return new HypeTrainTopic(broadcasterId);
                }
                case "/moderation/moderators/events": {
                    String broadcasterId = (String)params.get("broadcaster_id");
                    String userId = (String)params.get("user_id");
                    return new ModeratorChangeTopic(broadcasterId, userId);
                }
                case "/streams": {
                    String userId = (String)params.get("user_id");
                    return new StreamsTopic(userId);
                }
                case "/users": {
                    String userId = (String)params.get("user_id");
                    return new UsersTopic(userId);
                }
            }
        }
        return new UnknownTopic(url);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TwitchWebhookTopic)) {
            return false;
        }
        TwitchWebhookTopic other = (TwitchWebhookTopic)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$url = this.url;
        String other$url = other.url;
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        Class<T> this$type = this.getType();
        Class<T> other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TwitchWebhookTopic;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $url = this.url;
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        Class<T> $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    @Generated
    public Class<T> getType() {
        return this.type;
    }

    public static class UnknownTopic
    extends TwitchWebhookTopic<WebhookNotification> {
        public UnknownTopic(String url) {
            super(url, WebhookNotification.class);
        }
    }
}

