/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.helix.interceptor;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.philippheuer.credentialmanager.domain.Credential;
import com.github.philippheuer.credentialmanager.domain.OAuth2Credential;
import com.github.twitch4j.common.enums.TwitchLimitType;
import com.github.twitch4j.common.util.BucketUtils;
import com.github.twitch4j.common.util.TwitchLimitRegistry;
import com.github.twitch4j.helix.interceptor.TwitchHelixTokenManager;
import io.github.bucket4j.Bandwidth;
import io.github.bucket4j.Bucket;
import io.github.bucket4j.Refill;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public final class TwitchHelixRateLimitTracker {
    private static final String AUTOMOD_STATUS_MINUTE_ID = TwitchLimitType.HELIX_AUTOMOD_STATUS_LIMIT + "-min";
    private static final String AUTOMOD_STATUS_HOUR_ID = TwitchLimitType.HELIX_AUTOMOD_STATUS_LIMIT + "-hr";
    private static final String WHISPER_MINUTE_BANDWIDTH_ID = TwitchLimitType.CHAT_WHISPER_LIMIT.getBandwidthId() + "-minute";
    private static final String WHISPER_SECOND_BANDWIDTH_ID = TwitchLimitType.CHAT_WHISPER_LIMIT.getBandwidthId() + "-second";
    public static final List<Bandwidth> AUTOMOD_STATUS_NORMAL_BANDWIDTH = Arrays.asList(Bandwidth.simple((long)5L, (Duration)Duration.ofMinutes(1L)).withId(AUTOMOD_STATUS_MINUTE_ID), Bandwidth.simple((long)50L, (Duration)Duration.ofHours(1L)).withId(AUTOMOD_STATUS_HOUR_ID));
    public static final List<Bandwidth> AUTOMOD_STATUS_AFFILIATE_BANDWIDTH = Arrays.asList(Bandwidth.simple((long)10L, (Duration)Duration.ofMinutes(1L)).withId(AUTOMOD_STATUS_MINUTE_ID), Bandwidth.simple((long)100L, (Duration)Duration.ofHours(1L)).withId(AUTOMOD_STATUS_HOUR_ID));
    public static final List<Bandwidth> AUTOMOD_STATUS_PARTNER_BANDWIDTH = Arrays.asList(Bandwidth.simple((long)30L, (Duration)Duration.ofMinutes(1L)).withId(AUTOMOD_STATUS_MINUTE_ID), Bandwidth.simple((long)300L, (Duration)Duration.ofHours(1L)).withId(AUTOMOD_STATUS_HOUR_ID));
    private static final Bandwidth MOD_BANDWIDTH = Bandwidth.simple((long)10L, (Duration)Duration.ofSeconds(10L));
    private static final Bandwidth RAIDS_BANDWIDTH = Bandwidth.simple((long)10L, (Duration)Duration.ofMinutes(10L));
    private static final Bandwidth EXT_CHAT_BANDWIDTH = Bandwidth.simple((long)12L, (Duration)Duration.ofMinutes(1L));
    private static final Bandwidth EXT_PUBSUB_BANDWIDTH = Bandwidth.classic((long)100L, (Refill)Refill.greedy((long)1L, (Duration)Duration.ofSeconds(1L)));
    private static final Bandwidth VIP_BANDWIDTH = Bandwidth.simple((long)10L, (Duration)Duration.ofSeconds(10L));
    private static final List<Bandwidth> WHISPERS_BANDWIDTH = Arrays.asList(Bandwidth.simple((long)100L, (Duration)Duration.ofSeconds(60L)).withId(WHISPER_MINUTE_BANDWIDTH_ID), Bandwidth.simple((long)3L, (Duration)Duration.ofSeconds(1L)).withId(WHISPER_SECOND_BANDWIDTH_ID));
    private static final Bandwidth BANS_BANDWIDTH = Bandwidth.simple((long)100L, (Duration)Duration.ofSeconds(30L));
    private static final Bandwidth CLIPS_BANDWIDTH = Bandwidth.simple((long)600L, (Duration)Duration.ofSeconds(60L));
    private static final Bandwidth TERMS_BANDWIDTH = Bandwidth.simple((long)60L, (Duration)Duration.ofSeconds(60L));
    private final Cache<String, Bucket> primaryBuckets = Caffeine.newBuilder().expireAfterAccess(80L, TimeUnit.SECONDS).build();
    private final Cache<String, Bucket> extensionChatBuckets = Caffeine.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();
    private final Cache<String, Bucket> extensionPubSubBuckets = Caffeine.newBuilder().expireAfterAccess(100L, TimeUnit.SECONDS).build();
    private final Cache<String, Bucket> addModByChannelId = Caffeine.newBuilder().expireAfterAccess(30L, TimeUnit.SECONDS).build();
    private final Cache<String, Bucket> removeModByChannelId = Caffeine.newBuilder().expireAfterAccess(30L, TimeUnit.SECONDS).build();
    private final Cache<String, Bucket> raidsByChannelId = Caffeine.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build();
    private final Cache<String, Bucket> addVipByChannelId = Caffeine.newBuilder().expireAfterAccess(30L, TimeUnit.SECONDS).build();
    private final Cache<String, Bucket> removeVipByChannelId = Caffeine.newBuilder().expireAfterAccess(30L, TimeUnit.SECONDS).build();
    private final Cache<String, Bucket> bansByChannelId = Caffeine.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();
    private final Cache<String, Bucket> clipsByUserId = Caffeine.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();
    private final Cache<String, Bucket> termsByChannelId = Caffeine.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();
    private final Bandwidth apiRateLimit;
    private final TwitchHelixTokenManager tokenManager;

    @NotNull
    Bucket getOrInitializeBucket(@NotNull String key) {
        return (Bucket)this.primaryBuckets.get((Object)key, k -> BucketUtils.createBucket((Bandwidth)this.apiRateLimit));
    }

    @NotNull
    String getPrimaryBucketKey(@NotNull OAuth2Credential credential) {
        String clientId = TwitchHelixTokenManager.extractClientId(credential);
        return clientId == null ? "" : (StringUtils.isEmpty((CharSequence)credential.getUserId()) ? clientId : clientId + "-" + credential.getUserId());
    }

    @NotNull
    Bucket getExtensionChatBucket(@NotNull String clientId, @NotNull String channelId) {
        return (Bucket)this.extensionChatBuckets.get((Object)(clientId + ':' + channelId), k -> BucketUtils.createBucket((Bandwidth)EXT_CHAT_BANDWIDTH));
    }

    @NotNull
    Bucket getExtensionPubSubBucket(@NotNull String clientId, @NotNull String channelId) {
        return (Bucket)this.extensionPubSubBuckets.get((Object)(clientId + ':' + channelId), k -> BucketUtils.createBucket((Bandwidth)EXT_PUBSUB_BANDWIDTH));
    }

    @NotNull
    Bucket getAutomodStatusBucket(@NotNull String channelId) {
        return TwitchLimitRegistry.getInstance().getOrInitializeBucket(channelId, TwitchLimitType.HELIX_AUTOMOD_STATUS_LIMIT, AUTOMOD_STATUS_NORMAL_BANDWIDTH);
    }

    @NotNull
    Bucket getModAddBucket(@NotNull String channelId) {
        return (Bucket)this.addModByChannelId.get((Object)channelId, k -> BucketUtils.createBucket((Bandwidth)MOD_BANDWIDTH));
    }

    @NotNull
    Bucket getModRemoveBucket(@NotNull String channelId) {
        return (Bucket)this.removeModByChannelId.get((Object)channelId, k -> BucketUtils.createBucket((Bandwidth)MOD_BANDWIDTH));
    }

    @NotNull
    Bucket getRaidsBucket(@NotNull String channelId) {
        return (Bucket)this.raidsByChannelId.get((Object)channelId, k -> BucketUtils.createBucket((Bandwidth)RAIDS_BANDWIDTH));
    }

    @NotNull
    Bucket getVipAddBucket(@NotNull String channelId) {
        return (Bucket)this.addVipByChannelId.get((Object)channelId, k -> BucketUtils.createBucket((Bandwidth)VIP_BANDWIDTH));
    }

    @NotNull
    Bucket getVipRemoveBucket(@NotNull String channelId) {
        return (Bucket)this.removeVipByChannelId.get((Object)channelId, k -> BucketUtils.createBucket((Bandwidth)VIP_BANDWIDTH));
    }

    @NotNull
    Bucket getWhispersBucket(@NotNull String userId) {
        return TwitchLimitRegistry.getInstance().getOrInitializeBucket(userId, TwitchLimitType.CHAT_WHISPER_LIMIT, WHISPERS_BANDWIDTH);
    }

    @NotNull
    Bucket getModerationBucket(@NotNull String channelId) {
        return (Bucket)this.bansByChannelId.get((Object)channelId, k -> BucketUtils.createBucket((Bandwidth)BANS_BANDWIDTH));
    }

    @NotNull
    Bucket getClipBucket(@NotNull String userId) {
        return (Bucket)this.clipsByUserId.get((Object)userId, k -> BucketUtils.createBucket((Bandwidth)CLIPS_BANDWIDTH));
    }

    @NotNull
    Bucket getTermsBucket(@NotNull String channelId) {
        return (Bucket)this.termsByChannelId.get((Object)channelId, k -> BucketUtils.createBucket((Bandwidth)TERMS_BANDWIDTH));
    }

    public void updateRemaining(@NotNull String token, int remaining) {
        this.updateRemainingGeneric(token, remaining, this::getPrimaryBucketKey, this::getOrInitializeBucket);
    }

    public void updateRemainingExtensionChat(@NotNull String clientId, @NotNull String channelId, int remaining) {
        this.updateRemainingConservative(this.getExtensionChatBucket(clientId, channelId), remaining);
    }

    public void updateRemainingExtensionPubSub(@NotNull String clientId, @NotNull String target, int remaining) {
        this.updateRemainingConservative(this.getExtensionPubSubBucket(clientId, target), remaining);
    }

    public void updateRemainingCreateClip(@NotNull String token, int remaining) {
        this.updateRemainingGeneric(token, remaining, Credential::getUserId, this::getClipBucket);
    }

    public void markDepletedBanBucket(@NotNull String channelId) {
        Bucket modBucket = this.getModerationBucket(channelId);
        modBucket.consumeIgnoringRateLimits(Math.max(modBucket.tryConsumeAsMuchAsPossible(), 1L));
    }

    private void updateRemainingGeneric(String token, int remaining, Function<OAuth2Credential, String> credToKey, Function<String, Bucket> keyToBucket) {
        OAuth2Credential credential = this.tokenManager.getIfPresent(token);
        if (credential == null) {
            return;
        }
        String key = credToKey.apply(credential);
        if (key == null) {
            return;
        }
        Bucket bucket = keyToBucket.apply(key);
        this.updateRemainingConservative(bucket, remaining);
    }

    private void updateRemainingConservative(Bucket bucket, int remaining) {
        long diff = bucket.getAvailableTokens() - (long)remaining;
        if (diff > 0L) {
            bucket.tryConsumeAsMuchAsPossible(diff);
        }
    }

    public TwitchHelixRateLimitTracker(Bandwidth apiRateLimit, TwitchHelixTokenManager tokenManager) {
        this.apiRateLimit = apiRateLimit;
        this.tokenManager = tokenManager;
    }
}

