/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.helix;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.twitch4j.common.exception.NotFoundException;
import com.github.twitch4j.common.exception.UnauthorizedException;
import com.github.twitch4j.common.util.TypeConvert;
import com.github.twitch4j.helix.domain.TwitchHelixError;
import com.github.twitch4j.helix.interceptor.TwitchHelixRateLimitTracker;
import feign.Request;
import feign.RequestTemplate;
import feign.Response;
import feign.RetryableException;
import feign.codec.Decoder;
import feign.codec.ErrorDecoder;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.exception.ContextedRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwitchHelixErrorDecoder
implements ErrorDecoder {
    private static final Logger log = LoggerFactory.getLogger(TwitchHelixErrorDecoder.class);
    final Decoder decoder;
    final TwitchHelixRateLimitTracker rateLimitTracker;
    final ErrorDecoder defaultDecoder = new ErrorDecoder.Default();
    final ObjectMapper objectMapper = TypeConvert.getObjectMapper();

    public TwitchHelixErrorDecoder(Decoder decoder, TwitchHelixRateLimitTracker rateLimitTracker) {
        this.decoder = decoder;
        this.rateLimitTracker = rateLimitTracker;
    }

    public Exception decode(String methodKey, Response response) {
        Exception ex;
        try (InputStream is = response.body() == null ? null : response.body().asInputStream();){
            String responseBody;
            String string = responseBody = is == null ? "" : IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            if (response.status() == 401) {
                ex = new UnauthorizedException().addContextValue("requestUrl", (Object)response.request().url()).addContextValue("requestMethod", (Object)response.request().httpMethod()).addContextValue("responseBody", (Object)responseBody);
            } else if (response.status() == 404) {
                ex = new NotFoundException().addContextValue("requestUrl", (Object)response.request().url()).addContextValue("requestMethod", (Object)response.request().httpMethod()).addContextValue("responseBody", (Object)responseBody);
            } else if (response.status() == 429) {
                ex = new ContextedRuntimeException("Too many requests!").addContextValue("requestUrl", (Object)response.request().url()).addContextValue("requestMethod", (Object)response.request().httpMethod()).addContextValue("responseBody", (Object)responseBody);
                RequestTemplate template = response.request().requestTemplate();
                if (template.path().endsWith("/moderation/bans")) {
                    String channelId = (String)((Collection)template.queries().get("broadcaster_id")).iterator().next();
                    this.rateLimitTracker.markDepletedBanBucket(channelId);
                }
            } else if (response.status() == 503) {
                ex = new RetryableException(response.status(), "getting service unavailable, retrying ...", Request.HttpMethod.GET, null, response.request());
            } else {
                TwitchHelixError error = (TwitchHelixError)this.objectMapper.readValue(responseBody, TwitchHelixError.class);
                ex = new ContextedRuntimeException("Helix API Error").addContextValue("requestUrl", (Object)response.request().url()).addContextValue("requestMethod", (Object)response.request().httpMethod()).addContextValue("responseBody", (Object)responseBody).addContextValue("errorType", (Object)error.getError()).addContextValue("errorStatus", (Object)error.getStatus()).addContextValue("errorType", (Object)error.getMessage()).addContextValue("errorMessage", (Object)error.getMessage());
            }
        }
        catch (IOException fallbackToDefault) {
            ex = this.defaultDecoder.decode(methodKey, response);
        }
        return ex;
    }
}

