/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.graphql.internal;

import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.OperationName;
import com.apollographql.apollo.api.Query;
import com.apollographql.apollo.api.Response;
import com.apollographql.apollo.api.ResponseField;
import com.apollographql.apollo.api.ScalarType;
import com.apollographql.apollo.api.ScalarTypeAdapters;
import com.apollographql.apollo.api.internal.InputFieldMarshaller;
import com.apollographql.apollo.api.internal.InputFieldWriter;
import com.apollographql.apollo.api.internal.OperationRequestBodyComposer;
import com.apollographql.apollo.api.internal.QueryDocumentMinifier;
import com.apollographql.apollo.api.internal.ResponseFieldMapper;
import com.apollographql.apollo.api.internal.ResponseFieldMarshaller;
import com.apollographql.apollo.api.internal.ResponseReader;
import com.apollographql.apollo.api.internal.ResponseWriter;
import com.apollographql.apollo.api.internal.SimpleOperationResponseParser;
import com.apollographql.apollo.api.internal.UnmodifiableMapBuilder;
import com.apollographql.apollo.api.internal.Utils;
import com.github.twitch4j.graphql.internal.type.CustomType;
import com.github.twitch4j.graphql.internal.type.SquadStreamStatus;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FetchSquadStreamQuery
implements Query<Data, Data, Variables> {
    public static final String OPERATION_ID = "2ad934f180f92d32dbd4cb2d2542fca749aeeb64e47633492af139ee84fdc713";
    public static final String QUERY_DOCUMENT = QueryDocumentMinifier.minify((String)"query fetchSquadStream($id: ID!) {\n  squadStream(id: $id) {\n    __typename\n    id\n    members {\n      __typename\n      id\n      login\n      displayName\n      profileImageURL(width: 150)\n    }\n    owner {\n      __typename\n      id\n    }\n    status\n  }\n}");
    public static final OperationName OPERATION_NAME = new OperationName(){

        public String name() {
            return "fetchSquadStream";
        }
    };
    private final Variables variables;

    public FetchSquadStreamQuery(@NotNull String id) {
        Utils.checkNotNull((Object)id, (Object)"id == null");
        this.variables = new Variables(id);
    }

    public String operationId() {
        return OPERATION_ID;
    }

    public String queryDocument() {
        return QUERY_DOCUMENT;
    }

    public Data wrapData(Data data) {
        return data;
    }

    public Variables variables() {
        return this.variables;
    }

    public ResponseFieldMapper<Data> responseFieldMapper() {
        return new Data.Mapper();
    }

    public static Builder builder() {
        return new Builder();
    }

    public OperationName name() {
        return OPERATION_NAME;
    }

    @NotNull
    public Response<Data> parse(@NotNull BufferedSource source, @NotNull ScalarTypeAdapters scalarTypeAdapters) throws IOException {
        return SimpleOperationResponseParser.parse((BufferedSource)source, (Operation)this, (ScalarTypeAdapters)scalarTypeAdapters);
    }

    @NotNull
    public Response<Data> parse(@NotNull ByteString byteString, @NotNull ScalarTypeAdapters scalarTypeAdapters) throws IOException {
        return this.parse((BufferedSource)new Buffer().write(byteString), scalarTypeAdapters);
    }

    @NotNull
    public Response<Data> parse(@NotNull BufferedSource source) throws IOException {
        return this.parse(source, ScalarTypeAdapters.DEFAULT);
    }

    @NotNull
    public Response<Data> parse(@NotNull ByteString byteString) throws IOException {
        return this.parse(byteString, ScalarTypeAdapters.DEFAULT);
    }

    @NotNull
    public ByteString composeRequestBody(@NotNull ScalarTypeAdapters scalarTypeAdapters) {
        return OperationRequestBodyComposer.compose((Operation)this, (boolean)false, (boolean)true, (ScalarTypeAdapters)scalarTypeAdapters);
    }

    @NotNull
    public ByteString composeRequestBody() {
        return OperationRequestBodyComposer.compose((Operation)this, (boolean)false, (boolean)true, (ScalarTypeAdapters)ScalarTypeAdapters.DEFAULT);
    }

    @NotNull
    public ByteString composeRequestBody(boolean autoPersistQueries, boolean withQueryDocument, @NotNull ScalarTypeAdapters scalarTypeAdapters) {
        return OperationRequestBodyComposer.compose((Operation)this, (boolean)autoPersistQueries, (boolean)withQueryDocument, (ScalarTypeAdapters)scalarTypeAdapters);
    }

    public static final class Variables
    extends Operation.Variables {
        @NotNull
        private final String id;
        private final transient Map<String, Object> valueMap = new LinkedHashMap<String, Object>();

        Variables(@NotNull String id) {
            this.id = id;
            this.valueMap.put("id", id);
        }

        @NotNull
        public String id() {
            return this.id;
        }

        public Map<String, Object> valueMap() {
            return Collections.unmodifiableMap(this.valueMap);
        }

        public InputFieldMarshaller marshaller() {
            return new InputFieldMarshaller(){

                public void marshal(InputFieldWriter writer) throws IOException {
                    writer.writeCustom("id", (ScalarType)CustomType.ID, (Object)id);
                }
            };
        }
    }

    public static class Data
    implements Operation.Data {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forObject((String)"squadStream", (String)"squadStream", (Map)new UnmodifiableMapBuilder(1).put((Object)"id", (Object)new UnmodifiableMapBuilder(2).put((Object)"kind", (Object)"Variable").put((Object)"variableName", (Object)"id").build()).build(), (boolean)true, Collections.emptyList())};
        @Nullable
        final SquadStream squadStream;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public Data(@Nullable SquadStream squadStream) {
            this.squadStream = squadStream;
        }

        @Nullable
        public SquadStream squadStream() {
            return this.squadStream;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeObject($responseFields[0], squadStream != null ? squadStream.marshaller() : null);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "Data{squadStream=" + this.squadStream + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Data) {
                Data that = (Data)o;
                return this.squadStream == null ? that.squadStream == null : this.squadStream.equals(that.squadStream);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                this.$hashCode = h ^= this.squadStream == null ? 0 : this.squadStream.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<Data> {
            final SquadStream.Mapper squadStreamFieldMapper = new SquadStream.Mapper();

            public Data map(ResponseReader reader) {
                SquadStream squadStream = (SquadStream)reader.readObject($responseFields[0], (ResponseReader.ObjectReader)new ResponseReader.ObjectReader<SquadStream>(){

                    public SquadStream read(ResponseReader reader) {
                        return squadStreamFieldMapper.map(reader);
                    }
                });
                return new Data(squadStream);
            }
        }
    }

    public static final class Builder {
        @NotNull
        private String id;

        Builder() {
        }

        public Builder id(@NotNull String id) {
            this.id = id;
            return this;
        }

        public FetchSquadStreamQuery build() {
            Utils.checkNotNull((Object)this.id, (Object)"id == null");
            return new FetchSquadStreamQuery(this.id);
        }
    }

    public static class Owner {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forCustomType((String)"id", (String)"id", null, (boolean)false, (ScalarType)CustomType.ID, Collections.emptyList())};
        @NotNull
        final String __typename;
        @NotNull
        final String id;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public Owner(@NotNull String __typename, @NotNull String id) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.id = (String)Utils.checkNotNull((Object)id, (Object)"id == null");
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @NotNull
        public String id() {
            return this.id;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeCustom((ResponseField.CustomTypeField)$responseFields[1], (Object)id);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "Owner{__typename=" + this.__typename + ", id=" + this.id + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Owner) {
                Owner that = (Owner)o;
                return this.__typename.equals(that.__typename) && this.id.equals(that.id);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                this.$hashCode = h ^= this.id.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<Owner> {
            public Owner map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                String id = (String)reader.readCustomType((ResponseField.CustomTypeField)$responseFields[1]);
                return new Owner(__typename, id);
            }
        }
    }

    public static class Member {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forCustomType((String)"id", (String)"id", null, (boolean)false, (ScalarType)CustomType.ID, Collections.emptyList()), ResponseField.forString((String)"login", (String)"login", null, (boolean)false, Collections.emptyList()), ResponseField.forString((String)"displayName", (String)"displayName", null, (boolean)false, Collections.emptyList()), ResponseField.forString((String)"profileImageURL", (String)"profileImageURL", (Map)new UnmodifiableMapBuilder(1).put((Object)"width", (Object)150).build(), (boolean)true, Collections.emptyList())};
        @NotNull
        final String __typename;
        @NotNull
        final String id;
        @NotNull
        final String login;
        @NotNull
        final String displayName;
        @Nullable
        final String profileImageURL;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public Member(@NotNull String __typename, @NotNull String id, @NotNull String login, @NotNull String displayName, @Nullable String profileImageURL) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.id = (String)Utils.checkNotNull((Object)id, (Object)"id == null");
            this.login = (String)Utils.checkNotNull((Object)login, (Object)"login == null");
            this.displayName = (String)Utils.checkNotNull((Object)displayName, (Object)"displayName == null");
            this.profileImageURL = profileImageURL;
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @NotNull
        public String id() {
            return this.id;
        }

        @NotNull
        public String login() {
            return this.login;
        }

        @NotNull
        public String displayName() {
            return this.displayName;
        }

        @Nullable
        public String profileImageURL() {
            return this.profileImageURL;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeCustom((ResponseField.CustomTypeField)$responseFields[1], (Object)id);
                    writer.writeString($responseFields[2], login);
                    writer.writeString($responseFields[3], displayName);
                    writer.writeString($responseFields[4], profileImageURL);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "Member{__typename=" + this.__typename + ", id=" + this.id + ", login=" + this.login + ", displayName=" + this.displayName + ", profileImageURL=" + this.profileImageURL + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Member) {
                Member that = (Member)o;
                return this.__typename.equals(that.__typename) && this.id.equals(that.id) && this.login.equals(that.login) && this.displayName.equals(that.displayName) && (this.profileImageURL == null ? that.profileImageURL == null : this.profileImageURL.equals(that.profileImageURL));
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                h ^= this.id.hashCode();
                h *= 1000003;
                h ^= this.login.hashCode();
                h *= 1000003;
                h ^= this.displayName.hashCode();
                h *= 1000003;
                this.$hashCode = h ^= this.profileImageURL == null ? 0 : this.profileImageURL.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<Member> {
            public Member map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                String id = (String)reader.readCustomType((ResponseField.CustomTypeField)$responseFields[1]);
                String login = reader.readString($responseFields[2]);
                String displayName = reader.readString($responseFields[3]);
                String profileImageURL = reader.readString($responseFields[4]);
                return new Member(__typename, id, login, displayName, profileImageURL);
            }
        }
    }

    public static class SquadStream {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forCustomType((String)"id", (String)"id", null, (boolean)false, (ScalarType)CustomType.ID, Collections.emptyList()), ResponseField.forList((String)"members", (String)"members", null, (boolean)true, Collections.emptyList()), ResponseField.forObject((String)"owner", (String)"owner", null, (boolean)true, Collections.emptyList()), ResponseField.forString((String)"status", (String)"status", null, (boolean)false, Collections.emptyList())};
        @NotNull
        final String __typename;
        @NotNull
        final String id;
        @Nullable
        final List<Member> members;
        @Nullable
        final Owner owner;
        @NotNull
        final SquadStreamStatus status;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public SquadStream(@NotNull String __typename, @NotNull String id, @Nullable List<Member> members, @Nullable Owner owner, @NotNull SquadStreamStatus status) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.id = (String)Utils.checkNotNull((Object)id, (Object)"id == null");
            this.members = members;
            this.owner = owner;
            this.status = (SquadStreamStatus)((Object)Utils.checkNotNull((Object)((Object)status), (Object)"status == null"));
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @NotNull
        public String id() {
            return this.id;
        }

        @Nullable
        public List<Member> members() {
            return this.members;
        }

        @Nullable
        public Owner owner() {
            return this.owner;
        }

        @NotNull
        public SquadStreamStatus status() {
            return this.status;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeCustom((ResponseField.CustomTypeField)$responseFields[1], (Object)id);
                    writer.writeList($responseFields[2], members, new ResponseWriter.ListWriter(){

                        public void write(List items, ResponseWriter.ListItemWriter listItemWriter) {
                            for (Object item : items) {
                                listItemWriter.writeObject(((Member)item).marshaller());
                            }
                        }
                    });
                    writer.writeObject($responseFields[3], owner != null ? owner.marshaller() : null);
                    writer.writeString($responseFields[4], status.rawValue());
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "SquadStream{__typename=" + this.__typename + ", id=" + this.id + ", members=" + this.members + ", owner=" + this.owner + ", status=" + (Object)((Object)this.status) + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof SquadStream) {
                SquadStream that = (SquadStream)o;
                return this.__typename.equals(that.__typename) && this.id.equals(that.id) && (this.members == null ? that.members == null : this.members.equals(that.members)) && (this.owner == null ? that.owner == null : this.owner.equals(that.owner)) && this.status.equals((Object)that.status);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                h ^= this.id.hashCode();
                h *= 1000003;
                h ^= this.members == null ? 0 : this.members.hashCode();
                h *= 1000003;
                h ^= this.owner == null ? 0 : this.owner.hashCode();
                h *= 1000003;
                this.$hashCode = h ^= this.status.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<SquadStream> {
            final Member.Mapper memberFieldMapper = new Member.Mapper();
            final Owner.Mapper ownerFieldMapper = new Owner.Mapper();

            public SquadStream map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                String id = (String)reader.readCustomType((ResponseField.CustomTypeField)$responseFields[1]);
                List members = reader.readList($responseFields[2], (ResponseReader.ListReader)new ResponseReader.ListReader<Member>(){

                    public Member read(ResponseReader.ListItemReader listItemReader) {
                        return (Member)listItemReader.readObject((ResponseReader.ObjectReader)new ResponseReader.ObjectReader<Member>(){

                            public Member read(ResponseReader reader) {
                                return memberFieldMapper.map(reader);
                            }
                        });
                    }
                });
                Owner owner = (Owner)reader.readObject($responseFields[3], (ResponseReader.ObjectReader)new ResponseReader.ObjectReader<Owner>(){

                    public Owner read(ResponseReader reader) {
                        return ownerFieldMapper.map(reader);
                    }
                });
                String statusStr = reader.readString($responseFields[4]);
                SquadStreamStatus status = statusStr != null ? SquadStreamStatus.safeValueOf(statusStr) : null;
                return new SquadStream(__typename, id, members, owner, status);
            }
        }
    }
}

