/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.graphql;

import com.apollographql.apollo.ApolloClient;
import com.apollographql.apollo.internal.batch.BatchConfig;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.philippheuer.credentialmanager.domain.OAuth2Credential;
import com.github.philippheuer.events4j.core.EventManager;
import com.github.twitch4j.common.config.ProxyConfig;
import com.github.twitch4j.graphql.command.CommandAcceptFriendRequest;
import com.github.twitch4j.graphql.command.CommandAddChannelBlockedTerm;
import com.github.twitch4j.graphql.command.CommandAddChannelPermittedTerm;
import com.github.twitch4j.graphql.command.CommandApproveUnbanRequest;
import com.github.twitch4j.graphql.command.CommandArchivePoll;
import com.github.twitch4j.graphql.command.CommandBanUser;
import com.github.twitch4j.graphql.command.CommandBulkApproveUnbanRequest;
import com.github.twitch4j.graphql.command.CommandBulkDenyUnbanRequest;
import com.github.twitch4j.graphql.command.CommandCancelPrediction;
import com.github.twitch4j.graphql.command.CommandComputeId;
import com.github.twitch4j.graphql.command.CommandCreateClip;
import com.github.twitch4j.graphql.command.CommandCreateCommunityPointsGoal;
import com.github.twitch4j.graphql.command.CommandCreateModComment;
import com.github.twitch4j.graphql.command.CommandCreatePoll;
import com.github.twitch4j.graphql.command.CommandCreatePrediction;
import com.github.twitch4j.graphql.command.CommandDeleteChannelBlockedTerm;
import com.github.twitch4j.graphql.command.CommandDeleteChannelPermittedTerm;
import com.github.twitch4j.graphql.command.CommandDeleteClips;
import com.github.twitch4j.graphql.command.CommandDeleteCommunityPointsGoal;
import com.github.twitch4j.graphql.command.CommandDenyUnbanRequest;
import com.github.twitch4j.graphql.command.CommandFetchActivePredictions;
import com.github.twitch4j.graphql.command.CommandFetchBanStatus;
import com.github.twitch4j.graphql.command.CommandFetchChatHistory;
import com.github.twitch4j.graphql.command.CommandFetchChatters;
import com.github.twitch4j.graphql.command.CommandFetchCommunityPointsSettings;
import com.github.twitch4j.graphql.command.CommandFetchLastBroadcast;
import com.github.twitch4j.graphql.command.CommandFetchLockedPredictions;
import com.github.twitch4j.graphql.command.CommandFetchModComments;
import com.github.twitch4j.graphql.command.CommandFetchPoll;
import com.github.twitch4j.graphql.command.CommandFetchPrediction;
import com.github.twitch4j.graphql.command.CommandFetchSquadStream;
import com.github.twitch4j.graphql.command.CommandFetchUnbanRequests;
import com.github.twitch4j.graphql.command.CommandFetchUser;
import com.github.twitch4j.graphql.command.CommandFetchUserEmoteSets;
import com.github.twitch4j.graphql.command.CommandFetchUserSubscriptions;
import com.github.twitch4j.graphql.command.CommandFetchVideoComments;
import com.github.twitch4j.graphql.command.CommandFollowUser;
import com.github.twitch4j.graphql.command.CommandLockPrediction;
import com.github.twitch4j.graphql.command.CommandRejectFriendRequest;
import com.github.twitch4j.graphql.command.CommandResolvePrediction;
import com.github.twitch4j.graphql.command.CommandTerminatePoll;
import com.github.twitch4j.graphql.command.CommandUnfollowUser;
import com.github.twitch4j.graphql.command.CommandUpdateClip;
import com.github.twitch4j.graphql.command.CommandUpdateCommunityPointsGoal;
import com.github.twitch4j.graphql.command.CommandUpdateCustomRedemptionStatus;
import com.github.twitch4j.graphql.command.CommandUpdateCustomRedemptionStatuses;
import com.github.twitch4j.graphql.internal.type.CommunityPointsCustomRewardRedemptionStatus;
import com.github.twitch4j.graphql.internal.type.CreateCommunityPointsCommunityGoalInput;
import com.github.twitch4j.graphql.internal.type.CreatePollInput;
import com.github.twitch4j.graphql.internal.type.CreatePredictionEventInput;
import com.github.twitch4j.graphql.internal.type.UnbanRequestStatus;
import com.github.twitch4j.graphql.internal.type.UnbanRequestsSortOrder;
import com.github.twitch4j.graphql.internal.type.UpdateCommunityPointsCommunityGoalInput;
import java.util.List;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwitchGraphQL {
    private static final Logger log = LoggerFactory.getLogger(TwitchGraphQL.class);
    private final String baseUrl;
    private final String userAgent;
    private final EventManager eventManager;
    private final String clientId;
    private final OAuth2Credential defaultToken;
    private final ProxyConfig proxyConfig;
    private final boolean batchingEnabled;
    private final Integer timeout;
    private final Cache<String, ApolloClient> clientsByCredential;

    public TwitchGraphQL(String baseUrl, String userAgent, EventManager eventManager, String clientId, OAuth2Credential defaultToken, ProxyConfig proxyConfig, boolean batchingEnabled, Integer timeout) {
        this.baseUrl = baseUrl;
        this.userAgent = userAgent;
        this.eventManager = eventManager;
        this.clientId = clientId;
        this.defaultToken = defaultToken;
        this.proxyConfig = proxyConfig;
        this.batchingEnabled = batchingEnabled;
        this.timeout = timeout;
        this.clientsByCredential = Caffeine.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build();
    }

    private ApolloClient getApolloClient(OAuth2Credential credential) {
        if (credential == null) {
            credential = this.defaultToken;
        }
        String accessToken = credential != null && credential.getAccessToken() != null ? credential.getAccessToken() : "";
        return (ApolloClient)this.clientsByCredential.get((Object)accessToken, s -> {
            OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder().callTimeout((long)this.timeout.intValue(), TimeUnit.MILLISECONDS).connectTimeout((long)(this.timeout / 3), TimeUnit.MILLISECONDS).addInterceptor(chain -> {
                Request original = chain.request();
                Request.Builder requestBuilder = original.newBuilder().header("Accept", "*/*").header("Client-Id", this.clientId).header("User-Agent", this.userAgent).header("X-Device-Id", CommandComputeId.INSTANCE.getId());
                if (!accessToken.isEmpty()) {
                    requestBuilder.header("Authorization", "OAuth " + accessToken);
                }
                Request request = requestBuilder.build();
                return chain.proceed(request);
            });
            if (this.proxyConfig != null) {
                this.proxyConfig.apply(clientBuilder);
            }
            return ApolloClient.builder().serverUrl(this.baseUrl).okHttpClient(clientBuilder.build()).batchingConfiguration(new BatchConfig(this.batchingEnabled, 10L, 10)).build();
        });
    }

    public CommandFetchBanStatus fetchBanStatus(OAuth2Credential auth, String channelId, String userId) {
        return new CommandFetchBanStatus(this.getApolloClient(auth), channelId, userId);
    }

    @Deprecated
    public CommandAddChannelBlockedTerm addChannelBlockedTerm(OAuth2Credential auth, String channelId, Boolean isModEditable, List<String> phrases) {
        return new CommandAddChannelBlockedTerm(this.getApolloClient(auth), channelId, isModEditable, phrases);
    }

    @Deprecated
    public CommandDeleteChannelBlockedTerm deleteChannelBlockedTerm(OAuth2Credential auth, String channelId, List<String> phrases) {
        return new CommandDeleteChannelBlockedTerm(this.getApolloClient(auth), channelId, phrases);
    }

    public CommandAddChannelPermittedTerm addChannelPermittedTerm(OAuth2Credential auth, String channelId, List<String> phrases) {
        return new CommandAddChannelPermittedTerm(this.getApolloClient(auth), channelId, phrases);
    }

    public CommandDeleteChannelPermittedTerm deleteChannelPermittedTerm(OAuth2Credential auth, String channelId, List<String> phrases) {
        return new CommandDeleteChannelPermittedTerm(this.getApolloClient(auth), channelId, phrases);
    }

    public CommandFetchChatHistory fetchChatHistory(OAuth2Credential auth, String channelId, String userId, String after) {
        return new CommandFetchChatHistory(this.getApolloClient(auth), channelId, userId, after);
    }

    public CommandFetchChatters fetchChatters(OAuth2Credential auth, String channelLogin) {
        return new CommandFetchChatters(this.getApolloClient(auth), channelLogin);
    }

    public CommandCreateClip createClip(OAuth2Credential auth, String channelId, Double offsetSeconds, String broadcastId, String videoId) {
        return new CommandCreateClip(this.getApolloClient(auth), channelId, offsetSeconds, broadcastId, videoId);
    }

    public CommandDeleteClips deleteClips(OAuth2Credential auth, List<String> slugs) {
        return new CommandDeleteClips(this.getApolloClient(auth), slugs);
    }

    public CommandUpdateClip updateClip(OAuth2Credential auth, String slug, String newTitle) {
        return new CommandUpdateClip(this.getApolloClient(auth), slug, newTitle);
    }

    public CommandFetchCommunityPointsSettings fetchChannelPointRewards(OAuth2Credential auth, String channelLogin) {
        return new CommandFetchCommunityPointsSettings(this.getApolloClient(auth), channelLogin);
    }

    public CommandCreateCommunityPointsGoal createCommunityPointsGoal(OAuth2Credential auth, CreateCommunityPointsCommunityGoalInput input) {
        return new CommandCreateCommunityPointsGoal(this.getApolloClient(auth), input);
    }

    public CommandDeleteCommunityPointsGoal deleteCommunityPointsGoal(OAuth2Credential auth, String channelId, String goalId) {
        return new CommandDeleteCommunityPointsGoal(this.getApolloClient(auth), channelId, goalId);
    }

    public CommandUpdateCommunityPointsGoal updateCommunityPointsGoal(OAuth2Credential auth, UpdateCommunityPointsCommunityGoalInput input) {
        return new CommandUpdateCommunityPointsGoal(this.getApolloClient(auth), input);
    }

    public CommandUpdateCustomRedemptionStatus updateRedemptionStatus(OAuth2Credential auth, String channelId, String redemptionId, CommunityPointsCustomRewardRedemptionStatus newStatus) {
        return new CommandUpdateCustomRedemptionStatus(this.getApolloClient(auth), channelId, redemptionId, newStatus);
    }

    public CommandUpdateCustomRedemptionStatuses updateRedemptionStatuses(OAuth2Credential auth, String channelId, List<String> redemptionIds, CommunityPointsCustomRewardRedemptionStatus oldStatus, CommunityPointsCustomRewardRedemptionStatus newStatus) {
        return new CommandUpdateCustomRedemptionStatuses(this.getApolloClient(auth), channelId, redemptionIds, oldStatus, newStatus);
    }

    public CommandAcceptFriendRequest acceptFriendRequest(OAuth2Credential auth, String targetId) {
        return new CommandAcceptFriendRequest(this.getApolloClient(auth), targetId);
    }

    public CommandRejectFriendRequest rejectFriendRequest(OAuth2Credential auth, String targetId) {
        return new CommandRejectFriendRequest(this.getApolloClient(auth), targetId);
    }

    public CommandFetchLastBroadcast fetchLastBroadcast(OAuth2Credential auth, String userId, String userLogin) {
        return new CommandFetchLastBroadcast(this.getApolloClient(auth), userId, userLogin);
    }

    public CommandCreateModComment createModComment(OAuth2Credential auth, String channelId, String targetId, String text) {
        return new CommandCreateModComment(this.getApolloClient(auth), channelId, targetId, text);
    }

    public CommandFetchModComments fetchModComments(OAuth2Credential auth, String channelId, String targetId, String after) {
        return new CommandFetchModComments(this.getApolloClient(auth), channelId, targetId, after);
    }

    public CommandArchivePoll archivePoll(OAuth2Credential auth, String pollId) {
        return new CommandArchivePoll(this.getApolloClient(auth), pollId);
    }

    public CommandCreatePoll createPoll(OAuth2Credential auth, CreatePollInput input) {
        return new CommandCreatePoll(this.getApolloClient(auth), input);
    }

    public CommandFetchPoll fetchPoll(OAuth2Credential auth, String pollId) {
        return new CommandFetchPoll(this.getApolloClient(auth), pollId);
    }

    public CommandTerminatePoll terminatePoll(OAuth2Credential auth, String pollId) {
        return new CommandTerminatePoll(this.getApolloClient(auth), pollId);
    }

    public CommandCancelPrediction cancelPrediction(OAuth2Credential auth, String predictionEventId) {
        return new CommandCancelPrediction(this.getApolloClient(auth), predictionEventId);
    }

    public CommandCreatePrediction createPrediction(OAuth2Credential auth, CreatePredictionEventInput input) {
        return new CommandCreatePrediction(this.getApolloClient(auth), input);
    }

    public CommandFetchActivePredictions fetchActivePredictions(OAuth2Credential auth, String channelId) {
        return new CommandFetchActivePredictions(this.getApolloClient(auth), channelId);
    }

    public CommandFetchLockedPredictions fetchLockedPredictions(OAuth2Credential auth, String channelId) {
        return new CommandFetchLockedPredictions(this.getApolloClient(auth), channelId);
    }

    public CommandFetchPrediction fetchPrediction(OAuth2Credential auth, String predictionEventId) {
        return new CommandFetchPrediction(this.getApolloClient(auth), predictionEventId);
    }

    public CommandLockPrediction lockPrediction(OAuth2Credential auth, String predictionEventId) {
        return new CommandLockPrediction(this.getApolloClient(auth), predictionEventId);
    }

    public CommandResolvePrediction resolvePrediction(OAuth2Credential auth, String predictionEventId, String outcomeId) {
        return new CommandResolvePrediction(this.getApolloClient(auth), predictionEventId, outcomeId);
    }

    public CommandFetchSquadStream fetchSquadStream(OAuth2Credential auth, String id) {
        return new CommandFetchSquadStream(this.getApolloClient(auth), id);
    }

    public CommandApproveUnbanRequest approveUnbanRequest(OAuth2Credential auth, String id, String message) {
        return new CommandApproveUnbanRequest(this.getApolloClient(auth), id, message);
    }

    public CommandBulkApproveUnbanRequest bulkApproveUnbanRequest(OAuth2Credential auth, List<String> ids) {
        return new CommandBulkApproveUnbanRequest(this.getApolloClient(auth), ids);
    }

    public CommandBulkDenyUnbanRequest bulkDenyUnbanRequest(OAuth2Credential auth, List<String> ids) {
        return new CommandBulkDenyUnbanRequest(this.getApolloClient(auth), ids);
    }

    public CommandDenyUnbanRequest denyUnbanRequest(OAuth2Credential auth, String id, String message) {
        return new CommandDenyUnbanRequest(this.getApolloClient(auth), id, message);
    }

    public CommandFetchUnbanRequests fetchUnbanRequests(OAuth2Credential auth, String channelLogin, String cursor, Integer limit, UnbanRequestsSortOrder order, UnbanRequestStatus status, String userId) {
        return new CommandFetchUnbanRequests(this.getApolloClient(auth), channelLogin, cursor, limit, order, status, userId);
    }

    @Deprecated
    public CommandBanUser banUser(OAuth2Credential auth, String channelId, String targetUserLogin, String reason) {
        return new CommandBanUser(this.getApolloClient(auth), channelId, targetUserLogin, reason);
    }

    public CommandFetchUser fetchUser(OAuth2Credential auth, String userId, String userLogin) {
        return new CommandFetchUser(this.getApolloClient(auth), userId, userLogin);
    }

    public CommandFetchUserEmoteSets fetchUserEmoteSets(OAuth2Credential auth, String userId) {
        return new CommandFetchUserEmoteSets(this.getApolloClient(auth), userId);
    }

    public CommandFetchUserSubscriptions fetchUserSubscriptions(OAuth2Credential auth, String userId, Integer first, String after) {
        return new CommandFetchUserSubscriptions(this.getApolloClient(auth), userId, first, after);
    }

    public CommandFetchVideoComments fetchVideoComments(OAuth2Credential auth, String channelId, String videoId, String id, String after, String before, Integer first, Integer last) {
        return new CommandFetchVideoComments(this.getApolloClient(auth), channelId, videoId, id, after, before, first, last);
    }

    public CommandFollowUser followUser(OAuth2Credential auth, Long targetUserId, Boolean goLiveNotification) {
        return new CommandFollowUser(this.getApolloClient(auth), targetUserId, goLiveNotification);
    }

    public CommandUnfollowUser unfollowUser(OAuth2Credential auth, Long targetUserId) {
        return new CommandUnfollowUser(this.getApolloClient(auth), targetUserId);
    }
}

