/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.eventsub.socket;

import com.github.philippheuer.credentialmanager.domain.OAuth2Credential;
import com.github.twitch4j.common.config.ProxyConfig;
import com.github.twitch4j.common.pool.TwitchModuleConnectionPool;
import com.github.twitch4j.eventsub.EventSubSubscription;
import com.github.twitch4j.eventsub.socket.IEventSubSocket;
import com.github.twitch4j.eventsub.socket.SubscriptionWrapper;
import com.github.twitch4j.eventsub.socket.TwitchEventSocket;
import com.github.twitch4j.helix.TwitchHelix;
import com.github.twitch4j.helix.TwitchHelixBuilder;
import io.github.xanthic.cache.api.Cache;
import io.github.xanthic.cache.api.domain.ExpiryType;
import io.github.xanthic.cache.core.CacheApi;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.RandomStringUtils;
import org.jetbrains.annotations.Nullable;

public final class TwitchSingleUserEventSocketPool
extends TwitchModuleConnectionPool<TwitchEventSocket, EventSubSubscription, EventSubSubscription, Boolean, TwitchEventSocket.TwitchEventSocketBuilder>
implements IEventSubSocket {
    @Generated
    private final Object $lock = new Object[0];
    private final String threadPrefix = "twitch4j-unitary-pool-" + RandomStringUtils.random((int)4, (boolean)true, (boolean)true) + "-eventsub-ws-";
    private String baseUrl;
    @Nullable
    private TwitchHelix helix;
    @Nullable
    private OAuth2Credential defaultToken;
    private final Cache<SubscriptionWrapper, OAuth2Credential> credentials = CacheApi.create(spec -> {
        spec.maxSize(Long.valueOf((long)Runtime.getRuntime().availableProcessors() * 4L));
        spec.expiryType(ExpiryType.POST_WRITE);
        spec.expiryTime(Duration.ofMinutes(5L));
    });

    protected TwitchEventSocket createConnection() {
        if (this.closed.get()) {
            throw new IllegalStateException("EventSocket cannot be created after pool was closed!");
        }
        return ((TwitchEventSocket.TwitchEventSocketBuilder)this.advancedConfiguration.apply(TwitchEventSocket.builder().api(this.helix).baseUrl(this.baseUrl).defaultToken(this.defaultToken).eventManager(this.getConnectionEventManager()).proxyConfig((ProxyConfig)this.proxyConfig.get()).taskExecutor(this.getExecutor(this.threadPrefix + RandomStringUtils.random((int)4, (boolean)true, (boolean)true), 1)))).build();
    }

    protected void disposeConnection(TwitchEventSocket connection) {
        connection.close();
    }

    protected EventSubSubscription handleSubscription(TwitchEventSocket twitchEventSocket, EventSubSubscription eventSubSubscription) {
        SubscriptionWrapper wrapped = SubscriptionWrapper.wrap(eventSubSubscription);
        OAuth2Credential cred = (OAuth2Credential)this.credentials.remove((Object)wrapped);
        boolean success = twitchEventSocket.register(cred != null ? cred : this.defaultToken, wrapped);
        if (success) {
            return twitchEventSocket.getSubscriptions().stream().filter(sub -> sub.equals((Object)wrapped)).findAny().orElse(wrapped);
        }
        return null;
    }

    protected EventSubSubscription handleDuplicateSubscription(TwitchEventSocket twitchEventSocket, TwitchEventSocket old, EventSubSubscription eventSubSubscription) {
        return twitchEventSocket != null && twitchEventSocket != old && twitchEventSocket.unregister(eventSubSubscription) ? eventSubSubscription : null;
    }

    protected Boolean handleUnsubscription(TwitchEventSocket twitchEventSocket, EventSubSubscription eventSubSubscription) {
        return twitchEventSocket != null && twitchEventSocket.unregister(eventSubSubscription);
    }

    protected EventSubSubscription getRequestFromSubscription(EventSubSubscription eventSubSubscription) {
        return eventSubSubscription;
    }

    protected int getSubscriptionSize(EventSubSubscription eventSubSubscription) {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect() {
        Object object = this.$lock;
        synchronized (object) {
            if (this.saturatedConnections.isEmpty() && this.unsaturatedConnections.isEmpty()) {
                this.unsaturatedConnections.put(this.createConnection(), 0);
            }
        }
    }

    @Override
    public void disconnect() {
        this.getConnections().forEach(TwitchEventSocket::disconnect);
    }

    @Override
    public void reconnect() {
        this.getConnections().forEach(TwitchEventSocket::reconnect);
    }

    @Override
    public Collection<EventSubSubscription> getSubscriptions() {
        return Collections.unmodifiableSet(this.subscriptions.keySet());
    }

    @Override
    public boolean register(OAuth2Credential token, EventSubSubscription sub) {
        SubscriptionWrapper wrapped = SubscriptionWrapper.wrap(sub);
        this.credentials.put((Object)wrapped, (Object)(token != null ? token : Objects.requireNonNull(this.defaultToken)));
        return this.subscribe((Object)wrapped) != null;
    }

    @Override
    public boolean unregister(EventSubSubscription sub) {
        return (Boolean)this.unsubscribe((Object)SubscriptionWrapper.wrap(sub));
    }

    @Override
    public long getLatency() {
        long sum = 0L;
        int count = 0;
        for (TwitchEventSocket ws : this.getConnections()) {
            long latency = ws.getLatency();
            if (latency < 0L) continue;
            sum += latency;
            ++count;
        }
        return count > 0 ? sum / (long)count : -1L;
    }

    @Generated
    private static String $default$baseUrl() {
        return "wss://eventsub.wss.twitch.tv/ws";
    }

    @Generated
    private static TwitchHelix $default$helix() {
        return TwitchHelixBuilder.builder().build();
    }

    @Generated
    protected TwitchSingleUserEventSocketPool(TwitchSingleUserEventSocketPoolBuilder<?, ?> b) {
        super(b);
        this.baseUrl = ((TwitchSingleUserEventSocketPoolBuilder)b).baseUrl$set ? ((TwitchSingleUserEventSocketPoolBuilder)b).baseUrl$value : TwitchSingleUserEventSocketPool.$default$baseUrl();
        this.helix = ((TwitchSingleUserEventSocketPoolBuilder)b).helix$set ? ((TwitchSingleUserEventSocketPoolBuilder)b).helix$value : TwitchSingleUserEventSocketPool.$default$helix();
        this.defaultToken = ((TwitchSingleUserEventSocketPoolBuilder)b).defaultToken;
    }

    @Generated
    public static TwitchSingleUserEventSocketPoolBuilder<?, ?> builder() {
        return new TwitchSingleUserEventSocketPoolBuilderImpl();
    }

    @Override
    @Nullable
    @Generated
    public OAuth2Credential getDefaultToken() {
        return this.defaultToken;
    }

    @Generated
    public static abstract class TwitchSingleUserEventSocketPoolBuilder<C extends TwitchSingleUserEventSocketPool, B extends TwitchSingleUserEventSocketPoolBuilder<C, B>>
    extends TwitchModuleConnectionPool.TwitchModuleConnectionPoolBuilder<TwitchEventSocket, EventSubSubscription, EventSubSubscription, Boolean, TwitchEventSocket.TwitchEventSocketBuilder, C, B> {
        @Generated
        private boolean baseUrl$set;
        @Generated
        private String baseUrl$value;
        @Generated
        private boolean helix$set;
        @Generated
        private TwitchHelix helix$value;
        @Generated
        private OAuth2Credential defaultToken;

        @Generated
        public B baseUrl(String baseUrl) {
            this.baseUrl$value = baseUrl;
            this.baseUrl$set = true;
            return (B)this.self();
        }

        @Generated
        public B helix(@Nullable TwitchHelix helix) {
            this.helix$value = helix;
            this.helix$set = true;
            return (B)this.self();
        }

        @Generated
        public B defaultToken(@Nullable OAuth2Credential defaultToken) {
            this.defaultToken = defaultToken;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "TwitchSingleUserEventSocketPool.TwitchSingleUserEventSocketPoolBuilder(super=" + super.toString() + ", baseUrl$value=" + this.baseUrl$value + ", helix$value=" + this.helix$value + ", defaultToken=" + this.defaultToken + ")";
        }
    }

    @Generated
    private static final class TwitchSingleUserEventSocketPoolBuilderImpl
    extends TwitchSingleUserEventSocketPoolBuilder<TwitchSingleUserEventSocketPool, TwitchSingleUserEventSocketPoolBuilderImpl> {
        @Generated
        private TwitchSingleUserEventSocketPoolBuilderImpl() {
        }

        @Override
        @Generated
        protected TwitchSingleUserEventSocketPoolBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public TwitchSingleUserEventSocketPool build() {
            return new TwitchSingleUserEventSocketPool(this);
        }
    }
}

