/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.common.util;

import com.github.philippheuer.events4j.api.service.IEventHandler;
import com.github.philippheuer.events4j.core.EventManager;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventManagerUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EventManagerUtils.class);

    public static EventManager validateOrInitializeEventManager(@Nullable EventManager eventManager, @NotNull Class<?> defaultEventHandler) {
        EventManager em = eventManager != null ? eventManager : EventManagerUtils.initializeEventManager(defaultEventHandler);
        EventManagerUtils.validateEventManager(em);
        return em;
    }

    public static EventManager initializeEventManager(@NotNull Class<?> defaultEventHandler) {
        EventManager eventManager = new EventManager();
        try {
            eventManager.registerEventHandler((IEventHandler)defaultEventHandler.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            eventManager.setDefaultEventHandler(defaultEventHandler);
        }
        catch (Exception e) {
            log.warn("Failed to register the requested default event handler: " + defaultEventHandler, (Throwable)e);
        }
        if (eventManager.getDefaultEventHandler() == null) {
            eventManager.autoDiscovery();
            if (!eventManager.getEventHandlers().isEmpty()) {
                Class<?> clazz = ((IEventHandler)eventManager.getEventHandlers().get(0)).getClass();
                eventManager.setDefaultEventHandler(clazz);
                log.info("Registered fallback default event handler: {}", (Object)clazz.getTypeName());
            }
        }
        return eventManager;
    }

    public static void validateEventManager(@NotNull EventManager eventManager) {
        if (eventManager.getEventHandlers().size() == 0) {
            throw new RuntimeException("Fatal: No EventHandlers have been registered in the EventManager, please run the autodiscovery to add EventHandlers that are present in your classpath. -> eventHandler.autoDiscovery();");
        }
        if (eventManager.getDefaultEventHandler() == null) {
            throw new RuntimeException("Fatal: Twitch4J will not be functional unless you set a defaultEventHandler that can be used for internal events (eventManager.setDefaultEventHandler)!");
        }
    }
}

