/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.chat.util;

import com.github.twitch4j.common.enums.TwitchLimitType;
import io.github.bucket4j.Bandwidth;
import io.github.bucket4j.Bucket;
import io.github.bucket4j.local.LocalBucketBuilder;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class TwitchChatLimitHelper {
    public static final String MESSAGE_BANDWIDTH_ID = TwitchLimitType.CHAT_MESSAGE_LIMIT.getBandwidthId();
    public static final String JOIN_BANDWIDTH_ID = TwitchLimitType.CHAT_JOIN_LIMIT.getBandwidthId();
    public static final String AUTH_BANDWIDTH_ID = TwitchLimitType.CHAT_AUTH_LIMIT.getBandwidthId();
    public static final String WHISPER_MINUTE_BANDWIDTH_ID = TwitchLimitType.CHAT_WHISPER_LIMIT.getBandwidthId() + "-minute";
    public static final String WHISPER_SECOND_BANDWIDTH_ID = TwitchLimitType.CHAT_WHISPER_LIMIT.getBandwidthId() + "-second";
    public static final Bandwidth USER_MESSAGE_LIMIT = Bandwidth.simple((long)20L, (Duration)Duration.ofSeconds(30L)).withId(MESSAGE_BANDWIDTH_ID);
    public static final Bandwidth MOD_MESSAGE_LIMIT = Bandwidth.simple((long)100L, (Duration)Duration.ofSeconds(30L)).withId(MESSAGE_BANDWIDTH_ID);
    public static final Bandwidth KNOWN_MESSAGE_LIMIT = Bandwidth.simple((long)50L, (Duration)Duration.ofSeconds(30L)).withId(MESSAGE_BANDWIDTH_ID);
    public static final Bandwidth VERIFIED_MESSAGE_LIMIT = Bandwidth.simple((long)7500L, (Duration)Duration.ofSeconds(30L)).withId(MESSAGE_BANDWIDTH_ID);
    public static final List<Bandwidth> USER_WHISPER_LIMIT = Collections.unmodifiableList(Arrays.asList(Bandwidth.simple((long)100L, (Duration)Duration.ofSeconds(60L)).withId(WHISPER_MINUTE_BANDWIDTH_ID), Bandwidth.simple((long)3L, (Duration)Duration.ofSeconds(1L)).withId(WHISPER_SECOND_BANDWIDTH_ID)));
    public static final List<Bandwidth> KNOWN_WHISPER_LIMIT = Collections.unmodifiableList(Arrays.asList(Bandwidth.simple((long)200L, (Duration)Duration.ofSeconds(60L)).withId(WHISPER_MINUTE_BANDWIDTH_ID), Bandwidth.simple((long)10L, (Duration)Duration.ofSeconds(1L)).withId(WHISPER_SECOND_BANDWIDTH_ID)));
    public static final List<Bandwidth> VERIFIED_WHISPER_LIMIT = Collections.unmodifiableList(Arrays.asList(Bandwidth.simple((long)1200L, (Duration)Duration.ofSeconds(60L)).withId(WHISPER_MINUTE_BANDWIDTH_ID), Bandwidth.simple((long)20L, (Duration)Duration.ofSeconds(1L)).withId(WHISPER_SECOND_BANDWIDTH_ID)));
    public static final Bandwidth USER_JOIN_LIMIT = Bandwidth.simple((long)20L, (Duration)Duration.ofSeconds(10L)).withId(JOIN_BANDWIDTH_ID);
    public static final Bandwidth VERIFIED_JOIN_LIMIT = Bandwidth.simple((long)2000L, (Duration)Duration.ofSeconds(10L)).withId(JOIN_BANDWIDTH_ID);
    public static final Bandwidth USER_AUTH_LIMIT = Bandwidth.simple((long)20L, (Duration)Duration.ofSeconds(10L)).withId(AUTH_BANDWIDTH_ID);
    public static final Bandwidth VERIFIED_AUTH_LIMIT = Bandwidth.simple((long)200L, (Duration)Duration.ofSeconds(10L)).withId(AUTH_BANDWIDTH_ID);

    public static Bucket createBucket(Bandwidth limit) {
        return Bucket.builder().addLimit(limit).build();
    }

    public static Bucket createBucket(Bandwidth ... limits) {
        LocalBucketBuilder builder = Bucket.builder();
        for (Bandwidth limit : limits) {
            builder.addLimit(limit);
        }
        return builder.build();
    }

    public static Bucket createBucket(Iterable<Bandwidth> limits) {
        LocalBucketBuilder builder = Bucket.builder();
        for (Bandwidth limit : limits) {
            builder.addLimit(limit);
        }
        return builder.build();
    }

    private TwitchChatLimitHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

