/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.chat.events.channel;

import com.github.twitch4j.chat.events.AbstractChannelEvent;
import com.github.twitch4j.chat.events.channel.IRCMessageEvent;
import com.github.twitch4j.chat.flag.AutoModFlag;
import com.github.twitch4j.common.enums.CommandPermission;
import com.github.twitch4j.common.events.domain.EventChannel;
import com.github.twitch4j.common.events.domain.EventUser;
import java.util.List;
import java.util.Set;

public final class ChannelMessageActionEvent
extends AbstractChannelEvent {
    private final IRCMessageEvent messageEvent;
    private final EventUser user;
    private final String message;
    private final Set<CommandPermission> permissions;
    private final int subscriberMonths;
    private final int subscriptionTier;

    public ChannelMessageActionEvent(EventChannel channel, IRCMessageEvent messageEvent, EventUser user, String message, Set<CommandPermission> permissions) {
        super(channel);
        this.messageEvent = messageEvent;
        this.user = user;
        this.message = message;
        this.permissions = permissions;
        this.subscriberMonths = messageEvent.getSubscriberMonths().orElse(0);
        this.subscriptionTier = messageEvent.getSubscriptionTier().orElse(0);
    }

    public List<AutoModFlag> getFlags() {
        return this.messageEvent.getFlags();
    }

    @Override
    public String toString() {
        return "ChannelMessageActionEvent(messageEvent=" + (Object)((Object)this.getMessageEvent()) + ", user=" + this.getUser() + ", message=" + this.getMessage() + ", permissions=" + this.getPermissions() + ", subscriberMonths=" + this.getSubscriberMonths() + ", subscriptionTier=" + this.getSubscriptionTier() + ")";
    }

    public IRCMessageEvent getMessageEvent() {
        return this.messageEvent;
    }

    public EventUser getUser() {
        return this.user;
    }

    public String getMessage() {
        return this.message;
    }

    public Set<CommandPermission> getPermissions() {
        return this.permissions;
    }

    public int getSubscriberMonths() {
        return this.subscriberMonths;
    }

    public int getSubscriptionTier() {
        return this.subscriptionTier;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChannelMessageActionEvent)) {
            return false;
        }
        ChannelMessageActionEvent other = (ChannelMessageActionEvent)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getSubscriberMonths() != other.getSubscriberMonths()) {
            return false;
        }
        if (this.getSubscriptionTier() != other.getSubscriptionTier()) {
            return false;
        }
        IRCMessageEvent this$messageEvent = this.getMessageEvent();
        IRCMessageEvent other$messageEvent = other.getMessageEvent();
        if (this$messageEvent == null ? other$messageEvent != null : !((Object)((Object)this$messageEvent)).equals((Object)other$messageEvent)) {
            return false;
        }
        EventUser this$user = this.getUser();
        EventUser other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        Set<CommandPermission> this$permissions = this.getPermissions();
        Set<CommandPermission> other$permissions = other.getPermissions();
        return !(this$permissions == null ? other$permissions != null : !((Object)this$permissions).equals(other$permissions));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ChannelMessageActionEvent;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSubscriberMonths();
        result = result * 59 + this.getSubscriptionTier();
        IRCMessageEvent $messageEvent = this.getMessageEvent();
        result = result * 59 + ($messageEvent == null ? 43 : ((Object)((Object)$messageEvent)).hashCode());
        EventUser $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        Set<CommandPermission> $permissions = this.getPermissions();
        result = result * 59 + ($permissions == null ? 43 : ((Object)$permissions).hashCode());
        return result;
    }
}

