/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.chat.util;

import com.github.twitch4j.chat.events.channel.IRCMessageEvent;
import java.nio.CharBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public final class MessageParser {
    @Nullable
    @VisibleForTesting
    public static IRCMessageEvent parse(@NotNull String rawMessage) {
        return MessageParser.parse(rawMessage, new ConcurrentHashMap<String, String>(0), new ConcurrentHashMap<String, String>(0), null);
    }

    @Nullable
    @ApiStatus.Internal
    public static IRCMessageEvent parse(@NotNull String raw, @NotNull Map<String, String> channelIdToChannelName, @NotNull Map<String, String> channelNameToChannelId, @Nullable Collection<String> botOwnerIds) {
        CharBuffer channel;
        int chanDelim;
        Map<String, CharSequence> tags;
        int len = raw.length();
        if (len == 0) {
            return null;
        }
        char[] chars = raw.toCharArray();
        int i = 0;
        if (chars[0] == '@') {
            tags = new HashMap(32);
            i = MessageParser.parseTags(chars, tags);
        } else {
            tags = Collections.emptyMap();
        }
        if (chars[i] == ':') {
            ++i;
        }
        int exclamation = -1;
        int space = -1;
        for (int j = i; j < len; ++j) {
            char c = chars[j];
            if (c == '!') {
                if (exclamation >= 0) continue;
                exclamation = j;
                continue;
            }
            if (c != ' ') continue;
            space = j;
            break;
        }
        if (space < 0 || space + 1 >= len) {
            return null;
        }
        int clientNameEnd = exclamation > 0 ? exclamation : space;
        CharBuffer clientName = CharBuffer.wrap(chars, i, clientNameEnd - i);
        i = space + 1;
        int commandEnd = ArrayUtils.indexOf((char[])chars, (char)' ', (int)i);
        if (commandEnd < 0) {
            commandEnd = len;
        }
        String commandType = raw.substring(i, commandEnd);
        i = commandEnd + 1;
        if (i >= len) {
            return new IRCMessageEvent(raw, tags, clientName, commandType, null, null, null, channelIdToChannelName, channelNameToChannelId, botOwnerIds);
        }
        int messageStart = raw.indexOf(" :", i);
        if (messageStart < 0) {
            messageStart = len;
        }
        CharBuffer channelPart = (chanDelim = StringUtils.indexOf((CharSequence)(channel = CharBuffer.wrap(chars, i, messageStart - i)), (CharSequence)" = ")) < 0 ? channel : channel.subSequence(chanDelim + " = ".length(), channel.length());
        String channelName = (channelPart.length() > 0 && channelPart.charAt(0) == '#' ? channelPart.subSequence(1, channelPart.length()) : channelPart).toString();
        if (++messageStart >= len) {
            return new IRCMessageEvent(raw, tags, clientName, commandType, channelName, null, null, channelIdToChannelName, channelNameToChannelId, botOwnerIds);
        }
        CharBuffer payload = CharBuffer.wrap(chars, messageStart, len - messageStart);
        String message = raw.substring(messageStart + 1);
        return new IRCMessageEvent(raw, tags, clientName, commandType, channelName, payload, message, channelIdToChannelName, channelNameToChannelId, botOwnerIds);
    }

    @VisibleForTesting
    public static int parseTags(char[] inputChars, Map<String, CharSequence> output) {
        int len = inputChars.length;
        int i = 0;
        int delim = -1;
        for (int j = i + 1; j < len; ++j) {
            boolean boundary;
            char c = inputChars[j];
            boolean bl = boundary = c == ';';
            if (boundary || c == ' ') {
                int tagStart = i + 1;
                CharBuffer tag = CharBuffer.wrap(inputChars, tagStart, j - tagStart);
                MessageParser.parseTag(output, tag, delim - tagStart);
                i = j;
                delim = -1;
                if (boundary) continue;
                break;
            }
            if (c != '=' || delim >= 0) continue;
            delim = j;
        }
        return ++i;
    }

    private static void parseTag(Map<String, CharSequence> tags, CharSequence tag, int delim) {
        CharSequence value;
        CharSequence key;
        if (delim < 0) {
            key = tag;
            value = null;
        } else {
            key = tag.subSequence(0, delim);
            value = tag.subSequence(delim + 1, tag.length());
        }
        tags.put(key.toString(), value);
    }

    @ApiStatus.Internal
    public static void consumeLines(@NotNull String source, @NotNull Consumer<String> consumer) {
        int i;
        int len = source.length();
        int start = 0;
        while ((i = source.indexOf(10, start)) >= 0) {
            boolean carriage = i > 0 && source.charAt(i - 1) == '\r';
            consumer.accept(source.substring(start, carriage ? i - 1 : i));
            start = i + 1;
        }
        if (start < len) {
            consumer.accept(source.substring(start));
        }
    }

    @Generated
    private MessageParser() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

