/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.chat;

import com.github.philippheuer.credentialmanager.domain.OAuth2Credential;
import com.github.twitch4j.chat.ITwitchChat;
import com.github.twitch4j.chat.TwitchChat;
import com.github.twitch4j.chat.TwitchChatBuilder;
import com.github.twitch4j.chat.enums.NoticeTag;
import com.github.twitch4j.chat.events.channel.ChannelJoinFailureEvent;
import com.github.twitch4j.chat.events.channel.ChannelNoticeEvent;
import com.github.twitch4j.chat.util.TwitchChatLimitHelper;
import com.github.twitch4j.common.config.ProxyConfig;
import com.github.twitch4j.common.pool.TwitchModuleConnectionPool;
import com.github.twitch4j.util.IBackoffStrategy;
import io.github.bucket4j.Bandwidth;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.NonNull;
import org.apache.commons.lang3.RandomStringUtils;
import org.jetbrains.annotations.Nullable;

public class TwitchChatConnectionPool
extends TwitchModuleConnectionPool<TwitchChat, String, String, Boolean, TwitchChatBuilder>
implements ITwitchChat {
    private final String threadPrefix = "twitch4j-pool-" + RandomStringUtils.random((int)4, (boolean)true, (boolean)true) + "-chat-";
    @NonNull
    protected final Supplier<OAuth2Credential> chatAccount;
    @Deprecated
    protected final boolean automaticallyPartOnBan;
    protected Bandwidth chatRateLimit;
    protected Bandwidth[] whisperRateLimit;
    protected Bandwidth joinRateLimit;
    protected Bandwidth authRateLimit;
    protected Bandwidth perChannelRateLimit;
    private IBackoffStrategy connectionBackoffStrategy;

    @Override
    public boolean sendMessage(String channel, String message, @Nullable Map<String, Object> tags) {
        return this.sendMessage(channel, channel, message, tags);
    }

    public boolean sendMessage(String channelToIdentifyChatInstance, String targetChannel, String message) {
        return this.sendMessage(channelToIdentifyChatInstance, targetChannel, message, Collections.emptyMap());
    }

    public boolean sendMessage(String channelToIdentifyChatInstance, String targetChannel, String message, String nonce, String replyMsgId) {
        LinkedHashMap<String, Object> tags = new LinkedHashMap<String, Object>();
        if (nonce != null) {
            tags.put("client-nonce", nonce);
        }
        if (replyMsgId != null) {
            tags.put("reply-parent-msg-id", replyMsgId);
        }
        return this.sendMessage(channelToIdentifyChatInstance, targetChannel, message, tags);
    }

    public boolean sendMessage(String channelToIdentifyChatInstance, String targetChannel, String message, @Nullable Map<String, Object> tags) {
        if (channelToIdentifyChatInstance == null) {
            return false;
        }
        TwitchChat chat = (TwitchChat)this.subscriptions.get(channelToIdentifyChatInstance.toLowerCase());
        if (chat == null) {
            return false;
        }
        if (targetChannel != null) {
            chat.sendMessage(targetChannel, message, tags);
        } else {
            chat.sendRaw(message);
        }
        return true;
    }

    @Deprecated
    public boolean sendPrivateMessage(String channelToIdentifyChatInstance, String toChannel, String message) {
        TwitchChat chat;
        if (channelToIdentifyChatInstance == null || (chat = (TwitchChat)this.subscriptions.get(channelToIdentifyChatInstance.toLowerCase())) == null) {
            return false;
        }
        chat.sendPrivateMessage(toChannel, message);
        return true;
    }

    public String subscribe(String s) {
        return s != null ? (String)super.subscribe((Object)s.toLowerCase()) : null;
    }

    @Override
    public void joinChannel(String channelName) {
        this.subscribe(channelName);
    }

    public Boolean unsubscribe(String s) {
        return (Boolean)super.unsubscribe((Object)(s != null ? s.toLowerCase() : null));
    }

    @Override
    public boolean leaveChannel(String channelName) {
        Boolean b = this.unsubscribe(channelName);
        return b != null && b != false;
    }

    @Override
    public boolean isChannelJoined(String channelName) {
        return this.subscriptions.containsKey(channelName.toLowerCase());
    }

    @Override
    public Set<String> getChannels() {
        return Collections.unmodifiableSet(this.subscriptions.keySet());
    }

    protected String handleSubscription(TwitchChat twitchChat, String s) {
        if (twitchChat == null) {
            return null;
        }
        twitchChat.joinChannel(s);
        return s;
    }

    protected String handleDuplicateSubscription(TwitchChat twitchChat, TwitchChat old, String s) {
        return twitchChat != null && twitchChat != old && twitchChat.leaveChannel(s) ? s : null;
    }

    protected Boolean handleUnsubscription(TwitchChat twitchChat, String s) {
        return twitchChat != null ? Boolean.valueOf(twitchChat.leaveChannel(s)) : null;
    }

    protected String getRequestFromSubscription(String s) {
        return s;
    }

    protected int getSubscriptionSize(String s) {
        return 1;
    }

    protected TwitchChat createConnection() {
        if (this.closed.get()) {
            throw new IllegalStateException("Chat socket cannot be created after pool was closed!");
        }
        TwitchChat chat = ((TwitchChatBuilder)this.advancedConfiguration.apply(TwitchChatBuilder.builder().withChatAccount(this.chatAccount.get()).withEventManager(this.getConnectionEventManager()).withScheduledThreadPoolExecutor(this.getExecutor(this.threadPrefix + RandomStringUtils.random((int)4, (boolean)true, (boolean)true), 2)).withProxyConfig((ProxyConfig)this.proxyConfig.get()).withChatRateLimit(this.chatRateLimit).withWhisperRateLimit(this.whisperRateLimit).withJoinRateLimit(this.joinRateLimit).withAuthRateLimit(this.authRateLimit).withPerChannelRateLimit(this.perChannelRateLimit).withAutoJoinOwnChannel(false).withConnectionBackoffStrategy(this.connectionBackoffStrategy))).build();
        chat.getEventManager().onEvent(this.threadPrefix + "join-fail-tracker", ChannelJoinFailureEvent.class, e -> this.unsubscribe(e.getChannelName()));
        chat.getEventManager().onEvent(this.threadPrefix + "ban-tracker", ChannelNoticeEvent.class, e -> {
            if (this.automaticallyPartOnBan && NoticeTag.MSG_BANNED.toString().equals(e.getMsgId())) {
                this.unsubscribe(e.getChannel().getName());
            }
        });
        return chat;
    }

    protected void disposeConnection(TwitchChat connection) {
        connection.close();
    }

    @Override
    public long getLatency() {
        long sum = 0L;
        int count = 0;
        for (TwitchChat connection : this.getConnections()) {
            long latency = connection.getLatency();
            if (latency <= 0L) continue;
            sum += latency;
            ++count;
        }
        return count > 0 ? sum / (long)count : -1L;
    }

    @Override
    public Map<String, String> getChannelIdToChannelName() {
        return this.collectMapsFromConnections(TwitchChat::getChannelIdToChannelName);
    }

    @Override
    public Map<String, String> getChannelNameToChannelId() {
        return this.collectMapsFromConnections(TwitchChat::getChannelNameToChannelId);
    }

    private <K, V> Map<K, V> collectMapsFromConnections(Function<TwitchChat, Map<K, V>> mapRetriever) {
        HashMap aggregated = new HashMap(this.numConnections() * this.maxSubscriptionsPerConnection);
        Consumer<TwitchChat> retrieve = chat -> aggregated.putAll((Map)mapRetriever.apply((TwitchChat)chat));
        this.saturatedConnections.forEach(retrieve);
        this.unsaturatedConnections.keySet().forEach(retrieve);
        return Collections.unmodifiableMap(aggregated);
    }

    private static Supplier<OAuth2Credential> $default$chatAccount() {
        return () -> null;
    }

    private static boolean $default$automaticallyPartOnBan() {
        return false;
    }

    private static Bandwidth $default$chatRateLimit() {
        return TwitchChatLimitHelper.USER_MESSAGE_LIMIT;
    }

    private static Bandwidth[] $default$whisperRateLimit() {
        return TwitchChatLimitHelper.USER_WHISPER_LIMIT.toArray(new Bandwidth[2]);
    }

    private static Bandwidth $default$joinRateLimit() {
        return TwitchChatLimitHelper.USER_JOIN_LIMIT;
    }

    private static Bandwidth $default$authRateLimit() {
        return TwitchChatLimitHelper.USER_AUTH_LIMIT;
    }

    private static Bandwidth $default$perChannelRateLimit() {
        return TwitchChatLimitHelper.MOD_MESSAGE_LIMIT.withId("per-channel-limit");
    }

    private static IBackoffStrategy $default$connectionBackoffStrategy() {
        return null;
    }

    protected TwitchChatConnectionPool(TwitchChatConnectionPoolBuilder<?, ?> b) {
        super(b);
        this.chatAccount = ((TwitchChatConnectionPoolBuilder)b).chatAccount$set ? ((TwitchChatConnectionPoolBuilder)b).chatAccount$value : TwitchChatConnectionPool.$default$chatAccount();
        if (this.chatAccount == null) {
            throw new NullPointerException("chatAccount is marked non-null but is null");
        }
        this.automaticallyPartOnBan = ((TwitchChatConnectionPoolBuilder)b).automaticallyPartOnBan$set ? ((TwitchChatConnectionPoolBuilder)b).automaticallyPartOnBan$value : TwitchChatConnectionPool.$default$automaticallyPartOnBan();
        this.chatRateLimit = ((TwitchChatConnectionPoolBuilder)b).chatRateLimit$set ? ((TwitchChatConnectionPoolBuilder)b).chatRateLimit$value : TwitchChatConnectionPool.$default$chatRateLimit();
        this.whisperRateLimit = ((TwitchChatConnectionPoolBuilder)b).whisperRateLimit$set ? ((TwitchChatConnectionPoolBuilder)b).whisperRateLimit$value : TwitchChatConnectionPool.$default$whisperRateLimit();
        this.joinRateLimit = ((TwitchChatConnectionPoolBuilder)b).joinRateLimit$set ? ((TwitchChatConnectionPoolBuilder)b).joinRateLimit$value : TwitchChatConnectionPool.$default$joinRateLimit();
        this.authRateLimit = ((TwitchChatConnectionPoolBuilder)b).authRateLimit$set ? ((TwitchChatConnectionPoolBuilder)b).authRateLimit$value : TwitchChatConnectionPool.$default$authRateLimit();
        this.perChannelRateLimit = ((TwitchChatConnectionPoolBuilder)b).perChannelRateLimit$set ? ((TwitchChatConnectionPoolBuilder)b).perChannelRateLimit$value : TwitchChatConnectionPool.$default$perChannelRateLimit();
        this.connectionBackoffStrategy = ((TwitchChatConnectionPoolBuilder)b).connectionBackoffStrategy$set ? ((TwitchChatConnectionPoolBuilder)b).connectionBackoffStrategy$value : TwitchChatConnectionPool.$default$connectionBackoffStrategy();
    }

    public static TwitchChatConnectionPoolBuilder<?, ?> builder() {
        return new TwitchChatConnectionPoolBuilderImpl();
    }

    public static abstract class TwitchChatConnectionPoolBuilder<C extends TwitchChatConnectionPool, B extends TwitchChatConnectionPoolBuilder<C, B>>
    extends TwitchModuleConnectionPool.TwitchModuleConnectionPoolBuilder<TwitchChat, String, String, Boolean, TwitchChatBuilder, C, B> {
        private boolean chatAccount$set;
        private Supplier<OAuth2Credential> chatAccount$value;
        private boolean automaticallyPartOnBan$set;
        private boolean automaticallyPartOnBan$value;
        private boolean chatRateLimit$set;
        private Bandwidth chatRateLimit$value;
        private boolean whisperRateLimit$set;
        private Bandwidth[] whisperRateLimit$value;
        private boolean joinRateLimit$set;
        private Bandwidth joinRateLimit$value;
        private boolean authRateLimit$set;
        private Bandwidth authRateLimit$value;
        private boolean perChannelRateLimit$set;
        private Bandwidth perChannelRateLimit$value;
        private boolean connectionBackoffStrategy$set;
        private IBackoffStrategy connectionBackoffStrategy$value;

        public B chatAccount(@NonNull Supplier<OAuth2Credential> chatAccount) {
            if (chatAccount == null) {
                throw new NullPointerException("chatAccount is marked non-null but is null");
            }
            this.chatAccount$value = chatAccount;
            this.chatAccount$set = true;
            return (B)this.self();
        }

        @Deprecated
        public B automaticallyPartOnBan(boolean automaticallyPartOnBan) {
            this.automaticallyPartOnBan$value = automaticallyPartOnBan;
            this.automaticallyPartOnBan$set = true;
            return (B)this.self();
        }

        public B chatRateLimit(Bandwidth chatRateLimit) {
            this.chatRateLimit$value = chatRateLimit;
            this.chatRateLimit$set = true;
            return (B)this.self();
        }

        public B whisperRateLimit(Bandwidth[] whisperRateLimit) {
            this.whisperRateLimit$value = whisperRateLimit;
            this.whisperRateLimit$set = true;
            return (B)this.self();
        }

        public B joinRateLimit(Bandwidth joinRateLimit) {
            this.joinRateLimit$value = joinRateLimit;
            this.joinRateLimit$set = true;
            return (B)this.self();
        }

        public B authRateLimit(Bandwidth authRateLimit) {
            this.authRateLimit$value = authRateLimit;
            this.authRateLimit$set = true;
            return (B)this.self();
        }

        public B perChannelRateLimit(Bandwidth perChannelRateLimit) {
            this.perChannelRateLimit$value = perChannelRateLimit;
            this.perChannelRateLimit$set = true;
            return (B)this.self();
        }

        public B connectionBackoffStrategy(IBackoffStrategy connectionBackoffStrategy) {
            this.connectionBackoffStrategy$value = connectionBackoffStrategy;
            this.connectionBackoffStrategy$set = true;
            return (B)this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "TwitchChatConnectionPool.TwitchChatConnectionPoolBuilder(super=" + super.toString() + ", chatAccount$value=" + this.chatAccount$value + ", automaticallyPartOnBan$value=" + this.automaticallyPartOnBan$value + ", chatRateLimit$value=" + this.chatRateLimit$value + ", whisperRateLimit$value=" + Arrays.deepToString(this.whisperRateLimit$value) + ", joinRateLimit$value=" + this.joinRateLimit$value + ", authRateLimit$value=" + this.authRateLimit$value + ", perChannelRateLimit$value=" + this.perChannelRateLimit$value + ", connectionBackoffStrategy$value=" + this.connectionBackoffStrategy$value + ")";
        }
    }

    private static final class TwitchChatConnectionPoolBuilderImpl
    extends TwitchChatConnectionPoolBuilder<TwitchChatConnectionPool, TwitchChatConnectionPoolBuilderImpl> {
        private TwitchChatConnectionPoolBuilderImpl() {
        }

        @Override
        protected TwitchChatConnectionPoolBuilderImpl self() {
            return this;
        }

        @Override
        public TwitchChatConnectionPool build() {
            return new TwitchChatConnectionPool(this);
        }
    }
}

