/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.auth.providers;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.philippheuer.credentialmanager.domain.OAuth2Credential;
import com.github.philippheuer.credentialmanager.identityprovider.OAuth2IdentityProvider;
import com.github.philippheuer.credentialmanager.util.ProxyHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwitchIdentityProvider
extends OAuth2IdentityProvider {
    private static final Logger log = LoggerFactory.getLogger(TwitchIdentityProvider.class);
    public static final String PROVIDER_NAME = "twitch";

    public TwitchIdentityProvider(String clientId, String clientSecret, String redirectUrl) {
        super(PROVIDER_NAME, "oauth2", clientId, clientSecret, "https://id.twitch.tv/oauth2/authorize", "https://id.twitch.tv/oauth2/token", "https://id.twitch.tv/oauth2/device", redirectUrl, ProxyHelper.selectProxy());
        this.tokenEndpointPostType = "QUERY";
        this.scopeSeperator = "+";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<Boolean> isCredentialValid(OAuth2Credential credential) {
        if (credential == null) return Optional.of(false);
        if (credential.getAccessToken() == null) return Optional.of(false);
        if (credential.getAccessToken().isEmpty()) {
            return Optional.of(false);
        }
        Request request = new Request.Builder().url("https://id.twitch.tv/oauth2/validate").header("Authorization", "OAuth " + credential.getAccessToken()).build();
        try (Response response = this.httpClient.newCall(request).execute();){
            if (response.isSuccessful()) {
                Optional<Boolean> optional = Optional.of(true);
                return optional;
            }
            if (response.code() < 400) return Optional.empty();
            if (response.code() >= 500) return Optional.empty();
            Optional<Boolean> optional = Optional.of(false);
            return optional;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Optional.empty();
    }

    public Optional<OAuth2Credential> getAdditionalCredentialInformation(OAuth2Credential credential) {
        try {
            Request request = new Request.Builder().url("https://id.twitch.tv/oauth2/validate").header("Authorization", "OAuth " + credential.getAccessToken()).build();
            Response response = this.httpClient.newCall(request).execute();
            String responseBody = response.body().string();
            if (response.isSuccessful()) {
                ObjectMapper objectMapper = new ObjectMapper();
                HashMap tokenInfo = (HashMap)objectMapper.readValue(responseBody, (TypeReference)new TypeReference<HashMap<String, Object>>(){});
                String userId = (String)tokenInfo.get("user_id");
                String userName = (String)tokenInfo.get("login");
                List scopes = (List)tokenInfo.get("scopes");
                int expiresIn = (Integer)tokenInfo.get("expires_in");
                OAuth2Credential newCredential = new OAuth2Credential(credential.getIdentityProvider(), credential.getAccessToken(), credential.getRefreshToken(), userId, userName, Integer.valueOf(expiresIn), scopes);
                newCredential.getContext().put("client_id", tokenInfo.get("client_id"));
                return Optional.of(newCredential);
            }
            throw new RuntimeException("Request Failed! Code: " + response.code() + " - " + responseBody);
        }
        catch (Exception exception) {
            return Optional.empty();
        }
    }

    public boolean revokeCredential(OAuth2Credential credential) {
        HttpUrl url = HttpUrl.parse((String)"https://id.twitch.tv/oauth2/revoke").newBuilder().addQueryParameter("client_id", credential.getContext().getOrDefault("client_id", this.clientId)).addQueryParameter("token", credential.getAccessToken()).build();
        Request request = new Request.Builder().url(url).post(RequestBody.create((String)"", null)).build();
        try {
            Response response = this.httpClient.newCall(request).execute();
            if (response.isSuccessful()) {
                return true;
            }
            log.warn("Unable to revoke access token! Code: " + response.code() + " - " + response.body().string());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

