/*
 * Decompiled with CFR 0.152.
 */
package com.github.theholywaffle.teamspeak3;

import com.github.theholywaffle.teamspeak3.IOChannel;
import com.github.theholywaffle.teamspeak3.TS3Config;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

class SocketChannel
implements IOChannel {
    private final Socket socket;

    SocketChannel(TS3Config config) throws IOException {
        try {
            this.socket = new Socket(config.getHost(), config.getQueryPort());
            this.socket.setTcpNoDelay(true);
            this.socket.setSoTimeout(config.getCommandTimeout());
        }
        catch (IOException ioe) {
            this.close();
            throw ioe;
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.socket.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.socket.getOutputStream();
    }

    @Override
    public void close() throws IOException {
        if (this.socket != null) {
            this.socket.close();
        }
    }
}

