/*
 * Decompiled with CFR 0.152.
 */
package com.github.theholywaffle.teamspeak3.api.wrapper;

import com.github.theholywaffle.teamspeak3.api.Property;
import java.util.Collections;
import java.util.Map;

public class Wrapper {
    public static final Wrapper EMPTY = new Wrapper(Collections.emptyMap());
    private final Map<String, String> map;

    public Wrapper(Map<String, String> map) {
        this.map = map;
    }

    public Map<String, String> getMap() {
        return this.map;
    }

    public boolean getBoolean(String propertyName) {
        return this.getInt(propertyName) == 1;
    }

    public boolean getBoolean(Property property) {
        return this.getBoolean(property.getName());
    }

    public double getDouble(String propertyName) {
        String value = this.get(propertyName);
        if (value == null || value.isEmpty()) {
            return -1.0;
        }
        return Double.valueOf(value);
    }

    public double getDouble(Property property) {
        return this.getDouble(property.getName());
    }

    public long getLong(String propertyName) {
        String value = this.get(propertyName);
        if (value == null || value.isEmpty()) {
            return -1L;
        }
        return Long.parseLong(value);
    }

    public long getLong(Property property) {
        return this.getLong(property.getName());
    }

    public int getInt(String propertyName) {
        String value = this.get(propertyName);
        if (value == null || value.isEmpty()) {
            return -1;
        }
        return Integer.parseInt(value);
    }

    public int getInt(Property property) {
        return this.getInt(property.getName());
    }

    public String get(String propertyName) {
        String result = this.map.get(propertyName);
        return result != null ? result : "";
    }

    public String get(Property property) {
        return this.get(property.getName());
    }

    public String toString() {
        return this.map.toString();
    }
}

