/*
 * Decompiled with CFR 0.152.
 */
package com.github.theholywaffle.teamspeak3;

import com.github.theholywaffle.teamspeak3.QueryIO;
import com.github.theholywaffle.teamspeak3.TS3Config;
import com.github.theholywaffle.teamspeak3.commands.Command;
import com.github.theholywaffle.teamspeak3.commands.response.ResponseBuilder;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketWriter
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(SocketWriter.class);
    private final BlockingQueue<Command> sendQueue;
    private final BlockingQueue<ResponseBuilder> receiveQueue;
    private final int floodRate;
    private final boolean logComms;
    private final PrintStream out;
    private volatile long lastCommandTime = System.currentTimeMillis();
    private Command interruptedCommand = null;

    public SocketWriter(QueryIO io, TS3Config config) throws IOException {
        super("[TeamSpeak-3-Java-API] SocketWriter");
        this.sendQueue = io.getSendQueue();
        this.receiveQueue = io.getReceiveQueue();
        this.floodRate = config.getFloodRate().getMs();
        this.logComms = config.getEnableCommunicationsLogging();
        this.out = new PrintStream(io.getSocket().getOutputStream(), true, "UTF-8");
    }

    @Override
    public void run() {
        try {
            if (this.floodRate > 0) {
                Thread.sleep(this.floodRate);
            }
            while (!this.isInterrupted()) {
                Command c = this.sendQueue.take();
                String msg = c.toString();
                this.lastCommandTime = System.currentTimeMillis();
                try {
                    this.receiveQueue.put(new ResponseBuilder(c));
                }
                catch (InterruptedException e) {
                    this.interruptedCommand = c;
                    this.interrupt();
                    break;
                }
                if (this.logComms) {
                    log.debug("[{}] > {}", (Object)c.getName(), (Object)msg);
                }
                this.out.println(msg);
                if (this.floodRate <= 0) continue;
                Thread.sleep(this.floodRate);
            }
        }
        catch (InterruptedException e) {
            this.interrupt();
        }
        this.out.close();
        if (!this.isInterrupted()) {
            log.warn("SocketWriter has stopped!");
        }
    }

    long getIdleTime() {
        return System.currentTimeMillis() - this.lastCommandTime;
    }

    void drainCommandsTo(Collection<Command> commands) {
        if (this.interruptedCommand != null) {
            commands.add(this.interruptedCommand);
        }
        this.sendQueue.drainTo(commands);
    }
}

