/*
 * Decompiled with CFR 0.152.
 */
package com.github.theholywaffle.teamspeak3;

import com.github.theholywaffle.teamspeak3.api.wrapper.FileTransferParameters;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.CRC32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileTransferHelper {
    private static final Logger log = LoggerFactory.getLogger(FileTransferHelper.class);
    private static final int BUFFER_SIZE = 16384;
    private final AtomicInteger clientTransferId = new AtomicInteger(0);
    private final String defaultHost;

    FileTransferHelper(String host) {
        this.defaultHost = host;
    }

    public void downloadFile(OutputStream dataOut, FileTransferParameters params) throws IOException {
        String host = this.getHostFromResponse(params.getFileServerHost());
        int port = params.getFileServerPort();
        long dataLength = params.getFileSize();
        int downloadId = params.getClientTransferId() + 1;
        log.info("[Download {}] Download started", (Object)downloadId);
        try (Socket socket = new Socket(host, port);){
            socket.setReceiveBufferSize(16384);
            int actualSize = socket.getReceiveBufferSize();
            OutputStream out = socket.getOutputStream();
            out.write(params.getFileTransferKey().getBytes("UTF-8"));
            out.flush();
            InputStream in = socket.getInputStream();
            byte[] buffer = new byte[actualSize];
            long total = 0L;
            while (total < dataLength) {
                int read = in.read(buffer);
                if (read < 0) {
                    throw new IOException("Server response contained less data than specified");
                }
                if ((total += (long)read) > dataLength) {
                    throw new IOException("Server response contained more data than specified");
                }
                dataOut.write(buffer, 0, read);
            }
            log.info("[Download {}] Download finished", (Object)downloadId);
        }
        catch (IOException e) {
            log.warn("[Download {}] Download failed: {}", (Object)downloadId, (Object)e.getMessage());
            throw e;
        }
    }

    public void uploadFile(InputStream dataIn, long dataLength, FileTransferParameters params) throws IOException {
        String host = this.getHostFromResponse(params.getFileServerHost());
        int port = params.getFileServerPort();
        int uploadId = params.getClientTransferId() + 1;
        log.info("[Upload {}] Upload started", (Object)uploadId);
        try (Socket socket = new Socket(host, port);){
            int read;
            socket.setSendBufferSize(16384);
            int actualSize = socket.getSendBufferSize();
            OutputStream out = socket.getOutputStream();
            out.write(params.getFileTransferKey().getBytes("UTF-8"));
            out.flush();
            byte[] buffer = new byte[actualSize];
            for (long total = 0L; total < dataLength; total += (long)read) {
                int toRead = (int)Math.min((long)actualSize, dataLength - total);
                read = dataIn.read(buffer, 0, toRead);
                if (read < 0) {
                    throw new IOException("User stream did not contain enough data");
                }
                out.write(buffer, 0, read);
            }
            log.info("[Upload {}] Upload finished", (Object)uploadId);
        }
        catch (IOException e) {
            log.warn("[Upload {}] Upload failed: {}", (Object)uploadId, (Object)e.getMessage());
            throw e;
        }
    }

    public long getIconId(byte[] data) {
        CRC32 crc32 = new CRC32();
        crc32.update(data);
        return crc32.getValue();
    }

    public byte[] readFully(InputStream dataIn, long dataLength) throws IOException {
        int read;
        if (dataLength > 0x7FFFFFBFL) {
            throw new IOException("File too large");
        }
        int len = (int)dataLength;
        byte[] data = new byte[len];
        for (int total = 0; total < len; total += read) {
            read = dataIn.read(data, total, len - total);
            if (read >= 0) continue;
            throw new IOException("User stream did not contain enough data");
        }
        return data;
    }

    public int getClientTransferId() {
        int next;
        int prev;
        while (!this.clientTransferId.compareAndSet(prev = this.clientTransferId.get(), next = prev + 1 & 0xFFFF)) {
        }
        return prev;
    }

    private String getHostFromResponse(String raw) {
        if (raw == null || raw.isEmpty()) {
            return this.defaultHost;
        }
        if (raw.startsWith("0.0.0.0")) {
            return this.defaultHost;
        }
        int firstComma = raw.indexOf(44);
        if (firstComma <= 0) {
            return this.defaultHost;
        }
        return raw.substring(0, firstComma);
    }
}

