/*
 * Decompiled with CFR 0.152.
 */
package com.github.theholywaffle.teamspeak3;

import com.github.theholywaffle.teamspeak3.TS3Query;
import com.github.theholywaffle.teamspeak3.api.event.ChannelCreateEvent;
import com.github.theholywaffle.teamspeak3.api.event.ChannelDeletedEvent;
import com.github.theholywaffle.teamspeak3.api.event.ChannelDescriptionEditedEvent;
import com.github.theholywaffle.teamspeak3.api.event.ChannelEditedEvent;
import com.github.theholywaffle.teamspeak3.api.event.ChannelMovedEvent;
import com.github.theholywaffle.teamspeak3.api.event.ChannelPasswordChangedEvent;
import com.github.theholywaffle.teamspeak3.api.event.ClientJoinEvent;
import com.github.theholywaffle.teamspeak3.api.event.ClientLeaveEvent;
import com.github.theholywaffle.teamspeak3.api.event.ClientMovedEvent;
import com.github.theholywaffle.teamspeak3.api.event.PrivilegeKeyUsedEvent;
import com.github.theholywaffle.teamspeak3.api.event.ServerEditedEvent;
import com.github.theholywaffle.teamspeak3.api.event.TS3Event;
import com.github.theholywaffle.teamspeak3.api.event.TS3Listener;
import com.github.theholywaffle.teamspeak3.api.event.TextMessageEvent;
import com.github.theholywaffle.teamspeak3.api.exception.TS3UnknownEventException;
import com.github.theholywaffle.teamspeak3.api.wrapper.Wrapper;
import com.github.theholywaffle.teamspeak3.commands.response.DefaultArrayResponse;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventManager {
    private static final Logger log = LoggerFactory.getLogger(EventManager.class);
    private final Collection<ListenerTask> tasks = new CopyOnWriteArrayList<ListenerTask>();
    private final TS3Query ts3;

    EventManager(TS3Query query) {
        this.ts3 = query;
    }

    public void addListeners(TS3Listener ... listeners) {
        for (TS3Listener listener : listeners) {
            if (listener == null) {
                throw new IllegalArgumentException("A listener was null");
            }
            ListenerTask task = new ListenerTask(listener);
            this.tasks.add(task);
        }
    }

    public void removeListeners(TS3Listener ... listeners) {
        Iterator<ListenerTask> taskIterator = this.tasks.iterator();
        block0: while (taskIterator.hasNext()) {
            ListenerTask task = taskIterator.next();
            TS3Listener taskListener = task.getListener();
            for (TS3Listener listener : listeners) {
                if (!taskListener.equals(listener)) continue;
                taskIterator.remove();
                continue block0;
            }
        }
    }

    public void fireEvent(String notifyName, String notifyBody) {
        DefaultArrayResponse response = DefaultArrayResponse.parse(notifyBody);
        for (Wrapper dataWrapper : response.getResponses()) {
            Map<String, String> eventData = dataWrapper.getMap();
            TS3Event event = EventManager.createEvent(notifyName, eventData);
            this.fireEvent(event);
        }
    }

    public void fireEvent(TS3Event event) {
        if (event == null) {
            throw new IllegalArgumentException("TS3Event was null");
        }
        for (ListenerTask task : this.tasks) {
            task.enqueueEvent(event);
        }
    }

    private static TS3Event createEvent(String notifyName, Map<String, String> eventData) {
        switch (notifyName) {
            case "notifytextmessage": {
                return new TextMessageEvent(eventData);
            }
            case "notifycliententerview": {
                return new ClientJoinEvent(eventData);
            }
            case "notifyclientleftview": {
                return new ClientLeaveEvent(eventData);
            }
            case "notifyserveredited": {
                return new ServerEditedEvent(eventData);
            }
            case "notifychanneledited": {
                return new ChannelEditedEvent(eventData);
            }
            case "notifychanneldescriptionchanged": {
                return new ChannelDescriptionEditedEvent(eventData);
            }
            case "notifyclientmoved": {
                return new ClientMovedEvent(eventData);
            }
            case "notifychannelcreated": {
                return new ChannelCreateEvent(eventData);
            }
            case "notifychanneldeleted": {
                return new ChannelDeletedEvent(eventData);
            }
            case "notifychannelmoved": {
                return new ChannelMovedEvent(eventData);
            }
            case "notifychannelpasswordchanged": {
                return new ChannelPasswordChangedEvent(eventData);
            }
            case "notifytokenused": {
                return new PrivilegeKeyUsedEvent(eventData);
            }
        }
        throw new TS3UnknownEventException(notifyName + " " + eventData);
    }

    private class ListenerTask
    implements Runnable {
        private static final int START_QUEUE_SIZE = 16;
        private final TS3Listener listener;
        private final Queue<TS3Event> eventQueue;

        ListenerTask(TS3Listener ts3Listener) {
            this.listener = ts3Listener;
            this.eventQueue = new ArrayDeque<TS3Event>(16);
        }

        TS3Listener getListener() {
            return this.listener;
        }

        synchronized void enqueueEvent(TS3Event event) {
            if (this.eventQueue.isEmpty()) {
                this.eventQueue.add(event);
                EventManager.this.ts3.submitUserTask("Event listener task", this);
            } else {
                this.eventQueue.add(event);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TS3Event currentEvent;
            ListenerTask listenerTask = this;
            synchronized (listenerTask) {
                currentEvent = this.eventQueue.peek();
                if (currentEvent == null) {
                    throw new IllegalStateException("Task started without events");
                }
            }
            do {
                try {
                    currentEvent.fire(this.listener);
                }
                catch (Throwable throwable) {
                    log.error("Event listener threw an exception", throwable);
                }
                listenerTask = this;
                synchronized (listenerTask) {
                    this.eventQueue.remove();
                    currentEvent = this.eventQueue.peek();
                }
            } while (currentEvent != null);
        }
    }
}

