/*
 * Decompiled with CFR 0.152.
 */
package com.github.theholywaffle.teamspeak3.api.reconnect;

import com.github.theholywaffle.teamspeak3.api.reconnect.ConnectionHandler;
import com.github.theholywaffle.teamspeak3.api.reconnect.DisconnectingConnectionHandler;
import com.github.theholywaffle.teamspeak3.api.reconnect.ReconnectingConnectionHandler;

public abstract class ReconnectStrategy {
    private static final int CONSTANT_BACKOFF = 10000;
    private static final int START_TIMEOUT = 1000;
    private static final int TIMEOUT_CAP = 60000;
    private static final int ADDEND = 2000;
    private static final double MULTIPLIER = 1.5;

    private ReconnectStrategy() {
    }

    public abstract ConnectionHandler create(ConnectionHandler var1);

    public static ReconnectStrategy userControlled() {
        return new UserControlled();
    }

    public static ReconnectStrategy disconnect() {
        return new Disconnect();
    }

    public static ReconnectStrategy constantBackoff() {
        return ReconnectStrategy.constantBackoff(10000);
    }

    public static ReconnectStrategy constantBackoff(int timeout) {
        return new Constant(timeout);
    }

    public static ReconnectStrategy linearBackoff() {
        return ReconnectStrategy.linearBackoff(1000, 2000, 60000);
    }

    public static ReconnectStrategy linearBackoff(int startTimeout, int addend) {
        return ReconnectStrategy.linearBackoff(startTimeout, addend, 60000);
    }

    public static ReconnectStrategy linearBackoff(int startTimeout, int addend, int timeoutCap) {
        return new Linear(startTimeout, addend, timeoutCap);
    }

    public static ReconnectStrategy exponentialBackoff() {
        return ReconnectStrategy.exponentialBackoff(1000, 1.5, 60000);
    }

    public static ReconnectStrategy exponentialBackoff(int startTimeout, double multiplier) {
        return ReconnectStrategy.exponentialBackoff(startTimeout, multiplier, 60000);
    }

    public static ReconnectStrategy exponentialBackoff(int startTimeout, double multiplier, int timeoutCap) {
        return new Exponential(startTimeout, multiplier, timeoutCap);
    }

    private static class Exponential
    extends ReconnectStrategy {
        private final int startTimeout;
        private final double multiplier;
        private final int timeoutCap;

        private Exponential(int startTimeout, double multiplier, int timeoutCap) {
            if (startTimeout <= 0) {
                throw new IllegalArgumentException("Starting timeout must be greater than 0");
            }
            if (multiplier <= 1.0) {
                throw new IllegalArgumentException("Multiplier must be greater than 1");
            }
            this.startTimeout = startTimeout;
            this.multiplier = multiplier;
            this.timeoutCap = timeoutCap;
        }

        @Override
        public ConnectionHandler create(ConnectionHandler userConnectionHandler) {
            return new ReconnectingConnectionHandler(userConnectionHandler, this.startTimeout, this.timeoutCap, 0, this.multiplier);
        }
    }

    private static class Linear
    extends ReconnectStrategy {
        private final int startTimeout;
        private final int addend;
        private final int timeoutCap;

        private Linear(int startTimeout, int addend, int timeoutCap) {
            if (startTimeout <= 0) {
                throw new IllegalArgumentException("Starting timeout must be greater than 0");
            }
            if (addend <= 0) {
                throw new IllegalArgumentException("Addend must be greater than 0");
            }
            this.startTimeout = startTimeout;
            this.addend = addend;
            this.timeoutCap = timeoutCap;
        }

        @Override
        public ConnectionHandler create(ConnectionHandler userConnectionHandler) {
            return new ReconnectingConnectionHandler(userConnectionHandler, this.startTimeout, this.timeoutCap, this.addend, 1.0);
        }
    }

    private static class Constant
    extends ReconnectStrategy {
        private final int timeout;

        public Constant(int timeout) {
            if (timeout <= 0) {
                throw new IllegalArgumentException("Timeout must be greater than 0");
            }
            this.timeout = timeout;
        }

        @Override
        public ConnectionHandler create(ConnectionHandler userConnectionHandler) {
            return new ReconnectingConnectionHandler(userConnectionHandler, this.timeout, this.timeout, 0, 1.0);
        }
    }

    private static class Disconnect
    extends ReconnectStrategy {
        private Disconnect() {
        }

        @Override
        public ConnectionHandler create(ConnectionHandler userConnectionHandler) {
            return new DisconnectingConnectionHandler(userConnectionHandler);
        }
    }

    private static class UserControlled
    extends ReconnectStrategy {
        private UserControlled() {
        }

        @Override
        public ConnectionHandler create(ConnectionHandler userConnectionHandler) {
            String message = "userConnectionHandler cannot be null when using strategy UserControlled!";
            if (userConnectionHandler == null) {
                throw new IllegalArgumentException(message);
            }
            return userConnectionHandler;
        }
    }
}

