/*
 * Decompiled with CFR 0.152.
 */
package com.github.theholywaffle.teamspeak3;

import com.github.theholywaffle.teamspeak3.TS3Query;
import com.github.theholywaffle.teamspeak3.api.reconnect.ConnectionHandler;
import com.github.theholywaffle.teamspeak3.api.reconnect.ReconnectStrategy;

public class TS3Config {
    private String host = null;
    private int queryPort = 10011;
    private TS3Query.FloodRate floodRate = TS3Query.FloodRate.DEFAULT;
    private boolean enableCommunicationsLogging = false;
    private int commandTimeout = 4000;
    private ReconnectStrategy reconnectStrategy = ReconnectStrategy.disconnect();
    private ConnectionHandler connectionHandler = null;

    public TS3Config setHost(String host) {
        this.host = host;
        return this;
    }

    String getHost() {
        return this.host;
    }

    public TS3Config setQueryPort(int queryPort) {
        if (queryPort <= 0 || queryPort > 65535) {
            throw new IllegalArgumentException("Port out of range: " + queryPort);
        }
        this.queryPort = queryPort;
        return this;
    }

    int getQueryPort() {
        return this.queryPort;
    }

    public TS3Config setFloodRate(TS3Query.FloodRate rate) {
        if (rate == null) {
            throw new IllegalArgumentException("rate cannot be null!");
        }
        this.floodRate = rate;
        return this;
    }

    TS3Query.FloodRate getFloodRate() {
        return this.floodRate;
    }

    public TS3Config setEnableCommunicationsLogging(boolean enable) {
        this.enableCommunicationsLogging = enable;
        return this;
    }

    boolean getEnableCommunicationsLogging() {
        return this.enableCommunicationsLogging;
    }

    public TS3Config setCommandTimeout(int commandTimeout) {
        if (commandTimeout <= 0) {
            throw new IllegalArgumentException("Timeout value must be greater than 0");
        }
        this.commandTimeout = commandTimeout;
        return this;
    }

    int getCommandTimeout() {
        return this.commandTimeout;
    }

    public TS3Config setReconnectStrategy(ReconnectStrategy reconnectStrategy) {
        if (reconnectStrategy == null) {
            throw new IllegalArgumentException("reconnectStrategy cannot be null!");
        }
        this.reconnectStrategy = reconnectStrategy;
        return this;
    }

    ReconnectStrategy getReconnectStrategy() {
        return this.reconnectStrategy;
    }

    public TS3Config setConnectionHandler(ConnectionHandler connectionHandler) {
        this.connectionHandler = connectionHandler;
        return this;
    }

    ConnectionHandler getConnectionHandler() {
        return this.connectionHandler;
    }
}

