/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.util;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import lombok.NonNull;

public final class Validate {
    public static void isTrue(boolean value, @NonNull String message, Object ... args) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        Validate.isTrue(value, message, IllegalArgumentException.class, args);
    }

    public static <T extends Throwable> void isTrue(boolean value, @NonNull Class<? extends Throwable> throwable) throws T {
        if (throwable == null) {
            throw new NullPointerException("throwable is marked non-null but is null");
        }
        Validate.isTrue(value, null, throwable, new Object[0]);
    }

    public static <T extends Throwable> void isTrue(boolean value, String message, @NonNull Class<? extends Throwable> throwable, Object ... args) throws T {
        if (throwable == null) {
            throw new NullPointerException("throwable is marked non-null but is null");
        }
        if (value) {
            return;
        }
        throw Validate.createThrowable(throwable, message == null ? null : message.formatted(args));
    }

    private static Throwable createThrowable(Class<? extends Throwable> throwable, String formattedMessage) {
        try {
            Throwable result = formattedMessage == null ? throwable.getConstructor(new Class[0]).newInstance(new Object[0]) : throwable.getConstructor(String.class).newInstance(formattedMessage);
            StackTraceElement[] stackTrace = (StackTraceElement[])Arrays.stream(result.getStackTrace()).filter(entry -> !entry.getClassName().equals(Validate.class.getName()) && !entry.getClassName().equals(Constructor.class.getName())).toArray(StackTraceElement[]::new);
            result.setStackTrace(stackTrace);
            return result;
        }
        catch (Throwable ignored) {
            return new RuntimeException(formattedMessage);
        }
    }

    private Validate() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

