/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.socket;

import it.auties.whatsapp.api.DisconnectReason;

public enum SocketState {
    WAITING,
    CONNECTED,
    DISCONNECTED,
    RECONNECTING,
    LOGGED_OUT,
    RESTORE;


    static SocketState of(DisconnectReason reason) {
        return switch (reason) {
            default -> throw new IncompatibleClassChangeError();
            case DisconnectReason.DISCONNECTED -> DISCONNECTED;
            case DisconnectReason.RECONNECTING -> RECONNECTING;
            case DisconnectReason.LOGGED_OUT -> LOGGED_OUT;
            case DisconnectReason.RESTORE -> RESTORE;
        };
    }

    DisconnectReason toReason() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case WAITING, CONNECTED, RECONNECTING -> DisconnectReason.RECONNECTING;
            case DISCONNECTED -> DisconnectReason.DISCONNECTED;
            case LOGGED_OUT -> DisconnectReason.LOGGED_OUT;
            case RESTORE -> DisconnectReason.RESTORE;
        };
    }
}

