/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.socket;

import it.auties.whatsapp.api.ErrorHandler;
import it.auties.whatsapp.api.WebHistoryLength;
import it.auties.whatsapp.controller.Store;
import it.auties.whatsapp.crypto.GroupBuilder;
import it.auties.whatsapp.crypto.GroupCipher;
import it.auties.whatsapp.crypto.SessionBuilder;
import it.auties.whatsapp.crypto.SessionCipher;
import it.auties.whatsapp.model.action.ContactAction;
import it.auties.whatsapp.model.business.BusinessVerifiedNameCertificate;
import it.auties.whatsapp.model.chat.Chat;
import it.auties.whatsapp.model.chat.ChatEphemeralTimer;
import it.auties.whatsapp.model.chat.GroupMetadata;
import it.auties.whatsapp.model.chat.PastParticipant;
import it.auties.whatsapp.model.chat.PastParticipants;
import it.auties.whatsapp.model.contact.Contact;
import it.auties.whatsapp.model.contact.ContactJid;
import it.auties.whatsapp.model.contact.ContactStatus;
import it.auties.whatsapp.model.info.MessageIndexInfo;
import it.auties.whatsapp.model.info.MessageInfo;
import it.auties.whatsapp.model.message.button.ButtonsMessage;
import it.auties.whatsapp.model.message.button.ButtonsResponseMessage;
import it.auties.whatsapp.model.message.button.ListMessage;
import it.auties.whatsapp.model.message.button.ListResponseMessage;
import it.auties.whatsapp.model.message.button.NativeFlowResponseMessage;
import it.auties.whatsapp.model.message.model.Message;
import it.auties.whatsapp.model.message.model.MessageCategory;
import it.auties.whatsapp.model.message.model.MessageContainer;
import it.auties.whatsapp.model.message.model.MessageKey;
import it.auties.whatsapp.model.message.model.MessageStatus;
import it.auties.whatsapp.model.message.model.MessageType;
import it.auties.whatsapp.model.message.payment.PaymentOrderMessage;
import it.auties.whatsapp.model.message.server.DeviceSentMessage;
import it.auties.whatsapp.model.message.server.ProtocolMessage;
import it.auties.whatsapp.model.message.server.SenderKeyDistributionMessage;
import it.auties.whatsapp.model.message.standard.AudioMessage;
import it.auties.whatsapp.model.message.standard.ContactMessage;
import it.auties.whatsapp.model.message.standard.ContactsArrayMessage;
import it.auties.whatsapp.model.message.standard.DocumentMessage;
import it.auties.whatsapp.model.message.standard.ImageMessage;
import it.auties.whatsapp.model.message.standard.LiveLocationMessage;
import it.auties.whatsapp.model.message.standard.ProductMessage;
import it.auties.whatsapp.model.message.standard.StickerMessage;
import it.auties.whatsapp.model.message.standard.VideoMessage;
import it.auties.whatsapp.model.request.Attributes;
import it.auties.whatsapp.model.request.MessageSendRequest;
import it.auties.whatsapp.model.request.Node;
import it.auties.whatsapp.model.setting.EphemeralSetting;
import it.auties.whatsapp.model.signal.keypair.SignalSignedKeyPair;
import it.auties.whatsapp.model.signal.message.SignalDistributionMessage;
import it.auties.whatsapp.model.signal.message.SignalMessage;
import it.auties.whatsapp.model.signal.message.SignalPreKeyMessage;
import it.auties.whatsapp.model.signal.sender.SenderKeyName;
import it.auties.whatsapp.model.sync.HistorySync;
import it.auties.whatsapp.model.sync.PushName;
import it.auties.whatsapp.socket.SocketHandler;
import it.auties.whatsapp.util.BytesHelper;
import it.auties.whatsapp.util.Clock;
import it.auties.whatsapp.util.DeferredTaskRunner;
import it.auties.whatsapp.util.KeyHelper;
import it.auties.whatsapp.util.Medias;
import it.auties.whatsapp.util.Protobuf;
import it.auties.whatsapp.util.Validate;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class MessageHandler {
    private static final int WEEKS_GROUP_METADATA_SYNC = 2;
    private static final int HISTORY_SYNC_TIMEOUT = 10;
    private final SocketHandler socketHandler;
    private final Map<ContactJid, List<PastParticipant>> pastParticipantsQueue;
    private final Set<Chat> historyCache;
    private final System.Logger logger;
    private final DeferredTaskRunner deferredGroupQuery;
    private final Set<ContactJid> attributedGroups;
    private final EnumSet<HistorySync.Type> historySyncTypes;
    private ExecutorService executor;
    private CompletableFuture<?> historySyncTask;

    protected MessageHandler(SocketHandler socketHandler) {
        this.socketHandler = socketHandler;
        this.pastParticipantsQueue = new ConcurrentHashMap<ContactJid, List<PastParticipant>>();
        this.historyCache = ConcurrentHashMap.newKeySet();
        this.attributedGroups = ConcurrentHashMap.newKeySet();
        this.logger = System.getLogger("MessageHandler");
        this.historySyncTypes = EnumSet.noneOf(HistorySync.Type.class);
        this.deferredGroupQuery = new DeferredTaskRunner();
    }

    private synchronized ExecutorService getOrCreateMessageService() {
        if (this.executor == null || this.executor.isShutdown()) {
            this.executor = Executors.newSingleThreadExecutor();
        }
        return this.executor;
    }

    protected synchronized CompletableFuture<Void> encode(MessageSendRequest request) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.getOrCreateMessageService().execute(() -> {
            ((CompletableFuture)((CompletableFuture)this.encodeMessageNode(request).thenRunAsync(() -> this.attributeOutgoingMessage(request))).exceptionallyAsync(throwable -> this.onEncodeError(request, (Throwable)throwable))).join();
            future.complete(null);
        });
        return future;
    }

    private CompletableFuture<Node> encodeMessageNode(MessageSendRequest request) {
        return request.peer() || this.isConversation(request.info()) ? this.encodeConversation(request) : this.encodeGroup(request);
    }

    private Void onEncodeError(MessageSendRequest request, Throwable throwable) {
        request.info().status(MessageStatus.ERROR);
        return (Void)this.socketHandler.handleFailure(ErrorHandler.Location.MESSAGE, throwable);
    }

    private void attributeOutgoingMessage(MessageSendRequest request) {
        if (request.peer()) {
            return;
        }
        this.saveMessage(request.info(), false);
        this.attributeMessageReceipt(request.info());
    }

    private CompletableFuture<Node> encodeGroup(MessageSendRequest request) {
        byte[] encodedMessage = BytesHelper.messageToBytes(request.info().message());
        SenderKeyName senderName = new SenderKeyName(request.info().chatJid().toString(), this.socketHandler.store().jid().toSignalAddress());
        GroupBuilder groupBuilder = new GroupBuilder(this.socketHandler.keys());
        byte[] signalMessage = groupBuilder.createOutgoing(senderName);
        GroupCipher groupCipher = new GroupCipher(senderName, this.socketHandler.keys());
        GroupCipher.CipheredMessageResult groupMessage = groupCipher.encrypt(encodedMessage);
        Node messageNode = this.createMessageNode(request, groupMessage);
        if (request.hasRecipientOverride()) {
            return ((CompletableFuture)((CompletableFuture)this.getDevices(request.recipients(), false).thenComposeAsync(allDevices -> this.createGroupNodes(request, signalMessage, (List<ContactJid>)allDevices, request.force()))).thenApplyAsync(preKeys -> this.createEncodedMessageNode(request, (List<Node>)preKeys, messageNode))).thenComposeAsync(this.socketHandler::send);
        }
        if (request.force()) {
            return ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.socketHandler.queryGroupMetadata(request.info().chatJid()).thenComposeAsync(this::getGroupDevices)).thenComposeAsync(allDevices -> this.createGroupNodes(request, signalMessage, (List<ContactJid>)allDevices, true))).thenApplyAsync(preKeys -> this.createEncodedMessageNode(request, (List<Node>)preKeys, messageNode))).thenComposeAsync(this.socketHandler::send);
        }
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.socketHandler.queryGroupMetadata(request.info().chatJid()).thenComposeAsync(this::getGroupDevices)).thenComposeAsync(allDevices -> this.createGroupNodes(request, signalMessage, (List<ContactJid>)allDevices, false))).thenApplyAsync(preKeys -> this.createEncodedMessageNode(request, (List<Node>)preKeys, messageNode))).thenComposeAsync(this.socketHandler::send);
    }

    private CompletableFuture<Node> encodeConversation(MessageSendRequest request) {
        ContactJid sender = this.socketHandler.store().jid();
        if (sender == null) {
            return CompletableFuture.failedFuture(new IllegalStateException("Cannot create message: user is not signed in"));
        }
        byte[] encodedMessage = BytesHelper.messageToBytes(request.info().message());
        List<ContactJid> knownDevices = this.getRecipients(request, sender);
        ContactJid chatJid = request.info().chatJid();
        if (request.peer()) {
            Node peerNode = this.createMessageNode(request, chatJid, encodedMessage, true);
            Node encodedMessageNode = this.createEncodedMessageNode(request, List.of(peerNode), null);
            return this.socketHandler.send(encodedMessageNode);
        }
        DeviceSentMessage deviceMessage = new DeviceSentMessage(request.info().chatJid().toString(), request.info().message(), null);
        byte[] encodedDeviceMessage = BytesHelper.messageToBytes(deviceMessage);
        return ((CompletableFuture)((CompletableFuture)this.getDevices(knownDevices, true).thenComposeAsync(allDevices -> this.createConversationNodes(request, (List<ContactJid>)allDevices, encodedMessage, encodedDeviceMessage))).thenApplyAsync(sessions -> this.createEncodedMessageNode(request, (List<Node>)sessions, null))).thenComposeAsync(this.socketHandler::send);
    }

    private List<ContactJid> getRecipients(MessageSendRequest request, ContactJid sender) {
        if (request.peer()) {
            return List.of(request.info().chatJid());
        }
        if (request.hasRecipientOverride()) {
            return request.recipients();
        }
        return List.of(sender.toWhatsappJid(), request.info().chatJid());
    }

    private boolean isConversation(MessageInfo info) {
        return info.chatJid().hasServer(ContactJid.Server.WHATSAPP) || info.chatJid().hasServer(ContactJid.Server.USER);
    }

    private Node createEncodedMessageNode(MessageSendRequest request, List<Node> preKeys, Node descriptor) {
        ArrayList<Node> body = new ArrayList<Node>();
        if (!preKeys.isEmpty()) {
            if (request.peer()) {
                body.addAll(preKeys);
            } else {
                body.add(Node.of("participants", preKeys));
            }
        }
        if (descriptor != null) {
            body.add(descriptor);
        }
        if (!request.peer() && this.hasPreKeyMessage(preKeys)) {
            this.socketHandler.keys().companionIdentity().ifPresent(companionIdentity -> body.add(Node.of("device-identity", Protobuf.writeMessage(companionIdentity))));
        }
        BooleanSupplier[] booleanSupplierArray = new BooleanSupplier[1];
        booleanSupplierArray[0] = request::peer;
        ConcurrentHashMap<String, Object> attributes = Attributes.ofNullable(request.additionalAttributes()).put("id", request.info().id()).put("to", request.info().chatJid()).put("t", (Object)request.info().timestampSeconds(), !request.peer()).put("type", "text").put("category", (Object)"peer", booleanSupplierArray).put("duration", (Object)"900", request.info().message().type() == MessageType.LIVE_LOCATION).put("device_fanout", (Object)false, request.info().message().type() == MessageType.BUTTONS).put("push_priority", (Object)"high", this.isAppStateKeyShare(request)).toMap();
        return Node.of("message", attributes, body);
    }

    private boolean isAppStateKeyShare(MessageSendRequest request) {
        ProtocolMessage protocolMessage;
        Message message;
        return request.peer() && (message = request.info().message().content()) instanceof ProtocolMessage && (protocolMessage = (ProtocolMessage)message).protocolType() == ProtocolMessage.ProtocolMessageType.APP_STATE_SYNC_KEY_SHARE;
    }

    private boolean hasPreKeyMessage(List<Node> participants) {
        return participants.stream().map(Node::children).flatMap(Collection::stream).map(node -> node.attributes().getOptionalString("type")).flatMap(Optional::stream).anyMatch("pkmsg"::equals);
    }

    private CompletableFuture<List<Node>> createConversationNodes(MessageSendRequest request, List<ContactJid> contacts, byte[] message, byte[] deviceMessage) {
        Map<Boolean, List<ContactJid>> partitioned = contacts.stream().collect(Collectors.partitioningBy(contact -> Objects.equals(contact.user(), this.socketHandler.store().jid().user())));
        CompletionStage companions = this.querySessions(partitioned.get(true), request.force()).thenApplyAsync(ignored -> this.createMessageNodes(request, (List)partitioned.get(true), deviceMessage));
        CompletionStage others = this.querySessions(partitioned.get(false), request.force()).thenApplyAsync(ignored -> this.createMessageNodes(request, (List)partitioned.get(false), message));
        return ((CompletableFuture)companions).thenCombineAsync(others, (first, second) -> this.toSingleList((List)first, (List)second));
    }

    private CompletableFuture<List<Node>> createGroupNodes(MessageSendRequest request, byte[] distributionMessage, List<ContactJid> participants, boolean force) {
        List<ContactJid> missingParticipants = participants.stream().filter(participant -> force || !request.info().chat().participantsPreKeys().contains(participant)).toList();
        if (missingParticipants.isEmpty()) {
            return CompletableFuture.completedFuture(List.of());
        }
        SenderKeyDistributionMessage whatsappMessage = new SenderKeyDistributionMessage(request.info().chatJid().toString(), distributionMessage);
        byte[] paddedMessage = BytesHelper.messageToBytes(whatsappMessage);
        return ((CompletableFuture)this.querySessions(missingParticipants, force).thenApplyAsync(ignored -> this.createMessageNodes(request, missingParticipants, paddedMessage))).thenApplyAsync(results -> this.savePreKeys(request.info().chat(), missingParticipants, (List<Node>)results));
    }

    private List<Node> savePreKeys(Chat group, List<ContactJid> missingParticipants, List<Node> results) {
        group.participantsPreKeys().addAll(missingParticipants);
        return results;
    }

    protected CompletableFuture<Void> querySessions(List<ContactJid> contacts, boolean force) {
        List<Node> missingSessions = contacts.stream().filter(contact -> force || !this.socketHandler.keys().hasSession(contact.toSignalAddress())).map(contact -> Node.of("user", Map.of("jid", contact))).toList();
        return missingSessions.isEmpty() ? CompletableFuture.completedFuture(null) : this.querySession(missingSessions);
    }

    private CompletableFuture<Void> querySession(List<Node> children) {
        return this.socketHandler.sendQuery("get", "encrypt", Node.of("key", children)).thenAcceptAsync(this::parseSessions);
    }

    private List<Node> createMessageNodes(MessageSendRequest request, List<ContactJid> contacts, byte[] message) {
        return contacts.stream().map(contact -> this.createMessageNode(request, (ContactJid)contact, message, false)).toList();
    }

    private Node createMessageNode(MessageSendRequest request, ContactJid contact, byte[] message, boolean peer) {
        SessionCipher cipher = new SessionCipher(contact.toSignalAddress(), this.socketHandler.keys());
        GroupCipher.CipheredMessageResult encrypted = cipher.encrypt(message);
        Node messageNode = this.createMessageNode(request, encrypted);
        return peer ? messageNode : Node.of("to", Map.of("jid", contact), (Object)messageNode);
    }

    private CompletableFuture<List<ContactJid>> getGroupDevices(GroupMetadata metadata) {
        return this.getDevices(metadata.participantsJids(), false);
    }

    protected CompletableFuture<List<ContactJid>> getDevices(List<ContactJid> contacts, boolean excludeSelf) {
        return this.queryDevices(contacts, excludeSelf).thenApplyAsync(missingDevices -> excludeSelf ? this.toSingleList((List)contacts, (List)missingDevices) : missingDevices);
    }

    private CompletableFuture<List<ContactJid>> queryDevices(List<ContactJid> contacts, boolean excludeSelf) {
        List<Node> contactNodes = contacts.stream().map(contact -> Node.of("user", Map.of("jid", contact))).toList();
        Node body = Node.of("usync", Map.of("sid", UUID.randomUUID().toString(), "mode", "query", "last", "true", "index", "0", "context", "message"), Node.of("query", (Object)Node.of("devices", Map.of("version", "2"))), Node.of("list", contactNodes));
        return this.socketHandler.sendQuery("get", "usync", body).thenApplyAsync(result -> this.parseDevices((Node)result, excludeSelf));
    }

    private List<ContactJid> parseDevices(Node node, boolean excludeSelf) {
        return node.children().stream().map(child -> child.findNode("list")).flatMap(Optional::stream).map(Node::children).flatMap(Collection::stream).map(entry -> this.parseDevice((Node)entry, excludeSelf)).flatMap(Collection::stream).toList();
    }

    private List<ContactJid> parseDevice(Node wrapper, boolean excludeSelf) {
        ContactJid jid = wrapper.attributes().getJid("jid").orElseThrow(() -> new NoSuchElementException("Missing jid for sync device"));
        return wrapper.findNode("devices").orElseThrow(() -> new NoSuchElementException("Missing devices")).findNode("device-list").orElseThrow(() -> new NoSuchElementException("Missing device list")).children().stream().map(child -> this.parseDeviceId((Node)child, jid, excludeSelf)).flatMap(Optional::stream).map(id -> ContactJid.ofDevice(jid.user(), id)).toList();
    }

    private Optional<Integer> parseDeviceId(Node child, ContactJid jid, boolean excludeSelf) {
        int deviceId = child.attributes().getInt("id");
        return !(!child.description().equals("device") || excludeSelf && deviceId == 0 || jid.user().equals(this.socketHandler.store().jid().user()) && this.socketHandler.store().jid().device() == deviceId || deviceId != 0 && !child.attributes().hasKey("key-index")) ? Optional.of(deviceId) : Optional.empty();
    }

    protected void parseSessions(Node node) {
        node.findNode("list").orElseThrow(() -> new IllegalArgumentException("Cannot parse sessions: " + node)).findNodes("user").forEach(this::parseSession);
    }

    private void parseSession(Node node) {
        Validate.isTrue(!node.hasNode("error"), "Erroneous session node", SecurityException.class, new Object[0]);
        ContactJid jid = node.attributes().getJid("jid").orElseThrow(() -> new NoSuchElementException("Missing jid for session"));
        Integer registrationId = node.findNode("registration").map(id -> BytesHelper.bytesToInt(id.contentAsBytes().orElseThrow(), 4)).orElseThrow(() -> new NoSuchElementException("Missing id"));
        byte[] identity = node.findNode("identity").flatMap(Node::contentAsBytes).map(KeyHelper::withHeader).orElseThrow(() -> new NoSuchElementException("Missing identity"));
        SignalSignedKeyPair signedKey = (SignalSignedKeyPair)node.findNode("skey").flatMap(SignalSignedKeyPair::of).orElseThrow(() -> new NoSuchElementException("Missing signed key"));
        SignalSignedKeyPair key = node.findNode("key").flatMap(SignalSignedKeyPair::of).orElse(null);
        SessionBuilder builder = new SessionBuilder(jid.toSignalAddress(), this.socketHandler.keys());
        builder.createOutgoing(registrationId, identity, signedKey, key);
    }

    public synchronized void decode(Node node) {
        this.getOrCreateMessageService().execute(() -> {
            try {
                String businessName = this.getBusinessName(node);
                List<Node> encrypted = node.findNodes("enc");
                if (node.hasNode("unavailable") && !node.hasNode("enc")) {
                    this.decodeMessage(node, null, businessName);
                    return;
                }
                encrypted.forEach(message -> this.decodeMessage(node, (Node)message, businessName));
            }
            catch (Throwable throwable) {
                this.socketHandler.handleFailure(ErrorHandler.Location.MESSAGE, throwable);
            }
        });
    }

    private String getBusinessName(Node node) {
        return node.attributes().getOptionalString("verified_name").or(() -> MessageHandler.getBusinessNameFromNode(node)).orElse(null);
    }

    private static Optional<String> getBusinessNameFromNode(Node node) {
        return node.findNode("verified_name").flatMap(Node::contentAsBytes).map(bytes -> Protobuf.readMessage(bytes, BusinessVerifiedNameCertificate.class)).map(certificate -> certificate.details().name());
    }

    private Node createMessageNode(MessageSendRequest request, GroupCipher.CipheredMessageResult groupMessage) {
        String mediaType = this.getMediaType(request.info().message());
        ConcurrentHashMap<String, Object> attributes = Attributes.of(new Map.Entry[0]).put("v", "2").put("type", groupMessage.type()).put("mediatype", mediaType, Objects::nonNull).toMap();
        return Node.of("enc", attributes, (Object)groupMessage.message());
    }

    private String getMediaType(MessageContainer container) {
        Message content = container.content();
        if (content instanceof ImageMessage) {
            return "image";
        }
        if (content instanceof VideoMessage) {
            VideoMessage videoMessage = (VideoMessage)content;
            return videoMessage.gifPlayback() ? "gif" : "video";
        }
        if (content instanceof AudioMessage) {
            AudioMessage audioMessage = (AudioMessage)content;
            return audioMessage.voiceMessage() ? "ptt" : "audio";
        }
        if (content instanceof ContactMessage) {
            return "vcard";
        }
        if (content instanceof DocumentMessage) {
            return "document";
        }
        if (content instanceof ContactsArrayMessage) {
            return "contact_array";
        }
        if (content instanceof LiveLocationMessage) {
            return "livelocation";
        }
        if (content instanceof StickerMessage) {
            return "sticker";
        }
        if (content instanceof ListMessage) {
            return "list";
        }
        if (content instanceof ListResponseMessage) {
            return "list_response";
        }
        if (content instanceof ButtonsResponseMessage) {
            return "buttons_response";
        }
        if (content instanceof PaymentOrderMessage) {
            return "order";
        }
        if (content instanceof ProductMessage) {
            return "product";
        }
        if (content instanceof NativeFlowResponseMessage) {
            return "native_flow_response";
        }
        if (content instanceof ButtonsMessage) {
            ButtonsMessage buttonsMessage = (ButtonsMessage)content;
            return buttonsMessage.headerType().hasMedia() ? buttonsMessage.headerType().name().toLowerCase() : null;
        }
        return null;
    }

    private void decodeMessage(Node infoNode, Node messageNode, String businessName) {
        try {
            byte[] encodedMessage;
            boolean offline = infoNode.attributes().hasKey("offline");
            String pushName = infoNode.attributes().getNullableString("notify");
            long timestamp = infoNode.attributes().getLong("t");
            String id = infoNode.attributes().getRequiredString("id");
            ContactJid from = infoNode.attributes().getJid("from").orElseThrow(() -> new NoSuchElementException("Missing from"));
            ContactJid recipient = infoNode.attributes().getJid("recipient").orElse(from);
            ContactJid participant = infoNode.attributes().getJid("participant").orElse(null);
            MessageInfo.MessageInfoBuilder messageBuilder = MessageInfo.builder();
            MessageKey.MessageKeyBuilder keyBuilder = MessageKey.builder();
            ContactJid userCompanionJid = this.socketHandler.store().jid();
            if (userCompanionJid == null) {
                return;
            }
            ContactJid receiver = userCompanionJid.toWhatsappJid();
            if (from.hasServer(ContactJid.Server.WHATSAPP) || from.hasServer(ContactJid.Server.USER)) {
                keyBuilder.chatJid(recipient);
                keyBuilder.senderJid(from);
                keyBuilder.fromMe(Objects.equals(from, receiver));
                messageBuilder.senderJid(from);
            } else {
                keyBuilder.chatJid(from);
                keyBuilder.senderJid(Objects.requireNonNull(participant, "Missing participant in group message"));
                keyBuilder.fromMe(Objects.equals(participant.toWhatsappJid(), receiver));
                messageBuilder.senderJid(Objects.requireNonNull(participant, "Missing participant in group message"));
            }
            MessageKey key = keyBuilder.id(id).build();
            if (Objects.equals(key.senderJid().orElse(null), this.socketHandler.store().jid())) {
                this.sendReceipt(infoNode, id, key.chatJid(), key.senderJid().orElse(null), key.fromMe());
                return;
            }
            if (messageNode == null) {
                this.logger.log(System.Logger.Level.WARNING, "Cannot decode message(id: %s, from: %s)".formatted(id, from));
                this.sendReceipt(infoNode, id, key.chatJid(), key.senderJid().orElse(null), key.fromMe());
                return;
            }
            String type = messageNode.attributes().getRequiredString("type");
            MessageDecodeResult decodedMessage = this.decodeMessageBytes(type, encodedMessage = (byte[])messageNode.contentAsBytes().orElse(null), from, participant);
            if (decodedMessage.hasError()) {
                this.logger.log(System.Logger.Level.WARNING, "Cannot decode message(id: %s, from: %s): %s".formatted(id, from, decodedMessage.error().getMessage()));
                this.sendReceipt(infoNode, id, key.chatJid(), key.senderJid().orElse(null), key.fromMe());
                return;
            }
            MessageContainer messageContainer = BytesHelper.bytesToMessage(decodedMessage.message()).unbox();
            MessageInfo info = messageBuilder.key(key).broadcast(key.chatJid().hasServer(ContactJid.Server.BROADCAST)).pushName(pushName).status(MessageStatus.DELIVERED).businessVerifiedName(businessName).timestampSeconds(timestamp).message(messageContainer).build();
            this.attributeMessageReceipt(info);
            this.socketHandler.store().attribute(info);
            this.saveMessage(info, offline);
            this.sendReceipt(infoNode, id, key.chatJid(), key.senderJid().orElse(null), key.fromMe());
            this.socketHandler.onReply(info);
        }
        catch (Throwable throwable) {
            this.socketHandler.handleFailure(ErrorHandler.Location.MESSAGE, throwable);
        }
    }

    private void sendReceipt(Node infoNode, String id, ContactJid chatJid, ContactJid senderJid, boolean fromMe) {
        ContactJid participant = fromMe && senderJid == null ? chatJid : senderJid;
        String category = infoNode.attributes().getString("category");
        String receiptType = this.getReceiptType(category, fromMe);
        this.socketHandler.sendMessageAck(infoNode);
        this.socketHandler.sendReceipt(chatJid, participant, List.of(id), receiptType);
    }

    private String getReceiptType(String category, boolean fromMe) {
        if (Objects.equals(category, "peer")) {
            return "peer_msg";
        }
        if (fromMe) {
            return "sender";
        }
        if (!this.socketHandler.store().online()) {
            return "inactive";
        }
        return null;
    }

    private MessageDecodeResult decodeMessageBytes(String type, byte[] encodedMessage, ContactJid from, ContactJid participant) {
        try {
            if (encodedMessage == null) {
                return new MessageDecodeResult(null, new IllegalArgumentException("Missing encoded message"));
            }
            byte[] result = switch (type) {
                case "skmsg" -> {
                    Objects.requireNonNull(participant, "Cannot decipher skmsg without participant");
                    SenderKeyName senderName = new SenderKeyName(from.toString(), participant.toSignalAddress());
                    GroupCipher signalGroup = new GroupCipher(senderName, this.socketHandler.keys());
                    yield signalGroup.decrypt(encodedMessage);
                }
                case "pkmsg" -> {
                    ContactJid user = from.hasServer(ContactJid.Server.WHATSAPP) ? from : participant;
                    Objects.requireNonNull(user, "Cannot decipher pkmsg without user");
                    SessionCipher session = new SessionCipher(user.toSignalAddress(), this.socketHandler.keys());
                    SignalPreKeyMessage preKey = SignalPreKeyMessage.ofSerialized(encodedMessage);
                    yield session.decrypt(preKey);
                }
                case "msg" -> {
                    ContactJid user = from.hasServer(ContactJid.Server.WHATSAPP) ? from : participant;
                    Objects.requireNonNull(user, "Cannot decipher msg without user");
                    SessionCipher session = new SessionCipher(user.toSignalAddress(), this.socketHandler.keys());
                    SignalMessage signalMessage = SignalMessage.ofSerialized(encodedMessage);
                    yield session.decrypt(signalMessage);
                }
                default -> throw new IllegalArgumentException("Unsupported encoded message type: %s".formatted(type));
            };
            return new MessageDecodeResult(result, null);
        }
        catch (Throwable throwable) {
            return new MessageDecodeResult(null, throwable);
        }
    }

    private void attributeMessageReceipt(MessageInfo info) {
        ContactJid self = this.socketHandler.store().jid().toWhatsappJid();
        if (!info.fromMe() || !info.chatJid().equals(self)) {
            return;
        }
        info.receipt().readTimestampSeconds(info.timestampSeconds());
        info.receipt().deliveredJids().add(self);
        info.receipt().readJids().add(self);
        info.status(MessageStatus.READ);
    }

    private void saveMessage(MessageInfo info, boolean offline) {
        Message message = info.message().content();
        if (message instanceof SenderKeyDistributionMessage) {
            SenderKeyDistributionMessage distributionMessage = (SenderKeyDistributionMessage)message;
            this.handleDistributionMessage(distributionMessage, info.senderJid());
        }
        if (info.chatJid().type() == ContactJid.Type.STATUS) {
            this.socketHandler.store().addStatus(info);
            this.socketHandler.onNewStatus(info);
            return;
        }
        if (info.message().hasCategory(MessageCategory.SERVER)) {
            message = info.message().content();
            if (message instanceof ProtocolMessage) {
                ProtocolMessage protocolMessage = (ProtocolMessage)message;
                this.handleProtocolMessage(info, protocolMessage);
            }
            return;
        }
        boolean result = info.chat().addNewMessage(info);
        if (!result || info.timestampSeconds() <= this.socketHandler.store().initializationTimeStamp()) {
            return;
        }
        if (info.chat().archived() && this.socketHandler.store().unarchiveChats()) {
            info.chat().archived(false);
        }
        info.sender().filter(this::isTyping).ifPresent(sender -> this.socketHandler.onUpdateChatPresence(ContactStatus.AVAILABLE, sender.jid(), info.chat()));
        if (!info.ignore() && !info.fromMe()) {
            info.chat().unreadMessagesCount(info.chat().unreadMessagesCount() + 1);
        }
        this.socketHandler.onNewMessage(info, offline);
    }

    private void handleDistributionMessage(SenderKeyDistributionMessage distributionMessage, ContactJid from) {
        SenderKeyName groupName = new SenderKeyName(distributionMessage.groupId(), from.toSignalAddress());
        GroupBuilder builder = new GroupBuilder(this.socketHandler.keys());
        SignalDistributionMessage message = SignalDistributionMessage.ofSerialized(distributionMessage.data());
        builder.createIncoming(groupName, message);
    }

    private void handleProtocolMessage(MessageInfo info, ProtocolMessage protocolMessage) {
        switch (protocolMessage.protocolType()) {
            case HISTORY_SYNC_NOTIFICATION: {
                this.onHistorySyncNotification(info, protocolMessage);
                break;
            }
            case APP_STATE_SYNC_KEY_SHARE: {
                this.onAppStateSyncKeyShare(protocolMessage);
                break;
            }
            case REVOKE: {
                this.onMessageRevoked(info, protocolMessage);
                break;
            }
            case EPHEMERAL_SETTING: {
                this.onEphemeralSettings(info, protocolMessage);
            }
        }
    }

    private void onEphemeralSettings(MessageInfo info, ProtocolMessage protocolMessage) {
        info.chat().ephemeralMessagesToggleTime(info.timestampSeconds()).ephemeralMessageDuration(ChatEphemeralTimer.of(protocolMessage.ephemeralExpiration()));
        EphemeralSetting setting = new EphemeralSetting((int)protocolMessage.ephemeralExpiration(), info.timestampSeconds());
        this.socketHandler.onSetting(setting);
    }

    private void onMessageRevoked(MessageInfo info, ProtocolMessage protocolMessage) {
        this.socketHandler.store().findMessageById(info.chat(), protocolMessage.key().id()).ifPresent(message -> this.onMessageDeleted(info, (MessageInfo)message));
    }

    private void onAppStateSyncKeyShare(ProtocolMessage protocolMessage) {
        this.socketHandler.keys().addAppKeys(this.socketHandler.store().jid(), protocolMessage.appStateSyncKeyShare().keys());
        this.socketHandler.pullInitialPatches().exceptionallyAsync(throwable -> (Void)this.socketHandler.handleFailure(ErrorHandler.Location.UNKNOWN, (Throwable)throwable));
    }

    private void onHistorySyncNotification(MessageInfo info, ProtocolMessage protocolMessage) {
        if (this.isZeroHistorySyncComplete()) {
            return;
        }
        ((CompletableFuture)this.downloadHistorySync(protocolMessage).thenAcceptAsync(history -> this.onHistoryNotification(info, (HistorySync)history))).exceptionallyAsync(throwable -> (Void)this.socketHandler.handleFailure(ErrorHandler.Location.MESSAGE, (Throwable)throwable));
    }

    private boolean isZeroHistorySyncComplete() {
        return this.socketHandler.store().historyLength() == WebHistoryLength.ZERO && this.historySyncTypes.contains((Object)HistorySync.Type.INITIAL_STATUS_V3) && this.historySyncTypes.contains((Object)HistorySync.Type.PUSH_NAME) && this.historySyncTypes.contains((Object)HistorySync.Type.INITIAL_BOOTSTRAP) && this.historySyncTypes.contains((Object)HistorySync.Type.NON_BLOCKING_DATA);
    }

    private boolean isTyping(Contact sender) {
        return sender.lastKnownPresence() == ContactStatus.COMPOSING || sender.lastKnownPresence() == ContactStatus.RECORDING;
    }

    private CompletableFuture<HistorySync> downloadHistorySync(ProtocolMessage protocolMessage) {
        return ((CompletableFuture)Medias.download(protocolMessage.historySyncNotification()).thenApplyAsync(entry -> (byte[])entry.orElseThrow(() -> new NoSuchElementException("Cannot download history sync")))).thenApplyAsync(result -> Protobuf.readMessage(BytesHelper.decompress(result), HistorySync.class));
    }

    private void onHistoryNotification(MessageInfo info, HistorySync history) {
        this.handleHistorySync(history);
        if (history.progress() != null) {
            this.scheduleTimeoutSync(history);
            this.socketHandler.onHistorySyncProgress(history.progress(), history.syncType() == HistorySync.Type.RECENT);
        }
        this.socketHandler.sendReceipt(info.chatJid(), null, List.of(info.id()), "hist_sync");
    }

    private void scheduleTimeoutSync(HistorySync history) {
        Executor executor = CompletableFuture.delayedExecutor(10L, TimeUnit.SECONDS);
        if (this.historySyncTask != null) {
            this.historySyncTask.cancel(true);
        }
        this.historySyncTask = CompletableFuture.runAsync(() -> this.handleChatsSync(history, true), executor);
    }

    private void onMessageDeleted(MessageInfo info, MessageInfo message) {
        info.chat().removeMessage(message);
        message.revokeTimestampSeconds(Clock.nowSeconds());
        this.socketHandler.onMessageDeleted(message, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleHistorySync(HistorySync history) {
        try {
            switch (history.syncType()) {
                case INITIAL_STATUS_V3: {
                    this.handleInitialStatus(history);
                    return;
                }
                case PUSH_NAME: {
                    this.handlePushNames(history);
                    return;
                }
                case INITIAL_BOOTSTRAP: {
                    this.handleInitialBootstrap(history);
                    return;
                }
                case RECENT: 
                case FULL: {
                    this.deferredGroupQuery.execute();
                    this.handleChatsSync(history, false);
                    return;
                }
                case NON_BLOCKING_DATA: {
                    this.handleNonBlockingData(history);
                    return;
                }
            }
            return;
        }
        finally {
            this.historySyncTypes.add(history.syncType());
        }
    }

    private void handleInitialStatus(HistorySync history) {
        Store store = this.socketHandler.store();
        for (MessageInfo messageInfo : history.statusV3Messages()) {
            store.addStatus(messageInfo);
        }
        this.socketHandler.onStatus();
    }

    private void handlePushNames(HistorySync history) {
        for (PushName pushName : history.pushNames()) {
            this.handNewPushName(pushName);
        }
        this.socketHandler.onContacts();
    }

    private void handNewPushName(PushName pushName) {
        ContactJid jid = ContactJid.of(pushName.id());
        Contact contact = this.socketHandler.store().findContactByJid(jid).orElseGet(() -> this.createNewContact(jid));
        contact.chosenName(pushName.name());
        ContactAction action = new ContactAction(pushName.name(), null, null);
        this.socketHandler.onAction(action, MessageIndexInfo.of("contact", jid, null, true));
    }

    private Contact createNewContact(ContactJid jid) {
        Contact contact = this.socketHandler.store().addContact(jid);
        this.socketHandler.onNewContact(contact);
        return contact;
    }

    private void handleInitialBootstrap(HistorySync history) {
        if (this.socketHandler.store().historyLength() != WebHistoryLength.ZERO) {
            this.historyCache.addAll(history.conversations());
        }
        this.handleConversations(history);
        this.socketHandler.onChats();
    }

    private void handleChatsSync(HistorySync history, boolean forceDone) {
        if (this.socketHandler.store().historyLength() == WebHistoryLength.ZERO) {
            return;
        }
        this.handleConversations(history);
        for (Chat cached : this.historyCache) {
            boolean done;
            Chat chat = this.socketHandler.store().findChatByJid(cached.jid()).orElse(cached);
            boolean bl = done = forceDone || !history.conversations().contains(cached);
            if (done) {
                chat.endOfHistoryTransferType(Chat.EndOfHistoryTransferType.COMPLETE_AND_NO_MORE_MESSAGE_REMAIN_ON_PRIMARY);
            }
            this.socketHandler.onChatRecentMessages(chat, done);
        }
        this.historyCache.removeIf(entry -> !history.conversations().contains(entry));
    }

    private void handleConversations(HistorySync history) {
        Store store = this.socketHandler.store();
        for (Chat chat : history.conversations()) {
            List<PastParticipant> pastParticipants = this.pastParticipantsQueue.remove(chat.jid());
            if (pastParticipants != null) {
                chat.addPastParticipants(pastParticipants);
            }
            if (this.shouldSyncGroupMetadata(chat)) {
                this.attributedGroups.add(chat.jid());
                this.deferredGroupQuery.schedule(() -> this.socketHandler.queryGroupMetadata(chat));
            }
            store.addChat(chat);
        }
    }

    private boolean shouldSyncGroupMetadata(Chat chat) {
        return chat.isGroup() && !this.attributedGroups.contains(chat.jid()) && chat.timestamp().until(ZonedDateTime.now(), ChronoUnit.WEEKS) < 2L;
    }

    private void handleNonBlockingData(HistorySync history) {
        for (PastParticipants pastParticipants : history.pastParticipants()) {
            this.handlePastParticipants(pastParticipants);
        }
    }

    private void handlePastParticipants(PastParticipants pastParticipants) {
        this.socketHandler.store().findChatByJid(pastParticipants.groupJid()).ifPresentOrElse(chat -> chat.addPastParticipants(pastParticipants.pastParticipants()), () -> this.pastParticipantsQueue.put(pastParticipants.groupJid(), pastParticipants.pastParticipants()));
    }

    @SafeVarargs
    private <T> List<T> toSingleList(List<T> ... all) {
        return Stream.of(all).filter(Objects::nonNull).flatMap(Collection::stream).toList();
    }

    protected void dispose() {
        this.historyCache.clear();
        if (this.executor != null && !this.executor.isShutdown()) {
            this.executor.shutdownNow();
        }
        this.historySyncTask = null;
        this.historySyncTypes.clear();
    }

    private record MessageDecodeResult(byte[] message, Throwable error) {
        public boolean hasError() {
            return this.error != null;
        }
    }
}

