/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.socket;

import it.auties.curve25519.Curve25519;
import it.auties.protobuf.base.ProtobufDeserializationException;
import it.auties.whatsapp.api.ClientType;
import it.auties.whatsapp.api.WebHistoryLength;
import it.auties.whatsapp.crypto.Handshake;
import it.auties.whatsapp.model.mobile.PhoneNumber;
import it.auties.whatsapp.model.request.Request;
import it.auties.whatsapp.model.signal.auth.ClientFinish;
import it.auties.whatsapp.model.signal.auth.ClientPayload;
import it.auties.whatsapp.model.signal.auth.Companion;
import it.auties.whatsapp.model.signal.auth.CompanionData;
import it.auties.whatsapp.model.signal.auth.DNSSource;
import it.auties.whatsapp.model.signal.auth.HandshakeMessage;
import it.auties.whatsapp.model.signal.auth.ServerHello;
import it.auties.whatsapp.model.signal.auth.UserAgent;
import it.auties.whatsapp.socket.SocketHandler;
import it.auties.whatsapp.socket.SocketSession;
import it.auties.whatsapp.util.BytesHelper;
import it.auties.whatsapp.util.Protobuf;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

class AuthHandler {
    private final SocketHandler socketHandler;

    protected CompletableFuture<Boolean> login(SocketSession session, byte[] message) {
        try {
            Optional<ServerHello> serverHello = this.readHandshake(message);
            if (serverHello.isEmpty()) {
                return CompletableFuture.completedFuture(false);
            }
            Handshake handshake = new Handshake(this.socketHandler.keys());
            handshake.updateHash(this.socketHandler.keys().ephemeralKeyPair().publicKey());
            handshake.updateHash(serverHello.get().ephemeral());
            byte[] sharedEphemeral = Curve25519.sharedKey((byte[])serverHello.get().ephemeral(), (byte[])this.socketHandler.keys().ephemeralKeyPair().privateKey());
            handshake.mixIntoKey(sharedEphemeral);
            byte[] decodedStaticText = handshake.cipher(serverHello.get().staticText(), false);
            byte[] sharedStatic = Curve25519.sharedKey((byte[])decodedStaticText, (byte[])this.socketHandler.keys().ephemeralKeyPair().privateKey());
            handshake.mixIntoKey(sharedStatic);
            handshake.cipher(serverHello.get().payload(), false);
            byte[] encodedKey = handshake.cipher(this.socketHandler.keys().noiseKeyPair().publicKey(), true);
            byte[] sharedPrivate = Curve25519.sharedKey((byte[])serverHello.get().ephemeral(), (byte[])this.socketHandler.keys().noiseKeyPair().privateKey());
            handshake.mixIntoKey(sharedPrivate);
            HandshakeMessage handshakeMessage = this.createHandshakeMessage(handshake, encodedKey, this.encodeUserPayload());
            return this.sendHandshake(session, handshake, handshakeMessage);
        }
        catch (Throwable throwable) {
            return CompletableFuture.failedFuture(throwable);
        }
    }

    private Optional<ServerHello> readHandshake(byte[] message) {
        try {
            HandshakeMessage handshakeMessage = Protobuf.readMessage(message, HandshakeMessage.class);
            return Optional.ofNullable(handshakeMessage.serverHello());
        }
        catch (ProtobufDeserializationException exception) {
            return Optional.empty();
        }
    }

    private CompletableFuture<Boolean> sendHandshake(SocketSession session, Handshake handshake, HandshakeMessage handshakeMessage) {
        return Request.of(handshakeMessage).sendWithNoResponse(session, this.socketHandler.keys(), this.socketHandler.store()).thenApplyAsync(result -> this.onHandshakeSent(handshake));
    }

    private boolean onHandshakeSent(Handshake handshake) {
        this.socketHandler.keys().clearReadWriteKey();
        handshake.finish();
        return true;
    }

    private HandshakeMessage createHandshakeMessage(Handshake handshake, byte[] encodedKey, byte[] userPayload) {
        byte[] encodedPayload = handshake.cipher(userPayload, true);
        ClientFinish clientFinish = new ClientFinish(encodedKey, encodedPayload);
        return new HandshakeMessage(clientFinish);
    }

    private byte[] encodeUserPayload() {
        UserAgent userAgent = this.createUserAgent();
        ClientPayload.ClientPayloadBuilder builder = this.createUserPayloadBuilder(userAgent);
        return Protobuf.writeMessage(this.finishUserPayload(builder));
    }

    public ClientPayload.ClientPayloadBuilder createUserPayloadBuilder(UserAgent userAgent) {
        return ClientPayload.builder().connectReason(ClientPayload.ClientPayloadConnectReason.USER_ACTIVATED).connectType(ClientPayload.ClientPayloadConnectType.WIFI_UNKNOWN).userAgent(userAgent);
    }

    private UserAgent createUserAgent() {
        boolean mobile = this.socketHandler.store().clientType() == ClientType.MOBILE;
        return UserAgent.builder().appVersion(this.socketHandler.store().version()).osVersion(mobile ? this.socketHandler.store().device().osVersion().toString() : null).device(mobile ? this.socketHandler.store().device().model() : null).manufacturer(mobile ? this.socketHandler.store().device().manufacturer() : null).phoneId(mobile ? this.socketHandler.keys().phoneId() : null).platform(this.getPlatform()).releaseChannel(this.socketHandler.store().releaseChannel()).mcc("000").mnc("000").build();
    }

    private UserAgent.UserAgentPlatform getPlatform() {
        if (!this.socketHandler.store().business()) {
            return this.socketHandler.store().device().osType();
        }
        return switch (this.socketHandler.store().device().osType()) {
            case UserAgent.UserAgentPlatform.ANDROID -> UserAgent.UserAgentPlatform.SMB_ANDROID;
            case UserAgent.UserAgentPlatform.IOS -> UserAgent.UserAgentPlatform.SMB_IOS;
            default -> throw new IllegalStateException("Unexpected platform: " + this.socketHandler.store().device().osType());
        };
    }

    private ClientPayload finishUserPayload(ClientPayload.ClientPayloadBuilder builder) {
        return switch (this.socketHandler.store().clientType()) {
            default -> throw new IncompatibleClassChangeError();
            case ClientType.MOBILE -> {
                Long phoneNumber = this.socketHandler.store().phoneNumber().map(PhoneNumber::number).orElseThrow(() -> new NoSuchElementException("Missing phone number for mobile registration"));
                yield builder.sessionId(this.socketHandler.keys().registrationId()).shortConnect(true).connectAttemptCount(0).device(0).dnsSource(this.getDnsSource()).passive(false).pushName(this.socketHandler.store().name()).username(phoneNumber).build();
            }
            case ClientType.WEB -> this.socketHandler.store().jid() != null ? builder.username(Long.parseLong(this.socketHandler.store().jid().user())).passive(true).device(this.socketHandler.store().jid().device()).build() : builder.regData(this.createRegisterData()).passive(false).build();
        };
    }

    private DNSSource getDnsSource() {
        return DNSSource.builder().appCached(false).dnsMethod(DNSSource.DNSSourceDNSResolutionMethod.SYSTEM).build();
    }

    private CompanionData createRegisterData() {
        CompanionData.CompanionDataBuilder companion = CompanionData.builder().buildHash(this.socketHandler.store().version().toHash()).id(this.socketHandler.keys().encodedRegistrationId()).keyType(BytesHelper.intToBytes(5, 1)).identifier(this.socketHandler.keys().identityKeyPair().publicKey()).signatureId(this.socketHandler.keys().signedKeyPair().encodedId()).signaturePublicKey(this.socketHandler.keys().signedKeyPair().keyPair().publicKey()).signature(this.socketHandler.keys().signedKeyPair().signature());
        if (this.socketHandler.store().clientType() == ClientType.WEB) {
            byte[] props = Protobuf.writeMessage(this.createCompanionProps());
            companion.companion(props);
        }
        return companion.build();
    }

    private Companion createCompanionProps() {
        if (this.socketHandler.store().clientType() != ClientType.WEB) {
            return null;
        }
        return Companion.builder().os(this.socketHandler.store().name()).platformType(this.socketHandler.store().historyLength() == WebHistoryLength.EXTENDED ? Companion.CompanionPropsPlatformType.DESKTOP : Companion.CompanionPropsPlatformType.CHROME).requireFullSync(this.socketHandler.store().historyLength() == WebHistoryLength.EXTENDED).build();
    }

    public AuthHandler(SocketHandler socketHandler) {
        this.socketHandler = socketHandler;
    }
}

