/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.signal.message;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import it.auties.protobuf.base.ProtobufDeserializationException;
import it.auties.protobuf.base.ProtobufInputStream;
import it.auties.protobuf.base.ProtobufOutputStream;
import it.auties.protobuf.base.ProtobufProperty;
import it.auties.protobuf.base.ProtobufType;
import it.auties.whatsapp.model.signal.message.SignalProtocolMessage;
import it.auties.whatsapp.util.BytesHelper;
import it.auties.whatsapp.util.Protobuf;
import java.util.Arrays;
import java.util.function.Function;
import lombok.NonNull;

@JsonDeserialize(builder=SignalMessageBuilder.class)
public final class SignalMessage
implements SignalProtocolMessage {
    private int version;
    @ProtobufProperty(index=1, type=ProtobufType.BYTES)
    private byte @NonNull [] ephemeralPublicKey;
    @ProtobufProperty(index=2, type=ProtobufType.UINT32)
    private Integer counter;
    @ProtobufProperty(index=3, type=ProtobufType.UINT32)
    private Integer previousCounter;
    @ProtobufProperty(index=4, type=ProtobufType.BYTES)
    private byte @NonNull [] ciphertext;
    private byte[] signature;
    private byte[] serialized;

    public SignalMessage(byte @NonNull [] ephemeralPublicKey, int counter, int previousCounter, byte @NonNull [] ciphertext, Function<byte[], byte[]> signer) {
        if (ephemeralPublicKey == null) {
            throw new NullPointerException("ephemeralPublicKey is marked non-null but is null");
        }
        if (ciphertext == null) {
            throw new NullPointerException("ciphertext is marked non-null but is null");
        }
        this.version = 3;
        this.ephemeralPublicKey = ephemeralPublicKey;
        this.counter = counter;
        this.previousCounter = previousCounter;
        this.ciphertext = ciphertext;
        byte[] encodedMessage = BytesHelper.concat(this.serializedVersion(), Protobuf.writeMessage(this));
        this.signature = signer.apply(encodedMessage);
        this.serialized = BytesHelper.concat(encodedMessage, this.signature);
    }

    public static SignalMessage ofSerialized(byte[] serialized) {
        byte[] data = Arrays.copyOfRange(serialized, 1, serialized.length - 8);
        byte[] mac = Arrays.copyOfRange(serialized, serialized.length - 8, serialized.length);
        return Protobuf.readMessage(data, SignalMessage.class).version(BytesHelper.bytesToVersion(serialized[0])).signature(mac).serialized(serialized);
    }

    public static SignalMessageBuilder builder() {
        return new SignalMessageBuilder();
    }

    public SignalMessage(int version, byte @NonNull [] ephemeralPublicKey, Integer counter, Integer previousCounter, byte @NonNull [] ciphertext, byte[] signature, byte[] serialized) {
        if (ephemeralPublicKey == null) {
            throw new NullPointerException("ephemeralPublicKey is marked non-null but is null");
        }
        if (ciphertext == null) {
            throw new NullPointerException("ciphertext is marked non-null but is null");
        }
        this.version = version;
        this.ephemeralPublicKey = ephemeralPublicKey;
        this.counter = counter;
        this.previousCounter = previousCounter;
        this.ciphertext = ciphertext;
        this.signature = signature;
        this.serialized = serialized;
    }

    @Override
    public int version() {
        return this.version;
    }

    public byte @NonNull [] ephemeralPublicKey() {
        return this.ephemeralPublicKey;
    }

    public Integer counter() {
        return this.counter;
    }

    public Integer previousCounter() {
        return this.previousCounter;
    }

    public byte @NonNull [] ciphertext() {
        return this.ciphertext;
    }

    public byte[] signature() {
        return this.signature;
    }

    @Override
    public byte[] serialized() {
        return this.serialized;
    }

    public SignalMessage version(int version) {
        this.version = version;
        return this;
    }

    public SignalMessage ephemeralPublicKey(byte @NonNull [] ephemeralPublicKey) {
        if (ephemeralPublicKey == null) {
            throw new NullPointerException("ephemeralPublicKey is marked non-null but is null");
        }
        this.ephemeralPublicKey = ephemeralPublicKey;
        return this;
    }

    public SignalMessage counter(Integer counter) {
        this.counter = counter;
        return this;
    }

    public SignalMessage previousCounter(Integer previousCounter) {
        this.previousCounter = previousCounter;
        return this;
    }

    public SignalMessage ciphertext(byte @NonNull [] ciphertext) {
        if (ciphertext == null) {
            throw new NullPointerException("ciphertext is marked non-null but is null");
        }
        this.ciphertext = ciphertext;
        return this;
    }

    public SignalMessage signature(byte[] signature) {
        this.signature = signature;
        return this;
    }

    public SignalMessage serialized(byte[] serialized) {
        this.serialized = serialized;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SignalMessage)) {
            return false;
        }
        SignalMessage other = (SignalMessage)o;
        if (this.version() != other.version()) {
            return false;
        }
        Integer this$counter = this.counter();
        Integer other$counter = other.counter();
        if (this$counter == null ? other$counter != null : !((Object)this$counter).equals(other$counter)) {
            return false;
        }
        Integer this$previousCounter = this.previousCounter();
        Integer other$previousCounter = other.previousCounter();
        if (this$previousCounter == null ? other$previousCounter != null : !((Object)this$previousCounter).equals(other$previousCounter)) {
            return false;
        }
        if (!Arrays.equals(this.ephemeralPublicKey(), other.ephemeralPublicKey())) {
            return false;
        }
        if (!Arrays.equals(this.ciphertext(), other.ciphertext())) {
            return false;
        }
        if (!Arrays.equals(this.signature(), other.signature())) {
            return false;
        }
        return Arrays.equals(this.serialized(), other.serialized());
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.version();
        Integer $counter = this.counter();
        result = result * 59 + ($counter == null ? 43 : ((Object)$counter).hashCode());
        Integer $previousCounter = this.previousCounter();
        result = result * 59 + ($previousCounter == null ? 43 : ((Object)$previousCounter).hashCode());
        result = result * 59 + Arrays.hashCode(this.ephemeralPublicKey());
        result = result * 59 + Arrays.hashCode(this.ciphertext());
        result = result * 59 + Arrays.hashCode(this.signature());
        result = result * 59 + Arrays.hashCode(this.serialized());
        return result;
    }

    public String toString() {
        return "SignalMessage(version=" + this.version() + ", ephemeralPublicKey=" + this.ephemeralPublicKey() + ", counter=" + this.counter() + ", previousCounter=" + this.previousCounter() + ", ciphertext=" + this.ciphertext() + ", signature=" + Arrays.toString(this.signature()) + ", serialized=" + Arrays.toString(this.serialized()) + ")";
    }

    public byte[] toEncodedProtobuf() {
        ProtobufOutputStream protobufOutputStream = new ProtobufOutputStream();
        if (this.ephemeralPublicKey != null) {
            protobufOutputStream.writeBytes(1, this.ephemeralPublicKey);
        }
        if (this.previousCounter != null) {
            protobufOutputStream.writeUInt32(3, this.previousCounter);
        }
        if (this.counter != null) {
            protobufOutputStream.writeUInt32(2, this.counter);
        }
        if (this.ciphertext != null) {
            protobufOutputStream.writeBytes(4, this.ciphertext);
        }
        return protobufOutputStream.toByteArray();
    }

    public static SignalMessage ofProtobuf(byte[] byArray) {
        int n;
        SignalMessageBuilder signalMessageBuilder = SignalMessage.builder();
        ProtobufInputStream protobufInputStream = new ProtobufInputStream(byArray);
        block6: while ((n = protobufInputStream.readTag()) != 0) {
            int n2 = n >>> 3;
            int n3 = n & 7;
            switch (n2) {
                case 1: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    signalMessageBuilder.ephemeralPublicKey(protobufInputStream.readBytes());
                    continue block6;
                }
                case 3: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    signalMessageBuilder.previousCounter(protobufInputStream.readInt32());
                    continue block6;
                }
                case 2: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    signalMessageBuilder.counter(protobufInputStream.readInt32());
                    continue block6;
                }
                case 4: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    signalMessageBuilder.ciphertext(protobufInputStream.readBytes());
                    continue block6;
                }
            }
            protobufInputStream.readBytes();
        }
        return signalMessageBuilder.build();
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class SignalMessageBuilder {
        private int version;
        private byte @NonNull [] ephemeralPublicKey;
        private Integer counter;
        private Integer previousCounter;
        private byte @NonNull [] ciphertext;
        private byte[] signature;
        private byte[] serialized;

        SignalMessageBuilder() {
        }

        public SignalMessageBuilder version(int version) {
            this.version = version;
            return this;
        }

        public SignalMessageBuilder ephemeralPublicKey(byte @NonNull [] ephemeralPublicKey) {
            if (ephemeralPublicKey == null) {
                throw new NullPointerException("ephemeralPublicKey is marked non-null but is null");
            }
            this.ephemeralPublicKey = ephemeralPublicKey;
            return this;
        }

        public SignalMessageBuilder counter(Integer counter) {
            this.counter = counter;
            return this;
        }

        public SignalMessageBuilder previousCounter(Integer previousCounter) {
            this.previousCounter = previousCounter;
            return this;
        }

        public SignalMessageBuilder ciphertext(byte @NonNull [] ciphertext) {
            if (ciphertext == null) {
                throw new NullPointerException("ciphertext is marked non-null but is null");
            }
            this.ciphertext = ciphertext;
            return this;
        }

        public SignalMessageBuilder signature(byte[] signature) {
            this.signature = signature;
            return this;
        }

        public SignalMessageBuilder serialized(byte[] serialized) {
            this.serialized = serialized;
            return this;
        }

        public SignalMessage build() {
            return new SignalMessage(this.version, this.ephemeralPublicKey, this.counter, this.previousCounter, this.ciphertext, this.signature, this.serialized);
        }

        public String toString() {
            return "SignalMessage.SignalMessageBuilder(version=" + this.version + ", ephemeralPublicKey=" + this.ephemeralPublicKey + ", counter=" + this.counter + ", previousCounter=" + this.previousCounter + ", ciphertext=" + this.ciphertext + ", signature=" + Arrays.toString(this.signature) + ", serialized=" + Arrays.toString(this.serialized) + ")";
        }
    }
}

