/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.request;

import it.auties.whatsapp.model.request.Attributes;
import it.auties.whatsapp.model.request.Request;
import it.auties.whatsapp.util.Json;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.NonNull;

public record Node(@NonNull String description, @NonNull Attributes attributes, Object content) {
    public Node(@NonNull String description, @NonNull Attributes attributes, Object content) {
        if (description == null) {
            throw new NullPointerException("description is marked non-null but is null");
        }
        if (attributes == null) {
            throw new NullPointerException("attributes is marked non-null but is null");
        }
    }

    public static Node of(@NonNull String description) {
        if (description == null) {
            throw new NullPointerException("description is marked non-null but is null");
        }
        return new Node(description, Attributes.of(new Map.Entry[0]), null);
    }

    public static Node of(@NonNull String description, Object contentOrAttributes) {
        if (description == null) {
            throw new NullPointerException("description is marked non-null but is null");
        }
        if (contentOrAttributes instanceof Attributes) {
            Attributes attributes = (Attributes)contentOrAttributes;
            return new Node(description, attributes, null);
        }
        if (contentOrAttributes instanceof Map) {
            Map attributes = (Map)contentOrAttributes;
            try {
                return new Node(description, Node.getAttributesOrThrow(attributes), null);
            }
            catch (ClassCastException exception) {
                throw new IllegalArgumentException("Unexpected attributes type: " + contentOrAttributes.getClass().getName(), exception);
            }
        }
        if (contentOrAttributes instanceof List) {
            List list = (List)contentOrAttributes;
            try {
                return new Node(description, Attributes.of(new Map.Entry[0]), Node.getNodesOrThrow(list));
            }
            catch (ClassCastException exception) {
                throw new IllegalArgumentException("Unexpected attributes type: " + contentOrAttributes.getClass().getName(), exception);
            }
        }
        if (contentOrAttributes instanceof Node) {
            Node node = (Node)contentOrAttributes;
            return new Node(description, Attributes.of(new Map.Entry[0]), List.of(node));
        }
        return new Node(description, Attributes.of(new Map.Entry[0]), contentOrAttributes);
    }

    public static Node of(@NonNull String description, Node ... content) {
        if (description == null) {
            throw new NullPointerException("description is marked non-null but is null");
        }
        return new Node(description, Attributes.of(new Map.Entry[0]), Node.getNodesOrThrow(content));
    }

    public static Node of(@NonNull String description, Map<String, Object> attributes, Node ... content) {
        if (description == null) {
            throw new NullPointerException("description is marked non-null but is null");
        }
        return Node.of(description, Attributes.of(attributes), Node.getNodesOrThrow(content));
    }

    public static Node of(@NonNull String description, Attributes attributes, Node ... content) {
        if (description == null) {
            throw new NullPointerException("description is marked non-null but is null");
        }
        return new Node(description, attributes, Node.getNodesOrThrow(content));
    }

    public static Node of(@NonNull String description, Map<String, Object> attributes, Object content) {
        if (description == null) {
            throw new NullPointerException("description is marked non-null but is null");
        }
        return Node.of(description, Attributes.of(attributes), content);
    }

    public static Node of(@NonNull String description, Attributes attributes, Object content) {
        if (description == null) {
            throw new NullPointerException("description is marked non-null but is null");
        }
        if (content instanceof List) {
            List list = (List)content;
            try {
                return new Node(description, attributes, Node.getNodesOrThrow(list));
            }
            catch (ClassCastException exception) {
                throw new IllegalArgumentException("Unexpected attributes type: " + content.getClass().getName(), exception);
            }
        }
        if (content instanceof Node) {
            Node node = (Node)content;
            return new Node(description, attributes, List.of(node));
        }
        return new Node(description, attributes, content);
    }

    private static Attributes getAttributesOrThrow(Map<?, ?> attributes) {
        try {
            return Attributes.of(attributes);
        }
        catch (ClassCastException exception) {
            throw new IllegalArgumentException("Unexpected attributes type: " + attributes.getClass().getName(), exception);
        }
    }

    private static Collection<Node> getNodesOrThrow(Node[] entries) {
        if (entries == null) {
            return null;
        }
        return Arrays.stream(entries).filter(Objects::nonNull).toList();
    }

    private static Collection<Node> getNodesOrThrow(Collection<?> entries) {
        try {
            if (entries == null) {
                return null;
            }
            Collection<?> results = entries;
            return results.stream().filter(Objects::nonNull).toList();
        }
        catch (ClassCastException exception) {
            throw new IllegalArgumentException("Unexpected payload type: expected nodes collection", exception);
        }
    }

    public Optional<String> contentAsString() {
        Object object = this.content;
        if (object instanceof String) {
            String string = (String)object;
            return Optional.of(string);
        }
        object = this.content;
        if (object instanceof byte[]) {
            byte[] bytes = (byte[])object;
            return Optional.of(new String(bytes, StandardCharsets.UTF_8));
        }
        return Optional.empty();
    }

    public Optional<byte[]> contentAsBytes() {
        Optional<byte[]> optional;
        Object object = this.content;
        if (object instanceof byte[]) {
            byte[] bytes = (byte[])object;
            optional = Optional.of(bytes);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    public OptionalLong contentAsLong() {
        OptionalLong optionalLong;
        Object object = this.content;
        if (object instanceof Number) {
            Number number = (Number)object;
            optionalLong = OptionalLong.of(number.longValue());
        } else {
            optionalLong = OptionalLong.empty();
        }
        return optionalLong;
    }

    public OptionalDouble contentAsDouble() {
        OptionalDouble optionalDouble;
        Object object = this.content;
        if (object instanceof Number) {
            Number number = (Number)object;
            optionalDouble = OptionalDouble.of(number.doubleValue());
        } else {
            optionalDouble = OptionalDouble.empty();
        }
        return optionalDouble;
    }

    public Optional<Boolean> contentAsBoolean() {
        Object object = this.content;
        if (object instanceof String) {
            String string = (String)object;
            return Optional.of(Boolean.parseBoolean(string.toLowerCase(Locale.ROOT)));
        }
        object = this.content;
        if (object instanceof byte[]) {
            byte[] bytes = (byte[])object;
            return Optional.of(Boolean.parseBoolean(new String(bytes, StandardCharsets.UTF_8).toLowerCase(Locale.ROOT)));
        }
        return Optional.empty();
    }

    public boolean hasNode(String description) {
        return this.children().stream().anyMatch(node -> Objects.equals(node.description(), description));
    }

    public LinkedList<Node> children() {
        if (this.content == null) {
            return new LinkedList<Node>();
        }
        Object object = this.content;
        if (!(object instanceof Collection)) {
            return new LinkedList<Node>();
        }
        Collection collection = (Collection)object;
        return collection.stream().filter(entry -> entry instanceof Node).map(entry -> (Node)entry).collect(Collectors.toCollection(LinkedList::new));
    }

    public boolean hasDescription(@NonNull String description) {
        if (description == null) {
            throw new NullPointerException("description is marked non-null but is null");
        }
        return Objects.equals(this.description(), description);
    }

    public Optional<Node> findNode() {
        return this.children().stream().findFirst();
    }

    public Optional<Node> findNode(String description) {
        return this.children().stream().filter(node -> Objects.equals(node.description(), description)).findFirst();
    }

    public List<Node> findNodes(String description) {
        return this.children().stream().filter(node -> Objects.equals(node.description(), description)).toList();
    }

    public int size() {
        int descriptionSize = 1;
        int attributesSize = 2 * this.attributes.toMap().size();
        int contentSize = this.hasContent() ? 1 : 0;
        return descriptionSize + attributesSize + contentSize;
    }

    public boolean hasContent() {
        return Objects.nonNull(this.content);
    }

    public Request toRequest(Function<Node, Boolean> filter, boolean response) {
        if (response && this.id() == null) {
            this.attributes.put("id", UUID.randomUUID().toString());
        }
        return Request.of(this, filter);
    }

    public String id() {
        return this.attributes.getString("id", null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object other) {
        if (!(other instanceof Node)) return false;
        Node that = (Node)other;
        if (!Objects.equals(this.description(), that.description())) return false;
        if (!Objects.equals(this.attributes(), that.attributes())) return false;
        if (Objects.equals(this.content(), that.content())) return true;
        Object object = this.content();
        if (!(object instanceof byte[])) return false;
        byte[] theseBytes = (byte[])object;
        object = that.content();
        if (!(object instanceof byte[])) return false;
        byte[] thoseBytes = (byte[])object;
        if (!Arrays.equals(theseBytes, thoseBytes)) return false;
        return true;
    }

    @Override
    public String toString() {
        String string;
        String attributes;
        String description = this.description.isBlank() || this.description.isEmpty() ? "" : "description=%s".formatted(this.description);
        String string2 = attributes = this.attributes.toMap().isEmpty() ? "" : ", attributes=%s".formatted(this.attributes.toMap());
        if (this.content == null) {
            string = "";
        } else {
            Object object;
            Object[] objectArray = new Object[1];
            Object object2 = this.content;
            if (object2 instanceof byte[]) {
                byte[] bytes = (byte[])object2;
                object = Arrays.toString(bytes);
            } else {
                object = this.content;
            }
            objectArray[0] = object;
            string = ", content=%s".formatted(objectArray);
        }
        String content = string;
        return "Node[%s%s%s]".formatted(description, attributes, content);
    }

    public String toJson() {
        return Json.writeValueAsString(this, true);
    }
}

