/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.mobile;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.google.i18n.phonenumbers.NumberParseException;
import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.google.i18n.phonenumbers.Phonenumber;
import it.auties.whatsapp.model.contact.ContactJid;
import it.auties.whatsapp.model.mobile.CountryCode;
import java.util.Optional;
import lombok.NonNull;

public record PhoneNumber(@NonNull CountryCode countryCode, long numberWithoutPrefix) {
    public PhoneNumber(@NonNull CountryCode countryCode, long numberWithoutPrefix) {
        if (countryCode == null) {
            throw new NullPointerException("countryCode is marked non-null but is null");
        }
    }

    public static Optional<PhoneNumber> ofNullable(Long phoneNumber) {
        if (phoneNumber == null) {
            return Optional.empty();
        }
        return Optional.of(PhoneNumber.of(phoneNumber));
    }

    public static PhoneNumber of(String phoneNumber) {
        return PhoneNumber.of(Long.parseLong(phoneNumber));
    }

    @JsonCreator
    public static PhoneNumber of(long phoneNumber) {
        try {
            Phonenumber.PhoneNumber parsed = PhoneNumberUtil.getInstance().parse((CharSequence)"+%s".formatted(phoneNumber), null);
            return CountryCode.ofPrefix(String.valueOf(parsed.getCountryCode())).map(countryCode -> new PhoneNumber((CountryCode)((Object)countryCode), parsed.getNationalNumber())).orElseThrow(() -> new IllegalArgumentException("Cannot parse phone number %s".formatted(phoneNumber)));
        }
        catch (NumberParseException | NumberFormatException exception) {
            throw new IllegalArgumentException("Cannot parse phone number %s".formatted(phoneNumber), exception);
        }
    }

    public long number() {
        return Long.parseLong(this.countryCode.prefix() + this.numberWithoutPrefix);
    }

    public String prefix() {
        return this.countryCode.prefix();
    }

    public ContactJid toJid() {
        return ContactJid.of(this.toString());
    }

    @Override
    public String toString() {
        return String.valueOf(this.number());
    }
}

