/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.message.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import it.auties.protobuf.base.ProtobufDeserializationException;
import it.auties.protobuf.base.ProtobufInputStream;
import it.auties.protobuf.base.ProtobufMessage;
import it.auties.protobuf.base.ProtobufName;
import it.auties.protobuf.base.ProtobufOutputStream;
import it.auties.protobuf.base.ProtobufProperty;
import it.auties.protobuf.base.ProtobufType;
import it.auties.whatsapp.model.contact.ContactJid;
import it.auties.whatsapp.util.Clock;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;

@ProtobufName(value="UserReceipt")
@JsonDeserialize(builder=MessageReceiptBuilder.class)
public class MessageReceipt
implements ProtobufMessage {
    @ProtobufProperty(index=2, type=ProtobufType.INT64)
    private Long deliveredTimestampSeconds;
    @ProtobufProperty(index=3, type=ProtobufType.INT64)
    private Long readTimestampSeconds;
    @ProtobufProperty(index=4, type=ProtobufType.INT64)
    private Long playedTimestampSeconds;
    @ProtobufProperty(index=5, type=ProtobufType.STRING, repeated=true, implementation=ContactJid.class)
    private List<ContactJid> deliveredJids;
    @ProtobufProperty(index=6, type=ProtobufType.STRING, repeated=true, implementation=ContactJid.class)
    private List<ContactJid> readJids;

    public static MessageReceipt of() {
        return MessageReceipt.builder().build();
    }

    public ZonedDateTime deliveredTimestamp() {
        return Clock.parseSeconds(this.deliveredTimestampSeconds);
    }

    public ZonedDateTime readTimestamp() {
        return Clock.parseSeconds(this.readTimestampSeconds);
    }

    public ZonedDateTime playedTimestamp() {
        return Clock.parseSeconds(this.playedTimestampSeconds);
    }

    public MessageReceipt readTimestampSeconds(long readTimestampSeconds) {
        if (this.deliveredTimestampSeconds == null) {
            this.deliveredTimestampSeconds = readTimestampSeconds;
        }
        this.readTimestampSeconds = readTimestampSeconds;
        return this;
    }

    public MessageReceipt playedTimestampSeconds(long playedTimestampSeconds) {
        if (this.deliveredTimestampSeconds == null) {
            this.deliveredTimestampSeconds = playedTimestampSeconds;
        }
        if (this.readTimestampSeconds == null) {
            this.readTimestampSeconds = playedTimestampSeconds;
        }
        this.playedTimestampSeconds = playedTimestampSeconds;
        return this;
    }

    private static List<ContactJid> $default$deliveredJids() {
        return new ArrayList<ContactJid>();
    }

    private static List<ContactJid> $default$readJids() {
        return new ArrayList<ContactJid>();
    }

    public static MessageReceiptBuilder builder() {
        return new MessageReceiptBuilder();
    }

    public MessageReceipt(Long deliveredTimestampSeconds, Long readTimestampSeconds, Long playedTimestampSeconds, List<ContactJid> deliveredJids, List<ContactJid> readJids) {
        this.deliveredTimestampSeconds = deliveredTimestampSeconds;
        this.readTimestampSeconds = readTimestampSeconds;
        this.playedTimestampSeconds = playedTimestampSeconds;
        this.deliveredJids = deliveredJids;
        this.readJids = readJids;
    }

    public Long deliveredTimestampSeconds() {
        return this.deliveredTimestampSeconds;
    }

    public Long readTimestampSeconds() {
        return this.readTimestampSeconds;
    }

    public Long playedTimestampSeconds() {
        return this.playedTimestampSeconds;
    }

    public List<ContactJid> deliveredJids() {
        return this.deliveredJids;
    }

    public List<ContactJid> readJids() {
        return this.readJids;
    }

    public MessageReceipt deliveredTimestampSeconds(Long deliveredTimestampSeconds) {
        this.deliveredTimestampSeconds = deliveredTimestampSeconds;
        return this;
    }

    public MessageReceipt deliveredJids(List<ContactJid> deliveredJids) {
        this.deliveredJids = deliveredJids;
        return this;
    }

    public MessageReceipt readJids(List<ContactJid> readJids) {
        this.readJids = readJids;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MessageReceipt)) {
            return false;
        }
        MessageReceipt other = (MessageReceipt)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$deliveredTimestampSeconds = this.deliveredTimestampSeconds();
        Long other$deliveredTimestampSeconds = other.deliveredTimestampSeconds();
        if (this$deliveredTimestampSeconds == null ? other$deliveredTimestampSeconds != null : !((Object)this$deliveredTimestampSeconds).equals(other$deliveredTimestampSeconds)) {
            return false;
        }
        Long this$readTimestampSeconds = this.readTimestampSeconds();
        Long other$readTimestampSeconds = other.readTimestampSeconds();
        if (this$readTimestampSeconds == null ? other$readTimestampSeconds != null : !((Object)this$readTimestampSeconds).equals(other$readTimestampSeconds)) {
            return false;
        }
        Long this$playedTimestampSeconds = this.playedTimestampSeconds();
        Long other$playedTimestampSeconds = other.playedTimestampSeconds();
        if (this$playedTimestampSeconds == null ? other$playedTimestampSeconds != null : !((Object)this$playedTimestampSeconds).equals(other$playedTimestampSeconds)) {
            return false;
        }
        List<ContactJid> this$deliveredJids = this.deliveredJids();
        List<ContactJid> other$deliveredJids = other.deliveredJids();
        if (this$deliveredJids == null ? other$deliveredJids != null : !((Object)this$deliveredJids).equals(other$deliveredJids)) {
            return false;
        }
        List<ContactJid> this$readJids = this.readJids();
        List<ContactJid> other$readJids = other.readJids();
        return !(this$readJids == null ? other$readJids != null : !((Object)this$readJids).equals(other$readJids));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MessageReceipt;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $deliveredTimestampSeconds = this.deliveredTimestampSeconds();
        result = result * 59 + ($deliveredTimestampSeconds == null ? 43 : ((Object)$deliveredTimestampSeconds).hashCode());
        Long $readTimestampSeconds = this.readTimestampSeconds();
        result = result * 59 + ($readTimestampSeconds == null ? 43 : ((Object)$readTimestampSeconds).hashCode());
        Long $playedTimestampSeconds = this.playedTimestampSeconds();
        result = result * 59 + ($playedTimestampSeconds == null ? 43 : ((Object)$playedTimestampSeconds).hashCode());
        List<ContactJid> $deliveredJids = this.deliveredJids();
        result = result * 59 + ($deliveredJids == null ? 43 : ((Object)$deliveredJids).hashCode());
        List<ContactJid> $readJids = this.readJids();
        result = result * 59 + ($readJids == null ? 43 : ((Object)$readJids).hashCode());
        return result;
    }

    public String toString() {
        return "MessageReceipt(deliveredTimestampSeconds=" + this.deliveredTimestampSeconds() + ", readTimestampSeconds=" + this.readTimestampSeconds() + ", playedTimestampSeconds=" + this.playedTimestampSeconds() + ", deliveredJids=" + this.deliveredJids() + ", readJids=" + this.readJids() + ")";
    }

    public byte[] toEncodedProtobuf() {
        ProtobufOutputStream protobufOutputStream = new ProtobufOutputStream();
        if (this.deliveredJids != null) {
            for (ContactJid contactJid : this.deliveredJids) {
                protobufOutputStream.writeString(5, contactJid.toValue());
            }
        }
        if (this.playedTimestampSeconds != null) {
            protobufOutputStream.writeInt64(4, this.playedTimestampSeconds);
        }
        if (this.deliveredTimestampSeconds != null) {
            protobufOutputStream.writeInt64(2, this.deliveredTimestampSeconds);
        }
        if (this.readTimestampSeconds != null) {
            protobufOutputStream.writeInt64(3, this.readTimestampSeconds);
        }
        if (this.readJids != null) {
            for (ContactJid contactJid : this.readJids) {
                protobufOutputStream.writeString(6, contactJid.toValue());
            }
        }
        return protobufOutputStream.toByteArray();
    }

    public static MessageReceipt ofProtobuf(byte[] byArray) {
        int n;
        MessageReceiptBuilder messageReceiptBuilder = MessageReceipt.builder();
        ProtobufInputStream protobufInputStream = new ProtobufInputStream(byArray);
        ArrayList<ContactJid> arrayList = new ArrayList<ContactJid>();
        ArrayList<ContactJid> arrayList2 = new ArrayList<ContactJid>();
        block7: while ((n = protobufInputStream.readTag()) != 0) {
            int n2 = n >>> 3;
            int n3 = n & 7;
            switch (n2) {
                case 5: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    arrayList.add(ContactJid.ofProtobuf(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8)));
                    continue block7;
                }
                case 4: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    messageReceiptBuilder.playedTimestampSeconds(protobufInputStream.readInt64());
                    continue block7;
                }
                case 2: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    messageReceiptBuilder.deliveredTimestampSeconds(protobufInputStream.readInt64());
                    continue block7;
                }
                case 3: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    messageReceiptBuilder.readTimestampSeconds(protobufInputStream.readInt64());
                    continue block7;
                }
                case 6: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    arrayList2.add(ContactJid.ofProtobuf(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8)));
                    continue block7;
                }
            }
            protobufInputStream.readBytes();
        }
        messageReceiptBuilder.deliveredJids(arrayList);
        messageReceiptBuilder.readJids(arrayList2);
        return messageReceiptBuilder.build();
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class MessageReceiptBuilder {
        private Long deliveredTimestampSeconds;
        private Long readTimestampSeconds;
        private Long playedTimestampSeconds;
        private boolean deliveredJids$set;
        private List<ContactJid> deliveredJids$value;
        private boolean readJids$set;
        private List<ContactJid> readJids$value;

        MessageReceiptBuilder() {
        }

        public MessageReceiptBuilder deliveredTimestampSeconds(Long deliveredTimestampSeconds) {
            this.deliveredTimestampSeconds = deliveredTimestampSeconds;
            return this;
        }

        public MessageReceiptBuilder readTimestampSeconds(Long readTimestampSeconds) {
            this.readTimestampSeconds = readTimestampSeconds;
            return this;
        }

        public MessageReceiptBuilder playedTimestampSeconds(Long playedTimestampSeconds) {
            this.playedTimestampSeconds = playedTimestampSeconds;
            return this;
        }

        public MessageReceiptBuilder deliveredJids(List<ContactJid> deliveredJids) {
            this.deliveredJids$value = deliveredJids;
            this.deliveredJids$set = true;
            return this;
        }

        public MessageReceiptBuilder readJids(List<ContactJid> readJids) {
            this.readJids$value = readJids;
            this.readJids$set = true;
            return this;
        }

        public MessageReceipt build() {
            List<ContactJid> deliveredJids$value = this.deliveredJids$value;
            if (!this.deliveredJids$set) {
                deliveredJids$value = MessageReceipt.$default$deliveredJids();
            }
            List<ContactJid> readJids$value = this.readJids$value;
            if (!this.readJids$set) {
                readJids$value = MessageReceipt.$default$readJids();
            }
            return new MessageReceipt(this.deliveredTimestampSeconds, this.readTimestampSeconds, this.playedTimestampSeconds, deliveredJids$value, readJids$value);
        }

        public String toString() {
            return "MessageReceipt.MessageReceiptBuilder(deliveredTimestampSeconds=" + this.deliveredTimestampSeconds + ", readTimestampSeconds=" + this.readTimestampSeconds + ", playedTimestampSeconds=" + this.playedTimestampSeconds + ", deliveredJids$value=" + this.deliveredJids$value + ", readJids$value=" + this.readJids$value + ")";
        }
    }
}

