/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.contact;

import java.util.Arrays;
import java.util.Optional;
import lombok.NonNull;

public enum ContactStatus {
    AVAILABLE,
    UNAVAILABLE,
    COMPOSING,
    RECORDING;


    private static ContactStatus of(int index) {
        return Arrays.stream(ContactStatus.values()).filter(entry -> entry.ordinal() == index).findFirst().orElse(null);
    }

    public static Optional<ContactStatus> of(@NonNull String jsonValue) {
        if (jsonValue == null) {
            throw new NullPointerException("jsonValue is marked non-null but is null");
        }
        return Arrays.stream(ContactStatus.values()).filter(entry -> entry.name().equalsIgnoreCase(jsonValue)).findFirst();
    }

    public String data() {
        return this.name().toLowerCase();
    }
}

