/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.button.template.hydrated;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import it.auties.protobuf.base.ProtobufDeserializationException;
import it.auties.protobuf.base.ProtobufInputStream;
import it.auties.protobuf.base.ProtobufOutputStream;
import it.auties.protobuf.base.ProtobufProperty;
import it.auties.protobuf.base.ProtobufType;
import it.auties.whatsapp.model.button.template.hydrated.HydratedButton;
import it.auties.whatsapp.model.button.template.hydrated.HydratedButtonType;
import it.auties.whatsapp.util.BytesHelper;
import java.nio.charset.StandardCharsets;
import java.util.HexFormat;
import lombok.NonNull;

@JsonDeserialize(builder=HydratedQuickReplyButtonBuilder.class)
public class HydratedQuickReplyButton
implements HydratedButton {
    @ProtobufProperty(index=1, type=ProtobufType.STRING)
    private String text;
    @ProtobufProperty(index=2, type=ProtobufType.STRING)
    private String id;

    public static HydratedQuickReplyButton of(@NonNull String text) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        String id = HexFormat.of().formatHex(BytesHelper.random(6));
        return new HydratedQuickReplyButton(text, id);
    }

    @Override
    public HydratedButtonType buttonType() {
        return HydratedButtonType.QUICK_REPLY;
    }

    public static HydratedQuickReplyButtonBuilder builder() {
        return new HydratedQuickReplyButtonBuilder();
    }

    private HydratedQuickReplyButton(String text, String id) {
        this.text = text;
        this.id = id;
    }

    public static HydratedQuickReplyButton of(String text, String id) {
        return new HydratedQuickReplyButton(text, id);
    }

    @Override
    public String text() {
        return this.text;
    }

    public String id() {
        return this.id;
    }

    public HydratedQuickReplyButton text(String text) {
        this.text = text;
        return this;
    }

    public HydratedQuickReplyButton id(String id) {
        this.id = id;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HydratedQuickReplyButton)) {
            return false;
        }
        HydratedQuickReplyButton other = (HydratedQuickReplyButton)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$text = this.text();
        String other$text = other.text();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        String this$id = this.id();
        String other$id = other.id();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HydratedQuickReplyButton;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $text = this.text();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        String $id = this.id();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    public String toString() {
        return "HydratedQuickReplyButton(text=" + this.text() + ", id=" + this.id() + ")";
    }

    public byte[] toEncodedProtobuf() {
        ProtobufOutputStream protobufOutputStream = new ProtobufOutputStream();
        if (this.id != null) {
            protobufOutputStream.writeString(2, this.id);
        }
        if (this.text != null) {
            protobufOutputStream.writeString(1, this.text);
        }
        return protobufOutputStream.toByteArray();
    }

    public static HydratedQuickReplyButton ofProtobuf(byte[] byArray) {
        int n;
        HydratedQuickReplyButtonBuilder hydratedQuickReplyButtonBuilder = HydratedQuickReplyButton.builder();
        ProtobufInputStream protobufInputStream = new ProtobufInputStream(byArray);
        block4: while ((n = protobufInputStream.readTag()) != 0) {
            int n2 = n >>> 3;
            int n3 = n & 7;
            switch (n2) {
                case 2: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    hydratedQuickReplyButtonBuilder.id(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8));
                    continue block4;
                }
                case 1: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    hydratedQuickReplyButtonBuilder.text(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8));
                    continue block4;
                }
            }
            protobufInputStream.readBytes();
        }
        return hydratedQuickReplyButtonBuilder.build();
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class HydratedQuickReplyButtonBuilder {
        private String text;
        private String id;

        HydratedQuickReplyButtonBuilder() {
        }

        public HydratedQuickReplyButtonBuilder text(String text) {
            this.text = text;
            return this;
        }

        public HydratedQuickReplyButtonBuilder id(String id) {
            this.id = id;
            return this;
        }

        public HydratedQuickReplyButton build() {
            return new HydratedQuickReplyButton(this.text, this.id);
        }

        public String toString() {
            return "HydratedQuickReplyButton.HydratedQuickReplyButtonBuilder(text=" + this.text + ", id=" + this.id + ")";
        }
    }
}

