/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.business;

import it.auties.whatsapp.model.request.Node;
import lombok.NonNull;

public record BusinessHoursEntry(@NonNull String day, @NonNull String mode, long openTime, long closeTime) {
    public BusinessHoursEntry(@NonNull String day, @NonNull String mode, long openTime, long closeTime) {
        if (day == null) {
            throw new NullPointerException("day is marked non-null but is null");
        }
        if (mode == null) {
            throw new NullPointerException("mode is marked non-null but is null");
        }
    }

    public static BusinessHoursEntry of(@NonNull Node node) {
        if (node == null) {
            throw new NullPointerException("node is marked non-null but is null");
        }
        return new BusinessHoursEntry(node.attributes().getString("day_of_week"), node.attributes().getString("mode"), node.attributes().getLong("open_time"), node.attributes().getLong("close_time"));
    }

    public boolean isAlwaysOpen() {
        return this.openTime == 0L && this.closeTime == 0L;
    }
}

