/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.business;

import it.auties.whatsapp.model.business.BusinessCatalogEntry;
import it.auties.whatsapp.model.request.Node;
import java.util.List;
import java.util.NoSuchElementException;
import lombok.NonNull;

public record BusinessCollectionEntry(@NonNull String id, @NonNull String name, @NonNull List<BusinessCatalogEntry> products) {
    public BusinessCollectionEntry(@NonNull String id, @NonNull String name, @NonNull List<BusinessCatalogEntry> products) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (products == null) {
            throw new NullPointerException("products is marked non-null but is null");
        }
    }

    public static BusinessCollectionEntry of(@NonNull Node node) {
        if (node == null) {
            throw new NullPointerException("node is marked non-null but is null");
        }
        String id = (String)node.findNode("id").flatMap(Node::contentAsString).orElseThrow(() -> new NoSuchElementException("Missing id from business collections"));
        String name = (String)node.findNode("name").flatMap(Node::contentAsString).orElseThrow(() -> new NoSuchElementException("Missing name from business collections"));
        List<BusinessCatalogEntry> products = node.findNodes("product").stream().map(BusinessCatalogEntry::of).toList();
        return new BusinessCollectionEntry(id, name, products);
    }
}

