/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.action;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import it.auties.protobuf.base.ProtobufDeserializationException;
import it.auties.protobuf.base.ProtobufInputStream;
import it.auties.protobuf.base.ProtobufName;
import it.auties.protobuf.base.ProtobufOutputStream;
import it.auties.protobuf.base.ProtobufProperty;
import it.auties.protobuf.base.ProtobufType;
import it.auties.whatsapp.binary.BinaryPatchType;
import it.auties.whatsapp.model.action.Action;
import it.auties.whatsapp.util.Clock;
import java.time.ZonedDateTime;

@ProtobufName(value="SubscriptionAction")
@JsonDeserialize(builder=SubscriptionActionBuilder.class)
public final class SubscriptionAction
implements Action {
    @ProtobufProperty(index=1, name="isDeactivated", type=ProtobufType.BOOL)
    private boolean deactivated;
    @ProtobufProperty(index=2, name="isAutoRenewing", type=ProtobufType.BOOL)
    private boolean autoRenewing;
    @ProtobufProperty(index=3, name="expirationDate", type=ProtobufType.INT64)
    private long expirationDateSeconds;

    public ZonedDateTime messageTimestamp() {
        return Clock.parseSeconds(this.expirationDateSeconds);
    }

    @Override
    public String indexName() {
        return "subscription";
    }

    @Override
    public int actionVersion() {
        return 1;
    }

    @Override
    public BinaryPatchType actionType() {
        return null;
    }

    public static SubscriptionActionBuilder builder() {
        return new SubscriptionActionBuilder();
    }

    public SubscriptionAction(boolean deactivated, boolean autoRenewing, long expirationDateSeconds) {
        this.deactivated = deactivated;
        this.autoRenewing = autoRenewing;
        this.expirationDateSeconds = expirationDateSeconds;
    }

    public boolean deactivated() {
        return this.deactivated;
    }

    public boolean autoRenewing() {
        return this.autoRenewing;
    }

    public long expirationDateSeconds() {
        return this.expirationDateSeconds;
    }

    public SubscriptionAction deactivated(boolean deactivated) {
        this.deactivated = deactivated;
        return this;
    }

    public SubscriptionAction autoRenewing(boolean autoRenewing) {
        this.autoRenewing = autoRenewing;
        return this;
    }

    public SubscriptionAction expirationDateSeconds(long expirationDateSeconds) {
        this.expirationDateSeconds = expirationDateSeconds;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SubscriptionAction)) {
            return false;
        }
        SubscriptionAction other = (SubscriptionAction)o;
        if (this.deactivated() != other.deactivated()) {
            return false;
        }
        if (this.autoRenewing() != other.autoRenewing()) {
            return false;
        }
        return this.expirationDateSeconds() == other.expirationDateSeconds();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.deactivated() ? 79 : 97);
        result = result * 59 + (this.autoRenewing() ? 79 : 97);
        long $expirationDateSeconds = this.expirationDateSeconds();
        result = result * 59 + (int)($expirationDateSeconds >>> 32 ^ $expirationDateSeconds);
        return result;
    }

    public String toString() {
        return "SubscriptionAction(deactivated=" + this.deactivated() + ", autoRenewing=" + this.autoRenewing() + ", expirationDateSeconds=" + this.expirationDateSeconds() + ")";
    }

    public byte[] toEncodedProtobuf() {
        ProtobufOutputStream protobufOutputStream = new ProtobufOutputStream();
        protobufOutputStream.writeInt64(3, this.expirationDateSeconds);
        protobufOutputStream.writeBool(1, this.deactivated);
        protobufOutputStream.writeBool(2, this.autoRenewing);
        return protobufOutputStream.toByteArray();
    }

    public static SubscriptionAction ofProtobuf(byte[] byArray) {
        int n;
        SubscriptionActionBuilder subscriptionActionBuilder = SubscriptionAction.builder();
        ProtobufInputStream protobufInputStream = new ProtobufInputStream(byArray);
        block5: while ((n = protobufInputStream.readTag()) != 0) {
            int n2 = n >>> 3;
            int n3 = n & 7;
            switch (n2) {
                case 3: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    subscriptionActionBuilder.expirationDateSeconds(protobufInputStream.readInt64());
                    continue block5;
                }
                case 1: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    subscriptionActionBuilder.deactivated(protobufInputStream.readBool());
                    continue block5;
                }
                case 2: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    subscriptionActionBuilder.autoRenewing(protobufInputStream.readBool());
                    continue block5;
                }
            }
            protobufInputStream.readBytes();
        }
        return subscriptionActionBuilder.build();
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class SubscriptionActionBuilder {
        private boolean deactivated;
        private boolean autoRenewing;
        private long expirationDateSeconds;

        SubscriptionActionBuilder() {
        }

        public SubscriptionActionBuilder deactivated(boolean deactivated) {
            this.deactivated = deactivated;
            return this;
        }

        public SubscriptionActionBuilder autoRenewing(boolean autoRenewing) {
            this.autoRenewing = autoRenewing;
            return this;
        }

        public SubscriptionActionBuilder expirationDateSeconds(long expirationDateSeconds) {
            this.expirationDateSeconds = expirationDateSeconds;
            return this;
        }

        public SubscriptionAction build() {
            return new SubscriptionAction(this.deactivated, this.autoRenewing, this.expirationDateSeconds);
        }

        public String toString() {
            return "SubscriptionAction.SubscriptionActionBuilder(deactivated=" + this.deactivated + ", autoRenewing=" + this.autoRenewing + ", expirationDateSeconds=" + this.expirationDateSeconds + ")";
        }
    }
}

