/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.crypto;

import io.netty.buffer.ByteBuf;
import it.auties.whatsapp.util.BytesHelper;
import lombok.NonNull;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.modes.GCMBlockCipher;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.KeyParameter;

public final class AesGmc {
    private static final int NONCE = 128;

    public static byte[] encrypt(long iv, byte @NonNull [] input, byte @NonNull [] key) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return AesGmc.encrypt(iv, input, key, null);
    }

    public static byte[] encrypt(long iv, byte @NonNull [] input, byte @NonNull [] key, byte[] additionalData) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return AesGmc.cipher(AesGmc.toIv(iv), input, key, additionalData, true);
    }

    private static byte[] cipher(byte @NonNull [] iv, byte @NonNull [] input, byte @NonNull [] key, byte[] additionalData, boolean encrypt) {
        if (iv == null) {
            throw new NullPointerException("iv is marked non-null but is null");
        }
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        try {
            GCMBlockCipher cipher = new GCMBlockCipher((BlockCipher)new AESEngine());
            AEADParameters parameters = new AEADParameters(new KeyParameter(key), 128, iv, additionalData);
            cipher.init(encrypt, (CipherParameters)parameters);
            int outputLength = cipher.getOutputSize(input.length);
            byte[] output = new byte[outputLength];
            int outputOffset = cipher.processBytes(input, 0, input.length, output, 0);
            cipher.doFinal(output, outputOffset);
            return output;
        }
        catch (InvalidCipherTextException exception) {
            throw new RuntimeException("Cannot %s data".formatted(encrypt ? "encrypt" : "decrypt"), exception);
        }
    }

    private static byte[] toIv(long iv) {
        ByteBuf buffer = BytesHelper.newBuffer();
        buffer.writeBytes(new byte[4]);
        buffer.writeLong(iv);
        return BytesHelper.readBuffer(buffer);
    }

    public static byte[] decrypt(long iv, byte @NonNull [] input, byte @NonNull [] key) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return AesGmc.decrypt(iv, input, key, null);
    }

    public static byte[] decrypt(long iv, byte @NonNull [] input, byte @NonNull [] key, byte[] additionalData) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return AesGmc.cipher(AesGmc.toIv(iv), input, key, additionalData, false);
    }

    public static byte[] encrypt(byte @NonNull [] iv, byte @NonNull [] input, byte @NonNull [] key, byte[] additionalData) {
        if (iv == null) {
            throw new NullPointerException("iv is marked non-null but is null");
        }
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return AesGmc.cipher(iv, input, key, additionalData, true);
    }

    public static byte[] encrypt(byte @NonNull [] iv, byte @NonNull [] input, byte @NonNull [] key) {
        if (iv == null) {
            throw new NullPointerException("iv is marked non-null but is null");
        }
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return AesGmc.cipher(iv, input, key, null, true);
    }

    public static byte[] decrypt(byte @NonNull [] iv, byte @NonNull [] input, byte @NonNull [] key, byte[] additionalData) {
        if (iv == null) {
            throw new NullPointerException("iv is marked non-null but is null");
        }
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return AesGmc.cipher(iv, input, key, additionalData, false);
    }

    private AesGmc() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

