/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.controller;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import it.auties.whatsapp.api.ClientType;
import it.auties.whatsapp.binary.BinaryPatchType;
import it.auties.whatsapp.controller.Controller;
import it.auties.whatsapp.controller.ControllerSerializer;
import it.auties.whatsapp.controller.DefaultControllerSerializer;
import it.auties.whatsapp.model.contact.ContactJid;
import it.auties.whatsapp.model.mobile.PhoneNumber;
import it.auties.whatsapp.model.signal.auth.SignedDeviceIdentity;
import it.auties.whatsapp.model.signal.keypair.SignalKeyPair;
import it.auties.whatsapp.model.signal.keypair.SignalPreKeyPair;
import it.auties.whatsapp.model.signal.keypair.SignalSignedKeyPair;
import it.auties.whatsapp.model.signal.sender.SenderKeyName;
import it.auties.whatsapp.model.signal.sender.SenderKeyRecord;
import it.auties.whatsapp.model.signal.session.Session;
import it.auties.whatsapp.model.signal.session.SessionAddress;
import it.auties.whatsapp.model.sync.AppStateSyncKey;
import it.auties.whatsapp.model.sync.LTHashState;
import it.auties.whatsapp.util.BytesHelper;
import it.auties.whatsapp.util.KeyHelper;
import it.auties.whatsapp.util.Spec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import lombok.NonNull;

@JsonDeserialize(builder=KeysBuilderImpl.class)
public final class Keys
extends Controller<Keys> {
    private int registrationId;
    @NonNull
    private SignalKeyPair noiseKeyPair;
    @NonNull
    private SignalKeyPair ephemeralKeyPair;
    @NonNull
    private SignalKeyPair identityKeyPair;
    private SignalSignedKeyPair signedKeyPair;
    private byte[] signedKeyIndex;
    private long signedKeyIndexTimestamp;
    @NonNull
    private ArrayList<SignalPreKeyPair> preKeys;
    private SignalKeyPair companionKeyPair;
    private byte @NonNull [] prologue;
    private String phoneId;
    private String deviceId;
    private String recoveryToken;
    private SignedDeviceIdentity companionIdentity;
    @NonNull
    private Map<SenderKeyName, SenderKeyRecord> senderKeys;
    @NonNull
    private Map<ContactJid, LinkedList<AppStateSyncKey>> appStateKeys;
    @NonNull
    private Map<SessionAddress, Session> sessions;
    @NonNull
    private Map<ContactJid, Map<BinaryPatchType, LTHashState>> hashStates;
    private boolean registered;
    private boolean businessCertificate;
    private boolean initialAppSync;
    @JsonIgnore
    @NonNull
    private AtomicLong writeCounter;
    @JsonIgnore
    @NonNull
    private AtomicLong readCounter;
    @JsonIgnore
    private byte[] writeKey;
    @JsonIgnore
    private byte[] readKey;

    public static Keys of(UUID uuid, long phoneNumber, byte[] publicKey, byte[] privateKey, byte[] messagePublicKey, byte[] messagePrivateKey, byte[] registrationId) {
        Controller result = ((KeysBuilder)((KeysBuilder)((KeysBuilder)((KeysBuilder)((Controller.ControllerBuilder)((KeysBuilder)((KeysBuilder)((KeysBuilder)Keys.builder().serializer(DefaultControllerSerializer.instance())).phoneNumber(PhoneNumber.ofNullable(phoneNumber).orElse(null))).noiseKeyPair(new SignalKeyPair(publicKey, privateKey))).identityKeyPair(new SignalKeyPair(messagePublicKey, messagePrivateKey))).uuid(Objects.requireNonNullElseGet(uuid, UUID::randomUUID))).clientType(ClientType.MOBILE)).prologue(Spec.Whatsapp.APP_PROLOGUE)).registered(true)).build();
        ((Keys)result).signedKeyPair(SignalSignedKeyPair.of(((Keys)result).registrationId(), ((Keys)result).identityKeyPair()));
        ((Keys)result).serialize(true);
        return result;
    }

    public static Keys of(UUID uuid, @NonNull ClientType clientType) {
        if (clientType == null) {
            throw new NullPointerException("clientType is marked non-null but is null");
        }
        return Keys.of(uuid, clientType, DefaultControllerSerializer.instance());
    }

    public static Keys of(UUID uuid, @NonNull ClientType clientType, @NonNull ControllerSerializer serializer) {
        if (clientType == null) {
            throw new NullPointerException("clientType is marked non-null but is null");
        }
        if (serializer == null) {
            throw new NullPointerException("serializer is marked non-null but is null");
        }
        return Keys.ofNullable(uuid, clientType, serializer).orElseGet(() -> Keys.random(uuid, null, clientType, serializer, new String[0]));
    }

    public static Optional<Keys> ofNullable(UUID uuid, @NonNull ClientType clientType) {
        if (clientType == null) {
            throw new NullPointerException("clientType is marked non-null but is null");
        }
        return Keys.ofNullable(uuid, clientType, DefaultControllerSerializer.instance());
    }

    public static Optional<Keys> ofNullable(UUID uuid, @NonNull ClientType clientType, @NonNull ControllerSerializer serializer) {
        if (clientType == null) {
            throw new NullPointerException("clientType is marked non-null but is null");
        }
        if (serializer == null) {
            throw new NullPointerException("serializer is marked non-null but is null");
        }
        if (uuid == null) {
            return Optional.empty();
        }
        return serializer.deserializeKeys(clientType, uuid);
    }

    public static Keys of(UUID uuid, long phoneNumber, @NonNull ClientType clientType) {
        if (clientType == null) {
            throw new NullPointerException("clientType is marked non-null but is null");
        }
        return Keys.of(uuid, phoneNumber, clientType, DefaultControllerSerializer.instance());
    }

    public static Keys of(UUID uuid, long phoneNumber, @NonNull ClientType clientType, @NonNull ControllerSerializer serializer) {
        if (clientType == null) {
            throw new NullPointerException("clientType is marked non-null but is null");
        }
        if (serializer == null) {
            throw new NullPointerException("serializer is marked non-null but is null");
        }
        return Keys.ofNullable(phoneNumber, clientType, serializer).orElseGet(() -> Keys.random(uuid, (Long)phoneNumber, clientType, serializer, new String[0]));
    }

    public static Optional<Keys> ofNullable(Long phoneNumber, @NonNull ClientType clientType) {
        if (clientType == null) {
            throw new NullPointerException("clientType is marked non-null but is null");
        }
        return Keys.ofNullable(phoneNumber, clientType, DefaultControllerSerializer.instance());
    }

    public static Optional<Keys> ofNullable(Long phoneNumber, @NonNull ClientType clientType, @NonNull ControllerSerializer serializer) {
        if (clientType == null) {
            throw new NullPointerException("clientType is marked non-null but is null");
        }
        if (serializer == null) {
            throw new NullPointerException("serializer is marked non-null but is null");
        }
        if (phoneNumber == null) {
            return Optional.empty();
        }
        return serializer.deserializeKeys(clientType, phoneNumber);
    }

    public static Keys of(UUID uuid, String alias, @NonNull ClientType clientType) {
        if (clientType == null) {
            throw new NullPointerException("clientType is marked non-null but is null");
        }
        return Keys.of(uuid, alias, clientType, DefaultControllerSerializer.instance());
    }

    public static Keys of(UUID uuid, String alias, @NonNull ClientType clientType, @NonNull ControllerSerializer serializer) {
        if (clientType == null) {
            throw new NullPointerException("clientType is marked non-null but is null");
        }
        if (serializer == null) {
            throw new NullPointerException("serializer is marked non-null but is null");
        }
        return Keys.ofNullable(alias, clientType, serializer).orElseGet(() -> Keys.random(uuid, null, clientType, serializer, alias));
    }

    public static Optional<Keys> ofNullable(String alias, @NonNull ClientType clientType) {
        if (clientType == null) {
            throw new NullPointerException("clientType is marked non-null but is null");
        }
        return Keys.ofNullable(alias, clientType, DefaultControllerSerializer.instance());
    }

    public static Optional<Keys> ofNullable(String alias, @NonNull ClientType clientType, @NonNull ControllerSerializer serializer) {
        if (clientType == null) {
            throw new NullPointerException("clientType is marked non-null but is null");
        }
        if (serializer == null) {
            throw new NullPointerException("serializer is marked non-null but is null");
        }
        if (alias == null) {
            return Optional.empty();
        }
        return serializer.deserializeKeys(clientType, alias);
    }

    public static Keys random(UUID uuid, Long phoneNumber, @NonNull ClientType clientType, String ... alias) {
        if (clientType == null) {
            throw new NullPointerException("clientType is marked non-null but is null");
        }
        return Keys.random(uuid, phoneNumber, clientType, DefaultControllerSerializer.instance(), new String[0]);
    }

    public static Keys random(UUID uuid, Long phoneNumber, @NonNull ClientType clientType, @NonNull ControllerSerializer serializer, String ... alias) {
        if (clientType == null) {
            throw new NullPointerException("clientType is marked non-null but is null");
        }
        if (serializer == null) {
            throw new NullPointerException("serializer is marked non-null but is null");
        }
        Controller result = ((KeysBuilder)((KeysBuilder)((KeysBuilder)((KeysBuilder)((KeysBuilder)((KeysBuilder)Keys.builder().alias(Objects.requireNonNullElseGet(Arrays.asList(alias), ArrayList::new))).phoneNumber(PhoneNumber.ofNullable(phoneNumber).orElse(null))).serializer(serializer)).uuid(Objects.requireNonNullElseGet(uuid, UUID::randomUUID))).clientType(clientType)).prologue(clientType == ClientType.WEB ? Spec.Whatsapp.WEB_PROLOGUE : Spec.Whatsapp.APP_PROLOGUE)).build();
        ((Keys)result).signedKeyPair(SignalSignedKeyPair.of(((Keys)result).registrationId(), ((Keys)result).identityKeyPair()));
        ((Keys)result).serialize(true);
        return result;
    }

    public byte[] encodedRegistrationId() {
        return BytesHelper.intToBytes(this.registrationId(), 4);
    }

    public void clearReadWriteKey() {
        this.writeKey = null;
        this.writeCounter.set(0L);
        this.readCounter.set(0L);
    }

    public boolean hasPreKeys() {
        return !this.preKeys.isEmpty();
    }

    public SenderKeyRecord findSenderKeyByName(@NonNull SenderKeyName name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return Objects.requireNonNullElseGet(this.senderKeys.get(name), () -> {
            SenderKeyRecord record = new SenderKeyRecord();
            this.senderKeys.put(name, record);
            return record;
        });
    }

    public Optional<Session> findSessionByAddress(@NonNull SessionAddress address) {
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        return Optional.ofNullable(this.sessions.get(address));
    }

    public Optional<SignalSignedKeyPair> findSignedKeyPairById(int id) {
        return id == this.signedKeyPair.id() ? Optional.of(this.signedKeyPair) : Optional.empty();
    }

    public Optional<SignalPreKeyPair> findPreKeyById(Integer id) {
        return id == null ? Optional.empty() : this.preKeys.stream().filter(preKey -> preKey.id() == id.intValue()).findFirst();
    }

    public Optional<AppStateSyncKey> findAppKeyById(@NonNull ContactJid jid, byte[] id) {
        if (jid == null) {
            throw new NullPointerException("jid is marked non-null but is null");
        }
        return Objects.requireNonNull(this.appStateKeys.get(jid), "Missing keys").stream().filter(preKey -> preKey.keyId() != null && Arrays.equals(preKey.keyId().keyId(), id)).findFirst();
    }

    public Optional<LTHashState> findHashStateByName(@NonNull ContactJid device, @NonNull BinaryPatchType patchType) {
        if (device == null) {
            throw new NullPointerException("device is marked non-null but is null");
        }
        if (patchType == null) {
            throw new NullPointerException("patchType is marked non-null but is null");
        }
        return Optional.ofNullable(this.hashStates.get(device)).map(entry -> (LTHashState)entry.get((Object)patchType));
    }

    public boolean hasTrust(@NonNull SessionAddress address, byte[] identityKey) {
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        return true;
    }

    public boolean hasSession(@NonNull SessionAddress address) {
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        return this.sessions.containsKey(address);
    }

    public Keys putSession(@NonNull SessionAddress address, @NonNull Session record) {
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        if (record == null) {
            throw new NullPointerException("record is marked non-null but is null");
        }
        this.sessions.put(address, record);
        return this;
    }

    public Keys putState(@NonNull ContactJid device, @NonNull LTHashState state) {
        if (device == null) {
            throw new NullPointerException("device is marked non-null but is null");
        }
        if (state == null) {
            throw new NullPointerException("state is marked non-null but is null");
        }
        Map oldData = Objects.requireNonNullElseGet(this.hashStates.get(device), HashMap::new);
        oldData.put(state.name(), state);
        this.hashStates.put(device, oldData);
        return this;
    }

    public Keys addAppKeys(@NonNull ContactJid jid, @NonNull Collection<AppStateSyncKey> keys) {
        if (jid == null) {
            throw new NullPointerException("jid is marked non-null but is null");
        }
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        this.appStateKeys.put(jid, new LinkedList<AppStateSyncKey>(keys));
        return this;
    }

    public AppStateSyncKey getLatestAppKey(@NonNull ContactJid jid) {
        if (jid == null) {
            throw new NullPointerException("jid is marked non-null but is null");
        }
        LinkedList<AppStateSyncKey> keys = Objects.requireNonNull(this.appStateKeys.get(jid), "Missing keys");
        return keys.getLast();
    }

    public LinkedList<AppStateSyncKey> getAppKeys(@NonNull ContactJid jid) {
        if (jid == null) {
            throw new NullPointerException("jid is marked non-null but is null");
        }
        return Objects.requireNonNullElseGet(this.appStateKeys.get(jid), LinkedList::new);
    }

    public Keys addPreKey(SignalPreKeyPair preKey) {
        this.preKeys.add(preKey);
        return this;
    }

    public long writeCounter(boolean increment) {
        return increment ? this.writeCounter.getAndIncrement() : this.writeCounter.get();
    }

    public long readCounter(boolean increment) {
        return increment ? this.readCounter.getAndIncrement() : this.readCounter.get();
    }

    public int lastPreKeyId() {
        return this.preKeys.isEmpty() ? 0 : this.preKeys.get(this.preKeys.size() - 1).id();
    }

    @JsonSetter
    private void defaultSignedKey() {
        this.signedKeyPair = SignalSignedKeyPair.of(this.registrationId, this.identityKeyPair);
    }

    public Keys companionIdentity(SignedDeviceIdentity companionIdentity) {
        this.companionIdentity = companionIdentity;
        return this;
    }

    public Optional<SignedDeviceIdentity> companionIdentity() {
        return Optional.ofNullable(this.companionIdentity);
    }

    public Collection<SignalPreKeyPair> preKeys() {
        return Collections.unmodifiableList(this.preKeys);
    }

    @Override
    public void dispose() {
        this.serialize(false);
    }

    @Override
    public void serialize(boolean async) {
        this.serializer.serializeKeys(this, async);
    }

    private static int $default$registrationId() {
        return KeyHelper.registrationId();
    }

    private static SignalKeyPair $default$noiseKeyPair() {
        return SignalKeyPair.random();
    }

    private static SignalKeyPair $default$ephemeralKeyPair() {
        return SignalKeyPair.random();
    }

    private static SignalKeyPair $default$identityKeyPair() {
        return SignalKeyPair.random();
    }

    private static ArrayList<SignalPreKeyPair> $default$preKeys() {
        return new ArrayList<SignalPreKeyPair>();
    }

    private static SignalKeyPair $default$companionKeyPair() {
        return SignalKeyPair.random();
    }

    private static String $default$phoneId() {
        return KeyHelper.phoneId();
    }

    private static String $default$deviceId() {
        return KeyHelper.deviceId();
    }

    private static String $default$recoveryToken() {
        return KeyHelper.identityId();
    }

    private static Map<SenderKeyName, SenderKeyRecord> $default$senderKeys() {
        return new ConcurrentHashMap<SenderKeyName, SenderKeyRecord>();
    }

    private static Map<ContactJid, LinkedList<AppStateSyncKey>> $default$appStateKeys() {
        return new ConcurrentHashMap<ContactJid, LinkedList<AppStateSyncKey>>();
    }

    private static Map<SessionAddress, Session> $default$sessions() {
        return new ConcurrentHashMap<SessionAddress, Session>();
    }

    private static Map<ContactJid, Map<BinaryPatchType, LTHashState>> $default$hashStates() {
        return new ConcurrentHashMap<ContactJid, Map<BinaryPatchType, LTHashState>>();
    }

    private static boolean $default$registered() {
        return false;
    }

    private static boolean $default$businessCertificate() {
        return false;
    }

    private static boolean $default$initialAppSync() {
        return false;
    }

    private static AtomicLong $default$writeCounter() {
        return new AtomicLong();
    }

    private static AtomicLong $default$readCounter() {
        return new AtomicLong();
    }

    protected Keys(KeysBuilder<?, ?> b) {
        super(b);
        this.registrationId = b.registrationId$set ? b.registrationId$value : Keys.$default$registrationId();
        this.noiseKeyPair = b.noiseKeyPair$set ? b.noiseKeyPair$value : Keys.$default$noiseKeyPair();
        if (this.noiseKeyPair == null) {
            throw new NullPointerException("noiseKeyPair is marked non-null but is null");
        }
        this.ephemeralKeyPair = b.ephemeralKeyPair$set ? b.ephemeralKeyPair$value : Keys.$default$ephemeralKeyPair();
        if (this.ephemeralKeyPair == null) {
            throw new NullPointerException("ephemeralKeyPair is marked non-null but is null");
        }
        this.identityKeyPair = b.identityKeyPair$set ? b.identityKeyPair$value : Keys.$default$identityKeyPair();
        if (this.identityKeyPair == null) {
            throw new NullPointerException("identityKeyPair is marked non-null but is null");
        }
        this.signedKeyPair = b.signedKeyPair;
        this.signedKeyIndex = b.signedKeyIndex;
        this.signedKeyIndexTimestamp = b.signedKeyIndexTimestamp;
        this.preKeys = b.preKeys$set ? b.preKeys$value : Keys.$default$preKeys();
        if (this.preKeys == null) {
            throw new NullPointerException("preKeys is marked non-null but is null");
        }
        this.companionKeyPair = b.companionKeyPair$set ? b.companionKeyPair$value : Keys.$default$companionKeyPair();
        this.prologue = b.prologue;
        this.phoneId = b.phoneId$set ? b.phoneId$value : Keys.$default$phoneId();
        this.deviceId = b.deviceId$set ? b.deviceId$value : Keys.$default$deviceId();
        this.recoveryToken = b.recoveryToken$set ? b.recoveryToken$value : Keys.$default$recoveryToken();
        this.companionIdentity = b.companionIdentity;
        this.senderKeys = b.senderKeys$set ? b.senderKeys$value : Keys.$default$senderKeys();
        if (this.senderKeys == null) {
            throw new NullPointerException("senderKeys is marked non-null but is null");
        }
        this.appStateKeys = b.appStateKeys$set ? b.appStateKeys$value : Keys.$default$appStateKeys();
        if (this.appStateKeys == null) {
            throw new NullPointerException("appStateKeys is marked non-null but is null");
        }
        this.sessions = b.sessions$set ? b.sessions$value : Keys.$default$sessions();
        if (this.sessions == null) {
            throw new NullPointerException("sessions is marked non-null but is null");
        }
        this.hashStates = b.hashStates$set ? b.hashStates$value : Keys.$default$hashStates();
        if (this.hashStates == null) {
            throw new NullPointerException("hashStates is marked non-null but is null");
        }
        this.registered = b.registered$set ? b.registered$value : Keys.$default$registered();
        this.businessCertificate = b.businessCertificate$set ? b.businessCertificate$value : Keys.$default$businessCertificate();
        this.initialAppSync = b.initialAppSync$set ? b.initialAppSync$value : Keys.$default$initialAppSync();
        this.writeCounter = b.writeCounter$set ? b.writeCounter$value : Keys.$default$writeCounter();
        if (this.writeCounter == null) {
            throw new NullPointerException("writeCounter is marked non-null but is null");
        }
        this.readCounter = b.readCounter$set ? b.readCounter$value : Keys.$default$readCounter();
        if (this.readCounter == null) {
            throw new NullPointerException("readCounter is marked non-null but is null");
        }
        this.writeKey = b.writeKey;
        this.readKey = b.readKey;
    }

    public static KeysBuilder<?, ?> builder() {
        return new KeysBuilderImpl();
    }

    public int registrationId() {
        return this.registrationId;
    }

    @NonNull
    public SignalKeyPair noiseKeyPair() {
        return this.noiseKeyPair;
    }

    @NonNull
    public SignalKeyPair ephemeralKeyPair() {
        return this.ephemeralKeyPair;
    }

    @NonNull
    public SignalKeyPair identityKeyPair() {
        return this.identityKeyPair;
    }

    public SignalSignedKeyPair signedKeyPair() {
        return this.signedKeyPair;
    }

    private Keys signedKeyPair(SignalSignedKeyPair signedKeyPair) {
        this.signedKeyPair = signedKeyPair;
        return this;
    }

    public byte[] signedKeyIndex() {
        return this.signedKeyIndex;
    }

    public Keys signedKeyIndex(byte[] signedKeyIndex) {
        this.signedKeyIndex = signedKeyIndex;
        return this;
    }

    public long signedKeyIndexTimestamp() {
        return this.signedKeyIndexTimestamp;
    }

    public Keys signedKeyIndexTimestamp(long signedKeyIndexTimestamp) {
        this.signedKeyIndexTimestamp = signedKeyIndexTimestamp;
        return this;
    }

    public SignalKeyPair companionKeyPair() {
        return this.companionKeyPair;
    }

    public Keys companionKeyPair(SignalKeyPair companionKeyPair) {
        this.companionKeyPair = companionKeyPair;
        return this;
    }

    public byte @NonNull [] prologue() {
        return this.prologue;
    }

    public String phoneId() {
        return this.phoneId;
    }

    public String deviceId() {
        return this.deviceId;
    }

    public String recoveryToken() {
        return this.recoveryToken;
    }

    @NonNull
    public Map<SessionAddress, Session> sessions() {
        return this.sessions;
    }

    public boolean registered() {
        return this.registered;
    }

    public Keys registered(boolean registered) {
        this.registered = registered;
        return this;
    }

    public boolean businessCertificate() {
        return this.businessCertificate;
    }

    public Keys businessCertificate(boolean businessCertificate) {
        this.businessCertificate = businessCertificate;
        return this;
    }

    public boolean initialAppSync() {
        return this.initialAppSync;
    }

    public Keys initialAppSync(boolean initialAppSync) {
        this.initialAppSync = initialAppSync;
        return this;
    }

    public byte[] writeKey() {
        return this.writeKey;
    }

    public byte[] readKey() {
        return this.readKey;
    }

    @JsonIgnore
    public Keys writeKey(byte[] writeKey) {
        this.writeKey = writeKey;
        return this;
    }

    @JsonIgnore
    public Keys readKey(byte[] readKey) {
        this.readKey = readKey;
        return this;
    }

    public static abstract class KeysBuilder<C extends Keys, B extends KeysBuilder<C, B>>
    extends Controller.ControllerBuilder<Keys, C, B> {
        private boolean registrationId$set;
        private int registrationId$value;
        private boolean noiseKeyPair$set;
        private SignalKeyPair noiseKeyPair$value;
        private boolean ephemeralKeyPair$set;
        private SignalKeyPair ephemeralKeyPair$value;
        private boolean identityKeyPair$set;
        private SignalKeyPair identityKeyPair$value;
        private SignalSignedKeyPair signedKeyPair;
        private byte[] signedKeyIndex;
        private long signedKeyIndexTimestamp;
        private boolean preKeys$set;
        private ArrayList<SignalPreKeyPair> preKeys$value;
        private boolean companionKeyPair$set;
        private SignalKeyPair companionKeyPair$value;
        private byte @NonNull [] prologue;
        private boolean phoneId$set;
        private String phoneId$value;
        private boolean deviceId$set;
        private String deviceId$value;
        private boolean recoveryToken$set;
        private String recoveryToken$value;
        private SignedDeviceIdentity companionIdentity;
        private boolean senderKeys$set;
        private Map<SenderKeyName, SenderKeyRecord> senderKeys$value;
        private boolean appStateKeys$set;
        private Map<ContactJid, LinkedList<AppStateSyncKey>> appStateKeys$value;
        private boolean sessions$set;
        private Map<SessionAddress, Session> sessions$value;
        private boolean hashStates$set;
        private Map<ContactJid, Map<BinaryPatchType, LTHashState>> hashStates$value;
        private boolean registered$set;
        private boolean registered$value;
        private boolean businessCertificate$set;
        private boolean businessCertificate$value;
        private boolean initialAppSync$set;
        private boolean initialAppSync$value;
        private boolean writeCounter$set;
        private AtomicLong writeCounter$value;
        private boolean readCounter$set;
        private AtomicLong readCounter$value;
        private byte[] writeKey;
        private byte[] readKey;

        public B registrationId(int registrationId) {
            this.registrationId$value = registrationId;
            this.registrationId$set = true;
            return (B)this.self();
        }

        public B noiseKeyPair(@NonNull SignalKeyPair noiseKeyPair) {
            if (noiseKeyPair == null) {
                throw new NullPointerException("noiseKeyPair is marked non-null but is null");
            }
            this.noiseKeyPair$value = noiseKeyPair;
            this.noiseKeyPair$set = true;
            return (B)this.self();
        }

        public B ephemeralKeyPair(@NonNull SignalKeyPair ephemeralKeyPair) {
            if (ephemeralKeyPair == null) {
                throw new NullPointerException("ephemeralKeyPair is marked non-null but is null");
            }
            this.ephemeralKeyPair$value = ephemeralKeyPair;
            this.ephemeralKeyPair$set = true;
            return (B)this.self();
        }

        public B identityKeyPair(@NonNull SignalKeyPair identityKeyPair) {
            if (identityKeyPair == null) {
                throw new NullPointerException("identityKeyPair is marked non-null but is null");
            }
            this.identityKeyPair$value = identityKeyPair;
            this.identityKeyPair$set = true;
            return (B)this.self();
        }

        public B signedKeyPair(SignalSignedKeyPair signedKeyPair) {
            this.signedKeyPair = signedKeyPair;
            return (B)this.self();
        }

        public B signedKeyIndex(byte[] signedKeyIndex) {
            this.signedKeyIndex = signedKeyIndex;
            return (B)this.self();
        }

        public B signedKeyIndexTimestamp(long signedKeyIndexTimestamp) {
            this.signedKeyIndexTimestamp = signedKeyIndexTimestamp;
            return (B)this.self();
        }

        public B preKeys(@NonNull ArrayList<SignalPreKeyPair> preKeys) {
            if (preKeys == null) {
                throw new NullPointerException("preKeys is marked non-null but is null");
            }
            this.preKeys$value = preKeys;
            this.preKeys$set = true;
            return (B)this.self();
        }

        public B companionKeyPair(SignalKeyPair companionKeyPair) {
            this.companionKeyPair$value = companionKeyPair;
            this.companionKeyPair$set = true;
            return (B)this.self();
        }

        public B prologue(byte @NonNull [] prologue) {
            if (prologue == null) {
                throw new NullPointerException("prologue is marked non-null but is null");
            }
            this.prologue = prologue;
            return (B)this.self();
        }

        public B phoneId(String phoneId) {
            this.phoneId$value = phoneId;
            this.phoneId$set = true;
            return (B)this.self();
        }

        public B deviceId(String deviceId) {
            this.deviceId$value = deviceId;
            this.deviceId$set = true;
            return (B)this.self();
        }

        public B recoveryToken(String recoveryToken) {
            this.recoveryToken$value = recoveryToken;
            this.recoveryToken$set = true;
            return (B)this.self();
        }

        public B companionIdentity(SignedDeviceIdentity companionIdentity) {
            this.companionIdentity = companionIdentity;
            return (B)this.self();
        }

        public B senderKeys(@NonNull Map<SenderKeyName, SenderKeyRecord> senderKeys) {
            if (senderKeys == null) {
                throw new NullPointerException("senderKeys is marked non-null but is null");
            }
            this.senderKeys$value = senderKeys;
            this.senderKeys$set = true;
            return (B)this.self();
        }

        public B appStateKeys(@NonNull Map<ContactJid, LinkedList<AppStateSyncKey>> appStateKeys) {
            if (appStateKeys == null) {
                throw new NullPointerException("appStateKeys is marked non-null but is null");
            }
            this.appStateKeys$value = appStateKeys;
            this.appStateKeys$set = true;
            return (B)this.self();
        }

        public B sessions(@NonNull Map<SessionAddress, Session> sessions) {
            if (sessions == null) {
                throw new NullPointerException("sessions is marked non-null but is null");
            }
            this.sessions$value = sessions;
            this.sessions$set = true;
            return (B)this.self();
        }

        public B hashStates(@NonNull Map<ContactJid, Map<BinaryPatchType, LTHashState>> hashStates) {
            if (hashStates == null) {
                throw new NullPointerException("hashStates is marked non-null but is null");
            }
            this.hashStates$value = hashStates;
            this.hashStates$set = true;
            return (B)this.self();
        }

        public B registered(boolean registered) {
            this.registered$value = registered;
            this.registered$set = true;
            return (B)this.self();
        }

        public B businessCertificate(boolean businessCertificate) {
            this.businessCertificate$value = businessCertificate;
            this.businessCertificate$set = true;
            return (B)this.self();
        }

        public B initialAppSync(boolean initialAppSync) {
            this.initialAppSync$value = initialAppSync;
            this.initialAppSync$set = true;
            return (B)this.self();
        }

        @JsonIgnore
        public B writeCounter(@NonNull AtomicLong writeCounter) {
            if (writeCounter == null) {
                throw new NullPointerException("writeCounter is marked non-null but is null");
            }
            this.writeCounter$value = writeCounter;
            this.writeCounter$set = true;
            return (B)this.self();
        }

        @JsonIgnore
        public B readCounter(@NonNull AtomicLong readCounter) {
            if (readCounter == null) {
                throw new NullPointerException("readCounter is marked non-null but is null");
            }
            this.readCounter$value = readCounter;
            this.readCounter$set = true;
            return (B)this.self();
        }

        @JsonIgnore
        public B writeKey(byte[] writeKey) {
            this.writeKey = writeKey;
            return (B)this.self();
        }

        @JsonIgnore
        public B readKey(byte[] readKey) {
            this.readKey = readKey;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "Keys.KeysBuilder(super=" + super.toString() + ", registrationId$value=" + this.registrationId$value + ", noiseKeyPair$value=" + this.noiseKeyPair$value + ", ephemeralKeyPair$value=" + this.ephemeralKeyPair$value + ", identityKeyPair$value=" + this.identityKeyPair$value + ", signedKeyPair=" + this.signedKeyPair + ", signedKeyIndex=" + Arrays.toString(this.signedKeyIndex) + ", signedKeyIndexTimestamp=" + this.signedKeyIndexTimestamp + ", preKeys$value=" + this.preKeys$value + ", companionKeyPair$value=" + this.companionKeyPair$value + ", prologue=" + this.prologue + ", phoneId$value=" + this.phoneId$value + ", deviceId$value=" + this.deviceId$value + ", recoveryToken$value=" + this.recoveryToken$value + ", companionIdentity=" + this.companionIdentity + ", senderKeys$value=" + this.senderKeys$value + ", appStateKeys$value=" + this.appStateKeys$value + ", sessions$value=" + this.sessions$value + ", hashStates$value=" + this.hashStates$value + ", registered$value=" + this.registered$value + ", businessCertificate$value=" + this.businessCertificate$value + ", initialAppSync$value=" + this.initialAppSync$value + ", writeCounter$value=" + this.writeCounter$value + ", readCounter$value=" + this.readCounter$value + ", writeKey=" + Arrays.toString(this.writeKey) + ", readKey=" + Arrays.toString(this.readKey) + ")";
        }
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    static final class KeysBuilderImpl
    extends KeysBuilder<Keys, KeysBuilderImpl> {
        private KeysBuilderImpl() {
        }

        @Override
        protected KeysBuilderImpl self() {
            return this;
        }

        @Override
        public Keys build() {
            return new Keys(this);
        }
    }
}

