/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.binary;

import io.netty.buffer.ByteBuf;
import it.auties.whatsapp.binary.BinaryTag;
import it.auties.whatsapp.binary.BinaryTokens;
import it.auties.whatsapp.model.contact.ContactJid;
import it.auties.whatsapp.model.request.Node;
import it.auties.whatsapp.util.BytesHelper;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public final class BinaryEncoder {
    private static final int UNSIGNED_BYTE_MAX_VALUE = 256;
    private static final int UNSIGNED_SHORT_MAX_VALUE = 65536;
    private static final int INT_20_MAX_VALUE = 0x100000;
    private final ByteBuf buffer = BytesHelper.newBuffer();
    private final List<String> singleByteTokens;
    private final List<String> doubleByteTokens;

    public BinaryEncoder() {
        this(BinaryTokens.SINGLE_BYTE, BinaryTokens.DOUBLE_BYTE);
    }

    public BinaryEncoder(List<String> singleByteTokens, List<String> doubleByteTokens) {
        this.singleByteTokens = singleByteTokens;
        this.doubleByteTokens = doubleByteTokens;
    }

    public synchronized byte[] encode(Node node) {
        this.buffer.clear();
        byte[] encoded = this.writeNode(node);
        byte[] result = new byte[1 + encoded.length];
        result[0] = 0;
        System.arraycopy(encoded, 0, result, 1, encoded.length);
        return result;
    }

    private void writeString(String input, BinaryTag token) {
        this.buffer.writeByte(token.data());
        this.writeStringLength(input);
        int charCode = 0;
        for (int index = 0; index < input.length(); ++index) {
            int stringCodePoint = Character.codePointAt(input, index);
            int binaryCodePoint = this.getStringCodePoint(token, stringCodePoint);
            if (index % 2 != 0) {
                this.buffer.writeByte(charCode |= binaryCodePoint);
                continue;
            }
            charCode = binaryCodePoint << 4;
            if (index != input.length() - 1) continue;
            this.buffer.writeByte(charCode |= 0xF);
        }
    }

    private int getStringCodePoint(BinaryTag token, int codePoint) {
        if (codePoint >= 48 && codePoint <= 57) {
            return codePoint - 48;
        }
        if (token == BinaryTag.NIBBLE_8 && codePoint == 45) {
            return 10;
        }
        if (token == BinaryTag.NIBBLE_8 && codePoint == 46) {
            return 11;
        }
        if (token == BinaryTag.HEX_8 && codePoint >= 65 && codePoint <= 70) {
            return codePoint - 55;
        }
        throw new IllegalArgumentException("Cannot parse codepoint %s with token %s".formatted(new Object[]{codePoint, token}));
    }

    private void writeStringLength(String input) {
        int roundedLength = (int)Math.ceil((float)input.length() / 2.0f);
        if (input.length() % 2 == 1) {
            this.buffer.writeByte(roundedLength | 0x80);
            return;
        }
        this.buffer.writeByte(roundedLength);
    }

    private void writeLong(long input) {
        if (input < 256L) {
            this.buffer.writeByte(BinaryTag.BINARY_8.data());
            this.buffer.writeByte((int)input);
            return;
        }
        if (input < 0x100000L) {
            this.buffer.writeByte(BinaryTag.BINARY_20.data());
            this.buffer.writeByte((int)(input >>> 16 & 0xFFL));
            this.buffer.writeByte((int)(input >>> 8 & 0xFFL));
            this.buffer.writeByte((int)(0xFFL & input));
            return;
        }
        this.buffer.writeByte(BinaryTag.BINARY_32.data());
        this.buffer.writeLong(input);
    }

    private void writeString(String input) {
        if (input.isEmpty()) {
            this.buffer.writeByte(BinaryTag.BINARY_8.data());
            this.buffer.writeByte(BinaryTag.LIST_EMPTY.data());
            return;
        }
        int tokenIndex = this.singleByteTokens.indexOf(input);
        if (tokenIndex != -1) {
            this.buffer.writeByte(tokenIndex + 1);
            return;
        }
        if (this.writeDoubleByteString(input)) {
            return;
        }
        int length = this.length(input);
        if (length < 128 && !BinaryTokens.anyMatch(input, "[^0-9.-]+?")) {
            this.writeString(input, BinaryTag.NIBBLE_8);
            return;
        }
        if (length < 128 && !BinaryTokens.anyMatch(input, "[^0-9A-F]+?")) {
            this.writeString(input, BinaryTag.HEX_8);
            return;
        }
        this.writeLong(length);
        this.buffer.writeBytes(input.getBytes(StandardCharsets.UTF_8));
    }

    private boolean writeDoubleByteString(String input) {
        if (!this.doubleByteTokens.contains(input)) {
            return false;
        }
        int index = this.doubleByteTokens.indexOf(input);
        this.buffer.writeByte(this.doubleByteStringTag(index).data());
        this.buffer.writeByte(index % (this.doubleByteTokens.size() / 4));
        return true;
    }

    private BinaryTag doubleByteStringTag(int index) {
        return switch (index / (this.doubleByteTokens.size() / 4)) {
            case 0 -> BinaryTag.DICTIONARY_0;
            case 1 -> BinaryTag.DICTIONARY_1;
            case 2 -> BinaryTag.DICTIONARY_2;
            case 3 -> BinaryTag.DICTIONARY_3;
            default -> throw new IllegalArgumentException("Cannot find tag for quadrant %s".formatted(index));
        };
    }

    private byte[] writeNode(Node input) {
        if (input.description().equals("0")) {
            this.buffer.writeByte(BinaryTag.LIST_8.data());
            this.buffer.writeByte(BinaryTag.LIST_EMPTY.data());
            return BytesHelper.readBuffer(this.buffer.resetReaderIndex());
        }
        this.writeInt(input.size());
        this.writeString(input.description());
        this.writeAttributes(input);
        if (input.hasContent()) {
            this.write(input.content());
        }
        return BytesHelper.readBuffer(this.buffer.resetReaderIndex());
    }

    private void writeAttributes(Node input) {
        input.attributes().toMap().forEach((key, value) -> {
            this.writeString((String)key);
            this.write(value);
        });
    }

    private void writeInt(int size) {
        if (size < 256) {
            this.buffer.writeByte(BinaryTag.LIST_8.data());
            this.buffer.writeByte(size);
            return;
        }
        if (size < 65536) {
            this.buffer.writeByte(BinaryTag.LIST_16.data());
            this.buffer.writeShort(size);
            return;
        }
        throw new IllegalArgumentException("Cannot write int %s: overflow".formatted(size));
    }

    private void write(Object input) {
        if (input == null) {
            this.buffer.writeByte(BinaryTag.LIST_EMPTY.data());
        } else if (input instanceof String) {
            String str = (String)input;
            this.writeString(str);
        } else if (input instanceof Boolean) {
            Boolean bool = (Boolean)input;
            this.writeString(Boolean.toString(bool));
        } else if (input instanceof Number) {
            Number number = (Number)input;
            this.writeString(number.toString());
        } else if (input instanceof byte[]) {
            byte[] bytes = (byte[])input;
            this.writeBytes(bytes);
        } else if (input instanceof ContactJid) {
            ContactJid jid = (ContactJid)input;
            this.writeJid(jid);
        } else if (input instanceof Collection) {
            Collection collection = (Collection)input;
            this.writeList(collection);
        } else if (input instanceof Enum) {
            Enum serializable = (Enum)input;
            this.writeString(Objects.toString(serializable));
        } else {
            if (input instanceof Node) {
                throw new IllegalArgumentException("Invalid payload type(nodes should be wrapped by a collection): %s".formatted(input));
            }
            throw new IllegalArgumentException("Invalid payload type(%s): %s".formatted(input.getClass().getName(), input));
        }
    }

    private void writeList(Collection<?> collection) {
        this.writeInt(collection.size());
        collection.stream().filter(entry -> entry instanceof Node).map(entry -> (Node)entry).forEach(this::writeNode);
    }

    private void writeBytes(byte[] bytes) {
        this.writeLong(bytes.length);
        this.buffer.writeBytes(bytes);
    }

    private void writeJid(ContactJid jid) {
        if (jid.isCompanion()) {
            this.buffer.writeByte(BinaryTag.COMPANION_JID.data());
            this.buffer.writeByte(jid.agent());
            this.buffer.writeByte(jid.device());
            this.writeString(jid.user());
            return;
        }
        this.buffer.writeByte(BinaryTag.JID_PAIR.data());
        if (jid.user() != null) {
            this.writeString(jid.user());
            this.writeString(jid.server().address());
            return;
        }
        this.buffer.writeByte(BinaryTag.LIST_EMPTY.data());
        this.writeString(jid.server().address());
    }

    private int length(String input) {
        return input.getBytes(StandardCharsets.UTF_8).length;
    }
}

