/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.binary;

import io.netty.buffer.ByteBuf;
import it.auties.whatsapp.binary.BinaryTag;
import it.auties.whatsapp.binary.BinaryTokens;
import it.auties.whatsapp.model.contact.ContactJid;
import it.auties.whatsapp.model.request.Node;
import it.auties.whatsapp.util.BytesHelper;
import it.auties.whatsapp.util.Validate;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;

public final class BinaryDecoder {
    private ByteBuf buffer;

    public synchronized Node decode(byte[] input) {
        ByteBuf buffer = BytesHelper.newBuffer(input);
        int token = buffer.readByte() & 2;
        this.allocateBuffer(token, buffer);
        return this.readNode();
    }

    private void allocateBuffer(int token, ByteBuf input) {
        if (token == 0) {
            this.buffer = input;
            return;
        }
        byte[] bytes = BytesHelper.readBuffer(input);
        this.buffer = BytesHelper.newBuffer();
        this.buffer.writeBytes(BytesHelper.decompress(bytes));
    }

    private Node readNode() {
        short token = this.buffer.readUnsignedByte();
        int size = this.readSize(token);
        Validate.isTrue(size != 0, "Cannot decode node with empty body", new Object[0]);
        String description = this.readString();
        Map<String, Object> attrs = this.readAttributes(size);
        return size % 2 != 0 ? Node.of(description, attrs) : Node.of(description, attrs, this.read(false));
    }

    private String readString() {
        Object read = this.read(true);
        if (read instanceof String) {
            String string = (String)read;
            return string;
        }
        throw new IllegalArgumentException("Strict decoding failed: expected string, got %s with type %s".formatted(read, read == null ? null : read.getClass().getName()));
    }

    private List<Node> readList(int size) {
        return IntStream.range(0, size).mapToObj(index -> this.readNode()).toList();
    }

    private String readString(List<Character> permitted, int start, int end) {
        char[] string = new char[2 * end - start];
        IntStream.iterate(0, index -> index < string.length - 1, n -> n + 2).forEach(index -> this.readChar(permitted, string, index));
        if (start != 0) {
            string[string.length - 1] = permitted.get(this.buffer.readUnsignedByte() >>> 4).charValue();
        }
        return String.valueOf(string);
    }

    private void readChar(List<Character> permitted, char[] string, int index) {
        short token = this.buffer.readUnsignedByte();
        string[index] = permitted.get(token >>> 4).charValue();
        string[index + 1] = permitted.get(0xF & token).charValue();
    }

    private Object read(boolean parseBytes) {
        short tag = this.buffer.readUnsignedByte();
        return switch (BinaryTag.of(tag)) {
            case BinaryTag.LIST_EMPTY -> null;
            case BinaryTag.COMPANION_JID -> this.readCompanionJid();
            case BinaryTag.LIST_8 -> this.readList(this.buffer.readUnsignedByte());
            case BinaryTag.LIST_16 -> this.readList(this.buffer.readUnsignedShort());
            case BinaryTag.JID_PAIR -> this.readJidPair();
            case BinaryTag.HEX_8 -> this.readHexString();
            case BinaryTag.BINARY_8 -> this.readString(this.buffer.readUnsignedByte(), parseBytes);
            case BinaryTag.BINARY_20 -> this.readString(this.readString20Length(), parseBytes);
            case BinaryTag.BINARY_32 -> this.readString(this.buffer.readUnsignedShort(), parseBytes);
            case BinaryTag.NIBBLE_8 -> this.readNibble();
            default -> this.readStringFromToken(tag);
        };
    }

    private int readString20Length() {
        return ((0xF & this.buffer.readUnsignedByte()) << 16) + (this.buffer.readUnsignedByte() << 8) + this.buffer.readUnsignedByte();
    }

    private String readStringFromToken(int token) {
        if (token < BinaryTag.DICTIONARY_0.data() || token > BinaryTag.DICTIONARY_3.data()) {
            return BinaryTokens.SINGLE_BYTE.get(token - 1);
        }
        int delta = BinaryTokens.DOUBLE_BYTE.size() / 4 * (token - BinaryTag.DICTIONARY_0.data());
        return BinaryTokens.DOUBLE_BYTE.get(this.buffer.readUnsignedByte() + delta);
    }

    private String readNibble() {
        short number = this.buffer.readUnsignedByte();
        return this.readString(BinaryTokens.NUMBERS, number >>> 7, 0x7F & number);
    }

    private Object readString(int size, boolean parseBytes) {
        Object object;
        byte[] data = BytesHelper.readBuffer(this.buffer, size);
        if (parseBytes) {
            String string;
            object = string;
            string = new String(data, StandardCharsets.UTF_8);
        } else {
            object = data;
        }
        return object;
    }

    private String readHexString() {
        short number = this.buffer.readUnsignedByte();
        return this.readString(BinaryTokens.HEX, number >>> 7, 0x7F & number);
    }

    private ContactJid readJidPair() {
        Object read = this.read(true);
        if (read instanceof String) {
            String encoded = (String)read;
            return ContactJid.of(encoded, ContactJid.Server.of(this.readString()));
        }
        if (read == null) {
            return ContactJid.ofServer(ContactJid.Server.of(this.readString()));
        }
        throw new RuntimeException("Invalid jid type");
    }

    private ContactJid readCompanionJid() {
        short agent = this.buffer.readUnsignedByte();
        short device = this.buffer.readUnsignedByte();
        String user = this.readString();
        return ContactJid.ofDevice(user, device, agent);
    }

    private int readSize(int token) {
        return BinaryTag.LIST_8.contentEquals(token) ? this.buffer.readUnsignedByte() : this.buffer.readUnsignedShort();
    }

    private Map<String, Object> readAttributes(int size) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int pair = size - 1; pair > 1; pair -= 2) {
            String key = this.readString();
            Object value = this.read(true);
            map.put(key, value);
        }
        return map;
    }
}

