/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.api;

import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.ChecksumException;
import com.google.zxing.FormatException;
import com.google.zxing.LuminanceSource;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.qrcode.QRCodeReader;
import it.auties.curve25519.Curve25519;
import it.auties.linkpreview.LinkPreview;
import it.auties.linkpreview.LinkPreviewMatch;
import it.auties.linkpreview.LinkPreviewMedia;
import it.auties.linkpreview.LinkPreviewResult;
import it.auties.whatsapp.api.ClientType;
import it.auties.whatsapp.api.ConnectionBuilder;
import it.auties.whatsapp.api.DisconnectReason;
import it.auties.whatsapp.api.Emoji;
import it.auties.whatsapp.api.ErrorHandler;
import it.auties.whatsapp.api.MobileOptionsBuilder;
import it.auties.whatsapp.api.QrHandler;
import it.auties.whatsapp.api.TextPreviewSetting;
import it.auties.whatsapp.api.WebOptionsBuilder;
import it.auties.whatsapp.api.WebVerificationSupport;
import it.auties.whatsapp.binary.BinaryPatchType;
import it.auties.whatsapp.controller.Keys;
import it.auties.whatsapp.controller.Store;
import it.auties.whatsapp.crypto.AesGmc;
import it.auties.whatsapp.crypto.Hkdf;
import it.auties.whatsapp.crypto.Hmac;
import it.auties.whatsapp.crypto.Sha256;
import it.auties.whatsapp.listener.Listener;
import it.auties.whatsapp.listener.OnAction;
import it.auties.whatsapp.listener.OnAnyMessageStatus;
import it.auties.whatsapp.listener.OnChatMessagesSync;
import it.auties.whatsapp.listener.OnChats;
import it.auties.whatsapp.listener.OnContactBlocked;
import it.auties.whatsapp.listener.OnContactPictureChange;
import it.auties.whatsapp.listener.OnContactPresence;
import it.auties.whatsapp.listener.OnContacts;
import it.auties.whatsapp.listener.OnConversationMessageStatus;
import it.auties.whatsapp.listener.OnDisconnected;
import it.auties.whatsapp.listener.OnFeatures;
import it.auties.whatsapp.listener.OnGroupPictureChange;
import it.auties.whatsapp.listener.OnHistorySyncProgress;
import it.auties.whatsapp.listener.OnLinkedDevices;
import it.auties.whatsapp.listener.OnLoggedIn;
import it.auties.whatsapp.listener.OnMediaStatus;
import it.auties.whatsapp.listener.OnMessageDeleted;
import it.auties.whatsapp.listener.OnMessageReply;
import it.auties.whatsapp.listener.OnMetadata;
import it.auties.whatsapp.listener.OnNewContact;
import it.auties.whatsapp.listener.OnNewMarkedMessage;
import it.auties.whatsapp.listener.OnNewMediaStatus;
import it.auties.whatsapp.listener.OnNewMessage;
import it.auties.whatsapp.listener.OnNodeReceived;
import it.auties.whatsapp.listener.OnNodeSent;
import it.auties.whatsapp.listener.OnPrivacySettingChanged;
import it.auties.whatsapp.listener.OnRegistrationCode;
import it.auties.whatsapp.listener.OnSetting;
import it.auties.whatsapp.listener.OnSocketEvent;
import it.auties.whatsapp.listener.OnUserAboutChange;
import it.auties.whatsapp.listener.OnUserNameChange;
import it.auties.whatsapp.listener.OnUserPictureChange;
import it.auties.whatsapp.listener.OnWhatsappAction;
import it.auties.whatsapp.listener.OnWhatsappAnyMessageStatus;
import it.auties.whatsapp.listener.OnWhatsappChatMessagesSync;
import it.auties.whatsapp.listener.OnWhatsappContactBlocked;
import it.auties.whatsapp.listener.OnWhatsappContactPictureChange;
import it.auties.whatsapp.listener.OnWhatsappContactPresence;
import it.auties.whatsapp.listener.OnWhatsappContacts;
import it.auties.whatsapp.listener.OnWhatsappConversationMessageStatus;
import it.auties.whatsapp.listener.OnWhatsappDisconnected;
import it.auties.whatsapp.listener.OnWhatsappFeatures;
import it.auties.whatsapp.listener.OnWhatsappHistorySyncProgress;
import it.auties.whatsapp.listener.OnWhatsappLinkedDevices;
import it.auties.whatsapp.listener.OnWhatsappLoggedIn;
import it.auties.whatsapp.listener.OnWhatsappMediaStatus;
import it.auties.whatsapp.listener.OnWhatsappMessageDeleted;
import it.auties.whatsapp.listener.OnWhatsappMessageReply;
import it.auties.whatsapp.listener.OnWhatsappMetadata;
import it.auties.whatsapp.listener.OnWhatsappNewMarkedMessage;
import it.auties.whatsapp.listener.OnWhatsappNewMediaStatus;
import it.auties.whatsapp.listener.OnWhatsappNewMessage;
import it.auties.whatsapp.listener.OnWhatsappNodeReceived;
import it.auties.whatsapp.listener.OnWhatsappNodeSent;
import it.auties.whatsapp.listener.OnWhatsappPrivacySettingChanged;
import it.auties.whatsapp.listener.OnWhatsappRegistrationCode;
import it.auties.whatsapp.listener.OnWhatsappSetting;
import it.auties.whatsapp.listener.OnWhatsappSocketEvent;
import it.auties.whatsapp.listener.OnWhatsappUserAboutChange;
import it.auties.whatsapp.listener.OnWhatsappUserNameChange;
import it.auties.whatsapp.listener.OnWhatsappUserPictureChange;
import it.auties.whatsapp.model.action.AndroidUnsupportedActions;
import it.auties.whatsapp.model.action.ArchiveChatAction;
import it.auties.whatsapp.model.action.ClearChatAction;
import it.auties.whatsapp.model.action.ContactAction;
import it.auties.whatsapp.model.action.DeleteChatAction;
import it.auties.whatsapp.model.action.DeleteMessageForMeAction;
import it.auties.whatsapp.model.action.MarkChatAsReadAction;
import it.auties.whatsapp.model.action.MuteAction;
import it.auties.whatsapp.model.action.NuxAction;
import it.auties.whatsapp.model.action.PinAction;
import it.auties.whatsapp.model.action.PrimaryVersionAction;
import it.auties.whatsapp.model.action.StarAction;
import it.auties.whatsapp.model.action.TimeFormatAction;
import it.auties.whatsapp.model.business.BusinessCatalogEntry;
import it.auties.whatsapp.model.business.BusinessCategory;
import it.auties.whatsapp.model.business.BusinessCollectionEntry;
import it.auties.whatsapp.model.business.BusinessProfile;
import it.auties.whatsapp.model.business.BusinessVerifiedNameCertificate;
import it.auties.whatsapp.model.button.template.TemplateFormatter;
import it.auties.whatsapp.model.button.template.hsm.HighlyStructuredFourRowTemplate;
import it.auties.whatsapp.model.button.template.hydrated.HydratedFourRowTemplate;
import it.auties.whatsapp.model.chat.Chat;
import it.auties.whatsapp.model.chat.ChatEphemeralTimer;
import it.auties.whatsapp.model.chat.ChatMute;
import it.auties.whatsapp.model.chat.GroupAction;
import it.auties.whatsapp.model.chat.GroupMetadata;
import it.auties.whatsapp.model.chat.GroupPolicy;
import it.auties.whatsapp.model.chat.GroupRole;
import it.auties.whatsapp.model.chat.PastParticipant;
import it.auties.whatsapp.model.chat.PastParticipants;
import it.auties.whatsapp.model.companion.CompanionLinkResult;
import it.auties.whatsapp.model.contact.Contact;
import it.auties.whatsapp.model.contact.ContactJid;
import it.auties.whatsapp.model.contact.ContactJidProvider;
import it.auties.whatsapp.model.contact.ContactStatus;
import it.auties.whatsapp.model.info.ContextInfo;
import it.auties.whatsapp.model.info.MessageInfo;
import it.auties.whatsapp.model.media.AttachmentProvider;
import it.auties.whatsapp.model.media.AttachmentType;
import it.auties.whatsapp.model.media.MediaFile;
import it.auties.whatsapp.model.message.button.ButtonsMessage;
import it.auties.whatsapp.model.message.button.InteractiveMessage;
import it.auties.whatsapp.model.message.button.TemplateMessage;
import it.auties.whatsapp.model.message.model.ButtonMessage;
import it.auties.whatsapp.model.message.model.ContextualMessage;
import it.auties.whatsapp.model.message.model.MediaMessage;
import it.auties.whatsapp.model.message.model.Message;
import it.auties.whatsapp.model.message.model.MessageCategory;
import it.auties.whatsapp.model.message.model.MessageContainer;
import it.auties.whatsapp.model.message.model.MessageKey;
import it.auties.whatsapp.model.message.model.MessageMetadataProvider;
import it.auties.whatsapp.model.message.model.MessageStatus;
import it.auties.whatsapp.model.message.model.MessageType;
import it.auties.whatsapp.model.message.model.QuotedMessage;
import it.auties.whatsapp.model.message.server.ProtocolMessage;
import it.auties.whatsapp.model.message.standard.GroupInviteMessage;
import it.auties.whatsapp.model.message.standard.PollCreationMessage;
import it.auties.whatsapp.model.message.standard.PollUpdateMessage;
import it.auties.whatsapp.model.message.standard.ReactionMessage;
import it.auties.whatsapp.model.message.standard.TextMessage;
import it.auties.whatsapp.model.poll.PollAdditionalMetadata;
import it.auties.whatsapp.model.poll.PollUpdateEncryptedMetadata;
import it.auties.whatsapp.model.poll.PollUpdateEncryptedOptions;
import it.auties.whatsapp.model.privacy.GdprAccountReport;
import it.auties.whatsapp.model.privacy.PrivacySettingEntry;
import it.auties.whatsapp.model.privacy.PrivacySettingType;
import it.auties.whatsapp.model.privacy.PrivacySettingValue;
import it.auties.whatsapp.model.request.Attributes;
import it.auties.whatsapp.model.request.MessageSendRequest;
import it.auties.whatsapp.model.request.MexQueryRequest;
import it.auties.whatsapp.model.request.Node;
import it.auties.whatsapp.model.request.ReplyHandler;
import it.auties.whatsapp.model.response.ContactStatusResponse;
import it.auties.whatsapp.model.response.HasWhatsappResponse;
import it.auties.whatsapp.model.response.MexQueryResult;
import it.auties.whatsapp.model.setting.LocaleSetting;
import it.auties.whatsapp.model.setting.PushNameSetting;
import it.auties.whatsapp.model.signal.auth.DeviceIdentity;
import it.auties.whatsapp.model.signal.auth.KeyIndexList;
import it.auties.whatsapp.model.signal.auth.SignedDeviceIdentity;
import it.auties.whatsapp.model.signal.auth.SignedDeviceIdentityHMAC;
import it.auties.whatsapp.model.signal.auth.SignedKeyIndexList;
import it.auties.whatsapp.model.signal.auth.UserAgent;
import it.auties.whatsapp.model.signal.keypair.SignalKeyPair;
import it.auties.whatsapp.model.sync.ActionMessageRangeSync;
import it.auties.whatsapp.model.sync.ActionValueSync;
import it.auties.whatsapp.model.sync.AppStateSyncKey;
import it.auties.whatsapp.model.sync.AppStateSyncKeyData;
import it.auties.whatsapp.model.sync.AppStateSyncKeyFingerprint;
import it.auties.whatsapp.model.sync.AppStateSyncKeyId;
import it.auties.whatsapp.model.sync.AppStateSyncKeyShare;
import it.auties.whatsapp.model.sync.HistorySync;
import it.auties.whatsapp.model.sync.HistorySyncNotification;
import it.auties.whatsapp.model.sync.InitialSecurityNotificationSettingSync;
import it.auties.whatsapp.model.sync.MediaRetryNotification;
import it.auties.whatsapp.model.sync.PatchRequest;
import it.auties.whatsapp.model.sync.PushName;
import it.auties.whatsapp.model.sync.RecordSync;
import it.auties.whatsapp.model.sync.ServerErrorReceipt;
import it.auties.whatsapp.socket.SocketHandler;
import it.auties.whatsapp.socket.SocketState;
import it.auties.whatsapp.util.BytesHelper;
import it.auties.whatsapp.util.Clock;
import it.auties.whatsapp.util.Json;
import it.auties.whatsapp.util.KeyHelper;
import it.auties.whatsapp.util.ListenerScanner;
import it.auties.whatsapp.util.Medias;
import it.auties.whatsapp.util.Protobuf;
import it.auties.whatsapp.util.Spec;
import it.auties.whatsapp.util.Validate;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.HexFormat;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.imageio.ImageIO;
import lombok.NonNull;

public class Whatsapp {
    private static final Map<UUID, Whatsapp> instances = new ConcurrentHashMap<UUID, Whatsapp>();
    private final SocketHandler socketHandler;

    public static boolean isConnected(@NonNull UUID uuid) {
        if (uuid == null) {
            throw new NullPointerException("uuid is marked non-null but is null");
        }
        return SocketHandler.isConnected(uuid);
    }

    public static boolean isConnected(long phoneNumber) {
        return SocketHandler.isConnected(phoneNumber);
    }

    public static boolean isConnected(String alias) {
        return SocketHandler.isConnected(alias);
    }

    private static Whatsapp builder(@NonNull Store store, @NonNull Keys keys, ErrorHandler errorHandler, WebVerificationSupport webVerificationSupport, Executor socketExecutor) {
        if (store == null) {
            throw new NullPointerException("store is marked non-null but is null");
        }
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        Validate.isTrue(Objects.equals(store.uuid(), keys.uuid()), "UUIDs for store and keys don't match: %s != %s", store.uuid(), keys.uuid());
        Whatsapp knownInstance = instances.get(store.uuid());
        if (knownInstance != null) {
            return knownInstance;
        }
        WebVerificationSupport checkedSupport = Whatsapp.getWebVerificationMethod(store, keys, webVerificationSupport);
        Whatsapp result = new Whatsapp(store, keys, errorHandler, checkedSupport, socketExecutor);
        result.addDisconnectedListener((DisconnectReason reason) -> instances.remove(store.uuid()));
        return result;
    }

    private static WebVerificationSupport getWebVerificationMethod(Store store, Keys keys, WebVerificationSupport webVerificationSupport) {
        if (store.clientType() != ClientType.WEB) {
            return null;
        }
        if (!keys.registered() && webVerificationSupport == null) {
            return QrHandler.toTerminal();
        }
        return webVerificationSupport;
    }

    private Whatsapp(@NonNull Store store, @NonNull Keys keys, ErrorHandler errorHandler, WebVerificationSupport webVerificationSupport, Executor socketExecutor) {
        if (store == null) {
            throw new NullPointerException("store is marked non-null but is null");
        }
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        this.socketHandler = new SocketHandler(this, store, keys, errorHandler, webVerificationSupport, socketExecutor);
        if (store.autodetectListeners()) {
            return;
        }
        this.store().addListeners(ListenerScanner.scan(this));
    }

    public static ConnectionBuilder<WebOptionsBuilder> webBuilder() {
        return new ConnectionBuilder<WebOptionsBuilder>(ClientType.WEB);
    }

    public static ConnectionBuilder<MobileOptionsBuilder> mobileBuilder() {
        return new ConnectionBuilder<MobileOptionsBuilder>(ClientType.MOBILE);
    }

    public synchronized CompletableFuture<Whatsapp> connect() {
        return ((CompletableFuture)this.socketHandler.connect().thenRunAsync(() -> instances.put(this.store().uuid(), this))).thenApply(ignored -> this);
    }

    public synchronized CompletableFuture<Void> connectAwaitingLogout() {
        return ((CompletableFuture)this.socketHandler.connect().thenRunAsync(() -> instances.put(this.store().uuid(), this))).thenCompose(ignored -> this.socketHandler.logoutFuture());
    }

    public boolean isConnected() {
        return this.socketHandler.state() == SocketState.CONNECTED;
    }

    public Keys keys() {
        return this.socketHandler.keys();
    }

    public Store store() {
        return this.socketHandler.store();
    }

    public synchronized CompletableFuture<Void> disconnect() {
        return this.socketHandler.disconnect(DisconnectReason.DISCONNECTED);
    }

    public void awaitDisconnection() {
        this.socketHandler.logoutFuture().join();
    }

    public CompletableFuture<Void> reconnect() {
        return this.socketHandler.disconnect(DisconnectReason.RECONNECTING);
    }

    public CompletableFuture<Void> logout() {
        if (this.store().jid() == null) {
            return this.socketHandler.disconnect(DisconnectReason.LOGGED_OUT);
        }
        Map<String, String> metadata = Map.of("jid", this.store().jid(), "reason", "user_initiated");
        Node device = Node.of("remove-companion-device", metadata);
        return this.socketHandler.sendQuery("set", "md", device).thenRun(() -> {});
    }

    @SafeVarargs
    public final <T extends ContactJidProvider> CompletableFuture<Whatsapp> changePrivacySetting(@NonNull PrivacySettingType type, @NonNull PrivacySettingValue value, T ... excluded) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (excluded == null) {
            throw new NullPointerException("excluded is marked non-null but is null");
        }
        Validate.isTrue(type.isSupported(value), "Cannot change setting %s to %s: this toggle cannot be used because Whatsapp doesn't support it", value.name(), type.name());
        ConcurrentHashMap<String, Object> attributes = Attributes.of(new Map.Entry[0]).put("name", type.data()).put("value", value.data()).put("dhash", (Object)"none", () -> value == PrivacySettingValue.CONTACTS_EXCEPT).toMap();
        List<ContactJid> excludedJids = Arrays.stream(excluded).map(ContactJidProvider::toJid).toList();
        List<Node> children = value != PrivacySettingValue.CONTACTS_EXCEPT ? null : excludedJids.stream().map(entry -> Node.of("user", Map.of("jid", entry, "action", "add"))).toList();
        return ((CompletableFuture)this.socketHandler.sendQuery("set", "privacy", Node.of("privacy", (Object)Node.of("category", attributes, children))).thenRunAsync(() -> this.onPrivacyFeatureChanged(type, value, excludedJids))).thenApply(ignored -> this);
    }

    private void onPrivacyFeatureChanged(PrivacySettingType type, PrivacySettingValue value, List<ContactJid> excludedJids) {
        PrivacySettingEntry newEntry = new PrivacySettingEntry(type, value, excludedJids);
        PrivacySettingEntry oldEntry = this.store().findPrivacySetting(type);
        this.store().addPrivacySetting(type, newEntry);
        this.socketHandler.onPrivacySettingChanged(oldEntry, newEntry);
    }

    public CompletableFuture<Whatsapp> changeNewChatsEphemeralTimer(@NonNull ChatEphemeralTimer timer) {
        if (timer == null) {
            throw new NullPointerException("timer is marked non-null but is null");
        }
        return ((CompletableFuture)this.socketHandler.sendQuery("set", "disappearing_mode", Node.of("disappearing_mode", Map.of("duration", timer.period().toSeconds()))).thenRunAsync(() -> this.store().newChatsEphemeralTimer(timer))).thenApply(ignored -> this);
    }

    public CompletableFuture<Whatsapp> createGdprAccountInfo() {
        return this.socketHandler.sendQuery("get", "urn:xmpp:whatsapp:account", Node.of("gdpr", Map.of("gdpr", "request"))).thenApply(ignored -> this);
    }

    public CompletableFuture<GdprAccountReport> getGdprAccountInfoStatus() {
        return this.socketHandler.sendQuery("get", "urn:xmpp:whatsapp:account", Node.of("gdpr", Map.of("gdpr", "status"))).thenApplyAsync(result -> GdprAccountReport.ofPending(result.attributes().getLong("timestamp")));
    }

    public CompletableFuture<Whatsapp> changeName(@NonNull String newName) {
        if (newName == null) {
            throw new NullPointerException("newName is marked non-null but is null");
        }
        String oldName = this.store().name();
        return ((CompletableFuture)this.socketHandler.send(Node.of("presence", Map.of("name", newName))).thenRunAsync(() -> this.socketHandler.updateUserName(newName, oldName))).thenApply(ignored -> this);
    }

    public CompletableFuture<Whatsapp> changeStatus(@NonNull String newStatus) {
        if (newStatus == null) {
            throw new NullPointerException("newStatus is marked non-null but is null");
        }
        return ((CompletableFuture)this.socketHandler.sendQuery("set", "status", Node.of("status", newStatus.getBytes(StandardCharsets.UTF_8))).thenRunAsync(() -> this.store().name(newStatus))).thenApply(ignored -> this);
    }

    public <T extends ContactJidProvider> CompletableFuture<T> subscribeToPresence(@NonNull T jid) {
        if (jid == null) {
            throw new NullPointerException("jid is marked non-null but is null");
        }
        return this.socketHandler.subscribeToPresence(jid).thenApplyAsync(ignored -> jid);
    }

    public CompletableFuture<MessageInfo> removeReaction(@NonNull MessageMetadataProvider message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        return this.sendReaction(message, (String)null);
    }

    public CompletableFuture<MessageInfo> sendReaction(@NonNull MessageMetadataProvider message, String reaction) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        MessageKey key = MessageKey.builder().chatJid(message.chat().jid()).senderJid(message.senderJid()).fromMe(Objects.equals(message.senderJid().toWhatsappJid(), this.store().jid().toWhatsappJid())).id(message.id()).build();
        ReactionMessage reactionMessage = ReactionMessage.builder().key(key).content(reaction).timestamp(Instant.now().toEpochMilli()).build();
        return this.sendMessage((ContactJidProvider)message.chat(), reactionMessage);
    }

    public CompletableFuture<MessageInfo> sendMessage(@NonNull ContactJidProvider chat, @NonNull Message message) {
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        return this.sendMessage(chat, MessageContainer.of(message));
    }

    public CompletableFuture<MessageInfo> sendMessage(@NonNull ContactJidProvider chat, @NonNull MessageContainer message) {
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        MessageKey key = MessageKey.builder().chatJid(chat.toJid()).fromMe(true).senderJid(this.store().jid()).build();
        MessageInfo info = MessageInfo.builder().senderJid(this.store().jid()).key(key).message(message).timestampSeconds(Clock.nowSeconds()).broadcast(chat.toJid().hasServer(ContactJid.Server.BROADCAST)).build();
        return this.sendMessage(info);
    }

    public CompletableFuture<MessageInfo> sendMessage(@NonNull MessageInfo info) {
        if (info == null) {
            throw new NullPointerException("info is marked non-null but is null");
        }
        return this.sendMessage(MessageSendRequest.of(info));
    }

    public CompletableFuture<MessageInfo> sendMessage(@NonNull MessageSendRequest request) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        this.store().attribute(request.info());
        return ((CompletableFuture)this.attributeMessageMetadata(request.info()).thenComposeAsync(ignored -> this.socketHandler.sendMessage(request))).thenApplyAsync(ignored -> request.info());
    }

    private CompletableFuture<Void> attributeMessageMetadata(MessageInfo info) {
        info.key().chatJid(info.chatJid().toWhatsappJid());
        info.key().senderJid(info.senderJid() == null ? null : info.senderJid().toWhatsappJid());
        this.fixEphemeralMessage(info);
        Message content = info.message().content();
        if (content instanceof MediaMessage) {
            MediaMessage mediaMessage = (MediaMessage)content;
            return this.attributeMediaMessage(mediaMessage);
        }
        if (content instanceof ButtonMessage) {
            ButtonMessage buttonMessage = (ButtonMessage)content;
            return this.attributeButtonMessage(info, buttonMessage);
        }
        if (content instanceof TextMessage) {
            TextMessage textMessage = (TextMessage)content;
            this.attributeTextMessage(textMessage);
        } else if (content instanceof PollCreationMessage) {
            PollCreationMessage pollCreationMessage = (PollCreationMessage)content;
            this.attributePollCreationMessage(info, pollCreationMessage);
        } else if (content instanceof PollUpdateMessage) {
            PollUpdateMessage pollUpdateMessage = (PollUpdateMessage)content;
            this.attributePollUpdateMessage(info, pollUpdateMessage);
        } else if (content instanceof GroupInviteMessage) {
            GroupInviteMessage groupInviteMessage = (GroupInviteMessage)content;
            this.attributeGroupInviteMessage(info, groupInviteMessage);
        }
        return CompletableFuture.completedFuture(null);
    }

    public <T extends ContactJidProvider> CompletableFuture<T> markRead(@NonNull T chat) {
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        return ((CompletableFuture)this.mark(chat, true).thenComposeAsync(ignored -> this.markAllAsRead(chat))).thenApplyAsync(ignored -> chat);
    }

    private void fixEphemeralMessage(MessageInfo info) {
        if (info.message().hasCategory(MessageCategory.SERVER)) {
            return;
        }
        if (info.chat().isEphemeral()) {
            info.message().contentWithContext().map(ContextualMessage::contextInfo).ifPresent(contextInfo -> this.createEphemeralContext(info.chat(), (ContextInfo)contextInfo));
            info.message(info.message().toEphemeral());
            return;
        }
        if (info.message().type() != MessageType.EPHEMERAL) {
            return;
        }
        info.message(info.message().unbox());
    }

    private void attributeTextMessage(TextMessage textMessage) {
        if (this.store().textPreviewSetting() == TextPreviewSetting.DISABLED) {
            return;
        }
        LinkPreviewMatch match = LinkPreview.createPreview((String)textMessage.text()).orElse(null);
        if (match == null) {
            return;
        }
        String uri = match.result().uri().toString();
        if (this.store().textPreviewSetting() == TextPreviewSetting.ENABLED_WITH_INFERENCE && !match.text().equals(uri)) {
            textMessage.text(textMessage.text().replace(match.text(), uri));
        }
        URI imageUri = match.result().images().stream().reduce(this::compareDimensions).map(LinkPreviewMedia::uri).orElse(null);
        URI videoUri = match.result().videos().stream().reduce(this::compareDimensions).map(LinkPreviewMedia::uri).orElse(null);
        textMessage.matchedText(uri);
        textMessage.canonicalUrl(Objects.requireNonNullElse(videoUri, match.result().uri()).toString());
        textMessage.thumbnail(Medias.download(imageUri).orElse(null));
        textMessage.description(match.result().siteDescription());
        textMessage.title(match.result().title());
        textMessage.previewType(videoUri != null ? TextMessage.TextMessagePreviewType.VIDEO : TextMessage.TextMessagePreviewType.NONE);
    }

    private CompletableFuture<Void> attributeMediaMessage(MediaMessage mediaMessage) {
        return Medias.upload(mediaMessage.decodedMedia().orElseThrow(), mediaMessage.mediaType().toAttachmentType(), this.store().mediaConnection()).thenAccept(upload -> this.attributeMediaMessage(mediaMessage, (MediaFile)upload));
    }

    private AttachmentProvider attributeMediaMessage(MediaMessage mediaMessage, MediaFile upload) {
        return mediaMessage.mediaSha256(upload.fileSha256()).mediaEncryptedSha256(upload.fileEncSha256()).mediaKey(upload.mediaKey()).mediaUrl(upload.url()).mediaDirectPath(upload.directPath()).mediaSize(upload.fileLength());
    }

    private void attributePollCreationMessage(MessageInfo info, PollCreationMessage pollCreationMessage) {
        byte[] pollEncryptionKey = Objects.requireNonNullElseGet(pollCreationMessage.encryptionKey(), KeyHelper::senderKey);
        pollCreationMessage.encryptionKey(pollEncryptionKey);
        info.messageSecret(pollEncryptionKey);
        info.message().deviceInfo().messageSecret(pollEncryptionKey);
        PollAdditionalMetadata metadata = new PollAdditionalMetadata(false);
        info.pollAdditionalMetadata(metadata);
    }

    private void attributePollUpdateMessage(MessageInfo info, PollUpdateMessage pollUpdateMessage) {
        if (pollUpdateMessage.encryptedMetadata() != null) {
            return;
        }
        byte[] iv = BytesHelper.random(12);
        String additionalData = "%s\u0000%s".formatted(pollUpdateMessage.pollCreationMessageKey().id(), this.store().jid().toWhatsappJid());
        List<byte[]> encryptedOptions = pollUpdateMessage.votes().stream().map(entry -> Sha256.calculate(entry.name())).toList();
        byte[] pollUpdateEncryptedOptions = Protobuf.writeMessage(new PollUpdateEncryptedOptions(encryptedOptions));
        MessageInfo originalPollInfo = this.store().findMessageByKey(pollUpdateMessage.pollCreationMessageKey()).orElseThrow(() -> new NoSuchElementException("Missing original poll message"));
        PollCreationMessage originalPollMessage = (PollCreationMessage)originalPollInfo.message().content();
        byte[] originalPollSender = originalPollInfo.senderJid().toWhatsappJid().toString().getBytes(StandardCharsets.UTF_8);
        ContactJid modificationSenderJid = info.senderJid().toWhatsappJid();
        pollUpdateMessage.voter(modificationSenderJid);
        byte[] modificationSender = modificationSenderJid.toString().getBytes(StandardCharsets.UTF_8);
        byte[] secretName = pollUpdateMessage.secretName().getBytes(StandardCharsets.UTF_8);
        byte[] useSecretPayload = BytesHelper.concat(pollUpdateMessage.pollCreationMessageKey().id().getBytes(StandardCharsets.UTF_8), originalPollSender, modificationSender, secretName);
        byte[] useCaseSecret = Hkdf.extractAndExpand(originalPollMessage.encryptionKey(), useSecretPayload, 32);
        byte[] pollUpdateEncryptedPayload = AesGmc.encrypt(iv, pollUpdateEncryptedOptions, useCaseSecret, additionalData.getBytes(StandardCharsets.UTF_8));
        PollUpdateEncryptedMetadata pollUpdateEncryptedMetadata = new PollUpdateEncryptedMetadata(pollUpdateEncryptedPayload, iv);
        pollUpdateMessage.encryptedMetadata(pollUpdateEncryptedMetadata);
    }

    private CompletableFuture<Void> attributeButtonMessage(MessageInfo info, ButtonMessage buttonMessage) {
        InteractiveMessage interactiveMessage;
        TemplateMessage templateMessage;
        Object object;
        ButtonsMessage buttonsMessage;
        if (buttonMessage instanceof ButtonsMessage && (buttonsMessage = (ButtonsMessage)buttonMessage).header().isPresent() && (object = buttonsMessage.header().get()) instanceof MediaMessage) {
            MediaMessage mediaMessage = (MediaMessage)object;
            return this.attributeMediaMessage(mediaMessage);
        }
        if (buttonMessage instanceof TemplateMessage && (templateMessage = (TemplateMessage)buttonMessage).format().isPresent()) {
            HydratedFourRowTemplate hydratedFourRowTemplate;
            Object object2;
            HighlyStructuredFourRowTemplate highlyStructuredFourRowTemplate;
            TemplateFormatter templateFormatter = templateMessage.format().get();
            if (templateFormatter instanceof HighlyStructuredFourRowTemplate && (highlyStructuredFourRowTemplate = (HighlyStructuredFourRowTemplate)templateFormatter).title().isPresent() && (object2 = highlyStructuredFourRowTemplate.title().get()) instanceof MediaMessage) {
                MediaMessage mediaMessage = (MediaMessage)object2;
                return this.attributeMediaMessage(mediaMessage);
            }
            if (templateFormatter instanceof HydratedFourRowTemplate && (hydratedFourRowTemplate = (HydratedFourRowTemplate)templateFormatter).title().isPresent() && (object2 = hydratedFourRowTemplate.title().get()) instanceof MediaMessage) {
                MediaMessage mediaMessage = (MediaMessage)object2;
                return this.attributeMediaMessage(mediaMessage);
            }
            return CompletableFuture.completedFuture(null);
        }
        if (buttonMessage instanceof InteractiveMessage && (interactiveMessage = (InteractiveMessage)buttonMessage).header().isPresent() && interactiveMessage.header().get().attachment().isPresent() && (object = interactiveMessage.header().get().attachment().get()) instanceof MediaMessage) {
            MediaMessage mediaMessage = (MediaMessage)object;
            return this.attributeMediaMessage(mediaMessage);
        }
        return CompletableFuture.completedFuture(null);
    }

    private void attributeGroupInviteMessage(MessageInfo info, GroupInviteMessage groupInviteMessage) {
        Validate.isTrue(groupInviteMessage.code() != null, "Invalid message code", new Object[0]);
        String url = "https://chat.whatsapp.com/%s".formatted(groupInviteMessage.code());
        URI preview = LinkPreview.createPreview((URI)URI.create(url)).stream().map(LinkPreviewResult::images).map(Collection::stream).map(Stream::findFirst).flatMap(Optional::stream).findFirst().map(LinkPreviewMedia::uri).orElse(null);
        ContextualMessage replacement = ((TextMessage.TextMessageBuilder)((TextMessage.TextMessageBuilder)((TextMessage.TextMessageBuilder)((TextMessage.TextMessageBuilder)((TextMessage.TextMessageBuilder)((TextMessage.TextMessageBuilder)((TextMessage.TextMessageBuilder)TextMessage.builder().text(groupInviteMessage.caption() != null ? "%s: %s".formatted(groupInviteMessage.caption(), url) : url)).description("WhatsApp Group Invite")).title(groupInviteMessage.groupName())).previewType(TextMessage.TextMessagePreviewType.NONE)).thumbnail(Medias.download(preview).orElse(null))).matchedText(url)).canonicalUrl(url)).build();
        info.message(MessageContainer.of(replacement));
    }

    private <T extends ContactJidProvider> CompletableFuture<T> mark(@NonNull T chat, boolean read) {
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        if (this.store().clientType() == ClientType.MOBILE) {
            this.store().findChatByJid(chat.toJid()).ifPresent(entry -> entry.markedAsUnread(read));
            return CompletableFuture.completedFuture(chat);
        }
        ActionMessageRangeSync range = this.createRange(chat, false);
        MarkChatAsReadAction markAction = new MarkChatAsReadAction(read, range);
        ActionValueSync syncAction = ActionValueSync.of(markAction);
        PatchRequest.PatchEntry entry2 = PatchRequest.PatchEntry.of(syncAction, RecordSync.Operation.SET, 3, chat.toJid().toString());
        PatchRequest request = new PatchRequest(BinaryPatchType.REGULAR_HIGH, List.of(entry2));
        return this.socketHandler.pushPatch(request).thenApplyAsync(ignored -> chat);
    }

    private CompletableFuture<Void> markAllAsRead(ContactJidProvider chat) {
        CompletableFuture[] all = (CompletableFuture[])this.store().findChatByJid(chat.toJid()).stream().map(Chat::unreadMessages).flatMap(Collection::stream).map(this::markRead).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(all);
    }

    private LinkPreviewMedia compareDimensions(LinkPreviewMedia first, LinkPreviewMedia second) {
        return first.width() * first.height() > second.width() * second.height() ? first : second;
    }

    private ActionMessageRangeSync createRange(ContactJidProvider chat, boolean allMessages) {
        Chat known = this.store().findChatByJid(chat.toJid()).orElseGet(() -> this.store().addNewChat(chat.toJid()));
        return new ActionMessageRangeSync(known, allMessages);
    }

    public CompletableFuture<MessageInfo> markRead(@NonNull MessageInfo info) {
        if (info == null) {
            throw new NullPointerException("info is marked non-null but is null");
        }
        String type = this.store().findPrivacySetting(PrivacySettingType.READ_RECEIPTS).value() == PrivacySettingValue.EVERYONE ? "read" : "read-self";
        this.socketHandler.sendReceipt(info.chatJid(), info.senderJid(), List.of(info.id()), type);
        int count = info.chat().unreadMessagesCount();
        if (count > 0) {
            info.chat().unreadMessagesCount(count - 1);
        }
        return CompletableFuture.completedFuture(info.status(MessageStatus.READ));
    }

    private void createEphemeralContext(Chat chat, ContextInfo contextInfo) {
        long period = chat.ephemeralMessageDuration().period().toSeconds();
        contextInfo.ephemeralExpiration((int)period);
    }

    public CompletableFuture<MessageInfo> sendReaction(@NonNull MessageMetadataProvider message, Emoji reaction) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        return this.sendReaction(message, Objects.toString((Object)reaction));
    }

    public CompletableFuture<MessageInfo> sendMessage(@NonNull ContactJidProvider chat, @NonNull String message) {
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        return this.sendMessage(chat, MessageContainer.of(message));
    }

    public CompletableFuture<MessageInfo> sendMessage(@NonNull ContactJidProvider chat, @NonNull String message, @NonNull MessageMetadataProvider quotedMessage) {
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        if (quotedMessage == null) {
            throw new NullPointerException("quotedMessage is marked non-null but is null");
        }
        return this.sendMessage(chat, (ContextualMessage)TextMessage.of(message), quotedMessage);
    }

    public CompletableFuture<MessageInfo> sendMessage(@NonNull ContactJidProvider chat, @NonNull ContextualMessage message, @NonNull MessageMetadataProvider quotedMessage) {
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        if (quotedMessage == null) {
            throw new NullPointerException("quotedMessage is marked non-null but is null");
        }
        Validate.isTrue(!quotedMessage.message().isEmpty(), "Cannot quote an empty message", new Object[0]);
        Validate.isTrue(!quotedMessage.message().hasCategory(MessageCategory.SERVER), "Cannot quote a server message", new Object[0]);
        return this.sendMessage(chat, message, ContextInfo.of(quotedMessage));
    }

    public CompletableFuture<MessageInfo> sendMessage(@NonNull ContactJidProvider chat, @NonNull ContextualMessage message, @NonNull ContextInfo contextInfo) {
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        if (contextInfo == null) {
            throw new NullPointerException("contextInfo is marked non-null but is null");
        }
        message.contextInfo(contextInfo);
        return this.sendMessage(chat, message);
    }

    public CompletableFuture<MessageInfo> awaitReply(@NonNull MessageInfo info) {
        if (info == null) {
            throw new NullPointerException("info is marked non-null but is null");
        }
        return this.awaitReply(info.id());
    }

    public CompletableFuture<MessageInfo> awaitReply(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        return this.store().addPendingReply(ReplyHandler.of(id));
    }

    public CompletableFuture<HasWhatsappResponse> hasWhatsapp(@NonNull ContactJidProvider contact) {
        if (contact == null) {
            throw new NullPointerException("contact is marked non-null but is null");
        }
        return this.hasWhatsapp(new ContactJidProvider[]{contact}).thenApply(result -> (HasWhatsappResponse)result.get(contact.toJid()));
    }

    public CompletableFuture<Map<ContactJid, HasWhatsappResponse>> hasWhatsapp(ContactJidProvider ... contacts) {
        if (contacts == null) {
            throw new NullPointerException("contacts is marked non-null but is null");
        }
        Node[] contactNodes = (Node[])Arrays.stream(contacts).map(jid -> Node.of("user", (Object)Node.of("contact", jid.toJid().toPhoneNumber()))).toArray(Node[]::new);
        return this.socketHandler.sendInteractiveQuery(Node.of("contact"), contactNodes).thenApplyAsync(this::parseHasWhatsappResponse);
    }

    private Map<ContactJid, HasWhatsappResponse> parseHasWhatsappResponse(List<Node> nodes) {
        return nodes.stream().map(HasWhatsappResponse::new).collect(Collectors.toMap(HasWhatsappResponse::contact, Function.identity()));
    }

    public CompletableFuture<List<ContactJid>> queryBlockList() {
        return this.socketHandler.queryBlockList();
    }

    public CompletableFuture<Optional<String>> queryName(@NonNull ContactJidProvider contactJid) {
        if (contactJid == null) {
            throw new NullPointerException("contactJid is marked non-null but is null");
        }
        Optional<Contact> contact = this.store().findContactByJid(contactJid);
        if (contact.isPresent()) {
            return CompletableFuture.completedFuture(Optional.ofNullable(contact.get().chosenName()));
        }
        MexQueryRequest query = new MexQueryRequest(List.of(new MexQueryRequest.User(contactJid.toJid().user())), List.of("STATUS"));
        return this.socketHandler.sendQuery("get", "w:mex", Node.of("query", Json.writeValueAsBytes(query))).thenApplyAsync(this::parseNameResponse);
    }

    private Optional<String> parseNameResponse(Node result) {
        return result.findNode("result").flatMap(Node::contentAsString).map(json -> Json.readValue(json, MexQueryResult.class)).map(MexQueryResult::data).map(String::valueOf);
    }

    public CompletableFuture<Optional<ContactStatusResponse>> queryAbout(@NonNull ContactJidProvider chat) {
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        return this.socketHandler.queryAbout(chat);
    }

    public CompletableFuture<Optional<URI>> queryPicture(@NonNull ContactJidProvider chat) {
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        return this.socketHandler.queryPicture(chat);
    }

    public CompletableFuture<GroupMetadata> queryGroupMetadata(@NonNull ContactJidProvider chat) {
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        return this.socketHandler.queryGroupMetadata(chat.toJid());
    }

    public CompletableFuture<Optional<BusinessProfile>> queryBusinessProfile(@NonNull ContactJidProvider contact) {
        if (contact == null) {
            throw new NullPointerException("contact is marked non-null but is null");
        }
        return this.socketHandler.sendQuery("get", "w:biz", Node.of("business_profile", Map.of("v", 116), (Object)Node.of("profile", Map.of("jid", contact.toJid())))).thenApplyAsync(this::getBusinessProfile);
    }

    private Optional<BusinessProfile> getBusinessProfile(Node result) {
        return result.findNode("business_profile").flatMap(entry -> entry.findNode("profile")).map(BusinessProfile::of);
    }

    public CompletableFuture<List<BusinessCategory>> queryBusinessCategories() {
        return this.socketHandler.queryBusinessCategories();
    }

    public CompletableFuture<String> queryGroupInviteCode(@NonNull ContactJidProvider chat) {
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        return this.socketHandler.sendQuery(chat.toJid(), "get", "w:g2", Node.of("invite")).thenApplyAsync(Whatsapp::parseInviteCode);
    }

    private static String parseInviteCode(Node result) {
        return result.findNode("invite").orElseThrow(() -> new NoSuchElementException("Missing invite code in invite response")).attributes().getRequiredString("code");
    }

    public <T extends ContactJidProvider> CompletableFuture<T> revokeGroupInvite(@NonNull T chat) {
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        return this.socketHandler.sendQuery(chat.toJid(), "set", "w:g2", Node.of("invite")).thenApplyAsync(ignored -> chat);
    }

    public CompletableFuture<Optional<Chat>> acceptGroupInvite(@NonNull String inviteCode) {
        if (inviteCode == null) {
            throw new NullPointerException("inviteCode is marked non-null but is null");
        }
        return this.socketHandler.sendQuery(ContactJid.Server.GROUP.toJid(), "set", "w:g2", Node.of("invite", Map.of("code", inviteCode))).thenApplyAsync(this::parseAcceptInvite);
    }

    private Optional<Chat> parseAcceptInvite(Node result) {
        return result.findNode("group").flatMap(group -> group.attributes().getJid("jid")).map(jid -> this.store().findChatByJid((ContactJidProvider)jid).orElseGet(() -> this.store().addNewChat((ContactJid)jid)));
    }

    public CompletableFuture<Boolean> changePresence(boolean available) {
        boolean status = this.socketHandler.store().online();
        if (status == available) {
            return CompletableFuture.completedFuture(status);
        }
        ContactStatus presence = available ? ContactStatus.AVAILABLE : ContactStatus.UNAVAILABLE;
        Node node = Node.of("presence", Map.of("name", this.store().name(), "type", presence.data()));
        return ((CompletableFuture)this.socketHandler.sendWithNoResponse(node).thenAcceptAsync(socketHandler -> this.updateSelfPresence(null, presence))).thenApplyAsync(ignored -> available);
    }

    private void updateSelfPresence(ContactJidProvider chatJid, ContactStatus presence) {
        Optional<Contact> self;
        if (chatJid == null) {
            this.store().online(presence == ContactStatus.AVAILABLE);
        }
        if ((self = this.store().findContactByJid(this.store().jid().toWhatsappJid())).isEmpty()) {
            return;
        }
        if (presence == ContactStatus.AVAILABLE || presence == ContactStatus.UNAVAILABLE) {
            self.get().lastKnownPresence(presence);
        }
        if (chatJid != null) {
            this.store().findChatByJid(chatJid).ifPresent(chat -> chat.presences().put(((Contact)self.get()).jid(), presence));
        }
        self.get().lastSeen(ZonedDateTime.now());
    }

    public <T extends ContactJidProvider> CompletableFuture<T> changePresence(@NonNull T chatJid, @NonNull ContactStatus presence) {
        if (chatJid == null) {
            throw new NullPointerException("chatJid is marked non-null but is null");
        }
        if (presence == null) {
            throw new NullPointerException("presence is marked non-null but is null");
        }
        ContactStatus knownPresence = this.store().findChatByJid(chatJid).map(Chat::presences).map(entry -> (ContactStatus)((Object)((Object)entry.get(this.store().jid().toWhatsappJid())))).orElse(null);
        if (knownPresence == ContactStatus.COMPOSING || knownPresence == ContactStatus.RECORDING) {
            Node node = Node.of("chatstate", Map.of("to", chatJid.toJid()), (Object)Node.of("paused"));
            return this.socketHandler.sendWithNoResponse(node).thenApplyAsync(ignored -> chatJid);
        }
        if (presence == ContactStatus.COMPOSING || presence == ContactStatus.RECORDING) {
            String tag = presence == ContactStatus.RECORDING ? ContactStatus.COMPOSING.data() : presence.data();
            Node node = Node.of("chatstate", Map.of("to", chatJid.toJid()), (Object)Node.of(ContactStatus.COMPOSING.data(), presence == ContactStatus.RECORDING ? Map.of("media", "audio") : Map.of()));
            return ((CompletableFuture)this.socketHandler.sendWithNoResponse(node).thenAcceptAsync(socketHandler -> this.updateSelfPresence(chatJid, presence))).thenApplyAsync(ignored -> chatJid);
        }
        Node node = Node.of("presence", Map.of("type", presence.data(), "name", this.store().name()));
        return ((CompletableFuture)this.socketHandler.sendWithNoResponse(node).thenAcceptAsync(socketHandler -> this.updateSelfPresence(chatJid, presence))).thenApplyAsync(ignored -> chatJid);
    }

    public CompletableFuture<List<ContactJid>> promote(@NonNull ContactJidProvider group, ContactJidProvider ... contacts) {
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (contacts == null) {
            throw new NullPointerException("contacts is marked non-null but is null");
        }
        return this.executeActionOnGroupParticipant(group, GroupAction.PROMOTE, contacts);
    }

    public CompletableFuture<List<ContactJid>> demote(@NonNull ContactJidProvider group, ContactJidProvider ... contacts) {
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (contacts == null) {
            throw new NullPointerException("contacts is marked non-null but is null");
        }
        return this.executeActionOnGroupParticipant(group, GroupAction.DEMOTE, contacts);
    }

    public CompletableFuture<List<ContactJid>> addGroupParticipant(@NonNull ContactJidProvider group, ContactJidProvider ... contacts) {
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (contacts == null) {
            throw new NullPointerException("contacts is marked non-null but is null");
        }
        return this.executeActionOnGroupParticipant(group, GroupAction.ADD, contacts);
    }

    public CompletableFuture<List<ContactJid>> removeGroupParticipant(@NonNull ContactJidProvider group, ContactJidProvider ... contacts) {
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (contacts == null) {
            throw new NullPointerException("contacts is marked non-null but is null");
        }
        return this.executeActionOnGroupParticipant(group, GroupAction.REMOVE, contacts);
    }

    private CompletableFuture<List<ContactJid>> executeActionOnGroupParticipant(ContactJidProvider group, GroupAction action, ContactJidProvider ... jids) {
        Node[] body = (Node[])Arrays.stream(jids).map(ContactJidProvider::toJid).map(jid -> Node.of("participant", Map.of("jid", this.checkGroupParticipantJid((ContactJid)jid, "Cannot execute action on yourself")))).map(innerBody -> Node.of(action.data(), innerBody)).toArray(Node[]::new);
        return this.socketHandler.sendQuery(group.toJid(), "set", "w:g2", body).thenApplyAsync(result -> this.parseGroupActionResponse((Node)result, group, action));
    }

    private ContactJid checkGroupParticipantJid(ContactJid jid, String errorMessage) {
        Validate.isTrue(!Objects.equals(jid.toWhatsappJid(), this.store().jid().toWhatsappJid()), errorMessage, new Object[0]);
        return jid;
    }

    private List<ContactJid> parseGroupActionResponse(Node result, ContactJidProvider groupJid, GroupAction action) {
        Chat entry2;
        Chat chat;
        List<ContactJid> results = result.findNode(action.data()).orElseThrow(() -> new NoSuchElementException("An erroneous group operation was executed")).findNodes("participant").stream().filter(participant -> !participant.attributes().hasKey("error")).map(participant -> participant.attributes().getJid("jid")).flatMap(Optional::stream).toList();
        Chat chat2 = chat = groupJid instanceof Chat ? (entry2 = (Chat)groupJid) : (Chat)this.store().findChatByJid(groupJid).orElse(null);
        if (chat != null) {
            results.forEach(entry -> this.handleGroupAction(action, chat, (ContactJid)entry));
        }
        return results;
    }

    private void handleGroupAction(GroupAction action, Chat chat, ContactJid entry) {
        switch (action) {
            case ADD: {
                chat.addParticipant(entry, GroupRole.USER);
                break;
            }
            case REMOVE: {
                chat.removeParticipant(entry);
                chat.addPastParticipant(new PastParticipant(entry, PastParticipant.LeaveReason.REMOVED, Clock.nowSeconds()));
                break;
            }
            case PROMOTE: {
                chat.findParticipant(entry).ifPresent(participant -> participant.role(GroupRole.ADMIN));
                break;
            }
            case DEMOTE: {
                chat.findParticipant(entry).ifPresent(participant -> participant.role(GroupRole.USER));
            }
        }
    }

    public <T extends ContactJidProvider> CompletableFuture<T> changeGroupSubject(@NonNull T group, @NonNull String newName) {
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (newName == null) {
            throw new NullPointerException("newName is marked non-null but is null");
        }
        Node body = Node.of("subject", newName.getBytes(StandardCharsets.UTF_8));
        return this.socketHandler.sendQuery(group.toJid(), "set", "w:g2", body).thenApplyAsync(ignored -> group);
    }

    public <T extends ContactJidProvider> CompletableFuture<T> changeGroupDescription(@NonNull T group, String description) {
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        return ((CompletableFuture)((CompletableFuture)this.socketHandler.queryGroupMetadata(group.toJid()).thenApplyAsync(GroupMetadata::descriptionId)).thenComposeAsync(descriptionId -> this.changeGroupDescription(group, description, (String)descriptionId))).thenApplyAsync(ignored -> group);
    }

    private CompletableFuture<Void> changeGroupDescription(ContactJidProvider group, String description, String descriptionId) {
        Node descriptionNode = Optional.ofNullable(description).map(content -> Node.of("body", content.getBytes(StandardCharsets.UTF_8))).orElse(null);
        ConcurrentHashMap<String, Object> attributes = Attributes.of(new Map.Entry[0]).put("id", (Object)MessageKey.randomId(), () -> description != null).put("delete", (Object)true, () -> description == null).put("prev", (Object)descriptionId, () -> descriptionId != null).toMap();
        Node body = Node.of("description", attributes, (Object)descriptionNode);
        return this.socketHandler.sendQuery(group.toJid(), "set", "w:g2", body).thenRunAsync(() -> this.onDescriptionSet(group, description));
    }

    private void onDescriptionSet(ContactJidProvider groupJid, String description) {
        if (groupJid instanceof Chat) {
            Chat chat2 = (Chat)groupJid;
            chat2.description(description);
            return;
        }
        Optional<Chat> group = this.store().findChatByJid(groupJid);
        group.ifPresent(chat -> chat.description(description));
    }

    public <T extends ContactJidProvider> CompletableFuture<T> changeWhoCanSendMessages(@NonNull T group, @NonNull GroupPolicy policy) {
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (policy == null) {
            throw new NullPointerException("policy is marked non-null but is null");
        }
        Node body = Node.of(policy != GroupPolicy.ANYONE ? "not_announcement" : "announcement");
        return this.socketHandler.sendQuery(group.toJid(), "set", "w:g2", body).thenApplyAsync(ignored -> group);
    }

    public <T extends ContactJidProvider> CompletableFuture<T> changeWhoCanEditInfo(@NonNull T group, @NonNull GroupPolicy policy) {
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (policy == null) {
            throw new NullPointerException("policy is marked non-null but is null");
        }
        Node body = Node.of(policy != GroupPolicy.ANYONE ? "locked" : "unlocked");
        return this.socketHandler.sendQuery(group.toJid(), "set", "w:g2", body).thenApplyAsync(ignored -> group);
    }

    public CompletableFuture<ContactJid> changeProfilePicture(byte[] image) {
        return this.changeGroupPicture(this.store().jid(), image);
    }

    public <T extends ContactJidProvider> CompletableFuture<T> changeGroupPicture(@NonNull T group, URI image) {
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        return this.changeGroupPicture(group, image == null ? null : Medias.download(image).orElseThrow(() -> new IllegalArgumentException("Invalid uri: %s".formatted(image))));
    }

    public <T extends ContactJidProvider> CompletableFuture<T> changeGroupPicture(@NonNull T group, byte[] image) {
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        byte[] profilePic = image != null ? Medias.getProfilePic(image) : null;
        Node body = Node.of("picture", Map.of("type", "image"), (Object)profilePic);
        return this.socketHandler.sendQuery(group.toJid().toWhatsappJid(), "set", "w:profile:picture", body).thenApplyAsync(ignored -> group);
    }

    public CompletableFuture<GroupMetadata> createGroup(@NonNull String subject, ContactJidProvider ... contacts) {
        if (subject == null) {
            throw new NullPointerException("subject is marked non-null but is null");
        }
        if (contacts == null) {
            throw new NullPointerException("contacts is marked non-null but is null");
        }
        return this.createGroup(subject, ChatEphemeralTimer.OFF, contacts);
    }

    public CompletableFuture<GroupMetadata> createGroup(@NonNull String subject, @NonNull ChatEphemeralTimer timer, ContactJidProvider ... contacts) {
        if (subject == null) {
            throw new NullPointerException("subject is marked non-null but is null");
        }
        if (timer == null) {
            throw new NullPointerException("timer is marked non-null but is null");
        }
        if (contacts == null) {
            throw new NullPointerException("contacts is marked non-null but is null");
        }
        return this.createGroup(subject, timer, (ContactJidProvider)null, contacts);
    }

    public CompletableFuture<GroupMetadata> createGroup(@NonNull String subject, @NonNull ChatEphemeralTimer timer, ContactJidProvider parentGroup) {
        if (subject == null) {
            throw new NullPointerException("subject is marked non-null but is null");
        }
        if (timer == null) {
            throw new NullPointerException("timer is marked non-null but is null");
        }
        return this.createGroup(subject, timer, parentGroup, new ContactJidProvider[0]);
    }

    public CompletableFuture<GroupMetadata> createGroup(@NonNull String subject, @NonNull ChatEphemeralTimer timer, ContactJidProvider parentGroup, ContactJidProvider ... contacts) {
        if (subject == null) {
            throw new NullPointerException("subject is marked non-null but is null");
        }
        if (timer == null) {
            throw new NullPointerException("timer is marked non-null but is null");
        }
        if (contacts == null) {
            throw new NullPointerException("contacts is marked non-null but is null");
        }
        Validate.isTrue(!subject.isBlank(), "The subject of a group cannot be blank", new Object[0]);
        int minimumMembersCount = parentGroup == null ? 1 : 0;
        Validate.isTrue(contacts.length >= minimumMembersCount, "Expected at least %s members for this group", minimumMembersCount);
        ArrayList<Node> children = new ArrayList<Node>();
        if (parentGroup != null) {
            children.add(Node.of("linked_parent", Map.of("jid", parentGroup.toJid())));
        }
        if (timer != ChatEphemeralTimer.OFF) {
            children.add(Node.of("ephemeral", Map.of("expiration", timer.periodSeconds())));
        }
        Arrays.stream(contacts).map(contact -> Node.of("participant", Map.of("jid", this.checkGroupParticipantJid(contact.toJid(), "Cannot create group with yourself as a participant")))).forEach(children::add);
        String key = HexFormat.of().formatHex(BytesHelper.random(12));
        Node body = Node.of("create", Map.of("subject", subject, "key", key), children);
        return this.socketHandler.sendQuery(ContactJid.Server.GROUP.toJid(), "set", "w:g2", body).thenApplyAsync(this::parseGroupResponse);
    }

    private GroupMetadata parseGroupResponse(Node response) {
        return Optional.ofNullable(response).flatMap(node -> node.findNode("group")).map(GroupMetadata::of).map(this::addNewGroup).orElseThrow(() -> new NoSuchElementException("Missing group response, something went wrong: %s".formatted(this.findErrorNode(response))));
    }

    private GroupMetadata addNewGroup(GroupMetadata result) {
        Chat chat = Chat.builder().jid(result.jid()).description(result.description().orElse(null)).participants(result.participants()).founder(result.founder().orElse(null)).foundationTimestampSeconds(result.foundationTimestamp().toEpochSecond()).build();
        this.store().addChat(chat);
        return result;
    }

    private String findErrorNode(Node result) {
        return Optional.ofNullable(result).flatMap(node -> node.findNode("error")).map(Node::toString).orElseGet(() -> Objects.toString(result));
    }

    public <T extends ContactJidProvider> CompletableFuture<T> leaveGroup(@NonNull T group) {
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        Node body = Node.of("leave", (Object)Node.of("group", Map.of("id", group.toJid())));
        return this.socketHandler.sendQuery(ContactJid.Server.GROUP.toJid(), "set", "w:g2", body).thenApplyAsync(ignored -> this.handleLeaveGroup(group));
    }

    private <T extends ContactJidProvider> T handleLeaveGroup(T group) {
        Chat entry;
        Chat chat;
        Chat chat2 = chat = group instanceof Chat ? (entry = (Chat)group) : (Chat)this.store().findChatByJid(group).orElse(null);
        if (chat != null) {
            PastParticipant pastParticipant = PastParticipant.builder().jid(this.store().jid().toWhatsappJid()).reason(PastParticipant.LeaveReason.REMOVED).timestampSeconds(Clock.nowSeconds()).build();
            chat.addPastParticipant(pastParticipant);
        }
        return group;
    }

    public CompletableFuture<Map<ContactJid, Boolean>> linkGroupsToCommunity(@NonNull ContactJidProvider community, ContactJidProvider ... groups) {
        if (community == null) {
            throw new NullPointerException("community is marked non-null but is null");
        }
        if (groups == null) {
            throw new NullPointerException("groups is marked non-null but is null");
        }
        Node[] body = (Node[])Arrays.stream(groups).map(entry -> Node.of("group", Map.of("jid", entry.toJid()))).toArray(Node[]::new);
        return this.socketHandler.sendQuery(community.toJid(), "set", "w:g2", Node.of("links", (Object)Node.of("link", Map.of("link_type", "sub_group"), body))).thenApplyAsync(result -> this.parseLinksResponse((Node)result, groups));
    }

    private Map<ContactJid, Boolean> parseLinksResponse(Node result, @NonNull ContactJidProvider[] groups) {
        if (groups == null) {
            throw new NullPointerException("groups is marked non-null but is null");
        }
        Set success = result.findNode("links").stream().map(entry -> entry.findNodes("link")).flatMap(Collection::stream).filter(entry -> entry.attributes().hasKey("link_type", "sub_group")).map(entry -> entry.findNode("group")).flatMap(Optional::stream).map(entry -> entry.attributes().getJid("jid")).flatMap(Optional::stream).collect(Collectors.toUnmodifiableSet());
        return Arrays.stream(groups).map(ContactJidProvider::toJid).collect(Collectors.toUnmodifiableMap(Function.identity(), success::contains));
    }

    public CompletableFuture<Boolean> unlinkGroupFromCommunity(@NonNull ContactJidProvider community, @NonNull ContactJidProvider group) {
        if (community == null) {
            throw new NullPointerException("community is marked non-null but is null");
        }
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        return this.socketHandler.sendQuery(community.toJid(), "set", "w:g2", Node.of("unlink", Map.of("unlink_type", "sub_group"), (Object)Node.of("group", Map.of("jid", group.toJid())))).thenApplyAsync(result -> this.parseUnlinkResponse((Node)result, group));
    }

    private boolean parseUnlinkResponse(Node result, @NonNull ContactJidProvider group) {
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        return result.findNode("unlink").filter(entry -> entry.attributes().hasKey("unlink_type", "sub_group")).flatMap(entry -> entry.findNode("group")).map(entry -> entry.attributes().hasKey("jid", group.toJid().toString())).isPresent();
    }

    public <T extends ContactJidProvider> CompletableFuture<T> mute(@NonNull T chat) {
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        return this.mute(chat, ChatMute.muted());
    }

    public <T extends ContactJidProvider> CompletableFuture<T> mute(@NonNull T chat, @NonNull ChatMute mute) {
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        if (mute == null) {
            throw new NullPointerException("mute is marked non-null but is null");
        }
        if (this.store().clientType() == ClientType.MOBILE) {
            this.store().findChatByJid(chat).ifPresent(entry -> entry.mute(mute));
            return CompletableFuture.completedFuture(chat);
        }
        MuteAction muteAction = new MuteAction(true, mute.type() == ChatMute.Type.MUTED_FOR_TIMEFRAME ? mute.endTimeStamp() * 1000L : mute.endTimeStamp(), false);
        ActionValueSync syncAction = ActionValueSync.of(muteAction);
        PatchRequest.PatchEntry entry2 = PatchRequest.PatchEntry.of(syncAction, RecordSync.Operation.SET, 2, chat.toJid().toString());
        PatchRequest request = new PatchRequest(BinaryPatchType.REGULAR_HIGH, List.of(entry2));
        return this.socketHandler.pushPatch(request).thenApplyAsync(ignored -> chat);
    }

    public <T extends ContactJidProvider> CompletableFuture<T> unmute(@NonNull T chat) {
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        if (this.store().clientType() == ClientType.MOBILE) {
            this.store().findChatByJid(chat).ifPresent(entry -> entry.mute(ChatMute.notMuted()));
            return CompletableFuture.completedFuture(chat);
        }
        MuteAction muteAction = new MuteAction(false, null, false);
        ActionValueSync syncAction = ActionValueSync.of(muteAction);
        PatchRequest.PatchEntry entry2 = PatchRequest.PatchEntry.of(syncAction, RecordSync.Operation.SET, 2, chat.toJid().toString());
        PatchRequest request = new PatchRequest(BinaryPatchType.REGULAR_HIGH, List.of(entry2));
        return this.socketHandler.pushPatch(request).thenApplyAsync(ignored -> chat);
    }

    public <T extends ContactJidProvider> CompletableFuture<T> block(@NonNull T chat) {
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        Node body = Node.of("item", Map.of("action", "block", "jid", chat.toJid()));
        return this.socketHandler.sendQuery("set", "blocklist", body).thenApplyAsync(ignored -> chat);
    }

    public <T extends ContactJidProvider> CompletableFuture<T> unblock(@NonNull T chat) {
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        Node body = Node.of("item", Map.of("action", "unblock", "jid", chat.toJid()));
        return this.socketHandler.sendQuery("set", "blocklist", body).thenApplyAsync(ignored -> chat);
    }

    public <T extends ContactJidProvider> CompletableFuture<T> changeEphemeralTimer(@NonNull T chat, @NonNull ChatEphemeralTimer timer) {
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        if (timer == null) {
            throw new NullPointerException("timer is marked non-null but is null");
        }
        return switch (chat.toJid().server()) {
            case ContactJid.Server.USER, ContactJid.Server.WHATSAPP -> {
                ProtocolMessage message = ProtocolMessage.builder().protocolType(ProtocolMessage.ProtocolMessageType.EPHEMERAL_SETTING).ephemeralExpiration(timer.period().toSeconds()).build();
                yield this.sendMessage(chat, message).thenApplyAsync(ignored -> chat);
            }
            case ContactJid.Server.GROUP -> {
                Node body = timer == ChatEphemeralTimer.OFF ? Node.of("not_ephemeral") : Node.of("ephemeral", Map.of("expiration", timer.period().toSeconds()));
                yield this.socketHandler.sendQuery(chat.toJid(), "set", "w:g2", body).thenApplyAsync(ignored -> chat);
            }
            default -> throw new IllegalArgumentException("Unexpected chat %s: ephemeral messages are only supported for conversations and groups".formatted(chat.toJid()));
        };
    }

    public CompletableFuture<MessageInfo> markPlayed(@NonNull MessageInfo info) {
        if (info == null) {
            throw new NullPointerException("info is marked non-null but is null");
        }
        if (this.store().findPrivacySetting(PrivacySettingType.READ_RECEIPTS).value() != PrivacySettingValue.EVERYONE) {
            return CompletableFuture.completedFuture(info);
        }
        this.socketHandler.sendReceipt(info.chatJid(), info.senderJid(), List.of(info.id()), "played");
        return CompletableFuture.completedFuture(info.status(MessageStatus.PLAYED));
    }

    public <T extends ContactJidProvider> CompletableFuture<T> markUnread(@NonNull T chat) {
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        return this.mark(chat, false);
    }

    public <T extends ContactJidProvider> CompletableFuture<T> pin(@NonNull T chat) {
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        return this.pin(chat, true);
    }

    public <T extends ContactJidProvider> CompletableFuture<T> unpin(@NonNull T chat) {
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        return this.pin(chat, false);
    }

    private <T extends ContactJidProvider> CompletableFuture<T> pin(T chat, boolean pin) {
        if (this.store().clientType() == ClientType.MOBILE) {
            this.store().findChatByJid(chat).ifPresent(entry -> entry.pinnedTimestampSeconds(pin ? (int)Clock.nowSeconds() : 0));
            return CompletableFuture.completedFuture(chat);
        }
        PinAction pinAction = new PinAction(pin);
        ActionValueSync syncAction = ActionValueSync.of(pinAction);
        PatchRequest.PatchEntry entry2 = PatchRequest.PatchEntry.of(syncAction, RecordSync.Operation.SET, 5, chat.toJid().toString());
        PatchRequest request = new PatchRequest(BinaryPatchType.REGULAR_LOW, List.of(entry2));
        return this.socketHandler.pushPatch(request).thenApplyAsync(ignored -> chat);
    }

    public CompletableFuture<MessageInfo> star(@NonNull MessageInfo info) {
        if (info == null) {
            throw new NullPointerException("info is marked non-null but is null");
        }
        return this.star(info, true);
    }

    private CompletableFuture<MessageInfo> star(MessageInfo info, boolean star) {
        if (this.store().clientType() == ClientType.MOBILE) {
            info.starred(star);
            return CompletableFuture.completedFuture(info);
        }
        StarAction starAction = new StarAction(star);
        ActionValueSync syncAction = ActionValueSync.of(starAction);
        PatchRequest.PatchEntry entry = PatchRequest.PatchEntry.of(syncAction, RecordSync.Operation.SET, 3, info.chatJid().toString(), info.id(), this.fromMeToFlag(info), this.participantToFlag(info));
        PatchRequest request = new PatchRequest(BinaryPatchType.REGULAR_HIGH, List.of(entry));
        return this.socketHandler.pushPatch(request).thenApplyAsync(ignored -> info);
    }

    private String fromMeToFlag(MessageInfo info) {
        return this.booleanToInt(info.fromMe());
    }

    private String participantToFlag(MessageInfo info) {
        return info.chatJid().hasServer(ContactJid.Server.GROUP) && !info.fromMe() ? info.senderJid().toString() : "0";
    }

    private String booleanToInt(boolean keepStarredMessages) {
        return keepStarredMessages ? "1" : "0";
    }

    public CompletableFuture<MessageInfo> unstar(@NonNull MessageInfo info) {
        if (info == null) {
            throw new NullPointerException("info is marked non-null but is null");
        }
        return this.star(info, false);
    }

    public <T extends ContactJidProvider> CompletableFuture<T> archive(@NonNull T chat) {
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        return this.archive(chat, true);
    }

    private <T extends ContactJidProvider> CompletableFuture<T> archive(T chat, boolean archive) {
        if (this.store().clientType() == ClientType.MOBILE) {
            this.store().findChatByJid(chat).ifPresent(entry -> entry.archived(archive));
            return CompletableFuture.completedFuture(chat);
        }
        ActionMessageRangeSync range = this.createRange(chat, false);
        ArchiveChatAction archiveAction = new ArchiveChatAction(archive, range);
        ActionValueSync syncAction = ActionValueSync.of(archiveAction);
        PatchRequest.PatchEntry entry2 = PatchRequest.PatchEntry.of(syncAction, RecordSync.Operation.SET, 3, chat.toJid().toString());
        PatchRequest request = new PatchRequest(BinaryPatchType.REGULAR_LOW, List.of(entry2));
        return this.socketHandler.pushPatch(request).thenApplyAsync(ignored -> chat);
    }

    public <T extends ContactJidProvider> CompletableFuture<T> unarchive(@NonNull T chat) {
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        return this.archive(chat, false);
    }

    public CompletableFuture<MessageInfo> delete(@NonNull MessageInfo info, boolean everyone) {
        if (info == null) {
            throw new NullPointerException("info is marked non-null but is null");
        }
        if (everyone) {
            ProtocolMessage message = ProtocolMessage.builder().protocolType(ProtocolMessage.ProtocolMessageType.REVOKE).key(info.key()).build();
            ContactJid sender = info.chat().toJid().hasServer(ContactJid.Server.GROUP) ? this.store().jid() : null;
            MessageKey key = MessageKey.builder().chatJid(info.chatJid()).fromMe(true).senderJid(sender).build();
            MessageInfo revokeInfo = MessageInfo.builder().senderJid(sender).key(key).message(MessageContainer.of(message)).timestampSeconds(Clock.nowSeconds()).build();
            MessageSendRequest request = MessageSendRequest.builder().info(revokeInfo).additionalAttributes(Map.of("edit", info.chat().isGroup() && !info.fromMe() ? "8" : "7")).build();
            return this.socketHandler.sendMessage(request).thenApplyAsync(ignored -> info);
        }
        if (this.store().clientType() == ClientType.MOBILE) {
            info.chat().removeMessage(info);
            return CompletableFuture.completedFuture(info);
        }
        ActionMessageRangeSync range = this.createRange(info.chatJid(), false);
        DeleteMessageForMeAction deleteMessageAction = new DeleteMessageForMeAction(false, info.timestampSeconds());
        ActionValueSync syncAction = ActionValueSync.of(deleteMessageAction);
        PatchRequest.PatchEntry entry = PatchRequest.PatchEntry.of(syncAction, RecordSync.Operation.SET, 3, info.chatJid().toString(), info.id(), this.fromMeToFlag(info), this.participantToFlag(info));
        PatchRequest request = new PatchRequest(BinaryPatchType.REGULAR_HIGH, List.of(entry));
        return this.socketHandler.pushPatch(request).thenApplyAsync(ignored -> info);
    }

    public <T extends ContactJidProvider> CompletableFuture<T> delete(@NonNull T chat) {
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        if (this.store().clientType() == ClientType.MOBILE) {
            this.store().removeChat(chat.toJid());
            return CompletableFuture.completedFuture(chat);
        }
        ActionMessageRangeSync range = this.createRange(chat.toJid(), false);
        DeleteChatAction deleteChatAction = new DeleteChatAction(range);
        ActionValueSync syncAction = ActionValueSync.of(deleteChatAction);
        PatchRequest.PatchEntry entry = PatchRequest.PatchEntry.of(syncAction, RecordSync.Operation.SET, 6, chat.toJid().toString(), "1");
        PatchRequest request = new PatchRequest(BinaryPatchType.REGULAR_HIGH, List.of(entry));
        return this.socketHandler.pushPatch(request).thenApplyAsync(ignored -> chat);
    }

    public <T extends ContactJidProvider> CompletableFuture<T> clear(@NonNull T chat, boolean keepStarredMessages) {
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        if (this.store().clientType() == ClientType.MOBILE) {
            this.store().findChatByJid(chat.toJid()).ifPresent(Chat::removeMessages);
            return CompletableFuture.completedFuture(chat);
        }
        Optional<Chat> known = this.store().findChatByJid(chat);
        ActionMessageRangeSync range = this.createRange(chat.toJid(), true);
        ClearChatAction clearChatAction = new ClearChatAction(range);
        ActionValueSync syncAction = ActionValueSync.of(clearChatAction);
        PatchRequest.PatchEntry entry = PatchRequest.PatchEntry.of(syncAction, RecordSync.Operation.SET, 6, chat.toJid().toString(), this.booleanToInt(keepStarredMessages), "0");
        PatchRequest request = new PatchRequest(BinaryPatchType.REGULAR_HIGH, List.of(entry));
        return this.socketHandler.pushPatch(request).thenApplyAsync(ignored -> chat);
    }

    public CompletableFuture<String> changeBusinessDescription(String description) {
        return this.changeBusinessAttribute("description", description);
    }

    private CompletableFuture<String> changeBusinessAttribute(String key, String value) {
        return ((CompletableFuture)this.socketHandler.sendQuery("set", "w:biz", Node.of("business_profile", Map.of("v", "3", "mutation_type", "delta"), (Object)Node.of(key, Objects.requireNonNullElse(value, "").getBytes(StandardCharsets.UTF_8)))).thenAcceptAsync(result -> this.checkBusinessAttributeConflict(key, value, (Node)result))).thenApplyAsync(ignored -> value);
    }

    private void checkBusinessAttributeConflict(String key, String value, Node result) {
        Optional keyNode = result.findNode("profile").flatMap(entry -> entry.findNode(key));
        if (keyNode.isEmpty()) {
            return;
        }
        String actual = ((Node)keyNode.get()).contentAsString().orElseThrow(() -> new NoSuchElementException("Missing business %s response, something went wrong: %s".formatted(key, this.findErrorNode(result))));
        Validate.isTrue(value == null || value.equals(actual), "Cannot change business %s: conflict(expected %s, got %s)", key, value, actual);
    }

    public CompletableFuture<String> changeBusinessAddress(String address) {
        return this.changeBusinessAttribute("address", address);
    }

    public CompletableFuture<String> changeBusinessEmail(String email) {
        Validate.isTrue(email == null || this.isValidEmail(email), "Invalid email: %s", email);
        return this.changeBusinessAttribute("email", email);
    }

    private boolean isValidEmail(String email) {
        return Pattern.compile("^(.+)@(\\S+)$").matcher(email).matches();
    }

    public CompletableFuture<List<BusinessCategory>> changeBusinessCategories(List<BusinessCategory> categories) {
        return this.socketHandler.sendQuery("set", "w:biz", Node.of("business_profile", Map.of("v", "3", "mutation_type", "delta"), (Object)Node.of("categories", this.createCategories(categories)))).thenApplyAsync(ignored -> categories);
    }

    private Collection<Node> createCategories(List<BusinessCategory> categories) {
        if (categories == null) {
            return List.of();
        }
        return categories.stream().map(entry -> Node.of("category", Map.of("id", entry.id()))).toList();
    }

    public CompletableFuture<List<URI>> changeBusinessWebsites(List<URI> websites) {
        return this.socketHandler.sendQuery("set", "w:biz", Node.of("business_profile", Map.of("v", "3", "mutation_type", "delta"), Whatsapp.createWebsites(websites))).thenApplyAsync(ignored -> websites);
    }

    private static List<Node> createWebsites(List<URI> websites) {
        if (websites == null) {
            return List.of();
        }
        return websites.stream().map(entry -> Node.of("website", entry.toString().getBytes(StandardCharsets.UTF_8))).toList();
    }

    public CompletableFuture<List<BusinessCatalogEntry>> queryBusinessCatalog() {
        return this.queryBusinessCatalog(10);
    }

    public CompletableFuture<List<BusinessCatalogEntry>> queryBusinessCatalog(int productsLimit) {
        return this.queryBusinessCatalog(this.store().jid().toWhatsappJid(), productsLimit);
    }

    public CompletableFuture<List<BusinessCatalogEntry>> queryBusinessCatalog(@NonNull ContactJidProvider contact, int productsLimit) {
        if (contact == null) {
            throw new NullPointerException("contact is marked non-null but is null");
        }
        return this.socketHandler.sendQuery("get", "w:biz:catalog", Node.of("product_catalog", Map.of("jid", contact, "allow_shop_source", "true"), Node.of("limit", String.valueOf(productsLimit).getBytes(StandardCharsets.UTF_8)), Node.of("width", "100".getBytes(StandardCharsets.UTF_8)), Node.of("height", "100".getBytes(StandardCharsets.UTF_8)))).thenApplyAsync(this::parseCatalog);
    }

    private List<BusinessCatalogEntry> parseCatalog(Node result) {
        return Objects.requireNonNull(result, "Cannot query business catalog, missing response node").findNode("product_catalog").map(entry -> entry.findNodes("product")).stream().flatMap(Collection::stream).map(BusinessCatalogEntry::of).toList();
    }

    public CompletableFuture<List<BusinessCatalogEntry>> queryBusinessCatalog(@NonNull ContactJidProvider contact) {
        if (contact == null) {
            throw new NullPointerException("contact is marked non-null but is null");
        }
        return this.queryBusinessCatalog(contact, 10);
    }

    public CompletableFuture<?> queryBusinessCollections() {
        return this.queryBusinessCollections(50);
    }

    public CompletableFuture<?> queryBusinessCollections(int collectionsLimit) {
        return this.queryBusinessCollections(this.store().jid().toWhatsappJid(), collectionsLimit);
    }

    public CompletableFuture<List<BusinessCollectionEntry>> queryBusinessCollections(@NonNull ContactJidProvider contact, int collectionsLimit) {
        if (contact == null) {
            throw new NullPointerException("contact is marked non-null but is null");
        }
        return this.socketHandler.sendQuery("get", "w:biz:catalog", Map.of("smax_id", "35"), Node.of("collections", Map.of("biz_jid", contact), Node.of("collection_limit", String.valueOf(collectionsLimit).getBytes(StandardCharsets.UTF_8)), Node.of("item_limit", String.valueOf(collectionsLimit).getBytes(StandardCharsets.UTF_8)), Node.of("width", "100".getBytes(StandardCharsets.UTF_8)), Node.of("height", "100".getBytes(StandardCharsets.UTF_8)))).thenApplyAsync(this::parseCollections);
    }

    private List<BusinessCollectionEntry> parseCollections(Node result) {
        return Objects.requireNonNull(result, "Cannot query business collections, missing response node").findNode("collections").stream().map(entry -> entry.findNodes("collection")).flatMap(Collection::stream).map(BusinessCollectionEntry::of).toList();
    }

    public CompletableFuture<?> queryBusinessCollections(@NonNull ContactJidProvider contact) {
        if (contact == null) {
            throw new NullPointerException("contact is marked non-null but is null");
        }
        return this.queryBusinessCollections(contact, 50);
    }

    public CompletableFuture<byte[]> downloadMedia(@NonNull MessageInfo info) {
        if (info == null) {
            throw new NullPointerException("info is marked non-null but is null");
        }
        Validate.isTrue(info.message().category() == MessageCategory.MEDIA, "Expected media message, got: %s(%s)", new Object[]{info.message().category(), info.message().type()});
        return this.downloadMedia(info, false);
    }

    private CompletableFuture<byte[]> downloadMedia(MessageInfo info, boolean retried) {
        MediaMessage mediaMessage = (MediaMessage)info.message().content();
        Optional<byte[]> result = mediaMessage.decodedMedia();
        if (result.isEmpty()) {
            Validate.isTrue(!retried, "Media reupload failed", new Object[0]);
            return this.requireMediaReupload(info).thenComposeAsync(entry -> this.downloadMedia((MessageInfo)entry, true));
        }
        return CompletableFuture.completedFuture(result.get());
    }

    public CompletableFuture<MessageInfo> requireMediaReupload(@NonNull MessageInfo info) {
        if (info == null) {
            throw new NullPointerException("info is marked non-null but is null");
        }
        Validate.isTrue(info.message().category() == MessageCategory.MEDIA, "Expected media message, got: %s(%s)", new Object[]{info.message().category(), info.message().type()});
        MediaMessage mediaMessage = (MediaMessage)info.message().content();
        byte[] retryKey = Hkdf.extractAndExpand(mediaMessage.mediaKey(), "WhatsApp Media Retry Notification".getBytes(StandardCharsets.UTF_8), 32);
        byte[] retryIv = BytesHelper.random(12);
        byte[] retryIdData = info.key().id().getBytes(StandardCharsets.UTF_8);
        byte[] receipt = Protobuf.writeMessage(new ServerErrorReceipt(info.id()));
        byte[] ciphertext = AesGmc.encrypt(retryIv, receipt, retryKey, retryIdData);
        ConcurrentHashMap<String, Object> rmrAttributes = Attributes.of(new Map.Entry[0]).put("jid", info.chatJid()).put("from_me", String.valueOf(info.fromMe())).put("participant", (Object)info.senderJid(), () -> !Objects.equals(info.chatJid(), info.senderJid())).toMap();
        Node node = Node.of("receipt", Map.of("id", info.key().id(), "to", this.store().jid().toWhatsappJid(), "type", "server-error"), Node.of("encrypt", Node.of("enc_p", ciphertext), Node.of("enc_iv", retryIv)), Node.of("rmr", rmrAttributes));
        return this.socketHandler.send(node, result -> result.hasDescription("notification")).thenApplyAsync(result -> this.parseMediaReupload(info, mediaMessage, retryKey, retryIdData, (Node)result));
    }

    private MessageInfo parseMediaReupload(MessageInfo info, MediaMessage mediaMessage, byte[] retryKey, byte[] retryIdData, Node node) {
        Validate.isTrue(!node.hasNode("error"), "Erroneous response from media reupload: %s", node.attributes().getInt("code"));
        Node encryptNode = node.findNode("encrypt").orElseThrow(() -> new NoSuchElementException("Missing encrypt node in media reupload"));
        byte[] mediaPayload = (byte[])encryptNode.findNode("enc_p").flatMap(Node::contentAsBytes).orElseThrow(() -> new NoSuchElementException("Missing encrypted payload node in media reupload"));
        byte[] mediaIv = (byte[])encryptNode.findNode("enc_iv").flatMap(Node::contentAsBytes).orElseThrow(() -> new NoSuchElementException("Missing encrypted iv node in media reupload"));
        byte[] mediaRetryNotificationData = AesGmc.decrypt(mediaIv, mediaPayload, retryKey, retryIdData);
        MediaRetryNotification mediaRetryNotification = Protobuf.readMessage(mediaRetryNotificationData, MediaRetryNotification.class);
        Validate.isTrue(mediaRetryNotification.directPath() != null, "Media retry upload failed: %s", mediaRetryNotification);
        mediaMessage.mediaUrl(Medias.createMediaUrl(mediaRetryNotification.directPath()));
        mediaMessage.mediaDirectPath(mediaRetryNotification.directPath());
        return info;
    }

    public CompletableFuture<Node> sendNode(@NonNull Node node) {
        if (node == null) {
            throw new NullPointerException("node is marked non-null but is null");
        }
        return this.socketHandler.send(node);
    }

    public CompletableFuture<GroupMetadata> createCommunity(@NonNull String subject, String body) {
        if (subject == null) {
            throw new NullPointerException("subject is marked non-null but is null");
        }
        Node entry = Node.of("create", Map.of("subject", subject), Node.of("description", Map.of("id", UUID.randomUUID().toString()), (Object)Node.of("body", Objects.requireNonNullElse(body, "").getBytes(StandardCharsets.UTF_8))), Node.of("parent", Map.of("default_membership_approval_mode", "request_required")));
        return ((CompletableFuture)this.socketHandler.sendQuery(ContactJid.Server.GROUP.toJid(), "set", "w:g2", entry).thenApplyAsync(response -> (Node)Optional.ofNullable(response).flatMap(node -> node.findNode("group")).orElseThrow(() -> new NoSuchElementException("Missing community response, something went wrong: %s".formatted(this.findErrorNode((Node)response)))))).thenApplyAsync(GroupMetadata::of);
    }

    public CompletableFuture<Whatsapp> unlinkDevices() {
        return ((CompletableFuture)this.socketHandler.sendQuery("set", "md", Node.of("remove-companion-device", Map.of("all", true, "reason", "user_initiated"))).thenRun(() -> this.store().removeLinkedCompanions())).thenApply(ignored -> this);
    }

    public CompletableFuture<Whatsapp> unlinkDevice(@NonNull ContactJid companion) {
        if (companion == null) {
            throw new NullPointerException("companion is marked non-null but is null");
        }
        Validate.isTrue(companion.hasAgent(), "Expected companion, got jid without agent: %s", companion);
        return ((CompletableFuture)this.socketHandler.sendQuery("set", "md", Node.of("remove-companion-device", Map.of("jid", companion, "reason", "user_initiated"))).thenRun(() -> this.store().removeLinkedCompanion(companion))).thenApply(ignored -> this);
    }

    public CompletableFuture<CompanionLinkResult> linkDevice(byte @NonNull [] qrCode) {
        if (qrCode == null) {
            throw new NullPointerException("qrCode is marked non-null but is null");
        }
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(qrCode);
            BufferedImageLuminanceSource luminanceSource = new BufferedImageLuminanceSource(ImageIO.read(inputStream));
            HybridBinarizer hybridBinarizer = new HybridBinarizer((LuminanceSource)luminanceSource);
            BinaryBitmap binaryBitmap = new BinaryBitmap((Binarizer)hybridBinarizer);
            QRCodeReader reader = new QRCodeReader();
            Result result = reader.decode(binaryBitmap);
            return this.linkDevice(result.getText());
        }
        catch (ChecksumException | FormatException | NotFoundException | IOException exception) {
            throw new IllegalArgumentException("Cannot read qr code", exception);
        }
    }

    public CompletableFuture<CompanionLinkResult> linkDevice(@NonNull String qrCodeData) {
        if (qrCodeData == null) {
            throw new NullPointerException("qrCodeData is marked non-null but is null");
        }
        int maxDevices = this.getMaxLinkedDevices();
        if (this.store().linkedDevices().size() > maxDevices) {
            return CompletableFuture.completedFuture(CompanionLinkResult.MAX_DEVICES_ERROR);
        }
        String[] qrCodeParts = qrCodeData.split(",");
        Validate.isTrue(qrCodeParts.length >= 4, "Expected qr code to be made up of at least four parts", new Object[0]);
        String ref = qrCodeParts[0];
        byte[] publicKey = Base64.getDecoder().decode(qrCodeParts[1]);
        byte[] advIdentity = Base64.getDecoder().decode(qrCodeParts[2]);
        byte[] identityKey = Base64.getDecoder().decode(qrCodeParts[3]);
        return this.socketHandler.sendQuery("set", "w:sync:app:state", Node.of("delete_all_data")).thenComposeAsync(ignored -> this.linkDevice(advIdentity, identityKey, ref, publicKey));
    }

    private CompletableFuture<CompanionLinkResult> linkDevice(byte[] advIdentity, byte[] identityKey, String ref, byte[] publicKey) {
        DeviceIdentity deviceIdentity = DeviceIdentity.builder().rawId(KeyHelper.agent()).keyIndex(this.store().linkedDevices().size() + 1).timestamp(Clock.nowSeconds()).build();
        byte[] deviceIdentityBytes = Protobuf.writeMessage(deviceIdentity);
        byte[] accountSignatureMessage = BytesHelper.concat(Spec.Whatsapp.ACCOUNT_SIGNATURE_HEADER, deviceIdentityBytes, advIdentity);
        byte[] accountSignature = Curve25519.sign((byte[])this.keys().identityKeyPair().privateKey(), (byte[])accountSignatureMessage, (boolean)true);
        SignedDeviceIdentity signedDeviceIdentity = SignedDeviceIdentity.builder().accountSignature(accountSignature).accountSignatureKey(this.keys().identityKeyPair().publicKey()).details(deviceIdentityBytes).build();
        byte[] signedDeviceIdentityBytes = Protobuf.writeMessage(signedDeviceIdentity);
        SignedDeviceIdentityHMAC deviceIdentityHmac = SignedDeviceIdentityHMAC.builder().hmac(Hmac.calculateSha256(signedDeviceIdentityBytes, identityKey)).details(signedDeviceIdentityBytes).build();
        List<Integer> knownDevices = this.store().linkedDevices().stream().map(ContactJid::device).toList();
        KeyIndexList keyIndexList = KeyIndexList.builder().rawId(deviceIdentity.rawId()).timestamp(deviceIdentity.timestamp()).build();
        byte[] keyIndexListBytes = Protobuf.writeMessage(keyIndexList);
        byte[] deviceSignatureMessage = BytesHelper.concat(Spec.Whatsapp.DEVICE_MOBILE_SIGNATURE_HEADER, keyIndexListBytes);
        byte[] keyAccountSignature = Curve25519.sign((byte[])this.keys().identityKeyPair().privateKey(), (byte[])deviceSignatureMessage, (boolean)true);
        SignedKeyIndexList signedKeyIndexList = SignedKeyIndexList.builder().accountSignature(keyAccountSignature).details(keyIndexListBytes).build();
        return this.socketHandler.sendQuery("set", "md", Node.of("pair-device", Node.of("ref", ref), Node.of("pub-key", publicKey), Node.of("device-identity", Protobuf.writeMessage(deviceIdentityHmac)), Node.of("key-index-list", Map.of("ts", deviceIdentity.timestamp()), (Object)Protobuf.writeMessage(signedKeyIndexList)))).thenComposeAsync(result -> this.handleCompanionPairing((Node)result, deviceIdentity.keyIndex()));
    }

    private int getMaxLinkedDevices() {
        String maxDevices = this.socketHandler.store().properties().get("linked_device_max_count");
        if (maxDevices == null) {
            return 5;
        }
        try {
            return Integer.parseInt(maxDevices);
        }
        catch (NumberFormatException exception) {
            return 5;
        }
    }

    private CompletableFuture<CompanionLinkResult> handleCompanionPairing(Node result, int keyId) {
        if (result.attributes().hasKey("type", "error")) {
            CompanionLinkResult error = result.findNode("error").filter(entry -> entry.attributes().hasKey("text", "resource-limit")).map(entry -> CompanionLinkResult.MAX_DEVICES_ERROR).orElse(CompanionLinkResult.RETRY_ERROR);
            return CompletableFuture.completedFuture(error);
        }
        ContactJid device = result.findNode("device").flatMap(entry -> entry.attributes().getJid("jid")).orElse(null);
        if (device == null) {
            return CompletableFuture.completedFuture(CompanionLinkResult.RETRY_ERROR);
        }
        return ((CompletableFuture)this.awaitCompanionRegistration(device).thenComposeAsync(ignored -> this.socketHandler.sendQuery("get", "encrypt", Node.of("key", (Object)Node.of("user", Map.of("jid", device)))))).thenComposeAsync(encryptResult -> this.handleCompanionEncrypt((Node)encryptResult, device, keyId));
    }

    private CompletableFuture<Void> awaitCompanionRegistration(ContactJid device) {
        CompletableFuture future = new CompletableFuture();
        OnLinkedDevices listener = data -> {
            if (data.contains(device)) {
                future.complete(null);
            }
        };
        this.addLinkedDevicesListener(listener);
        return ((CompletableFuture)future.orTimeout(10L, TimeUnit.SECONDS).exceptionally(ignored -> null)).thenRun(() -> this.removeListener(listener));
    }

    private CompletableFuture<CompanionLinkResult> handleCompanionEncrypt(Node result, ContactJid companion, int keyId) {
        this.store().addLinkedDevice(companion, keyId);
        this.socketHandler.parseSessions(result);
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)this.sendInitialSecurityMessage(companion).thenComposeAsync(ignore -> this.sendAppStateKeysMessage(companion))).thenComposeAsync(ignore -> this.sendInitialNullMessage(companion))).thenComposeAsync(ignore -> this.sendInitialStatusMessage(companion))).thenComposeAsync(ignore -> this.sendPushNamesMessage(companion))).thenComposeAsync(ignore -> this.sendInitialBootstrapMessage(companion))).thenComposeAsync(ignore -> this.sendRecentMessage(companion))).thenComposeAsync(ignored -> this.syncCompanionState(companion))).thenApplyAsync(ignored -> CompanionLinkResult.SUCCESS);
    }

    private CompletableFuture<Void> syncCompanionState(ContactJid companion) {
        PatchRequest criticalUnblockLowRequest = this.createCriticalUnblockLowRequest();
        PatchRequest criticalBlockRequest = this.createCriticalBlockRequest();
        return this.socketHandler.pushPatches(companion, List.of(criticalUnblockLowRequest, criticalBlockRequest)).thenComposeAsync(ignored -> {
            PatchRequest regularLowRequests = this.createRegularLowRequests();
            PatchRequest regularRequests = this.createRegularRequests();
            return this.socketHandler.pushPatches(companion, List.of(regularLowRequests, regularRequests));
        });
    }

    private PatchRequest createRegularRequests() {
        return new PatchRequest(BinaryPatchType.REGULAR, List.of());
    }

    private PatchRequest createRegularLowRequests() {
        PatchRequest.PatchEntry timeFormatEntry = this.createTimeFormatEntry();
        PrimaryVersionAction primaryVersion = new PrimaryVersionAction(this.store().version().toString());
        PatchRequest.PatchEntry sessionVersionEntry = this.createPrimaryVersionEntry(primaryVersion, "session@s.whatsapp.net");
        PatchRequest.PatchEntry keepVersionEntry = this.createPrimaryVersionEntry(primaryVersion, "current@s.whatsapp.net");
        PatchRequest.PatchEntry nuxEntry = this.createNuxRequest();
        PatchRequest.PatchEntry androidEntry = this.createAndroidEntry();
        List<PatchRequest.PatchEntry> entries = Stream.of(timeFormatEntry, sessionVersionEntry, keepVersionEntry, nuxEntry, androidEntry).filter(Objects::nonNull).toList();
        return new PatchRequest(BinaryPatchType.REGULAR_LOW, entries);
    }

    private PatchRequest createCriticalBlockRequest() {
        PatchRequest.PatchEntry localeEntry = this.createLocaleEntry();
        PatchRequest.PatchEntry pushNameEntry = this.createPushNameEntry();
        return new PatchRequest(BinaryPatchType.CRITICAL_BLOCK, List.of(localeEntry, pushNameEntry));
    }

    private PatchRequest createCriticalUnblockLowRequest() {
        List<PatchRequest.PatchEntry> criticalUnblockLow = this.createContactEntries();
        return new PatchRequest(BinaryPatchType.CRITICAL_UNBLOCK_LOW, criticalUnblockLow);
    }

    private List<PatchRequest.PatchEntry> createContactEntries() {
        return this.store().contacts().stream().filter(entry -> entry.shortName() != null || entry.fullName() != null).map(this::createContactRequestEntry).collect(Collectors.toList());
    }

    private PatchRequest.PatchEntry createPushNameEntry() {
        PushNameSetting pushNameSetting = new PushNameSetting(this.store().name());
        return PatchRequest.PatchEntry.of(ActionValueSync.of(pushNameSetting), RecordSync.Operation.SET, 1, new String[0]);
    }

    private PatchRequest.PatchEntry createLocaleEntry() {
        LocaleSetting localeSetting = new LocaleSetting(this.store().locale());
        return PatchRequest.PatchEntry.of(ActionValueSync.of(localeSetting), RecordSync.Operation.SET, 3, new String[0]);
    }

    private PatchRequest.PatchEntry createAndroidEntry() {
        UserAgent.UserAgentPlatform osType = this.store().device().osType();
        if (osType != UserAgent.UserAgentPlatform.ANDROID && osType != UserAgent.UserAgentPlatform.SMB_ANDROID) {
            return null;
        }
        AndroidUnsupportedActions action = new AndroidUnsupportedActions(true);
        return PatchRequest.PatchEntry.of(ActionValueSync.of(action), RecordSync.Operation.SET);
    }

    private PatchRequest.PatchEntry createNuxRequest() {
        NuxAction timeFormatAction = new NuxAction(true);
        ActionValueSync timeFormatSync = ActionValueSync.of(timeFormatAction);
        return PatchRequest.PatchEntry.of(timeFormatSync, RecordSync.Operation.SET, 7, "keep@s.whatsapp.net");
    }

    private PatchRequest.PatchEntry createPrimaryVersionEntry(PrimaryVersionAction primaryVersion, String to) {
        ActionValueSync timeFormatSync = ActionValueSync.of(primaryVersion);
        return PatchRequest.PatchEntry.of(timeFormatSync, RecordSync.Operation.SET, 7, to);
    }

    private PatchRequest.PatchEntry createTimeFormatEntry() {
        TimeFormatAction timeFormatAction = new TimeFormatAction(this.store().twentyFourHourFormat());
        ActionValueSync timeFormatSync = ActionValueSync.of(timeFormatAction);
        return PatchRequest.PatchEntry.of(timeFormatSync, RecordSync.Operation.SET);
    }

    private PatchRequest.PatchEntry createContactRequestEntry(Contact contact) {
        ContactAction action = new ContactAction(null, contact.shortName(), contact.fullName());
        ActionValueSync sync = ActionValueSync.of(action);
        return PatchRequest.PatchEntry.of(sync, RecordSync.Operation.SET, 2, contact.jid().toString());
    }

    private CompletableFuture<Void> sendRecentMessage(ContactJid jid) {
        HistorySync pushNames = HistorySync.builder().conversations(List.of()).syncType(HistorySync.Type.RECENT).build();
        return this.sendHistoryProtocolMessage(jid, pushNames, HistorySyncNotification.Type.PUSH_NAME);
    }

    private CompletableFuture<Void> sendPushNamesMessage(ContactJid jid) {
        List<PushName> pushNamesData = this.store().contacts().stream().map(entry -> entry.chosenName() == null ? null : new PushName(entry.jid().toString(), entry.chosenName())).filter(Objects::nonNull).toList();
        HistorySync pushNames = HistorySync.builder().pushNames(pushNamesData).syncType(HistorySync.Type.PUSH_NAME).build();
        return this.sendHistoryProtocolMessage(jid, pushNames, HistorySyncNotification.Type.PUSH_NAME);
    }

    private CompletableFuture<Void> sendInitialStatusMessage(ContactJid jid) {
        HistorySync initialStatus = HistorySync.builder().statusV3Messages(new ArrayList<MessageInfo>(this.store().status())).syncType(HistorySync.Type.INITIAL_STATUS_V3).build();
        return this.sendHistoryProtocolMessage(jid, initialStatus, HistorySyncNotification.Type.INITIAL_STATUS_V3);
    }

    private CompletableFuture<Void> sendInitialBootstrapMessage(ContactJid jid) {
        List<Chat> chats = this.store().chats().stream().toList();
        HistorySync initialBootstrap = HistorySync.builder().conversations(chats).syncType(HistorySync.Type.INITIAL_BOOTSTRAP).build();
        return this.sendHistoryProtocolMessage(jid, initialBootstrap, HistorySyncNotification.Type.INITIAL_BOOTSTRAP);
    }

    private CompletableFuture<Void> sendInitialNullMessage(ContactJid jid) {
        List<PastParticipants> pastParticipants = this.store().chats().stream().map(this::getPastParticipants).filter(Objects::nonNull).toList();
        HistorySync initialBootstrap = HistorySync.builder().syncType(HistorySync.Type.NON_BLOCKING_DATA).pastParticipants(pastParticipants).build();
        return this.sendHistoryProtocolMessage(jid, initialBootstrap, null);
    }

    private PastParticipants getPastParticipants(Chat chat) {
        if (chat.pastParticipants().isEmpty()) {
            return null;
        }
        return PastParticipants.builder().groupJid(chat.jid()).pastParticipants(new ArrayList<PastParticipant>(chat.pastParticipants())).build();
    }

    private CompletableFuture<Void> sendAppStateKeysMessage(ContactJid companion) {
        List<AppStateSyncKey> preKeys = IntStream.range(0, 10).mapToObj(index -> this.createAppKey(companion, index)).toList();
        this.keys().addAppKeys(companion, preKeys);
        AppStateSyncKeyShare appStateSyncKeyShare = AppStateSyncKeyShare.builder().keys(preKeys).build();
        ProtocolMessage result = ProtocolMessage.builder().protocolType(ProtocolMessage.ProtocolMessageType.APP_STATE_SYNC_KEY_SHARE).appStateSyncKeyShare(appStateSyncKeyShare).build();
        return this.socketHandler.sendPeerMessage(companion, result);
    }

    private AppStateSyncKey createAppKey(ContactJid jid, int index) {
        return AppStateSyncKey.builder().keyId(new AppStateSyncKeyId(KeyHelper.appKeyId())).keyData(this.createAppKeyData(jid, index)).build();
    }

    private AppStateSyncKeyData createAppKeyData(ContactJid jid, int index) {
        return AppStateSyncKeyData.builder().keyData(SignalKeyPair.random().publicKey()).fingerprint(this.createAppKeyFingerprint(jid, index)).timestamp(Clock.nowMilliseconds()).build();
    }

    private AppStateSyncKeyFingerprint createAppKeyFingerprint(ContactJid jid, int index) {
        return AppStateSyncKeyFingerprint.builder().rawId(KeyHelper.senderKeyId()).currentIndex(index).build();
    }

    private CompletableFuture<Void> sendInitialSecurityMessage(ContactJid jid) {
        ProtocolMessage protocolMessage = ProtocolMessage.builder().protocolType(ProtocolMessage.ProtocolMessageType.INITIAL_SECURITY_NOTIFICATION_SETTING_SYNC).initialSecurityNotificationSettingSync(new InitialSecurityNotificationSettingSync(true)).build();
        return this.socketHandler.sendPeerMessage(jid, protocolMessage);
    }

    private CompletableFuture<Void> sendHistoryProtocolMessage(ContactJid jid, HistorySync historySync, HistorySyncNotification.Type type) {
        byte[] syncBytes = Protobuf.writeMessage(historySync);
        return ((CompletableFuture)Medias.upload(syncBytes, AttachmentType.HISTORY_SYNC, this.store().mediaConnection()).thenApplyAsync(upload -> this.createHistoryProtocolMessage((MediaFile)upload, type))).thenComposeAsync(result -> this.socketHandler.sendPeerMessage(jid, (ProtocolMessage)result));
    }

    private ProtocolMessage createHistoryProtocolMessage(MediaFile upload, HistorySyncNotification.Type type) {
        HistorySyncNotification notification = HistorySyncNotification.builder().mediaSha256(upload.fileSha256()).mediaEncryptedSha256(upload.fileEncSha256()).mediaKey(upload.mediaKey()).mediaDirectPath(upload.directPath()).mediaSize(upload.fileLength()).syncType(type).build();
        return ProtocolMessage.builder().protocolType(ProtocolMessage.ProtocolMessageType.HISTORY_SYNC_NOTIFICATION).historySyncNotification(notification).build();
    }

    public CompletableFuture<Optional<BusinessVerifiedNameCertificate>> queryBusinessCertificate(@NonNull ContactJidProvider provider) {
        if (provider == null) {
            throw new NullPointerException("provider is marked non-null but is null");
        }
        return this.socketHandler.sendQuery("get", "w:biz", Node.of("verified_name", Map.of("jid", provider.toJid()))).thenApplyAsync(this::parseCertificate);
    }

    public CompletableFuture<Optional<BusinessVerifiedNameCertificate>> changeBusinessCertificate(@NonNull ContactJidProvider provider) {
        if (provider == null) {
            throw new NullPointerException("provider is marked non-null but is null");
        }
        return this.socketHandler.sendQuery("set", "w:biz", Node.of("verified_name", Map.of("jid", provider.toJid()))).thenApplyAsync(this::parseCertificate);
    }

    private Optional<BusinessVerifiedNameCertificate> parseCertificate(Node result) {
        return result.findNode("verified_name").flatMap(Node::contentAsBytes).map(data -> Protobuf.readMessage(data, BusinessVerifiedNameCertificate.class));
    }

    public CompletableFuture<?> enable2fa(@NonNull String code) {
        if (code == null) {
            throw new NullPointerException("code is marked non-null but is null");
        }
        return this.set2fa(code, null);
    }

    public CompletableFuture<Boolean> enable2fa(@NonNull String code, String email) {
        if (code == null) {
            throw new NullPointerException("code is marked non-null but is null");
        }
        return this.set2fa(code, email);
    }

    public CompletableFuture<Boolean> disable2fa() {
        return this.set2fa(null, null);
    }

    private CompletableFuture<Boolean> set2fa(String code, String email) {
        Validate.isTrue(code == null || code.matches("^[0-9]*$") && code.length() == 6, "Invalid 2fa code: expected a numeric six digits string", new Object[0]);
        Validate.isTrue(email == null || this.isValidEmail(email), "Invalid email: %s", email);
        ArrayList<Node> body = new ArrayList<Node>();
        body.add(Node.of("code", Objects.requireNonNullElse(code, "").getBytes(StandardCharsets.UTF_8)));
        if (code != null && email != null) {
            body.add(Node.of("email", email.getBytes(StandardCharsets.UTF_8)));
        }
        return this.socketHandler.sendQuery("set", "urn:xmpp:whatsapp:account", Node.of("2fa", body)).thenApplyAsync(result -> !result.hasNode("error"));
    }

    public Whatsapp addListener(Listener listener) {
        this.store().addListener(listener);
        return this;
    }

    public Whatsapp removeListener(Listener listener) {
        this.store().removeListener(listener);
        return this;
    }

    public Whatsapp addActionListener(OnAction onAction) {
        return this.addListener(onAction);
    }

    public Whatsapp addChatMessagesSyncListener(OnChatMessagesSync onChatRecentMessages) {
        return this.addListener(onChatRecentMessages);
    }

    public Whatsapp addChatsListener(OnChats onChats) {
        return this.addListener(onChats);
    }

    public Whatsapp addContactPresenceListener(OnContactPresence onContactPresence) {
        return this.addListener(onContactPresence);
    }

    public Whatsapp addContactsListener(OnContacts onContacts) {
        return this.addListener(onContacts);
    }

    public Whatsapp addConversationMessageStatusListener(OnConversationMessageStatus onConversationMessageStatus) {
        return this.addListener(onConversationMessageStatus);
    }

    public Whatsapp addAnyMessageStatusListener(OnAnyMessageStatus onAnyMessageStatus) {
        return this.addListener(onAnyMessageStatus);
    }

    public Whatsapp addDisconnectedListener(OnDisconnected onDisconnected) {
        return this.addListener(onDisconnected);
    }

    public Whatsapp addFeaturesListener(OnFeatures onFeatures) {
        return this.addListener(onFeatures);
    }

    public Whatsapp addLoggedInListener(OnLoggedIn onLoggedIn) {
        return this.addListener(onLoggedIn);
    }

    public Whatsapp addMessageDeletedListener(OnMessageDeleted onMessageDeleted) {
        return this.addListener(onMessageDeleted);
    }

    public Whatsapp addMetadataListener(OnMetadata onMetadata) {
        return this.addListener(onMetadata);
    }

    public Whatsapp addNewContactListener(OnNewContact onNewContact) {
        return this.addListener(onNewContact);
    }

    public Whatsapp addNewMessageListener(OnNewMessage onNewMessage) {
        return this.addListener(onNewMessage);
    }

    public Whatsapp addNewMessageListener(OnNewMarkedMessage onNewMessage) {
        return this.addListener(onNewMessage);
    }

    public Whatsapp addNewStatusListener(OnNewMediaStatus onNewMediaStatus) {
        return this.addListener(onNewMediaStatus);
    }

    public Whatsapp addNodeReceivedListener(OnNodeReceived onNodeReceived) {
        return this.addListener(onNodeReceived);
    }

    public Whatsapp addNodeSentListener(OnNodeSent onNodeSent) {
        return this.addListener(onNodeSent);
    }

    public Whatsapp addSettingListener(OnSetting onSetting) {
        return this.addListener(onSetting);
    }

    public Whatsapp addMediaStatusListener(OnMediaStatus onMediaStatus) {
        return this.addListener(onMediaStatus);
    }

    public Whatsapp addSocketEventListener(OnSocketEvent onSocketEvent) {
        return this.addListener(onSocketEvent);
    }

    public Whatsapp addActionListener(OnWhatsappAction onAction) {
        return this.addListener(onAction);
    }

    public Whatsapp addHistorySyncProgressListener(OnHistorySyncProgress onSyncProgress) {
        return this.addListener(onSyncProgress);
    }

    public Whatsapp addChatMessagesSyncListener(OnWhatsappChatMessagesSync onChatRecentMessages) {
        return this.addListener(onChatRecentMessages);
    }

    public Whatsapp addChatsListener(OnChatMessagesSync onChats) {
        return this.addListener(onChats);
    }

    public Whatsapp addContactPresenceListener(OnWhatsappContactPresence onContactPresence) {
        return this.addListener(onContactPresence);
    }

    public Whatsapp addContactsListener(OnWhatsappContacts onContacts) {
        return this.addListener(onContacts);
    }

    public Whatsapp addConversationMessageStatusListener(OnWhatsappConversationMessageStatus onWhatsappConversationMessageStatus) {
        return this.addListener(onWhatsappConversationMessageStatus);
    }

    public Whatsapp addAnyMessageStatusListener(OnWhatsappAnyMessageStatus onMessageStatus) {
        return this.addListener(onMessageStatus);
    }

    public Whatsapp addDisconnectedListener(OnWhatsappDisconnected onDisconnected) {
        return this.addListener(onDisconnected);
    }

    public Whatsapp addFeaturesListener(OnWhatsappFeatures onFeatures) {
        return this.addListener(onFeatures);
    }

    public Whatsapp addLoggedInListener(OnWhatsappLoggedIn onLoggedIn) {
        return this.addListener(onLoggedIn);
    }

    public Whatsapp addMessageDeletedListener(OnWhatsappMessageDeleted onMessageDeleted) {
        return this.addListener(onMessageDeleted);
    }

    public Whatsapp addMetadataListener(OnWhatsappMetadata onMetadata) {
        return this.addListener(onMetadata);
    }

    public Whatsapp addNewMessageListener(OnWhatsappNewMessage onNewMessage) {
        return this.addListener(onNewMessage);
    }

    public Whatsapp addNewMessageListener(OnWhatsappNewMarkedMessage onNewMessage) {
        return this.addListener(onNewMessage);
    }

    public Whatsapp addNewStatusListener(OnWhatsappNewMediaStatus onNewStatus) {
        return this.addListener(onNewStatus);
    }

    public Whatsapp addNodeReceivedListener(OnWhatsappNodeReceived onNodeReceived) {
        return this.addListener(onNodeReceived);
    }

    public Whatsapp addNodeSentListener(OnWhatsappNodeSent onNodeSent) {
        return this.addListener(onNodeSent);
    }

    public Whatsapp addSettingListener(OnWhatsappSetting onSetting) {
        return this.addListener(onSetting);
    }

    public Whatsapp addMediaStatusListener(OnWhatsappMediaStatus onStatus) {
        return this.addListener(onStatus);
    }

    public Whatsapp addSocketEventListener(OnWhatsappSocketEvent onSocketEvent) {
        return this.addListener(onSocketEvent);
    }

    public Whatsapp addHistorySyncProgressListener(OnWhatsappHistorySyncProgress onSyncProgress) {
        return this.addListener(onSyncProgress);
    }

    public Whatsapp addMessageReplyListener(OnWhatsappMessageReply onMessageReply) {
        return this.addListener(onMessageReply);
    }

    public Whatsapp addMessageReplyListener(@NonNull MessageInfo info, @NonNull OnMessageReply onMessageReply) {
        if (info == null) {
            throw new NullPointerException("info is marked non-null but is null");
        }
        if (onMessageReply == null) {
            throw new NullPointerException("onMessageReply is marked non-null but is null");
        }
        return this.addMessageReplyListener(info.id(), onMessageReply);
    }

    public Whatsapp addMessageReplyListener(OnMessageReply onMessageReply) {
        return this.addListener(onMessageReply);
    }

    public Whatsapp addMessageReplyListener(@NonNull MessageInfo info, @NonNull OnWhatsappMessageReply onMessageReply) {
        if (info == null) {
            throw new NullPointerException("info is marked non-null but is null");
        }
        if (onMessageReply == null) {
            throw new NullPointerException("onMessageReply is marked non-null but is null");
        }
        return this.addMessageReplyListener(info.id(), onMessageReply);
    }

    public Whatsapp addMessageReplyListener(@NonNull String id, @NonNull OnMessageReply onMessageReply) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (onMessageReply == null) {
            throw new NullPointerException("onMessageReply is marked non-null but is null");
        }
        return this.addMessageReplyListener((MessageInfo info, QuotedMessage quoted) -> {
            if (!info.id().equals(id)) {
                return;
            }
            onMessageReply.onMessageReply(info, quoted);
        });
    }

    public Whatsapp addMessageReplyListener(@NonNull String id, @NonNull OnWhatsappMessageReply onMessageReply) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (onMessageReply == null) {
            throw new NullPointerException("onMessageReply is marked non-null but is null");
        }
        return this.addMessageReplyListener((Whatsapp whatsapp, MessageInfo info, QuotedMessage quoted) -> {
            if (!info.id().equals(id)) {
                return;
            }
            onMessageReply.onMessageReply(whatsapp, info, quoted);
        });
    }

    public Whatsapp addUserNameChangeListener(@NonNull OnUserNameChange onUserNameChange) {
        if (onUserNameChange == null) {
            throw new NullPointerException("onUserNameChange is marked non-null but is null");
        }
        return this.addListener(onUserNameChange);
    }

    public Whatsapp addUserNameChangeListener(@NonNull OnWhatsappUserNameChange onNameChange) {
        if (onNameChange == null) {
            throw new NullPointerException("onNameChange is marked non-null but is null");
        }
        return this.addListener(onNameChange);
    }

    public Whatsapp addUserStatusChangeListener(@NonNull OnUserAboutChange onUserAboutChange) {
        if (onUserAboutChange == null) {
            throw new NullPointerException("onUserAboutChange is marked non-null but is null");
        }
        return this.addListener(onUserAboutChange);
    }

    public Whatsapp addUserStatusChangeListener(@NonNull OnWhatsappUserAboutChange onUserStatusChange) {
        if (onUserStatusChange == null) {
            throw new NullPointerException("onUserStatusChange is marked non-null but is null");
        }
        return this.addListener(onUserStatusChange);
    }

    public Whatsapp addUserPictureChangeListener(@NonNull OnUserPictureChange onUserPictureChange) {
        if (onUserPictureChange == null) {
            throw new NullPointerException("onUserPictureChange is marked non-null but is null");
        }
        return this.addListener(onUserPictureChange);
    }

    public Whatsapp addUserPictureChangeListener(@NonNull OnWhatsappUserPictureChange onUserPictureChange) {
        if (onUserPictureChange == null) {
            throw new NullPointerException("onUserPictureChange is marked non-null but is null");
        }
        return this.addListener(onUserPictureChange);
    }

    public Whatsapp addContactPictureChangeListener(@NonNull OnContactPictureChange onContactPictureChange) {
        if (onContactPictureChange == null) {
            throw new NullPointerException("onContactPictureChange is marked non-null but is null");
        }
        return this.addListener(onContactPictureChange);
    }

    public Whatsapp addContactPictureChangeListener(@NonNull OnWhatsappContactPictureChange onProfilePictureChange) {
        if (onProfilePictureChange == null) {
            throw new NullPointerException("onProfilePictureChange is marked non-null but is null");
        }
        return this.addListener(onProfilePictureChange);
    }

    public Whatsapp addGroupPictureChangeListener(@NonNull OnGroupPictureChange onGroupPictureChange) {
        if (onGroupPictureChange == null) {
            throw new NullPointerException("onGroupPictureChange is marked non-null but is null");
        }
        return this.addListener(onGroupPictureChange);
    }

    public Whatsapp addGroupPictureChangeListener(@NonNull OnWhatsappContactPictureChange onGroupPictureChange) {
        if (onGroupPictureChange == null) {
            throw new NullPointerException("onGroupPictureChange is marked non-null but is null");
        }
        return this.addListener(onGroupPictureChange);
    }

    public Whatsapp addContactBlockedListener(@NonNull OnContactBlocked onContactBlocked) {
        if (onContactBlocked == null) {
            throw new NullPointerException("onContactBlocked is marked non-null but is null");
        }
        return this.addListener(onContactBlocked);
    }

    public Whatsapp addContactBlockedListener(@NonNull OnWhatsappContactBlocked onContactBlocked) {
        if (onContactBlocked == null) {
            throw new NullPointerException("onContactBlocked is marked non-null but is null");
        }
        return this.addListener(onContactBlocked);
    }

    public Whatsapp addPrivacySettingChangedListener(OnPrivacySettingChanged onPrivacySettingChanged) {
        return this.addListener(onPrivacySettingChanged);
    }

    public Whatsapp addPrivacySettingChangedListener(OnWhatsappPrivacySettingChanged onWhatsappPrivacySettingChanged) {
        return this.addListener(onWhatsappPrivacySettingChanged);
    }

    public Whatsapp addLinkedDevicesListener(OnLinkedDevices onLinkedDevices) {
        return this.addListener(onLinkedDevices);
    }

    public Whatsapp addLinkedDevicesListener(OnWhatsappLinkedDevices onWhatsappLinkedDevices) {
        return this.addListener(onWhatsappLinkedDevices);
    }

    public Whatsapp addRegistrationCodeListener(OnRegistrationCode onRegistrationCode) {
        return this.addListener(onRegistrationCode);
    }

    public Whatsapp addLinkedDevicesListener(OnWhatsappRegistrationCode onWhatsappRegistrationCode) {
        return this.addListener(onWhatsappRegistrationCode);
    }

    public static WhatsappBuilder customBuilder() {
        return new WhatsappBuilder();
    }

    public SocketHandler socketHandler() {
        return this.socketHandler;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Whatsapp)) {
            return false;
        }
        Whatsapp other = (Whatsapp)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SocketHandler this$socketHandler = this.socketHandler();
        SocketHandler other$socketHandler = other.socketHandler();
        return !(this$socketHandler == null ? other$socketHandler != null : !this$socketHandler.equals(other$socketHandler));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Whatsapp;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SocketHandler $socketHandler = this.socketHandler();
        result = result * 59 + ($socketHandler == null ? 43 : $socketHandler.hashCode());
        return result;
    }

    public String toString() {
        return "Whatsapp(socketHandler=" + this.socketHandler() + ")";
    }

    public static class WhatsappBuilder {
        private Store store;
        private Keys keys;
        private ErrorHandler errorHandler;
        private WebVerificationSupport webVerificationSupport;
        private Executor socketExecutor;

        WhatsappBuilder() {
        }

        public WhatsappBuilder store(@NonNull Store store) {
            if (store == null) {
                throw new NullPointerException("store is marked non-null but is null");
            }
            this.store = store;
            return this;
        }

        public WhatsappBuilder keys(@NonNull Keys keys) {
            if (keys == null) {
                throw new NullPointerException("keys is marked non-null but is null");
            }
            this.keys = keys;
            return this;
        }

        public WhatsappBuilder errorHandler(ErrorHandler errorHandler) {
            this.errorHandler = errorHandler;
            return this;
        }

        public WhatsappBuilder webVerificationSupport(WebVerificationSupport webVerificationSupport) {
            this.webVerificationSupport = webVerificationSupport;
            return this;
        }

        public WhatsappBuilder socketExecutor(Executor socketExecutor) {
            this.socketExecutor = socketExecutor;
            return this;
        }

        public Whatsapp build() {
            return Whatsapp.builder(this.store, this.keys, this.errorHandler, this.webVerificationSupport, this.socketExecutor);
        }

        public String toString() {
            return "Whatsapp.WhatsappBuilder(store=" + this.store + ", keys=" + this.keys + ", errorHandler=" + this.errorHandler + ", webVerificationSupport=" + this.webVerificationSupport + ", socketExecutor=" + this.socketExecutor + ")";
        }
    }
}

