/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.api;

import it.auties.whatsapp.api.ClientType;
import it.auties.whatsapp.exception.HmacValidationException;
import it.auties.whatsapp.util.Exceptions;
import java.nio.file.Path;
import java.util.function.Consumer;
import lombok.NonNull;

public interface ErrorHandler {
    public Result handleError(ClientType var1, Location var2, Throwable var3);

    public static ErrorHandler toTerminal() {
        return ErrorHandler.defaultErrorHandler(Throwable::printStackTrace);
    }

    public static ErrorHandler toFile() {
        return ErrorHandler.defaultErrorHandler(Exceptions::save);
    }

    public static ErrorHandler toFile(@NonNull Path directory) {
        if (directory == null) {
            throw new NullPointerException("directory is marked non-null but is null");
        }
        return ErrorHandler.defaultErrorHandler(throwable -> Exceptions.save(directory, throwable));
    }

    public static ErrorHandler defaultErrorHandler(Consumer<Throwable> printer) {
        return (type, location, throwable) -> {
            System.Logger logger = System.getLogger("ErrorHandler");
            logger.log(System.Logger.Level.ERROR, "Socket failure at %s".formatted(new Object[]{location}));
            if (printer != null) {
                printer.accept(throwable);
            }
            if (location == Location.INITIAL_APP_STATE_SYNC || location == Location.CRYPTOGRAPHY && type != ClientType.MOBILE || location == Location.MESSAGE && throwable instanceof HmacValidationException) {
                logger.log(System.Logger.Level.WARNING, "Socket failure at %s".formatted(new Object[]{location}));
                return Result.RESTORE;
            }
            logger.log(System.Logger.Level.WARNING, "Ignored failure");
            return Result.DISCARD;
        };
    }

    public static enum Location {
        UNKNOWN,
        LOGIN,
        CRYPTOGRAPHY,
        MEDIA_CONNECTION,
        STREAM,
        PULL_APP_STATE,
        PUSH_APP_STATE,
        INITIAL_APP_STATE_SYNC,
        MESSAGE;

    }

    public static enum Result {
        DISCARD,
        RESTORE,
        DISCONNECT,
        RECONNECT,
        LOG_OUT;

    }
}

