/*
 * Decompiled with CFR 0.152.
 */
package it.auties.linkpreview;

import it.auties.linkpreview.LinkPreviewMatch;
import it.auties.linkpreview.LinkPreviewMedia;
import it.auties.linkpreview.LinkPreviewResult;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public final class LinkPreview {
    private static final Pattern URL_REGEX = Pattern.compile("(https?://)?([\\w.-]+)(\\.\\w{2,})+(?::(\\d+))?([/\\w.?=-]*)", 10);
    private static final HttpClient CLIENT = HttpClient.newBuilder().version(HttpClient.Version.HTTP_1_1).followRedirects(HttpClient.Redirect.ALWAYS).build();

    public static List<LinkPreviewMatch> createPreviews(@NonNull String text) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        try {
            return LinkPreview.createPreviewStream(text).flatMap(Optional::stream).toList();
        }
        catch (Exception exception) {
            return List.of();
        }
    }

    public static Optional<LinkPreviewMatch> createPreview(@NonNull String text) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        try {
            return LinkPreview.createPreviewStream(text).flatMap(Optional::stream).findFirst();
        }
        catch (Exception exception) {
            return Optional.empty();
        }
    }

    private static Stream<Optional<LinkPreviewMatch>> createPreviewStream(String text) {
        return URL_REGEX.matcher(text).results().map(MatchResult::group).map(matched -> LinkPreview.createPreview(URI.create(matched)).map(result -> new LinkPreviewMatch((String)matched, (LinkPreviewResult)result)));
    }

    public static Optional<LinkPreviewResult> createPreview(URI uri) {
        try {
            return LinkPreview.createPreviewAsync(uri).join();
        }
        catch (Throwable throwable) {
            return Optional.empty();
        }
    }

    public static CompletableFuture<Optional<LinkPreviewResult>> createPreviewAsync(URI uri) {
        return LinkPreview.createPreviewAsync(CLIENT, uri);
    }

    public static Optional<LinkPreviewResult> createPreview(HttpClient client, URI uri) {
        try {
            return LinkPreview.createPreviewAsync(client, uri).join();
        }
        catch (Throwable throwable) {
            return Optional.empty();
        }
    }

    public static CompletableFuture<Optional<LinkPreviewResult>> createPreviewAsync(@NonNull HttpClient client, @NonNull URI uri) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (uri == null) {
            throw new NullPointerException("uri is marked non-null but is null");
        }
        try {
            return LinkPreview.createPreviewAsync(client, LinkPreview.createDefaultRequest(uri, true));
        }
        catch (Throwable throwable) {
            return LinkPreview.createPreviewAsync(client, LinkPreview.createDefaultRequest(uri, false));
        }
    }

    private static HttpRequest createDefaultRequest(URI uri, boolean secure) {
        return HttpRequest.newBuilder().uri(uri.getScheme() == null ? URI.create("%s://%s".formatted(secure ? "https" : "http", uri)) : uri).GET().header("User-Agent", "Googlebot").build();
    }

    public static Optional<LinkPreviewResult> createPreview(HttpClient client, HttpRequest request) {
        try {
            return LinkPreview.createPreviewAsync(client, request).join();
        }
        catch (Throwable throwable) {
            return Optional.empty();
        }
    }

    public static CompletableFuture<Optional<LinkPreviewResult>> createPreviewAsync(@NonNull HttpClient client, @NonNull HttpRequest request) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        return client.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApplyAsync(LinkPreview::handleResponse);
    }

    private static Optional<LinkPreviewResult> handleResponse(HttpResponse<String> response) {
        try {
            String contentType = response.headers().firstValue("Content-Type").map(type -> type.contains(";") ? type.split(";", 2)[0] : type).orElse(null);
            if (contentType == null || !contentType.equalsIgnoreCase("text/html")) {
                return Optional.empty();
            }
            Document document = Jsoup.parse((String)response.body());
            String title = LinkPreview.getElementContent(document, "og:title").or(() -> LinkPreview.getTitleFallback(document)).orElse("");
            String siteName = LinkPreview.getElementContent(document, "og:site_name").orElse("");
            String siteDescription = LinkPreview.getElementContent(document, "description").or(() -> LinkPreview.getElementContent(document, "Description")).or(() -> LinkPreview.getElementContent(document, "og:description")).orElse("");
            String mediaType = LinkPreview.getElementContent(document, "medium").or(() -> LinkPreview.getElementContent(document, "og:type")).orElse("website");
            Set<LinkPreviewMedia> images = LinkPreview.getImages(document, response.uri());
            Set<LinkPreviewMedia> videos = LinkPreview.getVideos(document);
            Set<URI> favIcons = LinkPreview.getFavIcons(document, response.uri());
            return Optional.of(new LinkPreviewResult(response.uri(), title, siteName, siteDescription, mediaType, images, videos, favIcons));
        }
        catch (Throwable throwable) {
            return Optional.empty();
        }
    }

    private static Optional<String> getTitleFallback(Document document) {
        return document.getElementsByTag("title").stream().findFirst().map(Element::text);
    }

    private static Set<URI> getFavIcons(Document document, URI uri) {
        Set<URI> results = Stream.of("@rel=\"icon\"", "@rel=\"shortcut icon\"", "@rel=\"apple-touch-icon\"").map(selector -> document.selectXpath("//link[%s]".formatted(selector))).flatMap(Collection::stream).map(src -> src.attr("href")).map(uri::resolve).collect(Collectors.toUnmodifiableSet());
        return results.isEmpty() ? Set.of(uri.resolve("/favicon.ico")) : results;
    }

    private static Set<LinkPreviewMedia> getImages(Document document, URI uri) {
        Set images = LinkPreview.getElements(document, "og:image").stream().map(src -> src.attr("content")).map(uri::resolve).collect(Collectors.toUnmodifiableSet());
        if (!images.isEmpty()) {
            Iterator widths = LinkPreview.getElements(document, "og:image:width").iterator();
            Iterator heights = LinkPreview.getElements(document, "og:image:height").iterator();
            return LinkPreview.createMedias(images.iterator(), widths, heights);
        }
        Elements src2 = document.selectXpath("link[rel=image_src]");
        if (src2.hasAttr("href")) {
            return Set.of(new LinkPreviewMedia(uri.resolve(src2.attr("href"))));
        }
        Elements nodes = document.getElementsByTag("img");
        if (nodes.isEmpty()) {
            return Set.of();
        }
        return nodes.stream().map(entry -> new LinkPreviewMedia(uri.resolve(entry.attr("src")), LinkPreview.tryParseUnsignedInt(entry.attr("width")), LinkPreview.tryParseUnsignedInt(entry.attr("height")))).collect(Collectors.toUnmodifiableSet());
    }

    private static int tryParseUnsignedInt(String input) {
        try {
            if (input == null) {
                return -1;
            }
            return Integer.parseUnsignedInt(input);
        }
        catch (NumberFormatException exception) {
            return -1;
        }
    }

    private static Set<LinkPreviewMedia> getVideos(Document document) {
        Set videos = Stream.of(LinkPreview.getElements(document, "og:video:secure_url"), LinkPreview.getElements(document, "og:video:url")).flatMap(Collection::stream).map(entry -> entry.attr("content")).distinct().map(URI::create).collect(Collectors.toUnmodifiableSet());
        if (videos.isEmpty()) {
            return Set.of();
        }
        Iterator widths = LinkPreview.getElements(document, "og:video:width").iterator();
        Iterator heights = LinkPreview.getElements(document, "og:video:height").iterator();
        return LinkPreview.createMedias(videos.iterator(), widths, heights);
    }

    private static Set<LinkPreviewMedia> createMedias(Iterator<URI> videoIterator, Iterator<Element> widths, Iterator<Element> heights) {
        HashSet<LinkPreviewMedia> results = new HashSet<LinkPreviewMedia>();
        while (videoIterator.hasNext()) {
            boolean hasData = widths.hasNext() && heights.hasNext();
            int width = !hasData ? -1 : LinkPreview.tryParseUnsignedInt(widths.next().attr("content"));
            int height = !hasData ? -1 : LinkPreview.tryParseUnsignedInt(heights.next().attr("content"));
            results.add(new LinkPreviewMedia(videoIterator.next(), width, height));
        }
        return Collections.unmodifiableSet(results);
    }

    private static Optional<String> getElementContent(Document document, String type) {
        return LinkPreview.getElements(document, type, "property").stream().findFirst().or(() -> LinkPreview.getElements(document, type, "name").stream().findFirst()).map(entry -> entry.attr("content"));
    }

    private static Elements getElements(Document document, String type) {
        Elements elements = LinkPreview.getElements(document, type, "property");
        return elements.isEmpty() ? LinkPreview.getElements(document, type, "name") : elements;
    }

    private static Elements getElements(Document document, String type, String attribute) {
        return document.selectXpath("//meta[@%s=\"%s\"]".formatted(attribute, type));
    }

    private LinkPreview() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

