/*
 * Decompiled with CFR 0.152.
 */
package com.flowpowered.network.session;

import com.flowpowered.network.AsyncableMessage;
import com.flowpowered.network.Message;
import com.flowpowered.network.exception.ChannelClosedException;
import com.flowpowered.network.protocol.AbstractProtocol;
import com.flowpowered.network.session.BasicSession;
import io.netty.channel.Channel;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class PulsingSession
extends BasicSession {
    private final Queue<Message> messageQueue = new ArrayDeque<Message>();
    private final Queue<Message> sendQueue = new ConcurrentLinkedQueue<Message>();
    private State state = State.EXCHANGE_HANDSHAKE;

    public PulsingSession(Channel channel, AbstractProtocol bootstrapProtocol) {
        super(channel, bootstrapProtocol);
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public void pulse() {
        Message message;
        if (this.state == State.OPEN) {
            while ((message = this.sendQueue.poll()) != null) {
                super.send(message);
            }
        }
        while ((message = this.messageQueue.poll()) != null) {
            super.messageReceived(message);
        }
    }

    @Override
    public void send(Message message) throws ChannelClosedException {
        this.send(SendType.QUEUE, message);
    }

    public void send(SendType type, Message message) throws ChannelClosedException {
        if (message == null) {
            return;
        }
        if (type == SendType.FORCE || this.state == State.OPEN) {
            super.send(message);
        } else if (type == SendType.QUEUE) {
            this.sendQueue.add(message);
        }
    }

    @Override
    public void sendAll(Message ... messages) {
        this.sendAll(SendType.QUEUE, messages);
    }

    public void sendAll(SendType type, Message ... messages) {
        for (Message msg : messages) {
            this.send(type, msg);
        }
    }

    @Override
    public void messageReceived(Message message) {
        if (message instanceof AsyncableMessage && ((AsyncableMessage)message).isAsync()) {
            super.messageReceived(message);
            return;
        }
        this.messageQueue.add(message);
    }

    public static enum State {
        EXCHANGE_HANDSHAKE,
        EXCHANGE_IDENTIFICATION,
        EXCHANGE_ENCRYPTION,
        WAITING,
        OPEN;

    }

    public static enum SendType {
        OPEN_ONLY,
        QUEUE,
        FORCE;

    }
}

